/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import java.util.Collections;
import java.util.EventListener;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.Bundle;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.spi.project.ui.support.ProjectConvertors;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class LineBreakpoint
extends AbstractBreakpoint {
    private static final Logger LOGGER = Logger.getLogger(LineBreakpoint.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(LineBreakpoint.class);
    public static final String PROP_URL = "url";
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String PROP_CONDITION = "condition";
    private final Line myLine;
    private final FileRemoveListener myListener;
    private FileChangeListener myWeakListener;
    private final String myFileUrl;
    private final Future<Boolean> isValidFuture;
    private String condition;

    public LineBreakpoint(Line line) {
        this.myLine = line;
        this.myListener = new FileRemoveListener();
        FileObject fileObject = (FileObject)line.getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            this.myWeakListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this.myListener), (Object)fileObject);
            fileObject.addFileChangeListener(this.myWeakListener);
            this.myFileUrl = fileObject.toURL().toString();
        } else {
            this.myFileUrl = "";
        }
        this.isValidFuture = RP.submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                final Boolean[] result = new Boolean[1];
                DataObject dataObject = DataEditorSupport.findDataObject((Line)LineBreakpoint.this.myLine);
                EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
                StyledDocument styledDocument = editorCookie.getDocument();
                if (styledDocument != null && styledDocument instanceof BaseDocument) {
                    try {
                        final BaseDocument baseDocument = (BaseDocument)styledDocument;
                        Source source = Source.create((Document)baseDocument);
                        ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                            public void run(ResultIterator resultIterator) throws Exception {
                                Parser.Result parserResult = resultIterator.getParserResult();
                                if (parserResult != null && parserResult instanceof PHPParseResult) {
                                    PHPParseResult phpParserResult = (PHPParseResult)parserResult;
                                    int rowStart = LineDocumentUtils.getLineStartFromIndex((LineDocument)baseDocument, (int)LineBreakpoint.this.myLine.getLineNumber());
                                    int contentStart = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)rowStart);
                                    int contentEnd = LineDocumentUtils.getLineLastNonWhitespace((LineDocument)baseDocument, (int)rowStart) + 1;
                                    StatementVisitor statementVisitor = new StatementVisitor(contentStart, contentEnd);
                                    statementVisitor.scan(phpParserResult.getProgram().getStatements());
                                    int properStatementOffset = statementVisitor.getProperStatementOffset();
                                    result[0] = properStatementOffset == contentStart;
                                }
                            }
                        });
                    }
                    catch (ParseException ex) {
                        LOGGER.log(Level.FINE, null, ex);
                    }
                }
                return result[0];
            }
        });
    }

    public final void refreshValidity() {
        Boolean valid = this.isValid();
        if (valid == null) {
            return;
        }
        if (!valid.booleanValue()) {
            this.setValidity(Breakpoint.VALIDITY.INVALID, null);
        } else if (this.getBreakpointId() == null) {
            this.setValidity(Breakpoint.VALIDITY.UNKNOWN, null);
        } else {
            this.setValidity(Breakpoint.VALIDITY.VALID, null);
        }
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Intentional")
    @CheckForNull
    private Boolean isValid() {
        try {
            return this.isValidFuture.get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
        }
        catch (ExecutionException | TimeoutException ex) {
            this.isValidFuture.cancel(true);
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return null;
    }

    public Line getLine() {
        return this.myLine;
    }

    public String getFileUrl() {
        return this.myFileUrl;
    }

    public final synchronized String getCondition() {
        return this.condition;
    }

    public final synchronized void setCondition(String condition) {
        String oldCondition = this.condition;
        if (condition != null && condition.equals(oldCondition) || condition == null && oldCondition == null) {
            return;
        }
        this.condition = condition;
        this.firePropertyChange(PROP_CONDITION, oldCondition, condition);
    }

    public final synchronized boolean isConditional() {
        return this.condition != null && !this.condition.isEmpty();
    }

    @Override
    public int isTemp() {
        return 0;
    }

    @Override
    public boolean isSessionRelated(DebugSession session) {
        SessionId id;
        SessionId sessionId = id = session != null ? session.getSessionId() : null;
        if (id == null) {
            return false;
        }
        return id.getProject() != null;
    }

    @Override
    public void removed() {
        FileObject fileObject = (FileObject)this.getLine().getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            fileObject.removeFileChangeListener(this.myWeakListener);
        }
    }

    public Breakpoint.GroupProperties getGroupProperties() {
        return new PhpGroupProperties();
    }

    void fireLineNumberChanged() {
        int lineNumber = this.getLine().getLineNumber();
        this.firePropertyChange(PROP_LINE_NUMBER, null, lineNumber);
    }

    private static final class StatementVisitor
    extends DefaultVisitor {
        private int properStatementOffset;
        private final int contentStart;
        private final int contentEnd;

        private StatementVisitor(int contentStart, int contentEnd) {
            this.contentStart = contentStart;
            this.contentEnd = contentEnd;
        }

        public void scan(ASTNode node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node != null) {
                OffsetRange nodeRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
                if (node instanceof Statement && nodeRange.containsInclusive(this.contentStart) && nodeRange.containsInclusive(this.contentEnd)) {
                    this.properStatementOffset = node.getStartOffset();
                }
                super.scan(node);
            }
        }

        public int getProperStatementOffset() {
            return this.properStatementOffset;
        }
    }

    private class FileRemoveListener
    extends FileChangeAdapter {
        private FileRemoveListener() {
        }

        public void fileDeleted(FileEvent arg0) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)LineBreakpoint.this);
        }

        public void fileRenamed(FileRenameEvent fe) {
            FileObject renamedFo = fe.getFile();
            LineBreakpoint.this.firePropertyChange(LineBreakpoint.PROP_URL, LineBreakpoint.this.myFileUrl, renamedFo.toURL().toString());
        }
    }

    private final class PhpGroupProperties
    extends Breakpoint.GroupProperties {
        private PhpGroupProperties() {
        }

        public String getLanguage() {
            return "PHP";
        }

        public String getType() {
            return Bundle.LineBreakpoint_type();
        }

        public FileObject[] getFiles() {
            FileObject file = this.getFile();
            if (file != null) {
                return new FileObject[]{file};
            }
            return null;
        }

        public Project[] getProjects() {
            Project project;
            FileObject file = this.getFile();
            if (file != null && (project = ProjectConvertors.getNonConvertorOwner((FileObject)file)) != null) {
                return new Project[]{project};
            }
            return null;
        }

        public DebuggerEngine[] getEngines() {
            return null;
        }

        public boolean isHidden() {
            return false;
        }

        @CheckForNull
        private FileObject getFile() {
            return (FileObject)LineBreakpoint.this.myLine.getLookup().lookup(FileObject.class);
        }
    }
}

