/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.completion;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeMemberElement;
import org.netbeans.modules.php.editor.completion.PHPCompletionItem;
import org.netbeans.modules.php.editor.completion.PHPCompletionResult;
import org.netbeans.modules.php.editor.index.PHPDOCTagElement;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPDocCommentTokenId;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.project.api.PhpAnnotations;
import org.netbeans.modules.php.spi.annotation.AnnotationCompletionTag;
import org.netbeans.modules.php.spi.annotation.AnnotationCompletionTagProvider;
import org.openide.util.ImageUtilities;

public final class PHPDOCCodeCompletion {
    private static final String TAG_PREFIX = "@";

    private PHPDOCCodeCompletion() {
    }

    private static void fetchDocText(PHPCompletionItem.CompletionRequest request, FetchedTextCallback callback) {
        TokenSequence<PHPTokenId> phpTS;
        TokenHierarchy th = request.info.getSnapshot().getTokenHierarchy();
        TokenSequence<PHPTokenId> tokenSequence = phpTS = th != null ? LexUtilities.getPHPTokenSequence(th, request.anchor) : null;
        if (phpTS != null) {
            TokenSequence tokenSequence2;
            phpTS.move(request.anchor);
            if (phpTS.moveNext() && (tokenSequence2 = phpTS.embedded(PHPDocCommentTokenId.language())) != null) {
                tokenSequence2.move(request.anchor);
                if (tokenSequence2.movePrevious()) {
                    int offset = tokenSequence2.offset() + tokenSequence2.token().length();
                    if (tokenSequence2.moveNext()) {
                        CharSequence tokenText = tokenSequence2.token().text();
                        String text = tokenText.subSequence(0, request.anchor - offset).toString().trim();
                        callback.call(text);
                    }
                }
            }
        }
    }

    static boolean isTypeCtx(PHPCompletionItem.CompletionRequest request) {
        TypeContextChecker typeContextChecker = new TypeContextChecker();
        PHPDOCCodeCompletion.fetchDocText(request, typeContextChecker);
        return typeContextChecker.isTypeContext();
    }

    public static void complete(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        if (request.prefix.startsWith(TAG_PREFIX)) {
            PHPDOCCodeCompletion.completeAnnotation(completionResult, request);
        }
        PHPDOCCodeCompletion.fetchDocText(request, new MemberCompletion(completionResult, request));
    }

    private static void completeAnnotation(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        String prefix = request.prefix.substring(TAG_PREFIX.length());
        List providers = PhpAnnotations.getDefault().getCompletionTagProviders(request.info.getSnapshot().getSource().getFileObject());
        ASTNode nodeAfterOffset = Utils.getNodeAfterOffset(request.result, request.anchor);
        int priority = 0;
        for (AnnotationCompletionTagProvider annotationProvider : providers) {
            ++priority;
            List annotations = nodeAfterOffset instanceof TypeDeclaration ? annotationProvider.getTypeAnnotations() : (nodeAfterOffset instanceof MethodDeclaration ? annotationProvider.getMethodAnnotations() : (nodeAfterOffset instanceof FunctionDeclaration ? annotationProvider.getFunctionAnnotations() : (nodeAfterOffset instanceof FieldsDeclaration ? annotationProvider.getFieldAnnotations() : annotationProvider.getAnnotations())));
            for (AnnotationCompletionTag tag : annotations) {
                if (!tag.getName().startsWith(prefix)) continue;
                completionResult.add(new PHPDOCCodeCompletionItem(request.anchor, tag, annotationProvider.getName(), priority));
            }
        }
    }

    public static class PHPDOCCodeCompletionItem
    implements CompletionProposal {
        private static final String PHP_ANNOTATION_ICON = "org/netbeans/modules/php/editor/resources/annotation.png";
        private static final ImageIcon ANNOTATION_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/php/editor/resources/annotation.png"));
        private final AnnotationCompletionTag tag;
        private final int anchorOffset;
        private final PHPDOCTagElement elem;
        private final String providerName;
        private final int priority;

        public PHPDOCCodeCompletionItem(int anchorOffset, AnnotationCompletionTag tag, String providerName, int priority) {
            this.tag = tag;
            this.anchorOffset = anchorOffset;
            this.providerName = providerName;
            this.priority = priority;
            this.elem = new PHPDOCTagElement(tag.getName(), tag.getDocumentation());
        }

        public int getAnchorOffset() {
            return this.anchorOffset;
        }

        public ElementHandle getElement() {
            return this.elem;
        }

        public String getName() {
            return PHPDOCCodeCompletion.TAG_PREFIX + this.tag.getName();
        }

        public String getInsertPrefix() {
            return this.getName();
        }

        public String getSortText() {
            return this.priority + this.providerName + this.getName();
        }

        public int getSortPrioOverride() {
            return 0;
        }

        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.name(this.getKind(), true);
            formatter.appendText(this.getName());
            formatter.name(this.getKind(), false);
            this.tag.formatParameters(formatter);
            return formatter.getText();
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return this.providerName;
        }

        public ElementKind getKind() {
            return this.elem.getKind();
        }

        public ImageIcon getIcon() {
            return ANNOTATION_ICON;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isSmart() {
            return false;
        }

        public String getCustomInsertTemplate() {
            return this.tag.getInsertTemplate();
        }
    }

    private static final class MemberCompletion
    implements FetchedTextCallback {
        private final PHPCompletionResult completionResult;
        private final PHPCompletionItem.CompletionRequest request;

        public MemberCompletion(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
            this.completionResult = completionResult;
            this.request = request;
        }

        @Override
        public void call(String possibleType) {
            String type;
            Set<TypeElement> types;
            TypeElement typeElement;
            if (!possibleType.trim().isEmpty() && possibleType.endsWith("::") && (typeElement = ModelUtils.getFirst(types = this.request.index.getTypes(NameKind.exact(type = possibleType.substring(0, possibleType.length() - 2))))) != null) {
                this.completeTypeMembers(typeElement);
            }
        }

        private void completeTypeMembers(TypeElement typeElement) {
            Set<TypeMemberElement> accessibleTypeMembers = this.request.index.getAccessibleTypeMembers(typeElement, null);
            for (TypeMemberElement typeMemberElement : accessibleTypeMembers) {
                this.completeTypeMember(typeMemberElement);
            }
        }

        private void completeTypeMember(TypeMemberElement typeMemberElement) {
            if (typeMemberElement instanceof MethodElement) {
                this.completeMethods((MethodElement)typeMemberElement);
            } else if (typeMemberElement instanceof FieldElement) {
                this.completeFields((FieldElement)typeMemberElement);
            } else if (typeMemberElement instanceof TypeConstantElement) {
                this.completeConstants((TypeConstantElement)typeMemberElement);
            }
        }

        private void completeMethods(MethodElement method) {
            List<PHPCompletionItem.MethodElementItem> items = PHPCompletionItem.MethodElementItem.getItems(method, this.request);
            for (PHPCompletionItem.MethodElementItem methodItem : items) {
                this.completionResult.add(methodItem);
            }
        }

        private void completeFields(FieldElement field) {
            PHPCompletionItem.FieldItem fieldItem = PHPCompletionItem.FieldItem.getItem(field, this.request, true);
            this.completionResult.add(fieldItem);
        }

        private void completeConstants(TypeConstantElement constant) {
            PHPCompletionItem.TypeConstantItem constantItem = PHPCompletionItem.TypeConstantItem.getItem(constant, this.request);
            this.completionResult.add(constantItem);
        }
    }

    private static final class TypeContextChecker
    implements FetchedTextCallback {
        private boolean isTypeContext = true;

        private TypeContextChecker() {
        }

        @Override
        public void call(String fetchedTxt) {
            String trimmedText;
            String fetchedText = CodeUtils.removeNullableTypePrefix(fetchedTxt);
            if (fetchedText.endsWith("?")) {
                fetchedText = fetchedText.substring(0, fetchedText.length() - 1);
            }
            if (!(trimmedText = fetchedText.trim()).isEmpty() && fetchedText.charAt(fetchedText.length() - 1) == '|') {
                boolean textPartHasWhitespace = false;
                for (int i = 0; i < trimmedText.length(); ++i) {
                    if (!Character.isWhitespace(trimmedText.charAt(i))) continue;
                    textPartHasWhitespace = true;
                    break;
                }
                this.isTypeContext = !textPartHasWhitespace;
            } else {
                for (int i = 0; i < fetchedText.length(); ++i) {
                    if (Character.isWhitespace(fetchedText.charAt(i))) continue;
                    this.isTypeContext = false;
                    break;
                }
            }
        }

        public boolean isTypeContext() {
            return this.isTypeContext;
        }
    }

    private static interface FetchedTextCallback {
        public void call(String var1);
    }
}

