/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.lexer;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public final class LexUtilities {
    private LexUtilities() {
    }

    public static TokenSequence<? extends TokenId> getMostEmbeddedTokenSequence(final Document doc, final int offset, boolean runUnderLock) {
        final AtomicReference ref = new AtomicReference();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                List sequences = th.embeddedTokenSequences(offset, false);
                if (sequences.isEmpty()) {
                    ref.set(th.tokenSequence());
                } else {
                    ref.set(sequences.get(sequences.size() - 1));
                }
            }
        };
        if (runUnderLock) {
            doc.render(r);
        } else {
            r.run();
        }
        return (TokenSequence)ref.get();
    }

    @CheckForNull
    public static TokenSequence<PHPTokenId> getPHPTokenSequence(Document doc, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        return LexUtilities.getPHPTokenSequence(th, offset);
    }

    public static TokenSequence<PHPTokenId> getPHPTokenSequence(TokenHierarchy<?> th, int offset) {
        TokenSequence ts;
        TokenSequence tokenSequence = ts = th == null ? null : th.tokenSequence(PHPTokenId.language());
        if (ts == null) {
            List list = th.embeddedTokenSequences(offset, true);
            for (TokenSequence t : list) {
                if (t.language() != PHPTokenId.language()) continue;
                ts = t;
                break;
            }
            if (ts == null) {
                list = th.embeddedTokenSequences(offset, false);
                for (TokenSequence t : list) {
                    if (t.language() != PHPTokenId.language()) continue;
                    ts = t;
                    break;
                }
            }
        }
        return ts;
    }

    public static TokenSequence<? extends PHPTokenId> getPositionedSequence(BaseDocument doc, int offset) {
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
        if (ts != null) {
            try {
                ts.move(offset);
            }
            catch (AssertionError e) {
                DataObject dobj = (DataObject)doc.getProperty((Object)"stream");
                if (dobj != null) {
                    Exceptions.attachMessage((Throwable)((Object)e), (String)FileUtil.getFileDisplayName((FileObject)dobj.getPrimaryFile()));
                }
                throw e;
            }
            if (!ts.moveNext() && !ts.movePrevious()) {
                return null;
            }
            return ts;
        }
        return null;
    }

    public static Token<? extends PHPTokenId> getToken(BaseDocument doc, int offset) {
        TokenSequence<? extends PHPTokenId> ts = LexUtilities.getPositionedSequence(doc, offset);
        if (ts != null) {
            return ts.token();
        }
        return null;
    }

    public static char getTokenChar(BaseDocument doc, int offset) {
        Token<? extends PHPTokenId> token = LexUtilities.getToken(doc, offset);
        if (token != null && token.text().length() > 0) {
            return token.text().charAt(0);
        }
        return '\u0000';
    }

    public static OffsetRange findFwd(BaseDocument doc, TokenSequence<? extends PHPTokenId> ts, PHPTokenId tokenUpId, char up, PHPTokenId tokenDownId, char down) {
        int balance = 0;
        while (ts.moveNext()) {
            Token token = ts.token();
            if (token.id() == tokenUpId && LexUtilities.textEquals(token.text(), up) || tokenUpId == PHPTokenId.PHP_CURLY_OPEN && token.id() == PHPTokenId.PHP_TOKEN && token.text().charAt(token.text().length() - 1) == '{') {
                ++balance;
                continue;
            }
            if (token.id() != tokenDownId || !LexUtilities.textEquals(token.text(), down)) continue;
            if (balance == 0) {
                return new OffsetRange(ts.offset(), ts.offset() + token.length());
            }
            --balance;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findBwd(BaseDocument doc, TokenSequence<? extends PHPTokenId> ts, PHPTokenId tokenUpId, char up, PHPTokenId tokenDownId, char down) {
        int balance = 0;
        while (ts.movePrevious()) {
            Token token = ts.token();
            TokenId id = token.id();
            if (token.id() == tokenUpId && LexUtilities.textEquals(token.text(), up) || tokenUpId == PHPTokenId.PHP_CURLY_OPEN && token.id() == PHPTokenId.PHP_TOKEN && token.text().charAt(token.text().length() - 1) == '{') {
                if (balance == 0) {
                    return new OffsetRange(ts.offset(), ts.offset() + token.length());
                }
                ++balance;
                continue;
            }
            if (token.id() != tokenDownId || !LexUtilities.textEquals(token.text(), down)) continue;
            --balance;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findFwdAlternativeSyntax(BaseDocument doc, TokenSequence<? extends PHPTokenId> ts, Token<? extends PHPTokenId> upToken) {
        List<PHPTokenId> possibleEnd;
        int balance = 0;
        Token<? extends PHPTokenId> beginToken = LexUtilities.findPreviousToken(ts, Arrays.asList(PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_WHILE, PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_SWITCH, PHPTokenId.PHP_CASE));
        PHPTokenId beginTokenId = (PHPTokenId)beginToken.id();
        if (beginTokenId == PHPTokenId.PHP_ELSE || beginTokenId == PHPTokenId.PHP_ELSEIF) {
            beginTokenId = PHPTokenId.PHP_IF;
        }
        if (beginTokenId == PHPTokenId.PHP_IF) {
            possibleEnd = Arrays.asList(PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_ENDIF);
        } else if (beginTokenId == PHPTokenId.PHP_WHILE) {
            possibleEnd = Arrays.asList(PHPTokenId.PHP_WHILE, PHPTokenId.PHP_ENDWHILE);
        } else if (beginTokenId == PHPTokenId.PHP_FOR) {
            possibleEnd = Arrays.asList(PHPTokenId.PHP_FOR, PHPTokenId.PHP_ENDFOR);
        } else if (beginTokenId == PHPTokenId.PHP_FOREACH) {
            possibleEnd = Arrays.asList(PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_ENDFOREACH);
        } else if (beginTokenId == PHPTokenId.PHP_SWITCH) {
            possibleEnd = Arrays.asList(PHPTokenId.PHP_SWITCH, PHPTokenId.PHP_ENDSWITCH);
        } else if (beginTokenId == PHPTokenId.PHP_CASE) {
            possibleEnd = Arrays.asList(PHPTokenId.PHP_BREAK, PHPTokenId.PHP_ENDSWITCH);
        } else {
            return OffsetRange.NONE;
        }
        while (ts.moveNext()) {
            Token<? extends PHPTokenId> token = LexUtilities.findNextToken(ts, possibleEnd);
            if (token.id() == beginTokenId) {
                ++balance;
                continue;
            }
            if (!possibleEnd.contains(token.id())) continue;
            if (balance == 0) {
                return new OffsetRange(ts.offset(), ts.offset() + token.length());
            }
            if (beginTokenId == PHPTokenId.PHP_IF && (beginTokenId != PHPTokenId.PHP_IF || token.id() != PHPTokenId.PHP_ENDIF)) continue;
            --balance;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findBwdAlternativeSyntax(BaseDocument doc, TokenSequence<? extends PHPTokenId> ts, Token<? extends PHPTokenId> downToken) {
        List<PHPTokenId> possibleBegin;
        int balance = 0;
        PHPTokenId endTokenId = (PHPTokenId)downToken.id();
        if (endTokenId == PHPTokenId.PHP_ELSE || endTokenId == PHPTokenId.PHP_ELSEIF) {
            endTokenId = PHPTokenId.PHP_ENDIF;
        }
        if (endTokenId == PHPTokenId.PHP_ENDIF) {
            possibleBegin = Arrays.asList(PHPTokenId.PHP_TOKEN, PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_ENDIF);
        } else if (endTokenId == PHPTokenId.PHP_ELSE) {
            possibleBegin = Arrays.asList(PHPTokenId.PHP_TOKEN, PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_ENDIF);
        } else if (endTokenId == PHPTokenId.PHP_ENDWHILE) {
            possibleBegin = Arrays.asList(PHPTokenId.PHP_TOKEN, PHPTokenId.PHP_WHILE, PHPTokenId.PHP_ENDWHILE);
        } else if (endTokenId == PHPTokenId.PHP_ENDFOR) {
            possibleBegin = Arrays.asList(PHPTokenId.PHP_TOKEN, PHPTokenId.PHP_FOR, PHPTokenId.PHP_ENDFOR);
        } else if (endTokenId == PHPTokenId.PHP_ENDFOREACH) {
            possibleBegin = Arrays.asList(PHPTokenId.PHP_TOKEN, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_ENDFOREACH);
        } else if (endTokenId == PHPTokenId.PHP_ENDSWITCH) {
            possibleBegin = Arrays.asList(PHPTokenId.PHP_TOKEN, PHPTokenId.PHP_SWITCH, PHPTokenId.PHP_ENDSWITCH);
        } else if (endTokenId == PHPTokenId.PHP_BREAK) {
            possibleBegin = Arrays.asList(PHPTokenId.PHP_TOKEN, PHPTokenId.PHP_BREAK, PHPTokenId.PHP_ENDSWITCH);
        } else {
            return OffsetRange.NONE;
        }
        int columnOffset = 0;
        while (ts.movePrevious()) {
            Token<? extends PHPTokenId> token = LexUtilities.findPreviousToken(ts, possibleBegin);
            if (token.id() == PHPTokenId.PHP_TOKEN) {
                if (!TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)":")) continue;
                columnOffset = ts.offset();
                continue;
            }
            if (token.id() == endTokenId) {
                --balance;
                continue;
            }
            if (balance == 0) {
                return new OffsetRange(columnOffset, columnOffset + 1);
            }
            if (endTokenId == PHPTokenId.PHP_ENDIF && (endTokenId != PHPTokenId.PHP_ENDIF || token.id() != PHPTokenId.PHP_IF)) continue;
            ++balance;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findBegin(BaseDocument doc, TokenSequence<? extends PHPTokenId> ts) {
        return OffsetRange.NONE;
    }

    public static int getLineBalance(BaseDocument doc, int offset, TokenId up, TokenId down, LineBalance lineBalance) {
        try {
            int begin = LineDocumentUtils.getLineStart((LineDocument)doc, (int)offset);
            int end = LineDocumentUtils.getLineEnd((LineDocument)doc, (int)offset);
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, begin);
            if (ts == null) {
                return 0;
            }
            ts.move(begin);
            if (!ts.moveNext()) {
                return 0;
            }
            int upCount = 0;
            int downCount = 0;
            do {
                Token token;
                TokenId id;
                if ((id = (token = ts.token()).id()) == up) {
                    if (lineBalance.equals((Object)LineBalance.DOWN_FIRST)) {
                        if (upCount <= 0) continue;
                        ++upCount;
                        continue;
                    }
                    ++upCount;
                    continue;
                }
                if (id != down) continue;
                if (lineBalance.equals((Object)LineBalance.UP_FIRST)) {
                    if (upCount <= 0) continue;
                    ++downCount;
                    continue;
                }
                ++downCount;
            } while (ts.moveNext() && ts.offset() <= end);
            return upCount - downCount;
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
            return 0;
        }
    }

    public static int getTokenBalance(BaseDocument doc, char open, char close, int offset) throws BadLocationException {
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, 0);
        if (ts == null) {
            return 0;
        }
        ts.moveIndex(0);
        if (!ts.moveNext()) {
            return 0;
        }
        int balance = 0;
        do {
            Token t = ts.token();
            if (LexUtilities.textEquals(t.text(), open)) {
                ++balance;
                continue;
            }
            if (!LexUtilities.textEquals(t.text(), close)) continue;
            --balance;
        } while (ts.moveNext());
        return balance;
    }

    public static boolean isCommentOnlyLine(BaseDocument doc, int offset) throws BadLocationException {
        int begin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
        if (begin == -1) {
            return false;
        }
        Token<? extends PHPTokenId> token = LexUtilities.getToken(doc, begin);
        if (token != null) {
            return token.id() == PHPTokenId.PHP_LINE_COMMENT;
        }
        return false;
    }

    public static boolean textEquals(CharSequence text1, char ... text2) {
        int len = text1.length();
        if (len == text2.length) {
            for (int i = len - 1; i >= 0; --i) {
                if (text1.charAt(i) == text2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Token<? extends PHPTokenId> findNext(TokenSequence<? extends PHPTokenId> ts, List<PHPTokenId> ignores) {
        if (ignores.contains(ts.token().id())) {
            while (ts.moveNext() && ignores.contains(ts.token().id())) {
            }
        }
        return ts.token();
    }

    public static Token<? extends PHPTokenId> findPrevious(TokenSequence<? extends PHPTokenId> ts, List<PHPTokenId> ignores) {
        if (ignores.contains(ts.token().id())) {
            while (ts.movePrevious() && ignores.contains(ts.token().id())) {
            }
        }
        return ts.token();
    }

    public static Token<? extends PHPTokenId> findNextToken(TokenSequence<? extends PHPTokenId> ts, List<PHPTokenId> lookfor) {
        if (!lookfor.contains(ts.token().id())) {
            while (ts.moveNext() && !lookfor.contains(ts.token().id())) {
            }
        }
        return ts.token();
    }

    public static Token<? extends PHPTokenId> findPreviousToken(TokenSequence<? extends PHPTokenId> ts, List<PHPTokenId> lookfor) {
        if (!lookfor.contains(ts.token().id())) {
            while (ts.movePrevious() && !lookfor.contains(ts.token().id())) {
            }
        }
        return ts.token();
    }

    public static Token<? extends PHPTokenId> findEndOfLine(TokenSequence<? extends PHPTokenId> ts) {
        do {
            Token<? extends PHPTokenId> token = LexUtilities.findNextToken(ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHP_LINE_COMMENT));
            for (int i = token.text().length() - 1; i > -1; --i) {
                if (token.text().charAt(i) != '\n') continue;
                return token;
            }
        } while (ts.moveNext());
        return ts.token();
    }

    public static int findStartTokenOfExpression(TokenSequence ts) {
        int start = -1;
        int origOffset = ts.offset();
        int balance = 0;
        int curlyBalance = 0;
        do {
            Token<? extends PHPTokenId> token;
            if ((token = ts.token()).id() == PHPTokenId.PHP_TOKEN) {
                switch (token.text().charAt(0)) {
                    case ')': {
                        --balance;
                        break;
                    }
                    case '(': {
                        ++balance;
                        break;
                    }
                }
                continue;
            }
            if ((token.id() == PHPTokenId.PHP_SEMICOLON || token.id() == PHPTokenId.PHP_OPENTAG) && ts.moveNext()) {
                LexUtilities.findNext((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT));
                start = ts.offset();
                break;
            }
            if (token.id() == PHPTokenId.PHP_IF) {
                int offsetIf = ts.offset();
                token = LexUtilities.findNextToken((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.PHP_TOKEN));
                if (ts.offset() < origOffset && token.text().charAt(0) == '(') {
                    int parentBalance = 1;
                    while (start == -1 && parentBalance > 0 && ts.offset() < origOffset && ts.moveNext()) {
                        token = LexUtilities.findNextToken((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.PHP_TOKEN));
                        if (token.text().charAt(0) == '(') {
                            ++parentBalance;
                            continue;
                        }
                        if (token.text().charAt(0) != ')') continue;
                        --parentBalance;
                    }
                    if (parentBalance == 0 && ts.moveNext() && ts.offset() < origOffset) {
                        start = offsetIf;
                        break;
                    }
                    if (parentBalance > 0) {
                        parentBalance = 0;
                        while (parentBalance < 1 && ts.offset() > offsetIf && ts.movePrevious()) {
                            token = LexUtilities.findPreviousToken((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.PHP_TOKEN));
                            if (token.text().charAt(0) == '(') {
                                ++parentBalance;
                                continue;
                            }
                            if (token.text().charAt(0) != ')') continue;
                            --parentBalance;
                        }
                        if (parentBalance != 1 || !ts.movePrevious()) break;
                        LexUtilities.findPrevious((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT));
                        start = ts.offset();
                        break;
                    }
                    if (parentBalance != 0) continue;
                    start = offsetIf;
                    break;
                }
                ts.move(offsetIf);
                ts.movePrevious();
                continue;
            }
            if (token.id() == PHPTokenId.PHP_CASE || token.id() == PHPTokenId.PHP_DEFAULT) {
                start = ts.offset();
                break;
            }
            if (token.id() == PHPTokenId.PHP_CURLY_CLOSE) {
                if (--curlyBalance != -1 || !ts.moveNext()) continue;
                LexUtilities.findNext((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT));
                if (ts.offset() <= origOffset) {
                    start = ts.offset();
                    break;
                }
                start = origOffset;
                break;
            }
            if (token.id() == PHPTokenId.PHP_CURLY_OPEN) {
                if (++curlyBalance != 1 || !ts.moveNext()) continue;
                LexUtilities.findNext((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT));
                if (ts.offset() <= origOffset) {
                    start = ts.offset();
                    break;
                }
                start = origOffset;
                break;
            }
            if (balance != 1 || token.id() != PHPTokenId.PHP_STRING) continue;
            start = ts.offset();
            break;
        } while (ts.movePrevious());
        if (!ts.movePrevious()) {
            LexUtilities.findNext((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.PHP_OPENTAG));
            start = ts.offset();
        }
        ts.move(origOffset);
        ts.moveNext();
        return start;
    }

    public static boolean isPHPOperator(PHPTokenId id) {
        return id == PHPTokenId.PHP_OPERATOR || id == PHPTokenId.PHP_TEXTUAL_OPERATOR;
    }

    public static enum LineBalance {
        PLAIN,
        UP_FIRST,
        DOWN_FIRST;

    }
}

