/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NullableType;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.Variadic;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.SuggestionRule;
import org.netbeans.modules.php.editor.verification.VerificationUtils;
import org.openide.filesystems.FileObject;

public class InitializeFieldSuggestion
extends SuggestionRule {
    private static final String SUGGESTION_ID = "Initialize.Field.Suggestion";

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        BaseDocument doc;
        int caretOffset;
        OffsetRange lineBounds;
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null && (lineBounds = VerificationUtils.createLineBounds(caretOffset = this.getCaretOffset(), doc = context.doc)).containsInclusive(caretOffset)) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            ConstructorVisitor constructorVisitor = new ConstructorVisitor(fileObject, doc);
            phpParseResult.getProgram().accept(constructorVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            hints.addAll(constructorVisitor.getHints());
        }
    }

    @CheckForNull
    private static String extractParameterName(Expression parameterNameExpression) {
        Variadic variadic;
        Expression expression;
        String result = null;
        if (parameterNameExpression instanceof Variable) {
            result = CodeUtils.extractVariableName((Variable)parameterNameExpression);
        } else if (parameterNameExpression instanceof Reference) {
            Reference reference = (Reference)parameterNameExpression;
            Expression expression2 = reference.getExpression();
            if (expression2 instanceof Variadic) {
                expression2 = ((Variadic)reference.getExpression()).getExpression();
            }
            if (expression2 instanceof Variable) {
                result = CodeUtils.extractVariableName((Variable)expression2);
            }
        } else if (parameterNameExpression instanceof Variadic && (expression = (variadic = (Variadic)parameterNameExpression).getExpression()) instanceof Variable) {
            result = CodeUtils.extractVariableName((Variable)expression);
        }
        return result;
    }

    public String getId() {
        return SUGGESTION_ID;
    }

    public String getDescription() {
        return Bundle.InitializeFieldSuggestionDesc();
    }

    public String getDisplayName() {
        return Bundle.InitializeFieldSuggestionDisp();
    }

    private static final class Fix
    implements HintFix {
        private final ParameterToInit parameterToInit;
        private final BaseDocument baseDocument;

        private Fix(ParameterToInit parameterToInit, BaseDocument baseDocument) {
            this.parameterToInit = parameterToInit;
            this.baseDocument = baseDocument;
        }

        public String getDescription() {
            return Bundle.InitializeFieldSuggestionFix(this.parameterToInit.getName());
        }

        public void implement() throws Exception {
            EditList editList = new EditList(this.baseDocument);
            this.parameterToInit.initialize(editList);
            editList.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static class FieldAssignmentInitializer
    extends InitializerImpl {
        private final String initString;

        public FieldAssignmentInitializer(int offset, String parameterName) {
            super(offset);
            this.initString = "$this->" + parameterName.substring(1) + " = " + parameterName + ";\n";
        }

        @Override
        public String getInitString() {
            return this.initString;
        }
    }

    private static class FieldDeclarationInitializer
    extends InitializerImpl {
        private final String initString;

        public FieldDeclarationInitializer(int offset, FormalParameter node) {
            super(offset);
            Expression parameterType = node.getParameterType();
            if (parameterType instanceof NullableType) {
                parameterType = ((NullableType)parameterType).getType();
            }
            String typeName = parameterType == null ? null : CodeUtils.extractQualifiedName(parameterType);
            String parameterName = InitializeFieldSuggestion.extractParameterName(node.getParameterName());
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            if (typeName != null) {
                sb.append("/**\n * @var ");
                sb.append(typeName);
                if (node.isNullableType()) {
                    sb.append("|null");
                }
                sb.append("\n */\n");
            }
            sb.append("private ").append(parameterName).append(";\n");
            this.initString = sb.toString();
        }

        @Override
        public String getInitString() {
            return this.initString;
        }
    }

    private static abstract class InitializerImpl
    implements Initializer {
        private final int offset;

        public InitializerImpl(int offset) {
            this.offset = offset;
        }

        @Override
        public void initialize(EditList editList) {
            editList.replace(this.offset, 0, this.getInitString(), true, 0);
        }

        public abstract String getInitString();
    }

    private static interface Initializer {
        public void initialize(EditList var1);
    }

    private final class ParameterToInit {
        private final FormalParameter formalParameter;
        private final List<Initializer> initializers;

        public ParameterToInit(FormalParameter formalParameter, List<Initializer> initializers) {
            this.formalParameter = formalParameter;
            this.initializers = initializers;
        }

        public String getName() {
            return InitializeFieldSuggestion.extractParameterName(this.formalParameter.getParameterName());
        }

        public Hint createHint(FileObject fileObject, BaseDocument baseDocument) {
            OffsetRange offsetRange = new OffsetRange(this.formalParameter.getStartOffset(), this.formalParameter.getEndOffset());
            return new Hint((Rule)InitializeFieldSuggestion.this, Bundle.InitializeFieldSuggestionText(this.getName()), fileObject, offsetRange, Collections.singletonList(new Fix(this, baseDocument)), 500);
        }

        public void initialize(EditList editList) {
            for (Initializer initializer : this.initializers) {
                initializer.initialize(editList);
            }
        }
    }

    private final class ConstructorVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final BaseDocument baseDocument;
        private final ArrayList<Hint> hints;
        private List<FormalParameter> formalParameters;
        private List<String> declaredFields;
        private List<String> usedVariables;
        private boolean isInConstructor;
        private int typeBodyStartOffset;
        private int constructorBodyEndOffset;

        private ConstructorVisitor(FileObject fileObject, BaseDocument baseDocument) {
            this.fileObject = fileObject;
            this.baseDocument = baseDocument;
            this.hints = new ArrayList();
        }

        public List<Hint> getHints() {
            return this.hints;
        }

        @Override
        public void visit(ClassDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.typeBodyStartOffset = node.getBody().getStartOffset() + 1;
            this.declaredFields = new ArrayList<String>();
            this.usedVariables = new ArrayList<String>();
            super.visit(node);
            this.typeBodyStartOffset = 0;
        }

        @Override
        public void visit(ClassInstanceCreation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!node.isAnonymous()) {
                return;
            }
            Block body = node.getBody();
            assert (body != null) : node;
            this.typeBodyStartOffset = body.getStartOffset() + 1;
            this.declaredFields = new ArrayList<String>();
            this.usedVariables = new ArrayList<String>();
            super.visit(node);
            this.typeBodyStartOffset = 0;
        }

        @Override
        public void visit(TraitDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.typeBodyStartOffset = node.getBody().getStartOffset() + 1;
            this.declaredFields = new ArrayList<String>();
            this.usedVariables = new ArrayList<String>();
            super.visit(node);
            this.typeBodyStartOffset = 0;
        }

        @Override
        public void visit(InterfaceDeclaration node) {
        }

        @Override
        public void visit(SingleFieldDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            String fieldName = CodeUtils.extractVariableName(node.getName());
            if (fieldName != null) {
                this.declaredFields.add(fieldName);
            }
        }

        @Override
        public void visit(MethodDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            FunctionDeclaration function = node.getFunction();
            if (CodeUtils.isConstructor(node) && function.getBody() != null) {
                this.formalParameters = new ArrayList<FormalParameter>(function.getFormalParameters());
                this.isInConstructor = true;
                this.constructorBodyEndOffset = function.getBody().getEndOffset() - 1;
                this.scan(function.getBody());
                this.isInConstructor = false;
                this.createHints();
            }
        }

        private void createHints() {
            for (ParameterToInit parameterToInit : this.createParametersToInit()) {
                this.hints.add(parameterToInit.createHint(this.fileObject, this.baseDocument));
            }
        }

        private List<ParameterToInit> createParametersToInit() {
            ArrayList<ParameterToInit> result = new ArrayList<ParameterToInit>();
            for (FormalParameter formalParameter : this.formalParameters) {
                String parameterName = InitializeFieldSuggestion.extractParameterName(formalParameter.getParameterName());
                if (parameterName == null || parameterName.isEmpty()) continue;
                ArrayList<Initializer> initializers = new ArrayList<Initializer>();
                if (!this.usedVariables.contains(parameterName)) {
                    initializers.add(new FieldAssignmentInitializer(this.constructorBodyEndOffset, parameterName));
                }
                if (!this.declaredFields.contains(parameterName)) {
                    initializers.add(new FieldDeclarationInitializer(this.typeBodyStartOffset, formalParameter));
                }
                if (initializers.isEmpty()) continue;
                result.add(new ParameterToInit(formalParameter, initializers));
            }
            return result;
        }

        @Override
        public void visit(Variable node) {
            String variableName;
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (this.isInConstructor && (variableName = CodeUtils.extractVariableName(node)) != null) {
                this.usedVariables.add(variableName);
            }
        }
    }
}

