/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.completion.PHPCompletionItem;
import org.netbeans.modules.php.editor.elements.MethodElementImpl;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassMemberElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.SuggestionRule;
import org.netbeans.modules.php.editor.verification.VerificationUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class IntroduceSuggestion
extends SuggestionRule {
    private static final String UNKNOWN_FILE_NAME = "?";
    private static final String NAMESPACE_PARAMETER_NAME = "namespace";
    private static final String NAMESPACE_SEPARATOR = "\\";

    public String getId() {
        return "Introduce.Hint";
    }

    public String getDescription() {
        return Bundle.IntroduceHintDesc();
    }

    public String getDisplayName() {
        return Bundle.IntroduceHintDispName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject == null) {
            return;
        }
        int caretOffset = this.getCaretOffset();
        BaseDocument doc = context.doc;
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        OffsetRange lineBounds = VerificationUtils.createLineBounds(caretOffset, doc);
        if (lineBounds.containsInclusive(caretOffset)) {
            Model model = phpParseResult.getModel();
            IntroduceFixVisitor introduceFixVisitor = new IntroduceFixVisitor(model, lineBounds);
            phpParseResult.getProgram().accept(introduceFixVisitor);
            IntroduceFix variableFix = introduceFixVisitor.getIntroduceFix();
            if (variableFix != null) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                hints.add(new Hint((Rule)this, this.getDisplayName(), fileObject, variableFix.getOffsetRange(), Collections.singletonList(variableFix), 500));
            }
        }
    }

    private static String getParameters(List<Expression> parameters) {
        StringBuilder paramNames = new StringBuilder();
        for (int i = 0; i < parameters.size(); ++i) {
            Expression expression = parameters.get(i);
            String varName = null;
            if (expression instanceof Variable) {
                varName = CodeUtils.extractVariableName((Variable)expression);
            }
            if (varName == null) {
                varName = String.format("$param%d", i);
            }
            if (i > 0) {
                paramNames.append(", ");
            }
            paramNames.append(varName);
        }
        return paramNames.toString();
    }

    private static int getOffset(BaseDocument doc, TypeScope typeScope, PhpElementKind kind) throws BadLocationException {
        int offset = -1;
        HashSet<ClassMemberElement> elements = new HashSet<ClassMemberElement>();
        elements.addAll(typeScope.getDeclaredConstants());
        switch (kind) {
            case METHOD: {
                ClassScope clz;
                if (typeScope instanceof ClassScope) {
                    clz = (ClassScope)typeScope;
                    elements.addAll(clz.getDeclaredFields());
                    elements.addAll(clz.getDeclaredMethods());
                    break;
                }
                if (!(typeScope instanceof TraitScope)) break;
                TraitScope trait = (TraitScope)typeScope;
                elements.addAll(trait.getDeclaredFields());
                elements.addAll(trait.getDeclaredMethods());
                break;
            }
            case FIELD: {
                ClassScope clz;
                if (typeScope instanceof ClassScope) {
                    clz = (ClassScope)typeScope;
                    elements.addAll(clz.getDeclaredFields());
                    break;
                }
                if (!(typeScope instanceof TraitScope)) break;
                TraitScope trait = (TraitScope)typeScope;
                elements.addAll(trait.getDeclaredFields());
                break;
            }
            case TYPE_CONSTANT: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        for (ModelElement modelElement : elements) {
            int newOffset = modelElement.getOffset();
            newOffset = modelElement instanceof MethodScope ? IntroduceSuggestion.getOffsetAfterBlockCloseCurly(doc, newOffset) : IntroduceSuggestion.getOffsetAfterNextSemicolon(doc, newOffset);
            if (newOffset <= offset) continue;
            offset = newOffset;
        }
        if (offset == -1) {
            offset = typeScope.isTraited() ? IntroduceSuggestion.getOffsetAfterUseTrait(doc, typeScope) : IntroduceSuggestion.getOffsetAfterClassOpenCurly(doc, typeScope.getOffset());
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getOffsetAfterBlockCloseCurly(BaseDocument doc, int offset) throws BadLocationException {
        int retval;
        block7: {
            retval = offset;
            doc.readLock();
            try {
                TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, retval);
                if (ts == null) break block7;
                ts.move(retval);
                int curlyMatch = 0;
                while (ts.moveNext()) {
                    Token t = ts.token();
                    if (t.id() != PHPTokenId.PHP_CURLY_OPEN && t.id() != PHPTokenId.PHP_CURLY_CLOSE) continue;
                    if (t.id() == PHPTokenId.PHP_CURLY_OPEN) {
                        ++curlyMatch;
                    } else if (t.id() == PHPTokenId.PHP_CURLY_CLOSE) {
                        --curlyMatch;
                    }
                    if (curlyMatch != 0) continue;
                    ts.moveNext();
                    retval = ts.offset();
                    break;
                }
            }
            finally {
                doc.readUnlock();
            }
        }
        return retval;
    }

    private static int getOffsetAfterNextSemicolon(BaseDocument doc, int offset) throws BadLocationException {
        return IntroduceSuggestion.getOffsetAfterNextTokenId(doc, offset, PHPTokenId.PHP_SEMICOLON);
    }

    private static int getOffsetAfterClassOpenCurly(BaseDocument doc, int offset) throws BadLocationException {
        return IntroduceSuggestion.getOffsetAfterNextTokenId(doc, offset, PHPTokenId.PHP_CURLY_OPEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getOffsetAfterNextTokenId(BaseDocument doc, int offset, PHPTokenId tokenId) throws BadLocationException {
        int retval;
        block4: {
            retval = offset;
            doc.readLock();
            try {
                TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, retval);
                if (ts == null) break block4;
                ts.move(retval);
                while (ts.moveNext()) {
                    Token t = ts.token();
                    if (t.id() != tokenId) continue;
                    ts.moveNext();
                    retval = ts.offset();
                    break;
                }
            }
            finally {
                doc.readUnlock();
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getOffsetAfterUseTrait(BaseDocument document, TypeScope typeScope) {
        OffsetRange blockRange = typeScope.getBlockRange();
        int offset = blockRange.getEnd() - 1;
        HashSet<ClassMemberElement> elements = new HashSet<ClassMemberElement>();
        elements.addAll(typeScope.getDeclaredMethods());
        if (typeScope instanceof ClassScope) {
            elements.addAll(((ClassScope)typeScope).getDeclaredFields());
        } else if (typeScope instanceof TraitScope) {
            elements.addAll(((TraitScope)typeScope).getDeclaredFields());
        }
        for (ModelElement modelElement : elements) {
            int newOffset = modelElement.getOffset();
            if (newOffset >= offset) continue;
            offset = newOffset;
        }
        document.readLock();
        try {
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)document, offset);
            if (ts != null) {
                List<PHPTokenId> list;
                Token<? extends PHPTokenId> previousToken;
                ts.move(offset);
                if (ts.movePrevious() && (previousToken = LexUtilities.findPreviousToken(ts, list = Arrays.asList(PHPTokenId.PHP_SEMICOLON, PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.PHP_CURLY_OPEN))) != null) {
                    int n = ts.offset() + previousToken.length();
                    return n;
                }
            }
        }
        finally {
            document.readUnlock();
        }
        return offset;
    }

    private static PHPCompletionItem.MethodDeclarationItem createMethodDeclarationItem(TypeScope typeScope, MethodInvocation node) {
        String methodName = CodeUtils.extractFunctionName(node.getMethod());
        MethodElement method = MethodElementImpl.createMagicMethod(typeScope, methodName, 0, IntroduceSuggestion.getParameters(node.getMethod().getParameters()));
        return typeScope.isInterface() ? PHPCompletionItem.MethodDeclarationItem.forIntroduceInterfaceHint(method, null) : PHPCompletionItem.MethodDeclarationItem.forIntroduceHint(method, null);
    }

    private static PHPCompletionItem.MethodDeclarationItem createMethodDeclarationItem(TypeScope typeScope, StaticMethodInvocation node) {
        String methodName = CodeUtils.extractFunctionName(node.getMethod());
        MethodElement method = MethodElementImpl.createMagicMethod(typeScope, methodName, 8, IntroduceSuggestion.getParameters(node.getMethod().getParameters()));
        return PHPCompletionItem.MethodDeclarationItem.forIntroduceHint(method, null);
    }

    private static String getTypeKindName(TypeScope typeScope) {
        if (typeScope instanceof ClassScope) {
            return Bundle.IntroduceHintClassName();
        }
        if (typeScope instanceof InterfaceScope) {
            return Bundle.IntroduceHintInterfaceName();
        }
        if (typeScope instanceof TraitScope) {
            return Bundle.IntroduceHintTraitName();
        }
        assert (false);
        return UNKNOWN_FILE_NAME;
    }

    static abstract class IntroduceFix
    implements HintFix {
        BaseDocument doc;
        ASTNode node;

        public IntroduceFix(BaseDocument doc, ASTNode node) {
            this.doc = doc;
            this.node = node;
        }

        OffsetRange getOffsetRange() {
            return new OffsetRange(this.node.getStartOffset(), this.node.getEndOffset());
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean isSafe() {
            return true;
        }
    }

    private static class IntroduceClassConstantFix
    extends IntroduceFix {
        private final TypeScope type;
        private final String templ;
        private final String constantName;

        public IntroduceClassConstantFix(BaseDocument doc, StaticConstantAccess node, TypeScope type) {
            super(doc, node);
            this.type = type;
            this.constantName = node.getConstantName().getName();
            this.templ = String.format("const %s = \"\";", this.constantName);
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, 0, "\n" + this.templ, true, 0);
            edits.apply();
            templateOffset = LineDocumentUtils.getLineEnd((LineDocument)this.doc, (int)(templateOffset + 1)) - 2;
            UiUtils.open((FileObject)this.type.getFileObject(), (int)templateOffset);
        }

        public String getDescription() {
            String typeName = this.type.getName();
            FileObject fileObject = this.type.getFileObject();
            String fileName = fileObject == null ? IntroduceSuggestion.UNKNOWN_FILE_NAME : fileObject.getNameExt();
            String typeKindName = IntroduceSuggestion.getTypeKindName(this.type);
            return Bundle.IntroduceHintClassConstDesc(this.constantName, typeKindName, typeName, fileName);
        }

        int getOffset() throws BadLocationException {
            return IntroduceSuggestion.getOffset(this.doc, this.type, PhpElementKind.TYPE_CONSTANT);
        }
    }

    private static class IntroduceStaticFieldFix
    extends IntroduceFix {
        private final TypeScope type;
        private final String templ;
        private String fieldName;

        public IntroduceStaticFieldFix(BaseDocument doc, StaticFieldAccess node, TypeScope type) {
            super(doc, node);
            this.type = type;
            this.templ = this.createTemplate();
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, 0, "\n" + this.templ, true, 0);
            edits.apply();
            templateOffset = LineDocumentUtils.getLineEnd((LineDocument)this.doc, (int)(templateOffset + 1)) - 2;
            UiUtils.open((FileObject)this.type.getFileObject(), (int)templateOffset);
        }

        public String getDescription() {
            String typeName = this.type.getName();
            FileObject fileObject = this.type.getFileObject();
            String fileName = fileObject == null ? IntroduceSuggestion.UNKNOWN_FILE_NAME : fileObject.getNameExt();
            String typeKindName = IntroduceSuggestion.getTypeKindName(this.type);
            return Bundle.IntroduceHintStaticFieldDesc(this.fieldName, typeKindName, typeName, fileName);
        }

        int getOffset() throws BadLocationException {
            return IntroduceSuggestion.getOffset(this.doc, this.type, PhpElementKind.FIELD);
        }

        private String createTemplate() {
            Variable fieldVar = ((StaticFieldAccess)this.node).getField();
            this.fieldName = CodeUtils.extractVariableName(fieldVar);
            if (!fieldVar.isDollared()) {
                this.fieldName = "$" + this.fieldName;
            }
            return String.format("static %s = \"\";", this.fieldName);
        }
    }

    private static class IntroduceFieldFix
    extends IntroduceFix {
        private final TypeScope type;
        private final String templ;
        private final VariableBase dispatcher;
        private String fieldName;

        public IntroduceFieldFix(BaseDocument doc, FieldAccess node, TypeScope type) {
            super(doc, node);
            this.type = type;
            this.dispatcher = node.getDispatcher();
            this.templ = this.createTemplate();
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, 0, "\n" + this.templ, true, 0);
            edits.apply();
            templateOffset = LineDocumentUtils.getLineEnd((LineDocument)this.doc, (int)(templateOffset + 1)) - 2;
            UiUtils.open((FileObject)this.type.getFileObject(), (int)templateOffset);
        }

        public String getDescription() {
            String typeName = this.type.getName();
            FileObject fileObject = this.type.getFileObject();
            String fileName = fileObject == null ? IntroduceSuggestion.UNKNOWN_FILE_NAME : fileObject.getNameExt();
            String typeKindName = IntroduceSuggestion.getTypeKindName(this.type);
            return Bundle.IntroduceHintFieldDesc(this.templ, typeKindName, typeName, fileName);
        }

        int getOffset() throws BadLocationException {
            return IntroduceSuggestion.getOffset(this.doc, this.type, PhpElementKind.FIELD);
        }

        private String createTemplate() {
            Variable fieldVar = ((FieldAccess)this.node).getField();
            this.fieldName = CodeUtils.extractVariableName(fieldVar);
            if (!fieldVar.isDollared()) {
                this.fieldName = "$" + this.fieldName;
            }
            return String.format("%s %s;", this.isInternal() ? "private" : "public", this.fieldName);
        }

        private boolean isInternal() {
            boolean result = false;
            if (this.dispatcher instanceof Variable) {
                Variable variable = (Variable)this.dispatcher;
                String dispatcherName = CodeUtils.extractVariableName(variable);
                result = "$this".equals(dispatcherName);
            }
            return result;
        }
    }

    private static class IntroduceStaticMethodFix
    extends IntroduceFix {
        private final TypeScope type;
        private final PHPCompletionItem.MethodDeclarationItem item;

        public IntroduceStaticMethodFix(BaseDocument doc, StaticMethodInvocation node, TypeScope type) {
            super(doc, node);
            this.type = type;
            this.item = IntroduceSuggestion.createMethodDeclarationItem(type, node);
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, 0, "\n" + this.item.getCustomInsertTemplate(), true, 0);
            edits.apply();
            templateOffset = LineDocumentUtils.getLineEnd((LineDocument)this.doc, (int)(templateOffset + 1));
            UiUtils.open((FileObject)this.type.getFileObject(), (int)(LineDocumentUtils.getLineEnd((LineDocument)this.doc, (int)(templateOffset + 1)) - 1));
        }

        public String getDescription() {
            String typeName = this.type.getName();
            FileObject fileObject = this.type.getFileObject();
            String fileName = fileObject == null ? IntroduceSuggestion.UNKNOWN_FILE_NAME : fileObject.getNameExt();
            String typeKindName = IntroduceSuggestion.getTypeKindName(this.type);
            return Bundle.IntroduceHintStaticMethodDesc(this.item.getMethod().asString(BaseFunctionElement.PrintAs.NameAndParamsDeclaration), typeKindName, typeName, fileName);
        }

        int getOffset() throws BadLocationException {
            return IntroduceSuggestion.getOffset(this.doc, this.type, PhpElementKind.METHOD);
        }
    }

    private static class IntroduceMethodFix
    extends IntroduceFix {
        private final TypeScope type;
        private final PHPCompletionItem.MethodDeclarationItem item;

        public IntroduceMethodFix(BaseDocument doc, MethodInvocation node, TypeScope type) {
            super(doc, node);
            this.type = type;
            this.item = IntroduceSuggestion.createMethodDeclarationItem(type, node);
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, 0, "\n" + this.item.getCustomInsertTemplate(), true, 0);
            edits.apply();
            templateOffset = LineDocumentUtils.getLineEnd((LineDocument)this.doc, (int)(templateOffset + 1));
            UiUtils.open((FileObject)this.type.getFileObject(), (int)(LineDocumentUtils.getLineEnd((LineDocument)this.doc, (int)(templateOffset + 1)) - 1));
        }

        public String getDescription() {
            String typeName = this.type.getName();
            FileObject fileObject = this.type.getFileObject();
            String fileName = fileObject == null ? IntroduceSuggestion.UNKNOWN_FILE_NAME : fileObject.getNameExt();
            String typeKindName = IntroduceSuggestion.getTypeKindName(this.type);
            return Bundle.IntroduceHintMethodDesc(this.item.getMethod().asString(BaseFunctionElement.PrintAs.NameAndParamsDeclaration), typeKindName, typeName, fileName);
        }

        int getOffset() throws BadLocationException {
            return IntroduceSuggestion.getOffset(this.doc, this.type, PhpElementKind.METHOD);
        }
    }

    private static class IntroduceClassFix
    extends IntroduceFix {
        private final String nsPart;
        private final String className;
        private final String classNameWithNsPart;
        private final FileObject folder;
        private final FileObject template;

        static IntroduceClassFix getInstance(String className, Model model, ClassInstanceCreation instanceCreation) {
            FileObject currentFile = model.getFileScope().getFileObject();
            FileObject folder = currentFile == null ? null : currentFile.getParent();
            String templatePath = "Templates/Scripting/PHPClass.php";
            FileObject template = FileUtil.getConfigFile((String)templatePath);
            return template != null && folder != null && folder.canWrite() ? new IntroduceClassFix(className, template, folder, instanceCreation) : null;
        }

        IntroduceClassFix(String classNameWithNsPart, FileObject template, FileObject folder, ClassInstanceCreation instanceCreation) {
            super(null, instanceCreation);
            int lastIndexOfNsSeparator = classNameWithNsPart.lastIndexOf(IntroduceSuggestion.NAMESPACE_SEPARATOR);
            this.nsPart = lastIndexOfNsSeparator == -1 ? "" : classNameWithNsPart.substring(0, lastIndexOfNsSeparator);
            this.className = classNameWithNsPart.substring(lastIndexOfNsSeparator + 1);
            this.classNameWithNsPart = classNameWithNsPart;
            this.template = template;
            this.folder = folder;
        }

        public void implement() throws Exception {
            final DataFolder dataFolder = DataFolder.findFolder((FileObject)this.folder);
            final DataObject configDataObject = DataObject.find((FileObject)this.template);
            final FileObject[] clsFo = new FileObject[1];
            FileUtil.runAtomicAction((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        if (StringUtils.hasText((String)nsPart)) {
                            parameters.put(IntroduceSuggestion.NAMESPACE_PARAMETER_NAME, nsPart);
                        }
                        DataObject clsDataObject = configDataObject.createFromTemplate(dataFolder, className, parameters);
                        clsFo[0] = clsDataObject.getPrimaryFile();
                        FileObject fo = clsFo[0];
                        FileLock lock = fo.lock();
                        try {
                            fo.rename(lock, fo.getName(), "php");
                        }
                        finally {
                            lock.releaseLock();
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
            if (clsFo[0] != null) {
                UiUtils.open((FileObject)clsFo[0], (int)0);
            }
        }

        public String getDescription() {
            String fileName = FileUtil.getFileDisplayName((FileObject)this.folder);
            int length = fileName.length();
            if (length > 30) {
                int indexOf = (fileName = fileName.substring(length - 30)).indexOf(File.separator);
                if (indexOf != -1) {
                    fileName = fileName.substring(indexOf);
                }
                fileName = String.format("...%s%s%s.php", fileName, File.separator, this.className);
            }
            return Bundle.IntroduceHintClassDesc(this.classNameWithNsPart, fileName);
        }
    }

    private static class IntroduceFixVisitor
    extends DefaultTreePathVisitor {
        private final Model model;
        private final OffsetRange lineBounds;
        private IntroduceFix fix;

        IntroduceFixVisitor(Model model, OffsetRange lineBounds) {
            this.lineBounds = lineBounds;
            this.model = model;
        }

        @Override
        public void scan(ASTNode node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node != null && VerificationUtils.isBefore(node.getStartOffset(), this.lineBounds.getEnd())) {
                super.scan(node);
            }
        }

        @Override
        public void visit(ClassInstanceCreation instanceCreation) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!instanceCreation.isAnonymous() && this.lineBounds.containsInclusive(instanceCreation.getStartOffset())) {
                ClassElement clz;
                String clzName = CodeUtils.extractClassName(instanceCreation.getClassName());
                clzName = clzName != null && clzName.trim().length() > 0 ? clzName : null;
                ElementQuery.Index index = this.model.getIndexScope().getIndex();
                Set<Object> classes = Collections.emptySet();
                if (StringUtils.hasText((String)clzName)) {
                    classes = index.getClasses(NameKind.exact(clzName));
                }
                if (clzName != null && classes.isEmpty() && (clz = this.getIndexedClass(clzName)) == null) {
                    this.fix = IntroduceClassFix.getInstance(clzName, this.model, instanceCreation);
                }
            }
            super.visit(instanceCreation);
        }

        @Override
        public void visit(MethodInvocation methodInvocation) {
            Collection<? extends TypeScope> allTypes;
            String methName;
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (this.lineBounds.containsInclusive(methodInvocation.getStartOffset()) && StringUtils.hasText((String)(methName = CodeUtils.extractFunctionName(methodInvocation.getMethod()))) && (allTypes = ModelUtils.resolveType(this.model, methodInvocation)).size() == 1) {
                TypeScope type = ModelUtils.getFirst(allTypes);
                ElementQuery.Index index = this.model.getIndexScope().getIndex();
                Set<MethodElement> allMethods = ElementFilter.forName(NameKind.exact(methName)).filter(index.getAllMethods(type));
                if (allMethods.isEmpty()) {
                    BaseDocument document;
                    assert (type != null);
                    FileObject fileObject = type.getFileObject();
                    BaseDocument baseDocument = document = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)true) : null;
                    if (document != null && fileObject.canWrite()) {
                        this.fix = new IntroduceMethodFix(document, methodInvocation, type);
                    }
                }
            }
            super.visit(methodInvocation);
        }

        @Override
        public void visit(StaticMethodInvocation methodInvocation) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (this.lineBounds.containsInclusive(methodInvocation.getStartOffset())) {
                Collection<? extends TypeScope> allTypes;
                String methName = CodeUtils.extractFunctionName(methodInvocation.getMethod());
                String clzName = CodeUtils.extractUnqualifiedClassName(methodInvocation);
                if (clzName != null && StringUtils.hasText((String)methName) && (allTypes = ModelUtils.resolveType(this.model, methodInvocation)).size() == 1) {
                    ElementFilter staticFilter;
                    TypeScope type = ModelUtils.getFirst(allTypes);
                    ElementQuery.Index index = this.model.getIndexScope().getIndex();
                    ElementFilter nameFilter = ElementFilter.forName(NameKind.exact(methName));
                    Set<MethodElement> allMethods = ElementFilter.allOf(nameFilter, staticFilter = ElementFilter.forStaticModifiers(true)).filter(index.getAllMethods(type));
                    if (allMethods.isEmpty()) {
                        BaseDocument document;
                        assert (type != null);
                        FileObject fileObject = type.getFileObject();
                        BaseDocument baseDocument = document = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)true) : null;
                        if (document != null && fileObject.canWrite()) {
                            this.fix = new IntroduceStaticMethodFix(document, methodInvocation, type);
                        }
                    }
                }
            }
            super.visit(methodInvocation);
        }

        @Override
        public void visit(FieldAccess fieldAccess) {
            Collection<? extends TypeScope> allTypes;
            String fieldName;
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (this.lineBounds.containsInclusive(fieldAccess.getStartOffset()) && StringUtils.hasText((String)(fieldName = CodeUtils.extractVariableName(fieldAccess.getField()))) && (allTypes = ModelUtils.resolveType(this.model, fieldAccess)).size() == 1) {
                TypeScope type = ModelUtils.getFirst(allTypes);
                ElementQuery.Index index = this.model.getIndexScope().getIndex();
                Set<FieldElement> allFields = ElementFilter.forName(NameKind.exact(fieldName)).filter(index.getAlllFields(type));
                if (allFields.isEmpty()) {
                    BaseDocument document;
                    assert (type != null);
                    FileObject fileObject = type.getFileObject();
                    BaseDocument baseDocument = document = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)false) : null;
                    if (document != null && fileObject.canWrite() && (type instanceof ClassScope || type instanceof TraitScope)) {
                        this.fix = new IntroduceFieldFix(document, fieldAccess, type);
                    }
                }
            }
            super.visit(fieldAccess);
        }

        @Override
        public void visit(StaticFieldAccess fieldAccess) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (this.lineBounds.containsInclusive(fieldAccess.getStartOffset())) {
                Variable field = fieldAccess.getField();
                String clzName = CodeUtils.extractUnqualifiedClassName(fieldAccess);
                if (clzName != null) {
                    Collection<? extends TypeScope> allTypes;
                    String fieldName = CodeUtils.extractVariableName(field);
                    if (!StringUtils.hasText((String)fieldName)) {
                        return;
                    }
                    assert (fieldName != null);
                    if (fieldName.startsWith("$")) {
                        fieldName = fieldName.substring(1);
                    }
                    if ((allTypes = ModelUtils.resolveType(this.model, fieldAccess)).size() == 1) {
                        TypeScope type = ModelUtils.getFirst(allTypes);
                        ElementQuery.Index index = this.model.getIndexScope().getIndex();
                        ElementFilter staticFieldsFilter = ElementFilter.allOf(ElementFilter.forName(NameKind.exact(fieldName)), ElementFilter.forStaticModifiers(true));
                        Set<FieldElement> allFields = staticFieldsFilter.filter(index.getAlllFields(type));
                        if (allFields.isEmpty()) {
                            BaseDocument document;
                            assert (type != null);
                            FileObject fileObject = type.getFileObject();
                            BaseDocument baseDocument = document = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)true) : null;
                            if (document != null && fileObject.canWrite() && (type instanceof ClassScope || type instanceof TraitScope)) {
                                this.fix = new IntroduceStaticFieldFix(document, fieldAccess, type);
                            }
                        }
                    }
                }
            }
            super.visit(fieldAccess);
        }

        @Override
        public void visit(StaticConstantAccess staticConstantAccess) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (this.lineBounds.containsInclusive(staticConstantAccess.getStartOffset())) {
                TypeScope type;
                Collection<? extends TypeScope> allTypes;
                String constName = staticConstantAccess.getConstantName().getName();
                String clzName = CodeUtils.extractUnqualifiedClassName(staticConstantAccess);
                if (clzName != null && StringUtils.hasText((String)constName) && (allTypes = ModelUtils.resolveType(this.model, staticConstantAccess)).size() == 1 && !((type = ModelUtils.getFirst(allTypes)) instanceof TraitScope)) {
                    ElementQuery.Index index = this.model.getIndexScope().getIndex();
                    Set<TypeConstantElement> allConstants = ElementFilter.forName(NameKind.exact(constName)).filter(index.getAllTypeConstants(type));
                    if (allConstants.isEmpty()) {
                        BaseDocument document;
                        assert (type != null);
                        FileObject fileObject = type.getFileObject();
                        BaseDocument baseDocument = document = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)false) : null;
                        if (document != null && fileObject.canWrite()) {
                            this.fix = new IntroduceClassConstantFix(document, staticConstantAccess, type);
                        }
                    }
                }
            }
            super.visit(staticConstantAccess);
        }

        public IntroduceFix getIntroduceFix() {
            return this.fix;
        }

        private ClassElement getIndexedClass(String name) {
            ClassElement retval = null;
            ElementQuery.Index index = this.model.getIndexScope().getIndex();
            Collection<Object> classes = Collections.emptyList();
            if ("self".equals(name) || "parent".equals(name)) {
                ClassDeclaration classDeclaration = null;
                for (ASTNode aSTNode : this.getPath()) {
                    if (!(aSTNode instanceof ClassDeclaration)) continue;
                    classDeclaration = (ClassDeclaration)aSTNode;
                    break;
                }
                if (classDeclaration != null) {
                    String clzName = CodeUtils.extractClassName(classDeclaration);
                    classes = index.getClasses(NameKind.exact(clzName));
                }
            } else {
                classes = index.getClasses(NameKind.exact(name));
            }
            if (classes.size() == 1) {
                String superClassName;
                QualifiedName superClassQualifiedName;
                retval = (ClassElement)classes.iterator().next();
                if ("parent".equals(name) && (superClassQualifiedName = retval.getSuperClassName()) != null && (superClassName = superClassQualifiedName.getName()) != null) {
                    classes = index.getClasses(NameKind.exact(superClassName));
                    retval = classes.size() == 1 ? (ClassElement)classes.iterator().next() : null;
                }
            }
            return retval;
        }
    }
}

