/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.pac.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.core.network.proxy.pac.PacHelperMethods;
import org.netbeans.core.network.proxy.pac.PacUtils;
import org.netbeans.core.network.proxy.pac.datetime.PacUtilsDateTime;
import org.netbeans.core.network.utils.IpAddressUtils;
import org.netbeans.core.network.utils.LocalAddressUtils;

public class NbPacHelperMethods
extends PacHelperMethods {
    private static final Logger LOGGER = Logger.getLogger(NbPacHelperMethods.class.getName());
    public static final int DNS_TIMEOUT_MS = 4000;

    @Override
    public boolean isPlainHostName(String host) {
        return !host.contains(".");
    }

    @Override
    public boolean dnsDomainIs(String host, String domain) {
        int dotPos = host.indexOf(".");
        if (dotPos != -1 && dotPos < host.length() - 1) {
            if (host.substring(dotPos).equals(domain)) {
                return true;
            }
            if (host.substring(dotPos + 1).equals(domain)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean localHostOrDomainIs(String host, String hostdom) {
        if (host.equals(hostdom)) {
            return true;
        }
        return host.equals(NbPacHelperMethods.getDomains(hostdom)[0]);
    }

    @Override
    public boolean isResolvable(String host) {
        try {
            IpAddressUtils.nameResolve(host, 4000, IpAddressUtils.IpTypePreference.IPV4_ONLY);
            return true;
        }
        catch (InterruptedException | UnknownHostException | TimeoutException ex) {
            return false;
        }
    }

    @Override
    public String dnsResolve(String host) {
        try {
            return IpAddressUtils.nameResolve(host, 4000, IpAddressUtils.IpTypePreference.IPV4_ONLY).getHostAddress();
        }
        catch (InterruptedException | UnknownHostException | TimeoutException ex) {
            return null;
        }
    }

    @Override
    public String myIpAddress() {
        return LocalAddressUtils.getMostLikelyLocalInetAddress(IpAddressUtils.IpTypePreference.IPV4_ONLY).getHostAddress();
    }

    @Override
    public boolean isInNet(String host, String pattern, String mask) {
        try {
            String hostIP = IpAddressUtils.nameResolve(host, 4000, IpAddressUtils.IpTypePreference.IPV4_ONLY).getHostAddress();
            String[] hostIPElements = hostIP.split("\\.");
            String[] patternElements = pattern.split("\\.");
            String[] maskElements = mask.split("\\.");
            for (int i = 0; i < hostIPElements.length; ++i) {
                if (i >= maskElements.length || !maskElements[i].trim().equals("255") || hostIPElements[i].trim().equals(patternElements[i].trim())) continue;
                return false;
            }
            return true;
        }
        catch (InterruptedException | UnknownHostException | TimeoutException ex) {
            return false;
        }
    }

    @Override
    public int dnsDomainLevels(String host) {
        if (host == null) {
            return 0;
        }
        return NbPacHelperMethods.getNoOfOccurrences(host, '.');
    }

    @Override
    public boolean shExpMatch(String str, String shexp) {
        Pattern pattern = PacUtils.createRegexPatternFromGlob(shexp);
        return pattern.matcher(str).matches();
    }

    @Override
    public boolean weekdayRange(Object ... args) {
        try {
            return PacUtilsDateTime.isInWeekdayRange(new Date(), args);
        }
        catch (PacUtilsDateTime.PacDateTimeInputException ex) {
            LOGGER.log(Level.WARNING, "PAC script error : arguments passed to weekdayRange() function {0} are faulty: {1}", new Object[]{Arrays.toString(args), ex.getMessage()});
            return false;
        }
    }

    @Override
    public boolean dateRange(Object ... args) {
        try {
            return PacUtilsDateTime.isInDateRange(new Date(), args);
        }
        catch (PacUtilsDateTime.PacDateTimeInputException ex) {
            LOGGER.log(Level.WARNING, "PAC script error : arguments passed to dateRange() function {0} are faulty: {1}", new Object[]{Arrays.toString(args), ex.getMessage()});
            return false;
        }
    }

    @Override
    public boolean timeRange(Object ... args) {
        try {
            return PacUtilsDateTime.isInTimeRange(new Date(), args);
        }
        catch (PacUtilsDateTime.PacDateTimeInputException ex) {
            LOGGER.log(Level.WARNING, "PAC script error : arguments passed to timeRange() function {0} are faulty: {1}", new Object[]{Arrays.toString(args), ex.getMessage()});
            return false;
        }
    }

    @Override
    public boolean isResolvableEx(String host) {
        try {
            IpAddressUtils.nameResolve(host, 4000, IpAddressUtils.IpTypePreference.ANY_JDK_PREF).getHostAddress();
            return true;
        }
        catch (InterruptedException | UnknownHostException | TimeoutException ex) {
            return false;
        }
    }

    @Override
    public String dnsResolveEx(String host) {
        try {
            return IpAddressUtils.nameResolve(host, 4000, IpAddressUtils.IpTypePreference.ANY_JDK_PREF).getHostAddress();
        }
        catch (InterruptedException | UnknownHostException | TimeoutException ex) {
            return "";
        }
    }

    @Override
    public String myIpAddressEx() {
        InetAddress[] addresses = LocalAddressUtils.getMostLikelyLocalInetAddresses(IpAddressUtils.IpTypePreference.ANY_JDK_PREF);
        return PacUtils.toSemiColonListInetAddress(addresses);
    }

    @Override
    public String sortIpAddressList(String ipAddressList) {
        if (ipAddressList == null) {
            return "";
        }
        String[] strComps = ipAddressList.split(";");
        ArrayList<InetAddress> addressesB = new ArrayList<InetAddress>();
        for (String s : strComps) {
            try {
                addressesB.add(InetAddress.getByName(s.trim()));
            }
            catch (UnknownHostException ex) {
                return "";
            }
        }
        ArrayList<InetAddress> addressesS = new ArrayList<InetAddress>(addressesB);
        IpAddressUtils.sortIpAddresses(addressesS, false);
        ArrayList<String> addressesStr = new ArrayList<String>(addressesS.size());
        for (InetAddress addr : addressesS) {
            addressesStr.add(strComps[addressesB.indexOf(addr)].trim());
        }
        return PacUtils.toSemiColonList(addressesStr);
    }

    @Override
    public String getClientVersion() {
        return "1.0";
    }

    @Override
    public boolean isInNetEx(String ipAddress, String ipPrefix) {
        String[] ipPrefixes;
        InetAddress iAddr;
        if (ipAddress == null) {
            return false;
        }
        if (ipPrefix == null) {
            return false;
        }
        try {
            iAddr = IpAddressUtils.nameResolve(ipAddress, 4000, IpAddressUtils.IpTypePreference.ANY_JDK_PREF);
        }
        catch (InterruptedException | UnknownHostException | TimeoutException ex) {
            return false;
        }
        for (String ipP : ipPrefixes = ipPrefix.split(";")) {
            if (!PacUtils.ipPrefixMatch(iAddr, ipP)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void alert(String message) {
        LOGGER.log(Level.INFO, "PAC script says : {0}", message);
    }

    private static String[] getDomains(String host) {
        String[] doms = host.split("\\.");
        ArrayList<String> domsList = new ArrayList<String>(doms.length);
        for (String dom : doms) {
            if (dom == null || dom.isEmpty()) continue;
            domsList.add(dom);
        }
        return domsList.toArray(new String[domsList.size()]);
    }

    private static int getNoOfOccurrences(String str, char ch) {
        int counter = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ch) continue;
            ++counter;
        }
        return counter;
    }
}

