/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.coverage;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.web.clientproject.api.jstesting.Coverage;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class CloverLogParser
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(CloverLogParser.class.getName());
    private final File sourceDir;
    final XMLReader xmlReader;
    final List<Coverage.File> files = new ArrayList<Coverage.File>();
    private boolean inWrongPackage = false;
    private String filePath;
    private Coverage.FileMetrics fileMetrics;
    private List<Coverage.Line> lines;

    private CloverLogParser(File sourceDir) throws SAXException {
        assert (sourceDir.isDirectory()) : sourceDir;
        this.sourceDir = sourceDir;
        this.xmlReader = CloverLogParser.createXmlReader();
    }

    private static CloverLogParser create(File sourceDir) throws SAXException {
        CloverLogParser parser = new CloverLogParser(sourceDir);
        parser.xmlReader.setContentHandler(parser);
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public static List<Coverage.File> parse(Reader reader, File sourceDir) {
        try {
            CloverLogParser parser = CloverLogParser.create(sourceDir);
            parser.xmlReader.parse(new InputSource(reader));
            List<Coverage.File> list = Collections.unmodifiableList(parser.files);
            return list;
        }
        catch (SAXException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (Throwable ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
        return null;
    }

    private static XMLReader createXmlReader() throws SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        try {
            return factory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("Cannot create SAX parser", ex);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("package".equals(qName)) {
            this.processPackageStart(attributes);
        }
        if (this.inWrongPackage) {
            return;
        }
        if ("file".equals(qName)) {
            this.processFileStart(attributes);
        } else if ("metrics".equals(qName)) {
            this.processMetricsStart(attributes);
        } else if ("line".equals(qName)) {
            this.processLine(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.inWrongPackage) {
            return;
        }
        if ("file".equals(qName)) {
            this.processFileEnd();
        }
    }

    private void processPackageStart(Attributes attributes) {
        String name = this.getName(attributes);
        this.inWrongPackage = name.startsWith("bower_components");
    }

    private void processFileStart(Attributes attributes) {
        assert (!this.inWrongPackage);
        assert (this.filePath == null) : this.filePath;
        assert (this.fileMetrics == null) : this.fileMetrics;
        assert (this.lines == null) : this.lines;
        String path = this.getPath(attributes);
        this.filePath = path.startsWith("./") ? new File(this.sourceDir, path.substring(2)).getAbsolutePath() : new File(path).getAbsolutePath();
        this.lines = new ArrayList<Coverage.Line>();
    }

    private void processMetricsStart(Attributes attributes) {
        assert (!this.inWrongPackage);
        if (this.filePath == null) {
            return;
        }
        this.fileMetrics = new Coverage.FileMetrics(this.getLineCount(this.filePath), this.getStatements(attributes), this.getCoveredStatements(attributes));
    }

    private void processFileEnd() {
        assert (!this.inWrongPackage);
        assert (this.filePath != null);
        assert (this.fileMetrics != null);
        this.files.add(new Coverage.File(this.filePath, this.fileMetrics, this.lines));
        this.filePath = null;
        this.fileMetrics = null;
        this.lines = null;
    }

    private void processLine(Attributes attributes) {
        assert (!this.inWrongPackage);
        assert (this.filePath != null) : attributes;
        assert (this.lines != null) : this.filePath;
        int number = this.getNum(attributes);
        int hits = this.getCount(attributes);
        if (number == -1 || hits == -1) {
            LOGGER.log(Level.INFO, "Unexpected line number or hits [{0}]", attributes);
            return;
        }
        this.lines.add(new Coverage.Line(number, hits));
    }

    private String getName(Attributes attributes) {
        return attributes.getValue("name");
    }

    private String getPath(Attributes attributes) {
        return attributes.getValue("path");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getLineCount(String filePath) {
        File file = new File(filePath);
        assert (file.isFile()) : file;
        FileObject fo = FileUtil.toFileObject((File)file);
        assert (fo != null) : file;
        try (LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), FileEncodingQuery.getEncoding((FileObject)fo)));){
            while (lineNumberReader.readLine() != null) {
            }
            int n = lineNumberReader.getLineNumber();
            return n;
        }
        catch (IOException exc) {
            LOGGER.log(Level.WARNING, null, exc);
            return -1;
        }
    }

    private int getStatements(Attributes attributes) {
        return this.getInt(attributes, "statements");
    }

    private int getCoveredStatements(Attributes attributes) {
        return this.getInt(attributes, "coveredstatements");
    }

    private int getNum(Attributes attributes) {
        return this.getInt(attributes, "num");
    }

    private int getCount(Attributes attributes) {
        return this.getInt(attributes, "count");
    }

    private int getInt(Attributes attributes, String name) {
        int i = -1;
        try {
            i = Integer.parseInt(attributes.getValue(name));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return i;
    }
}

