/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jvyamlb.Position;
import org.jvyamlb.Positionable;
import org.jvyamlb.nodes.Node;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.languages.yaml.YamlParser;
import org.netbeans.modules.languages.yaml.YamlScanner;
import org.netbeans.modules.parsing.api.Snapshot;

public class YamlParserResult
extends ParserResult {
    private final List<Error> errors = new ArrayList<Error>();
    private List<Node> nodes;
    private List<? extends StructureItem> items;
    private int[] byteToUtf8;
    private int[] utf8ToByte;

    public YamlParserResult(List<Node> nodes, YamlParser parser, Snapshot snapshot, boolean valid, int[] byteToUtf8, int[] utf8ToByte) {
        super(snapshot);
        assert (nodes != null);
        this.nodes = nodes;
        this.byteToUtf8 = byteToUtf8;
        this.utf8ToByte = utf8ToByte;
    }

    public List<Node> getRootNodes() {
        return this.nodes;
    }

    public void addError(Error error) {
        this.errors.add(error);
    }

    public List<? extends Error> getDiagnostics() {
        return Collections.unmodifiableList(this.errors);
    }

    protected void invalidate() {
    }

    public synchronized List<? extends StructureItem> getItems() {
        if (this.items == null) {
            this.items = new YamlScanner().scanStructure(this);
        }
        return this.items;
    }

    public void setItems(List<? extends StructureItem> items) {
        this.items = items;
    }

    public int convertUtf8ToByte(int utf8Pos) {
        if (this.utf8ToByte == null) {
            return utf8Pos;
        }
        if (utf8Pos < this.utf8ToByte.length) {
            return this.utf8ToByte[utf8Pos];
        }
        return this.utf8ToByte.length;
    }

    public int convertByteToUtf8(int bytePos) {
        if (this.byteToUtf8 == null) {
            return bytePos;
        }
        if (bytePos < this.byteToUtf8.length) {
            return this.byteToUtf8[bytePos];
        }
        return this.byteToUtf8.length;
    }

    public OffsetRange getAstRange(Position.Range range) {
        int start = range.start.offset;
        int end = range.end.offset;
        if (this.byteToUtf8 == null) {
            return new OffsetRange(start, end);
        }
        int s = start >= this.byteToUtf8.length ? this.byteToUtf8.length : this.byteToUtf8[start];
        int e = end >= this.byteToUtf8.length ? this.byteToUtf8.length : this.byteToUtf8[end];
        return new OffsetRange(s, e);
    }

    public OffsetRange getAstRange(Node node) {
        return this.getAstRange(((Positionable)node).getRange());
    }
}

