/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.PropertyNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Collections;
import java.util.List;

public class ClassNode
extends Expression {
    private final IdentNode ident;
    private final Expression classHeritage;
    private final PropertyNode constructor;
    private final List<PropertyNode> classElements;
    private final List<Expression> decorators;
    private final int line;

    public ClassNode(int n, long l, int n2, IdentNode identNode, Expression expression, PropertyNode propertyNode, List<PropertyNode> list, List<Expression> list2) {
        super(l, n2);
        this.line = n;
        this.ident = identNode;
        this.classHeritage = expression;
        this.constructor = propertyNode;
        this.classElements = list;
        this.decorators = list2;
    }

    private ClassNode(ClassNode classNode, IdentNode identNode, Expression expression, PropertyNode propertyNode, List<PropertyNode> list, List<Expression> list2) {
        super(classNode);
        this.line = classNode.getLineNumber();
        this.ident = identNode;
        this.classHeritage = expression;
        this.constructor = propertyNode;
        this.classElements = list;
        this.decorators = list2;
    }

    public IdentNode getIdent() {
        return this.ident;
    }

    private ClassNode setIdent(IdentNode identNode) {
        if (this.ident == identNode) {
            return this;
        }
        return new ClassNode(this, identNode, this.classHeritage, this.constructor, this.classElements, this.decorators);
    }

    public Expression getClassHeritage() {
        return this.classHeritage;
    }

    private ClassNode setClassHeritage(Expression expression) {
        if (this.classHeritage == expression) {
            return this;
        }
        return new ClassNode(this, this.ident, expression, this.constructor, this.classElements, this.decorators);
    }

    public PropertyNode getConstructor() {
        return this.constructor;
    }

    private ClassNode setConstructor(PropertyNode propertyNode) {
        if (this.constructor == propertyNode) {
            return this;
        }
        return new ClassNode(this, this.ident, this.classHeritage, propertyNode, this.classElements, this.decorators);
    }

    public List<PropertyNode> getClassElements() {
        return Collections.unmodifiableList(this.classElements);
    }

    private ClassNode setClassElements(List<PropertyNode> list) {
        if (this.classElements == list) {
            return this;
        }
        return new ClassNode(this, this.ident, this.classHeritage, this.constructor, list, this.decorators);
    }

    public List<Expression> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    private ClassNode setDecorators(List<Expression> list) {
        if (this.decorators == list) {
            return this;
        }
        return new ClassNode(this, this.ident, this.classHeritage, this.constructor, this.classElements, list);
    }

    public int getLineNumber() {
        return this.line;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterClassNode(this)) {
            IdentNode identNode = this.ident == null ? null : (IdentNode)this.ident.accept(nodeVisitor);
            Expression expression = this.classHeritage == null ? null : (Expression)this.classHeritage.accept(nodeVisitor);
            PropertyNode propertyNode = this.constructor == null ? null : (PropertyNode)this.constructor.accept(nodeVisitor);
            return nodeVisitor.leaveClassNode(this.setIdent(identNode).setClassHeritage(expression).setConstructor(propertyNode).setClassElements(Node.accept(nodeVisitor, this.classElements)).setDecorators(Node.accept(nodeVisitor, this.decorators)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterClassNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("class");
        if (this.ident != null) {
            stringBuilder.append(' ');
            this.ident.toString(stringBuilder, bl);
        }
        if (this.classHeritage != null) {
            stringBuilder.append(" extends");
            this.classHeritage.toString(stringBuilder, bl);
        }
        stringBuilder.append(" {");
        if (this.constructor != null) {
            this.constructor.toString(stringBuilder, bl);
        }
        for (PropertyNode propertyNode : this.classElements) {
            stringBuilder.append(" ");
            propertyNode.toString(stringBuilder, bl);
        }
        stringBuilder.append("}");
    }
}

