/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.execution.ExecutionEvent;
import org.json.simple.JSONObject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.maven.execute.cmd.ExecMojo;
import org.netbeans.modules.maven.execute.cmd.ExecProject;
import org.netbeans.modules.maven.execute.cmd.ExecSession;
import org.openide.windows.FoldHandle;
import org.openide.windows.IOFolding;
import org.openide.windows.IOPosition;
import org.openide.windows.InputOutput;

public class ExecutionEventObject {
    public final ExecutionEvent.Type type;
    private static final List<ExecutionEvent.Type> mojo_types = Arrays.asList(ExecutionEvent.Type.MojoStarted, ExecutionEvent.Type.MojoFailed, ExecutionEvent.Type.MojoSucceeded, ExecutionEvent.Type.MojoSkipped);
    private static final List<ExecutionEvent.Type> project_types = Arrays.asList(ExecutionEvent.Type.ProjectStarted, ExecutionEvent.Type.ProjectFailed, ExecutionEvent.Type.ProjectSucceeded, ExecutionEvent.Type.ProjectSkipped);
    private static final List<ExecutionEvent.Type> session_types = Arrays.asList(ExecutionEvent.Type.SessionStarted, ExecutionEvent.Type.SessionEnded);

    public ExecutionEventObject(ExecutionEvent.Type type) {
        this.type = type;
    }

    public static ExecutionEventObject create(JSONObject obj) {
        String s = (String)obj.get((Object)"type");
        ExecutionEvent.Type t = ExecutionEvent.Type.valueOf((String)s);
        if (mojo_types.contains(t)) {
            return ExecMojo.create(obj, t);
        }
        if (project_types.contains(t)) {
            return ExecProject.create(obj, t);
        }
        if (session_types.contains(t)) {
            return ExecSession.create(obj, t);
        }
        return new ExecutionEventObject(t);
    }

    public static class Tree {
        private final ExecutionEventObject startEvent;
        private ExecutionEventObject endEvent;
        private Tree parentNode;
        private final List<Tree> childrenNodes = new ArrayList<Tree>();
        private IOPosition.Position startOffset;
        private IOPosition.Position endOffset;
        private FoldHandle foldHandle;
        private FoldHandle innerOutputFoldHandle;

        public Tree(ExecutionEventObject current, Tree parent) {
            this.startEvent = current;
            this.parentNode = parent;
        }

        @CheckForNull
        public IOPosition.Position getStartOffset() {
            return this.startOffset;
        }

        public void setStartOffset(@NonNull IOPosition.Position startOffset) {
            this.startOffset = startOffset;
        }

        @CheckForNull
        public IOPosition.Position getEndOffset() {
            return this.endOffset;
        }

        public void setEndOffset(@NonNull IOPosition.Position endOffset) {
            this.endOffset = endOffset;
        }

        public void setEndEvent(ExecutionEventObject endEvent) {
            this.endEvent = endEvent;
            if (ExecutionEvent.Type.MojoStarted.equals((Object)this.startEvent.type)) {
                ((ExecMojo)this.startEvent).setClasspathURLs(((ExecMojo)endEvent).getClasspathURLs());
            }
            assert (endEvent != null && endEvent.getClass().equals(this.startEvent.getClass()));
        }

        @CheckForNull
        public ExecutionEventObject getStartEvent() {
            return this.startEvent;
        }

        @CheckForNull
        public ExecutionEventObject getEndEvent() {
            return this.endEvent;
        }

        @CheckForNull
        public Tree getParentNode() {
            return this.parentNode;
        }

        @NonNull
        public List<Tree> getChildrenNodes() {
            return this.childrenNodes;
        }

        public Tree findParentNodeOfType(ExecutionEvent.Type startType) {
            if (this.parentNode == null) {
                return null;
            }
            ExecutionEventObject event = this.parentNode.getStartEvent();
            if (event == null) {
                return null;
            }
            if (startType.equals((Object)event.type)) {
                return this.parentNode;
            }
            return this.parentNode.findParentNodeOfType(startType);
        }

        public void reassingParent(Tree parent) {
            this.parentNode = parent;
        }

        public void startFold(InputOutput io) {
            if (!IOFolding.isSupported((InputOutput)io)) {
                return;
            }
            assert (this.foldHandle == null);
            Tree parentProject = this.findParentNodeOfType(ExecutionEvent.Type.MojoStarted);
            if (parentProject != null) {
                assert (parentProject.foldHandle != null);
                this.foldHandle = parentProject.foldHandle.silentStartFold(true);
                return;
            }
            parentProject = this.findParentNodeOfType(ExecutionEvent.Type.ProjectStarted);
            if (parentProject == null) {
                this.foldHandle = IOFolding.startFold((InputOutput)io, (boolean)true);
            } else {
                if (parentProject.foldHandle == null) {
                    parentProject.startFold(io);
                }
                assert (parentProject.foldHandle != null);
                this.foldHandle = parentProject.foldHandle.silentStartFold(true);
            }
        }

        public void finishFold() {
            if (this.foldHandle != null) {
                this.finishInnerOutputFold();
                if (!this.foldHandle.isFinished()) {
                    this.foldHandle.silentFinish();
                }
            }
        }

        public void startInnerOutputFold(InputOutput io) {
            if (!IOFolding.isSupported((InputOutput)io)) {
                return;
            }
            if (this.innerOutputFoldHandle != null && !this.innerOutputFoldHandle.isFinished()) {
                this.innerOutputFoldHandle.silentFinish();
            }
            this.innerOutputFoldHandle = this.foldHandle != null ? this.foldHandle.silentStartFold(true) : IOFolding.startFold((InputOutput)io, (boolean)true);
        }

        public void finishInnerOutputFold() {
            if (this.innerOutputFoldHandle != null) {
                if (!this.innerOutputFoldHandle.isFinished()) {
                    this.innerOutputFoldHandle.silentFinish();
                }
                this.innerOutputFoldHandle = null;
            }
        }

        public boolean hasInnerOutputFold() {
            return this.innerOutputFoldHandle != null;
        }

        public void collapseFold() {
            if (this.foldHandle != null) {
                this.foldHandle.setExpanded(false);
            }
        }

        public void expandFold() {
            if (this.foldHandle != null) {
                this.foldHandle.setExpanded(true);
            }
        }
    }

    public static class GAV {
        public final String groupId;
        public final String artifactId;
        public final String version;

        public GAV(@NonNull String groupId, @NonNull String artifactId, @NonNull String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getId() {
            return this.groupId + ":" + this.artifactId + ":" + this.version;
        }
    }
}

