/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.dd.api.application.Web;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ui.customizer.AdditionalContentTableModel;
import org.netbeans.modules.j2ee.earproject.ui.customizer.CustomizerRun;
import org.netbeans.modules.j2ee.earproject.util.EarProjectUtil;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ClassPathUiSupport;
import org.netbeans.modules.java.api.common.project.ui.customizer.ClassPathListCellRenderer;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.modules.javaee.project.api.ant.DeployOnSaveUtils;
import org.netbeans.modules.javaee.project.api.ant.ui.J2EEProjectProperties;
import org.netbeans.modules.javaee.project.api.ui.utils.J2eePlatformUiSupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.browser.api.BrowserUISupport;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.ui.StoreGroup;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public final class EarProjectProperties {
    public static final String WEB_PROJECT_NAME = "web.project.name";
    public static final String JAVA_PLATFORM = "platform.active";
    public static final String J2EE_PLATFORM = "j2ee.platform";
    public static final String J2EE_PLATFORM_CLASSPATH = "j2ee.platform.classpath";
    public static final String SOURCE_ROOT = "source.root";
    public static final String BUILD_FILE = "buildfile";
    public static final String LIBRARIES_DIR = "lib.dir";
    public static final String DIST_DIR = "dist.dir";
    public static final String DIST_JAR = "dist.jar";
    public static final String JAVAC_CLASSPATH = "javac.classpath";
    public static final String DEBUG_CLASSPATH = "debug.classpath";
    public static final String RUN_CLASSPATH = "run.classpath";
    public static final String JAR_NAME = "jar.name";
    public static final String JAR_COMPRESS = "jar.compress";
    public static final String JAR_CONTENT_ADDITIONAL = "jar.content.additional";
    public static final String APPLICATION_CLIENT = "app.client";
    public static final String APPCLIENT_MAIN_CLASS = "main.class";
    public static final String APPCLIENT_ARGS = "application.args";
    public static final String APPCLIENT_JVM_OPTIONS = "j2ee.appclient.jvmoptions";
    public static final String APPCLIENT_MAINCLASS_ARGS = "j2ee.appclient.mainclass.args";
    public static final String LAUNCH_URL_RELATIVE = "client.urlPart";
    public static final String DISPLAY_BROWSER = "display.browser";
    public static final String J2EE_DEPLOY_ON_SAVE = "j2ee.deploy.on.save";
    public static final String J2EE_COMPILE_ON_SAVE = "j2ee.compile.on.save";
    public static final String CLIENT_MODULE_URI = "client.module.uri";
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    public static final String J2EE_SERVER_TYPE = "j2ee.server.type";
    public static final String JAVAC_SOURCE = "javac.source";
    public static final String JAVAC_DEBUG = "javac.debug";
    public static final String JAVAC_DEPRECATION = "javac.deprecation";
    public static final String JAVAC_TARGET = "javac.target";
    public static final String META_INF = "meta.inf";
    public static final String RESOURCE_DIR = "resource.dir";
    public static final String WEB_DOCBASE_DIR = "web.docbase.dir";
    public static final String BUILD_DIR = "build.dir";
    public static final String BUILD_GENERATED_DIR = "build.generated.dir";
    public static final String BUILD_CLASSES_EXCLUDES = "build.classes.excludes";
    public static final String DIST_JAVADOC_DIR = "dist.javadoc.dir";
    public static final String NO_DEPENDENCIES = "no.dependencies";
    public static final String JAVADOC_PRIVATE = "javadoc.private";
    public static final String JAVADOC_NO_TREE = "javadoc.notree";
    public static final String JAVADOC_USE = "javadoc.use";
    public static final String JAVADOC_NO_NAVBAR = "javadoc.nonavbar";
    public static final String JAVADOC_NO_INDEX = "javadoc.noindex";
    public static final String JAVADOC_SPLIT_INDEX = "javadoc.splitindex";
    public static final String JAVADOC_AUTHOR = "javadoc.author";
    public static final String JAVADOC_VERSION = "javadoc.version";
    public static final String JAVADOC_WINDOW_TITLE = "javadoc.windowtitle";
    public static final String JAVADOC_ENCODING = "javadoc.encoding";
    public static final String JAVADOC_PREVIEW = "javadoc.preview";
    public static final String COMPILE_JSPS = "compile.jsps";
    public static final String CLIENT_NAME = "j2ee.clientName";
    public static final String APPCLIENT_TOOL_RUNTIME = "j2ee.appclient.tool.runtime";
    public static final String APPCLIENT_TOOL_MAINCLASS = "j2ee.appclient.tool.mainclass";
    public static final String APPCLIENT_TOOL_JVMOPTS = "j2ee.appclient.tool.jvmoptions";
    public static final String APPCLIENT_TOOL_ARGS = "j2ee.appclient.tool.args";
    private static final String J2EE_PLATFORM_APPCLIENT_ARGS = "j2ee.appclient.args";
    static final String APPCLIENT_WA_COPY_CLIENT_JAR_FROM = "wa.copy.client.jar.from";
    public static final String TAG_WEB_MODULE_LIBRARIES = "web-module-libraries";
    public static final String TAG_WEB_MODULE__ADDITIONAL_LIBRARIES = "web-module-additional-libraries";
    public static final String DEPLOY_ANT_PROPS_FILE = "deploy.ant.properties.file";
    public static final String ANT_DEPLOY_BUILD_SCRIPT = "nbproject/ant-deploy.xml";
    public static final String SELECTED_BROWSER = "selected.browser";
    private static final Logger LOGGER = Logger.getLogger(EarProjectProperties.class.getName());
    Document SHARED_LIBRARIES_MODEL;
    DefaultListModel DEBUG_CLASSPATH_MODEL;
    DefaultListModel ENDORSED_CLASSPATH_MODEL;
    ListCellRenderer CLASS_PATH_LIST_RENDERER;
    Document ARCHIVE_NAME_MODEL;
    ButtonModel ARCHIVE_COMPRESS_MODEL;
    Document BUILD_CLASSES_EXCLUDES_MODEL;
    AdditionalContentTableModel EAR_CONTENT_ADDITIONAL_MODEL;
    TableCellRenderer CLASS_PATH_TABLE_RENDERER;
    CustomizerRun.ApplicationUrisComboBoxModel CLIENT_MODULE_MODEL;
    ComboBoxModel J2EE_SERVER_INSTANCE_MODEL;
    Document J2EE_PLATFORM_MODEL;
    ButtonModel DISPLAY_BROWSER_MODEL;
    Document LAUNCH_URL_RELATIVE_MODEL;
    Document MAIN_CLASS_MODEL;
    Document ARUGMENTS_MODEL;
    Document VM_OPTIONS_MODEL;
    Document APPLICATION_CLIENT_MODEL;
    JToggleButton.ToggleButtonModel DEPLOY_ON_SAVE_MODEL;
    JToggleButton.ToggleButtonModel COMPILE_ON_SAVE_MODEL;
    BrowserUISupport.BrowserComboBoxModel BROWSERS_MODEL;
    private StoreGroup privateGroup;
    private StoreGroup projectGroup;
    private final AntProjectHelper antProjectHelper;
    private final ReferenceHelper refHelper;
    private final UpdateHelper updateHelper;
    private final EarProject project;
    private final GeneratedFilesHelper genFilesHelper;
    private PropertyEvaluator evaluator;
    public ClassPathSupport cs;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    EarProjectProperties(EarProject project, UpdateHelper updateHelper, PropertyEvaluator evaluator, ReferenceHelper refHelper) {
        this.project = project;
        this.updateHelper = project.getUpdateHelper();
        this.antProjectHelper = updateHelper.getAntProjectHelper();
        this.refHelper = refHelper;
        this.genFilesHelper = project.getGeneratedFilesHelper();
        this.evaluator = evaluator;
        this.privateGroup = new StoreGroup();
        this.projectGroup = new StoreGroup();
        this.cs = project.getClassPathSupport();
        this.init();
    }

    private void init() {
        this.SHARED_LIBRARIES_MODEL = new PlainDocument();
        try {
            this.SHARED_LIBRARIES_MODEL.insertString(0, this.project.getAntProjectHelper().getLibrariesLocation(), null);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        EditableProperties projectProperties = this.updateHelper.getProperties("nbproject/project.properties");
        EditableProperties privateProperties = this.updateHelper.getProperties("nbproject/private/private.properties");
        this.DEBUG_CLASSPATH_MODEL = ClassPathUiSupport.createListModel((Iterator)this.cs.itemsIterator(projectProperties.get((Object)RUN_CLASSPATH), null));
        this.ENDORSED_CLASSPATH_MODEL = ClassPathUiSupport.createListModel((Iterator)this.cs.itemsIterator(projectProperties.get((Object)"endorsed.classpath"), null));
        this.CLASS_PATH_LIST_RENDERER = ClassPathListCellRenderer.createClassPathListRenderer((PropertyEvaluator)this.evaluator, (FileObject)this.project.getProjectDirectory());
        this.ARCHIVE_COMPRESS_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, JAR_COMPRESS);
        this.ARCHIVE_NAME_MODEL = this.projectGroup.createStringDocument(this.evaluator, JAR_NAME);
        this.BUILD_CLASSES_EXCLUDES_MODEL = this.projectGroup.createStringDocument(this.evaluator, BUILD_CLASSES_EXCLUDES);
        this.EAR_CONTENT_ADDITIONAL_MODEL = AdditionalContentTableModel.createTableModel(this.cs.itemsIterator(projectProperties.get((Object)JAR_CONTENT_ADDITIONAL), TAG_WEB_MODULE__ADDITIONAL_LIBRARIES));
        this.EAR_CONTENT_ADDITIONAL_MODEL.getDefaultListModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                EarProjectProperties.this.CLIENT_MODULE_MODEL.refresh(ClassPathUiSupport.getList((DefaultListModel)EarProjectProperties.this.EAR_CONTENT_ADDITIONAL_MODEL.getDefaultListModel()));
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                EarProjectProperties.this.CLIENT_MODULE_MODEL.refresh(ClassPathUiSupport.getList((DefaultListModel)EarProjectProperties.this.EAR_CONTENT_ADDITIONAL_MODEL.getDefaultListModel()));
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                EarProjectProperties.this.CLIENT_MODULE_MODEL.refresh(ClassPathUiSupport.getList((DefaultListModel)EarProjectProperties.this.EAR_CONTENT_ADDITIONAL_MODEL.getDefaultListModel()));
            }
        });
        this.CLASS_PATH_TABLE_RENDERER = ClassPathListCellRenderer.createClassPathTableRenderer((PropertyEvaluator)this.evaluator, (FileObject)this.project.getProjectDirectory());
        this.J2EE_PLATFORM_MODEL = this.projectGroup.createStringDocument(this.evaluator, J2EE_PLATFORM);
        this.LAUNCH_URL_RELATIVE_MODEL = this.projectGroup.createStringDocument(this.evaluator, LAUNCH_URL_RELATIVE);
        this.DISPLAY_BROWSER_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, DISPLAY_BROWSER);
        this.DEPLOY_ON_SAVE_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, J2EE_DEPLOY_ON_SAVE);
        this.COMPILE_ON_SAVE_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, J2EE_COMPILE_ON_SAVE);
        this.COMPILE_ON_SAVE_MODEL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EarProjectProperties.this.COMPILE_ON_SAVE_MODEL.isSelected()) {
                    EarProjectProperties.this.DEPLOY_ON_SAVE_MODEL.setSelected(false);
                }
            }
        });
        this.DEPLOY_ON_SAVE_MODEL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EarProjectProperties.this.DEPLOY_ON_SAVE_MODEL.isSelected()) {
                    EarProjectProperties.this.COMPILE_ON_SAVE_MODEL.setSelected(true);
                }
            }
        });
        this.J2EE_SERVER_INSTANCE_MODEL = J2eePlatformUiSupport.createPlatformComboBoxModel((String)privateProperties.getProperty(J2EE_SERVER_INSTANCE), (Profile)Profile.fromPropertiesString((String)projectProperties.getProperty(J2EE_PLATFORM)), (J2eeModule.Type)J2eeModule.Type.EAR);
        this.MAIN_CLASS_MODEL = this.projectGroup.createStringDocument(this.evaluator, APPCLIENT_MAIN_CLASS);
        this.ARUGMENTS_MODEL = this.projectGroup.createStringDocument(this.evaluator, APPCLIENT_ARGS);
        this.VM_OPTIONS_MODEL = this.projectGroup.createStringDocument(this.evaluator, APPCLIENT_JVM_OPTIONS);
        this.APPLICATION_CLIENT_MODEL = this.projectGroup.createStringDocument(this.evaluator, APPLICATION_CLIENT);
        this.CLIENT_MODULE_MODEL = CustomizerRun.createApplicationUrisComboBoxModel(this.project);
        String selectedBrowser = this.evaluator.getProperty(SELECTED_BROWSER);
        this.BROWSERS_MODEL = BrowserUISupport.createBrowserModel((String)selectedBrowser, (boolean)true);
    }

    private void saveLibrariesLocation() throws IOException, IllegalArgumentException {
        try {
            String old;
            String str = this.SHARED_LIBRARIES_MODEL.getText(0, this.SHARED_LIBRARIES_MODEL.getLength()).trim();
            if (str.length() == 0) {
                str = null;
            }
            if (!((old = this.project.getAntProjectHelper().getLibrariesLocation()) == null && str == null || old != null && old.equals(str))) {
                this.project.getAntProjectHelper().setLibrariesLocation(str);
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
        }
        catch (BadLocationException x) {
            Exceptions.printStackTrace((Throwable)x);
        }
    }

    private void storeProperties() throws IOException {
        this.resolveProjectDependencies();
        String[] debug_cp = this.cs.encodeToStrings(ClassPathUiSupport.getList((DefaultListModel)this.DEBUG_CLASSPATH_MODEL), null);
        String[] additional_content = this.cs.encodeToStrings(ClassPathUiSupport.getList((DefaultListModel)this.EAR_CONTENT_ADDITIONAL_MODEL.getDefaultListModel()), TAG_WEB_MODULE__ADDITIONAL_LIBRARIES);
        String[] endorsed_cp = this.cs.encodeToStrings(ClassPathUiSupport.getList((DefaultListModel)this.ENDORSED_CLASSPATH_MODEL), null);
        EditableProperties projectProperties = this.updateHelper.getProperties("nbproject/project.properties");
        EditableProperties privateProperties = this.updateHelper.getProperties("nbproject/private/private.properties");
        this.projectGroup.store(projectProperties);
        this.privateGroup.store(privateProperties);
        projectProperties.setProperty(RUN_CLASSPATH, debug_cp);
        projectProperties.setProperty(JAR_CONTENT_ADDITIONAL, additional_content);
        projectProperties.setProperty("endorsed.classpath", endorsed_cp);
        if (this.J2EE_SERVER_INSTANCE_MODEL.getSelectedItem() != null) {
            Profile profile = Profile.fromPropertiesString((String)this.project.evaluator().getProperty(J2EE_PLATFORM));
            String serverInstance = J2eePlatformUiSupport.getServerInstanceID((Object)this.J2EE_SERVER_INSTANCE_MODEL.getSelectedItem());
            J2EEProjectProperties.updateServerProperties((EditableProperties)projectProperties, (EditableProperties)privateProperties, (String)serverInstance, null, null, (J2EEProjectProperties.Callback)new CallbackImpl(this.project), (Project)this.project, (Profile)profile, (J2eeModule.Type)J2eeModule.Type.EAR);
            EarProjectProperties.updateEarServerProperties(serverInstance, projectProperties, privateProperties);
        }
        this.CLIENT_MODULE_MODEL.storeSelectedItem(projectProperties);
        privateProperties.setProperty(SELECTED_BROWSER, this.BROWSERS_MODEL.getSelectedBrowserId());
        this.updateHelper.putProperties("nbproject/project.properties", projectProperties);
        this.updateHelper.putProperties("nbproject/private/private.properties", privateProperties);
        if (this.COMPILE_ON_SAVE_MODEL.isEnabled() && this.COMPILE_ON_SAVE_MODEL.isSelected()) {
            LOGGER.log(Level.FINE, "Starting listening on cos for {0}", this.project.getAppModule());
            Deployment.getDefault().enableCompileOnSaveSupport((J2eeModuleProvider)this.project.getAppModule());
        } else {
            LOGGER.log(Level.FINE, "Stopping listening on cos for {0}", this.project.getAppModule());
            Deployment.getDefault().disableCompileOnSaveSupport((J2eeModuleProvider)this.project.getAppModule());
        }
    }

    public static void setServerInstance(final EarProject project, final UpdateHelper helper, final String serverInstanceID) {
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    EditableProperties projectProps = helper.getProperties("nbproject/project.properties");
                    EditableProperties privateProps = helper.getProperties("nbproject/private/private.properties");
                    Profile profile = Profile.fromPropertiesString((String)project.evaluator().getProperty(EarProjectProperties.J2EE_PLATFORM));
                    J2EEProjectProperties.updateServerProperties((EditableProperties)projectProps, (EditableProperties)privateProps, (String)serverInstanceID, null, null, (J2EEProjectProperties.Callback)new CallbackImpl(project), (Project)project, (Profile)profile, (J2eeModule.Type)J2eeModule.Type.EAR);
                    EarProjectProperties.updateEarServerProperties(serverInstanceID, projectProps, privateProps);
                    helper.putProperties("nbproject/project.properties", projectProps);
                    helper.putProperties("nbproject/private/private.properties", privateProps);
                    ProjectManager.getDefault().saveProject((Project)project);
                    EarProjectProperties.setupDeploymentDescriptor(project);
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        });
    }

    private static void updateEarServerProperties(String newServInstID, EditableProperties projectProps, EditableProperties privateProps) {
        assert (newServInstID != null) : "Server isntance id to set can't be null";
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(newServInstID);
        if (j2eePlatform == null) {
            privateProps.remove((Object)APPCLIENT_TOOL_RUNTIME);
            return;
        }
        Map roots = J2EEProjectProperties.extractPlatformLibrariesRoot((J2eePlatform)j2eePlatform);
        if (j2eePlatform.isToolSupported("appClientRuntime")) {
            File[] wsClasspath = j2eePlatform.getToolClasspathEntries("appClientRuntime");
            privateProps.setProperty(APPCLIENT_TOOL_RUNTIME, J2EEProjectProperties.toClasspathString((File[])wsClasspath, (Map)roots));
        } else {
            privateProps.remove((Object)APPCLIENT_TOOL_RUNTIME);
        }
        String mainClassArgs = j2eePlatform.getToolProperty("appClientRuntime", "main.class.args");
        if (mainClassArgs != null && !mainClassArgs.equals("")) {
            projectProps.setProperty(APPCLIENT_MAINCLASS_ARGS, mainClassArgs);
            projectProps.remove((Object)CLIENT_NAME);
        } else {
            mainClassArgs = j2eePlatform.getToolProperty("appClientRuntime", CLIENT_NAME);
            if (mainClassArgs != null) {
                projectProps.setProperty(CLIENT_NAME, mainClassArgs);
                projectProps.remove((Object)APPCLIENT_MAINCLASS_ARGS);
            } else {
                projectProps.remove((Object)APPCLIENT_MAINCLASS_ARGS);
                projectProps.remove((Object)CLIENT_NAME);
            }
        }
        EarProjectProperties.setAppClientPrivateProperties(j2eePlatform, newServInstID, privateProps);
    }

    static void updateContentDependency(EarProject project, List<ClassPathSupport.Item> oldContent, List<ClassPathSupport.Item> newContent, EditableProperties props) {
        Application app = project.getAppModule().getApplication();
        if (app == null) {
            return;
        }
        HashSet<ClassPathSupport.Item> deleted = new HashSet<ClassPathSupport.Item>(oldContent);
        deleted.removeAll(newContent);
        HashSet<ClassPathSupport.Item> added = new HashSet<ClassPathSupport.Item>(newContent);
        added.removeAll(oldContent);
        HashSet<ClassPathSupport.Item> needsUpdate = new HashSet<ClassPathSupport.Item>(newContent);
        needsUpdate.removeAll(added);
        boolean saveNeeded = false;
        for (ClassPathSupport.Item item : deleted) {
            EarProjectProperties.removeItemFromAppDD(project, app, item);
            saveNeeded = true;
        }
        for (ClassPathSupport.Item item : added) {
            EarProjectProperties.addItemToAppDD(project, app, item);
            saveNeeded = true;
        }
        for (ClassPathSupport.Item item : needsUpdate) {
            ClassPathSupport.Item old = oldContent.get(oldContent.indexOf(item));
            boolean bl = old.getAdditionalProperty("pathInDeployment") == null ? item.getAdditionalProperty("pathInDeployment") != null : !old.getAdditionalProperty("pathInDeployment").equals(item.getAdditionalProperty("pathInDeployment"));
            boolean changed = bl;
            if (!changed) continue;
            EarProjectProperties.removeItemFromAppDD(project, app, old);
            EarProjectProperties.addItemToAppDD(project, app, item);
            saveNeeded = true;
        }
        if (saveNeeded && EarProjectUtil.isDDWritable(project)) {
            try {
                app.write(project.getAppModule().getDeploymentDescriptor());
            }
            catch (IOException ioe) {
                Logger.getLogger("global").log(Level.INFO, ioe.getLocalizedMessage());
            }
        }
    }

    private static void removeItemFromAppDD(EarProject project, Application dd, ClassPathSupport.Item item) {
        String pathInEAR = EarProjectProperties.getCompletePathInArchive(project, item);
        Module m = EarProjectProperties.searchForModule(dd, pathInEAR);
        if (null != m) {
            J2eeModule jm;
            AntArtifact aa;
            Project p;
            J2eeModuleProvider jmp;
            dd.removeModule(m);
            if (item.getType() == 2 && !item.isBroken() && null != (jmp = (J2eeModuleProvider)(p = (aa = item.getArtifact()).getProject()).getLookup().lookup(J2eeModuleProvider.class)) && null != (jm = jmp.getJ2eeModule())) {
                project.getAppModule().removeModuleProvider(jmp, pathInEAR);
            }
        }
    }

    private static Module searchForModule(Application dd, String path) {
        Module[] mods = dd.getModule();
        int len = 0;
        if (null != mods) {
            len = mods.length;
        }
        for (int i = 0; i < len; ++i) {
            String val = mods[i].getEjb();
            if (null != val && val.equals(path)) {
                return mods[i];
            }
            val = mods[i].getConnector();
            if (null != val && val.equals(path)) {
                return mods[i];
            }
            val = mods[i].getJava();
            if (null != val && val.equals(path)) {
                return mods[i];
            }
            Web w = mods[i].getWeb();
            val = null;
            if (null != w) {
                val = w.getWebUri();
            }
            if (null == val || !val.equals(path)) continue;
            return mods[i];
        }
        return null;
    }

    public static void addItemToAppDD(EarProject project, Application dd, ClassPathSupport.Item item) {
        if (item.isBroken()) {
            return;
        }
        String path = EarProjectProperties.getCompletePathInArchive(project, item);
        Module mod = null;
        if (item.getType() == 2) {
            mod = EarProjectProperties.getModFromAntArtifact(project, item.getArtifact(), dd, path);
        } else if (item.getType() == 0) {
            mod = EarProjectProperties.getModFromFile(item.getResolvedFile(), dd, path);
        }
        Module prevMod = EarProjectProperties.searchForModule(dd, path);
        if (null == prevMod && null != mod) {
            dd.addModule(mod);
        }
    }

    private static Module getModFromAntArtifact(EarProject project, AntArtifact aa, Application dd, String path) {
        Project p = aa.getProject();
        Module mod = null;
        try {
            J2eeModuleProvider jmp = (J2eeModuleProvider)p.getLookup().lookup(J2eeModuleProvider.class);
            if (null != jmp) {
                J2eeModule jm;
                String serverInstanceId = project.getServerInstanceID();
                if (serverInstanceId != null) {
                    jmp.setServerInstanceID(serverInstanceId);
                }
                if (null == (jm = jmp.getJ2eeModule())) {
                    return null;
                }
                project.getAppModule().addModuleProvider(jmp, path);
                mod = (Module)dd.createBean("Module");
                if (J2eeModule.Type.EJB.equals(jm.getType())) {
                    mod.setEjb(path);
                } else if (J2eeModule.Type.WAR.equals(jm.getType())) {
                    Web w = mod.newWeb();
                    w.setWebUri(path);
                    FileObject tmp = aa.getScriptFile();
                    if (null != tmp) {
                        tmp = tmp.getParent().getFileObject("web/WEB-INF/web.xml");
                    }
                    WebModule wm = null;
                    if (null != tmp) {
                        wm = WebModule.getWebModule((FileObject)tmp);
                    }
                    String contextPath = null;
                    if (null != wm) {
                        contextPath = wm.getContextPath();
                    }
                    if (contextPath == null) {
                        int endex = path.length() - 4;
                        if (endex < 1) {
                            endex = path.length();
                        }
                        contextPath = "/" + path.substring(0, endex);
                    }
                    w.setContextRoot(contextPath);
                    mod.setWeb(w);
                } else if (J2eeModule.Type.RAR.equals(jm.getType())) {
                    mod.setConnector(path);
                } else if (J2eeModule.Type.CAR.equals(jm.getType())) {
                    mod.setJava(path);
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            Exceptions.printStackTrace((Throwable)cnfe);
        }
        return mod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Module getModFromFile(File f, Application dd, String path) {
        JarFile jar = null;
        Module mod = null;
        try {
            jar = new JarFile(f);
            JarEntry ddf = jar.getJarEntry("META-INF/ejb-jar.xml");
            if (null != ddf) {
                mod = (Module)dd.createBean("Module");
                mod.setEjb(path);
            }
            if (null != (ddf = jar.getJarEntry("META-INF/ra.xml")) && null == mod) {
                mod = (Module)dd.createBean("Module");
                mod.setConnector(path);
            } else if (null != ddf && null != mod) {
                Module module = null;
                return module;
            }
            ddf = jar.getJarEntry("META-INF/application-client.xml");
            if (null != ddf && null == mod) {
                mod = (Module)dd.createBean("Module");
                mod.setJava(path);
            } else if (null != ddf && null != mod) {
                Module module = null;
                return module;
            }
            ddf = jar.getJarEntry("WEB-INF/web.xml");
            if (null != ddf && null == mod) {
                mod = (Module)dd.createBean("Module");
                Web w = mod.newWeb();
                w.setWebUri(path);
                int endex = path.length() - 4;
                if (endex < 1) {
                    endex = path.length();
                }
                w.setContextRoot("/" + path.substring(0, endex));
                mod.setWeb(w);
            } else if (null != ddf && null != mod) {
                Module module = null;
                return module;
            }
            ddf = jar.getJarEntry("META-INF/application.xml");
            if (null == ddf) return mod;
            Module module = null;
            return module;
        }
        catch (ClassNotFoundException cnfe) {
            Logger.getLogger("global").log(Level.INFO, cnfe.getLocalizedMessage());
            return mod;
        }
        catch (IOException ioe) {
            Logger.getLogger("global").log(Level.INFO, ioe.getLocalizedMessage());
            return mod;
        }
        finally {
            try {
                if (null != jar) {
                    jar.close();
                }
            }
            catch (IOException cnfe) {}
        }
    }

    public static List<ClassPathSupport.Item> getJarContentAdditional(EarProject project) {
        EditableProperties ep = project.getAntProjectHelper().getProperties("nbproject/project.properties");
        return project.getClassPathSupport().itemsList(ep.get((Object)JAR_CONTENT_ADDITIONAL), TAG_WEB_MODULE__ADDITIONAL_LIBRARIES);
    }

    public static Map<String, J2eeModuleProvider> getModuleMap(EarProject project) {
        HashMap<String, J2eeModuleProvider> mods = new HashMap<String, J2eeModuleProvider>();
        for (ClassPathSupport.Item item : EarProjectProperties.getJarContentAdditional(project)) {
            J2eeModule jm;
            AntArtifact aa;
            Project p;
            J2eeModuleProvider jmp;
            if (item.getType() != 2 || item.isBroken() || null == (jmp = (J2eeModuleProvider)(p = (aa = item.getArtifact()).getProject()).getLookup().lookup(J2eeModuleProvider.class)) || null == (jm = jmp.getJ2eeModule())) continue;
            String path = EarProjectProperties.getCompletePathInArchive(project, item);
            mods.put(path, jmp);
        }
        return mods;
    }

    public static void addJ2eeSubprojects(EarProject project, Project[] moduleProjects) {
        EarProjectProperties.addRemoveJ2eeSubprojects(project, moduleProjects, true);
    }

    public static void removeJ2eeSubprojects(EarProject project, Project[] moduleProjects) {
        EarProjectProperties.addRemoveJ2eeSubprojects(project, moduleProjects, false);
    }

    private static void addRemoveJ2eeSubprojects(final EarProject project, final Project[] moduleProjects, final boolean add) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                try {
                    EditableProperties ep = project.getUpdateHelper().getProperties("nbproject/project.properties");
                    List oldContent = project.getClassPathSupport().itemsList(ep.get((Object)EarProjectProperties.JAR_CONTENT_ADDITIONAL), EarProjectProperties.TAG_WEB_MODULE__ADDITIONAL_LIBRARIES);
                    ArrayList<ClassPathSupport.Item> l = new ArrayList<ClassPathSupport.Item>(oldContent);
                    ArrayList<String> referencesToBeDestroyed = new ArrayList<String>();
                    for (int i = 0; i < moduleProjects.length; ++i) {
                        AntArtifact[] artifacts;
                        for (AntArtifact artifact : artifacts = AntArtifactQuery.findArtifactsByType((Project)moduleProjects[i], (String)"j2ee_ear_archive")) {
                            ClassPathSupport.Item item = ClassPathSupport.Item.create((AntArtifact)artifact, (URI)artifact.getArtifactLocations()[0], null);
                            item.setAdditionalProperty("pathInDeployment", "/");
                            if (add) {
                                l.add(item);
                                continue;
                            }
                            if (l.indexOf(item) == -1) continue;
                            ClassPathSupport.Item existingItem = (ClassPathSupport.Item)l.get(l.indexOf(item));
                            l.remove(existingItem);
                            if (!EarProjectProperties.isLastReference(CommonProjectUtils.getAntPropertyName((String)existingItem.getReference()), ep, EarProjectProperties.JAR_CONTENT_ADDITIONAL)) continue;
                            referencesToBeDestroyed.add(existingItem.getReference());
                        }
                    }
                    String[] newValue = project.getClassPathSupport().encodeToStrings(l, EarProjectProperties.TAG_WEB_MODULE__ADDITIONAL_LIBRARIES);
                    ep = project.getUpdateHelper().getProperties("nbproject/project.properties");
                    ep.setProperty(EarProjectProperties.JAR_CONTENT_ADDITIONAL, newValue);
                    EarProjectProperties.updateContentDependency(project, oldContent, l, ep);
                    project.getUpdateHelper().putProperties("nbproject/project.properties", ep);
                    EarProjectProperties.updateClientModule(project, ep);
                    project.getUpdateHelper().putProperties("nbproject/project.properties", ep);
                    for (String ref : referencesToBeDestroyed) {
                        project.getReferenceHelper().destroyReference(ref);
                    }
                    ProjectManager.getDefault().saveProject((Project)project);
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        });
    }

    private static boolean isLastReference(String property, EditableProperties props, String ignoreProperty) {
        for (Map.Entry entry : props.entrySet()) {
            if (ignoreProperty.equals(entry.getKey()) || !((String)entry.getValue()).contains(property)) continue;
            return false;
        }
        return true;
    }

    private static void updateClientModule(EarProject project, EditableProperties ep) {
        CustomizerRun.ApplicationUrisComboBoxModel m = new CustomizerRun.ApplicationUrisComboBoxModel(project);
        m.storeSelectedItem(ep);
    }

    static List<Project> getApplicationSubprojects(EarProject p) {
        return EarProjectProperties.getApplicationSubprojects(EarProjectProperties.getJarContentAdditional(p), null);
    }

    static List<Project> getApplicationSubprojects(List<ClassPathSupport.Item> items, J2eeModule.Type moduleType) {
        ArrayList<Project> projects = new ArrayList<Project>(items.size());
        for (ClassPathSupport.Item item : items) {
            Project vcpiProject;
            J2eeModuleProvider jmp;
            if (item.getType() != 2 || item.getArtifact() == null || (jmp = (J2eeModuleProvider)(vcpiProject = item.getArtifact().getProject()).getLookup().lookup(J2eeModuleProvider.class)) == null) continue;
            if (moduleType == null) {
                projects.add(vcpiProject);
                continue;
            }
            if (!moduleType.equals(jmp.getJ2eeModule().getType())) continue;
            projects.add(vcpiProject);
        }
        return projects;
    }

    public static List getSortedSubprojectsList(EarProject project) {
        ArrayList<Project> subprojects = new ArrayList<Project>();
        EarProjectProperties.addSubprojects(project, subprojects);
        String[] displayNames = new String[subprojects.size()];
        for (int i = 0; i < subprojects.size(); ++i) {
            displayNames[i] = ProjectUtils.getInformation((Project)((Project)subprojects.get(i))).getDisplayName();
        }
        Arrays.sort(displayNames, Collator.getInstance());
        return Arrays.asList(displayNames);
    }

    private static void addSubprojects(Project project, List<Project> result) {
        SubprojectProvider spp = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        if (spp == null) {
            return;
        }
        for (Project sp : spp.getSubprojects()) {
            if (ProjectUtils.hasSubprojectCycles((Project)project, (Project)sp)) {
                Logger.getLogger("global").log(Level.WARNING, "There would be cyclic dependencies if the " + sp + " would be added. Skipping...");
                continue;
            }
            if (!result.contains(sp)) {
                result.add(sp);
            }
            EarProjectProperties.addSubprojects(sp, result);
        }
    }

    public void store() {
        try {
            Boolean result = (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    EarProjectProperties.this.saveLibrariesLocation();
                    EarProjectProperties.this.storeProperties();
                    if (!EarProjectProperties.this.COMPILE_ON_SAVE_MODEL.isSelected()) {
                        DeployOnSaveUtils.performCleanup((Project)EarProjectProperties.this.project, (PropertyEvaluator)EarProjectProperties.this.evaluator, (UpdateHelper)EarProjectProperties.this.updateHelper, null, (boolean)true);
                    }
                    EarProjectProperties.setupDeploymentDescriptor(EarProjectProperties.this.project);
                    return true;
                }
            });
            if (result.booleanValue()) {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
        }
        catch (MutexException e) {
            Exceptions.printStackTrace((Throwable)((IOException)e.getException()));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void setupDeploymentDescriptor(EarProject project) {
        if (project.getAppModule().getConfigSupport().isDescriptorRequired()) {
            project.getAppModule().getMetadataModel();
        }
    }

    private static void setAppClientPrivateProperties(J2eePlatform j2eePlatform, String serverInstanceID, EditableProperties ep) {
        String args;
        String jvmOpts;
        if (!j2eePlatform.getSupportedTypes().contains(J2eeModule.Type.CAR)) {
            return;
        }
        String mainClass = j2eePlatform.getToolProperty("appClientRuntime", APPCLIENT_MAIN_CLASS);
        if (mainClass != null) {
            ep.setProperty(APPCLIENT_TOOL_MAINCLASS, mainClass);
        }
        if ((jvmOpts = j2eePlatform.getToolProperty("appClientRuntime", "jvm.opts")) != null) {
            ep.setProperty(APPCLIENT_TOOL_JVMOPTS, jvmOpts);
        }
        if ((args = j2eePlatform.getToolProperty("appClientRuntime", J2EE_PLATFORM_APPCLIENT_ARGS)) != null) {
            ep.setProperty(APPCLIENT_TOOL_ARGS, args);
        } else {
            ep.remove((Object)APPCLIENT_TOOL_ARGS);
        }
        File asRoot = j2eePlatform.getPlatformRoots()[0];
        InstanceProperties ip = InstanceProperties.getInstanceProperties((String)serverInstanceID);
        if (ip != null) {
            if (new File(asRoot, "lib/admin-cli.jar").exists()) {
                File exFile = new File(asRoot, "lib/javaee.jar");
                if (exFile.exists()) {
                    ep.setProperty(APPCLIENT_WA_COPY_CLIENT_JAR_FROM, new File(ip.getProperty("LOCATION"), ip.getProperty("DOMAIN") + "/generated/xml/j2ee-apps").getAbsolutePath());
                } else {
                    ep.setProperty(APPCLIENT_WA_COPY_CLIENT_JAR_FROM, new File(ip.getProperty("LOCATION"), ip.getProperty("DOMAIN") + "/applications/j2ee-apps").getAbsolutePath());
                }
            } else {
                String copyProperty = j2eePlatform.getToolProperty("appClientRuntime", "client.jar.location");
                if (copyProperty != null) {
                    ep.setProperty(APPCLIENT_WA_COPY_CLIENT_JAR_FROM, copyProperty);
                } else {
                    ep.remove((Object)APPCLIENT_WA_COPY_CLIENT_JAR_FROM);
                }
            }
        } else {
            ep.remove((Object)APPCLIENT_WA_COPY_CLIENT_JAR_FROM);
        }
    }

    private void resolveProjectDependencies() {
        HashSet oldArtifacts = new HashSet();
        EditableProperties projectProperties = this.updateHelper.getProperties("nbproject/project.properties");
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get((Object)RUN_CLASSPATH), null));
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get((Object)JAR_CONTENT_ADDITIONAL), null));
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get((Object)"endorsed.classpath"), null));
        HashSet newArtifacts = new HashSet();
        newArtifacts.addAll(ClassPathUiSupport.getList((DefaultListModel)this.DEBUG_CLASSPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList((DefaultListModel)this.EAR_CONTENT_ADDITIONAL_MODEL.getDefaultListModel()));
        newArtifacts.addAll(ClassPathUiSupport.getList((DefaultListModel)this.ENDORSED_CLASSPATH_MODEL));
        projectProperties = this.updateHelper.getProperties("nbproject/project.properties");
        EarProjectProperties.updateContentDependency(this.project, this.cs.itemsList(projectProperties.get((Object)JAR_CONTENT_ADDITIONAL), TAG_WEB_MODULE__ADDITIONAL_LIBRARIES), ClassPathUiSupport.getList((DefaultListModel)this.EAR_CONTENT_ADDITIONAL_MODEL.getDefaultListModel()), projectProperties);
        this.updateHelper.putProperties("nbproject/project.properties", projectProperties);
        HashSet removed = new HashSet(oldArtifacts);
        removed.removeAll(newArtifacts);
        HashSet added = new HashSet(newArtifacts);
        added.removeAll(oldArtifacts);
        for (ClassPathSupport.Item item : removed) {
            if (item.getType() != 2 && item.getType() != 0) continue;
            this.refHelper.destroyReference(item.getReference());
            if (item.getType() != 0) continue;
            item.removeSourceAndJavadoc(this.updateHelper);
        }
        EditableProperties ep = this.updateHelper.getProperties("nbproject/project.properties");
        boolean changed = false;
        for (ClassPathSupport.Item item : removed) {
            if (item.getType() != 1) continue;
            String prop = item.getReference();
            prop = prop.substring(2, prop.length() - 1);
            ep.remove((Object)prop);
            changed = true;
        }
        if (changed) {
            this.updateHelper.putProperties("nbproject/project.properties", ep);
        }
    }

    public static String getCompletePathInArchive(EarProject project, ClassPathSupport.Item item) {
        String full;
        block7: {
            block6: {
                full = "";
                if (item.getReference() != null) break block6;
                switch (item.getType()) {
                    case 2: {
                        full = item.getArtifact().getArtifactLocations()[0].getPath();
                        break block7;
                    }
                    case 0: {
                        full = item.getResolvedFile().getPath();
                        break block7;
                    }
                    case 1: {
                        full = item.getLibrary().getName();
                        break block7;
                    }
                    default: {
                        assert (false);
                        break block7;
                    }
                }
            }
            full = project.evaluator().evaluate(item.getReference());
        }
        int lastSlash = full != null ? full.lastIndexOf(47) : -1;
        String trimmed = null;
        trimmed = lastSlash != -1 ? full.substring(lastSlash + 1) : full;
        String path = item.getAdditionalProperty("pathInDeployment");
        return null != path && path.length() > 1 ? path + '/' + trimmed : trimmed;
    }

    public EarProject getProject() {
        return this.project;
    }

    private static class CallbackImpl
    implements J2EEProjectProperties.Callback {
        private EarProject project;

        public CallbackImpl(EarProject project) {
            this.project = project;
        }

        public void registerJ2eePlatformListener(J2eePlatform platform) {
            this.project.registerJ2eePlatformListener(platform);
        }

        public void unregisterJ2eePlatformListener(J2eePlatform platform) {
            this.project.unregisterJ2eePlatformListener(platform);
        }
    }
}

