/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.preprocessorbridge.api;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.java.preprocessorbridge.JavaSourceUtilImplAccessor;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaSourceUtilImpl;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public class JavaSourceUtil {
    private static final Lookup.Result<JavaSourceUtilImpl> result = Lookup.getDefault().lookupResult(JavaSourceUtilImpl.class);

    private JavaSourceUtil() {
    }

    @NonNull
    public static Handle createControllerHandle(@NonNull FileObject file, int position, @NullAllowed Handle handle) throws IOException {
        Parameters.notNull((CharSequence)"file", (Object)file);
        JavaSourceUtilImpl impl = JavaSourceUtil.getSPI();
        assert (impl != null);
        long id = handle == null ? -1L : handle.id;
        Object[] param = new Object[]{handle == null ? null : handle.compilationController};
        long newId = JavaSourceUtilImplAccessor.getInstance().createTaggedCompilationController(impl, file, position, id, param);
        if (newId == id) {
            return handle;
        }
        return new Handle(param[0], newId);
    }

    @NonNull
    public static Handle createControllerHandle(@NonNull FileObject file, @NullAllowed Handle handle) throws IOException {
        return JavaSourceUtil.createControllerHandle(file, -1, handle);
    }

    @NonNull
    public static Map<String, byte[]> generate(@NonNull FileObject srcRoot, @NonNull FileObject file, @NullAllowed CharSequence content, @NullAllowed DiagnosticListener<? super JavaFileObject> diagnostics) throws IOException {
        JavaSourceUtilImpl impl = JavaSourceUtil.getSPI();
        return JavaSourceUtilImplAccessor.getInstance().generate(impl, srcRoot, file, content, diagnostics);
    }

    private static JavaSourceUtilImpl getSPI() {
        Collection instances = result.allInstances();
        int size = instances.size();
        assert (size < 2);
        return size == 0 ? null : (JavaSourceUtilImpl)instances.iterator().next();
    }

    public static class Handle {
        private final long id;
        private final Object compilationController;

        private Handle(Object compilaionController, long id) {
            this.compilationController = compilaionController;
            this.id = id;
        }

        public Object getCompilationController() {
            return this.compilationController;
        }
    }
}

