/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.matcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.tm4e.core.internal.matcher.IMatchesName;
import org.eclipse.tm4e.core.internal.matcher.MatcherWithPriority;

public class Matcher<T>
implements Predicate<T> {
    private static final Pattern IDENTIFIER_REGEXP = Pattern.compile("[\\w\\.:]+");
    private final List<MatcherWithPriority<T>> results = new ArrayList<MatcherWithPriority<T>>();
    private final Tokenizer tokenizer;
    private final IMatchesName<T> matchesName;
    private String token;

    public static Collection<MatcherWithPriority<List<String>>> createMatchers(String expression) {
        return Matcher.createMatchers(expression, IMatchesName.NAME_MATCHER);
    }

    private static <T> Collection<MatcherWithPriority<T>> createMatchers(String selector, IMatchesName<T> matchesName) {
        return new Matcher<T>((String)selector, matchesName).results;
    }

    public Matcher(String expression, IMatchesName<T> matchesName) {
        this.tokenizer = new Tokenizer(expression);
        this.matchesName = matchesName;
        this.token = this.tokenizer.next();
        while (this.token != null) {
            Predicate<T> matcher;
            int priority = 0;
            if (this.token.length() == 2 && this.token.charAt(1) == ':') {
                switch (this.token.charAt(0)) {
                    case 'R': {
                        priority = 1;
                        break;
                    }
                    case 'L': {
                        priority = -1;
                        break;
                    }
                }
                this.token = this.tokenizer.next();
            }
            if ((matcher = this.parseConjunction()) != null) {
                this.results.add(new MatcherWithPriority<T>(matcher, priority));
            }
            if (!",".equals(this.token)) break;
            this.token = this.tokenizer.next();
        }
    }

    private Predicate<T> parseInnerExpression() {
        ArrayList matchers = new ArrayList();
        Predicate<T> matcher = this.parseConjunction();
        while (matcher != null) {
            matchers.add(matcher);
            if (!this.token.equals("|") && !this.token.equals(",")) break;
            do {
                this.token = this.tokenizer.next();
            } while (this.token.equals("|") || this.token.equals(","));
            matcher = this.parseConjunction();
        }
        return matcherInput -> {
            for (Predicate matcher1 : matchers) {
                if (!matcher1.test(matcherInput)) continue;
                return true;
            }
            return false;
        };
    }

    private Predicate<T> parseConjunction() {
        ArrayList matchers = new ArrayList();
        Predicate<T> matcher = this.parseOperand();
        while (matcher != null) {
            matchers.add(matcher);
            matcher = this.parseOperand();
        }
        return matcherInput -> {
            for (Predicate matcher1 : matchers) {
                if (matcher1.test(matcherInput)) continue;
                return false;
            }
            return true;
        };
    }

    private Predicate<T> parseOperand() {
        if ("-".equals(this.token)) {
            this.token = this.tokenizer.next();
            Predicate expressionToNegate = this.parseOperand();
            return matcherInput -> {
                if (expressionToNegate == null) {
                    return false;
                }
                return !expressionToNegate.test(matcherInput);
            };
        }
        if ("(".equals(this.token)) {
            this.token = this.tokenizer.next();
            Predicate<T> expressionInParents = this.parseInnerExpression();
            if (")".equals(this.token)) {
                this.token = this.tokenizer.next();
            }
            return expressionInParents;
        }
        if (this.isIdentifier(this.token)) {
            ArrayList<String> identifiers = new ArrayList<String>();
            do {
                identifiers.add(this.token);
                this.token = this.tokenizer.next();
            } while (this.isIdentifier(this.token));
            return matcherInput -> this.matchesName.match(identifiers, matcherInput);
        }
        return null;
    }

    private boolean isIdentifier(String token) {
        return token != null && IDENTIFIER_REGEXP.matcher(token).matches();
    }

    @Override
    public boolean test(T matcherInput) {
        return false;
    }

    private static class Tokenizer {
        private static final Pattern REGEXP = Pattern.compile("([LR]:|[\\w\\.:]+|[\\,\\|\\-\\(\\)])");
        private java.util.regex.Matcher regex;

        public Tokenizer(String input) {
            this.regex = REGEXP.matcher(input);
        }

        public String next() {
            if (this.regex.find()) {
                return this.regex.group();
            }
            return null;
        }
    }
}

