/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.micronaut.completion.MicronautConfigCompletionProvider;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.netbeans.swing.plaf.LFCustoms;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.xml.XMLUtil;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;

public abstract class MicronautConfigCompletionItem
implements CompletionItem {
    public static final String PROPERTY_NAME_COLOR = MicronautConfigCompletionItem.getHTMLColor(64, 64, 217);
    private static final String ICON = "org/netbeans/modules/editor/resources/completion/field_16.png";
    protected final String propName;
    protected final int offset;
    protected final int baseIndent;
    protected final int indentLevelSize;
    private ImageIcon icon;

    public static MicronautConfigCompletionItem createTopLevelPropertyItem(String propName, int offset, int baseIndent, int indentLevelSize) {
        return new TopLevelItem(propName, offset, baseIndent, indentLevelSize);
    }

    public static MicronautConfigCompletionItem createPropertyItem(ConfigurationMetadataProperty property, int offset, int baseIndent, int indentLevelSize, int idx) {
        return new PropertyItem(property, offset, baseIndent, indentLevelSize, idx);
    }

    private MicronautConfigCompletionItem(String propName, int offset, int baseIndent, int indentLevelSize) {
        this.propName = propName;
        this.offset = offset;
        this.baseIndent = baseIndent;
        this.indentLevelSize = indentLevelSize;
    }

    public void defaultAction(JTextComponent component) {
        if (component != null) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            this.process(component, false);
        }
    }

    public void processKeyEvent(KeyEvent evt) {
        if (evt.getID() == 401 && evt.getKeyCode() == 10 && (evt.getModifiers() & 2) > 0) {
            JTextComponent component = (JTextComponent)evt.getSource();
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            this.process(component, true);
            evt.consume();
        }
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent component) {
        return false;
    }

    public CharSequence getSortText() {
        return this.propName;
    }

    public CharSequence getInsertPrefix() {
        return this.propName;
    }

    protected String getLeftHtmlText() {
        return null;
    }

    protected String getRightHtmlText() {
        return null;
    }

    protected ImageIcon getIcon() {
        if (this.icon == null) {
            this.icon = ImageUtilities.loadImageIcon((String)ICON, (boolean)false);
        }
        return this.icon;
    }

    protected abstract void process(JTextComponent var1, boolean var2);

    private static String getHTMLColor(int r, int g, int b) {
        Color c = LFCustoms.shiftColor((Color)new Color(r, g, b));
        return "<font color=#" + LFCustoms.getHexString((int)c.getRed()) + LFCustoms.getHexString((int)c.getGreen()) + LFCustoms.getHexString((int)c.getBlue()) + ">";
    }

    private static String escape(String s) {
        if (s != null) {
            try {
                return XMLUtil.toAttributeValue((String)s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    private static final class PropertyItem
    extends MicronautConfigCompletionItem {
        private static final Pattern FQN = Pattern.compile("(\\w+\\.)+(\\w+)");
        private final ConfigurationMetadataProperty property;
        private final int idx;
        private String left;
        private String right;

        private PropertyItem(ConfigurationMetadataProperty property, int offset, int baseIndent, int indentLevelSize, int idx) {
            super(property.getId(), offset, baseIndent, indentLevelSize);
            this.property = property;
            this.idx = idx;
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return MicronautConfigCompletionProvider.createDocTask(this.property);
        }

        public int getSortPriority() {
            return this.property.isDeprecated() ? 30 : 20;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.left == null) {
                this.left = this.property.isDeprecated() ? PROPERTY_NAME_COLOR + "<s>" + this.propName + "</s></font>" : PROPERTY_NAME_COLOR + this.propName + "</font>";
            }
            return this.left;
        }

        @Override
        protected String getRightHtmlText() {
            if (this.right == null) {
                String type = this.property.getType();
                this.right = type != null ? MicronautConfigCompletionItem.escape(PropertyItem.FQN.matcher(type).replaceAll("$2")) : "";
            }
            return this.right;
        }

        @Override
        protected void process(JTextComponent component, boolean overwrite) {
            try {
                Document doc = component.getDocument();
                LineDocument lineDocument = (LineDocument)LineDocumentUtils.as((Document)doc, LineDocument.class);
                if (lineDocument != null) {
                    int caretOffset = component.getCaretPosition();
                    int end = LineDocumentUtils.getWordEnd((LineDocument)lineDocument, (int)caretOffset);
                    if (overwrite && LineDocumentUtils.getWordStart((LineDocument)lineDocument, (int)end) == this.offset) {
                        if (doc.getText(end, 1).endsWith(":")) {
                            ++end;
                        }
                        doc.remove(this.offset, Math.max(caretOffset, end) - this.offset);
                    } else if (this.offset < caretOffset) {
                        doc.remove(this.offset, caretOffset - this.offset);
                    }
                    int lineStart = LineDocumentUtils.getLineStart((LineDocument)lineDocument, (int)caretOffset);
                    int lineIndent = IndentUtils.lineIndent((Document)doc, (int)lineStart);
                    StringBuilder sb = new StringBuilder();
                    ArrayUtilities.appendSpaces((StringBuilder)sb, (int)(this.baseIndent - lineIndent));
                    String name = this.propName.substring(this.idx);
                    int indent = this.baseIndent;
                    String[] parts = name.split("\\.");
                    int num = 1;
                    for (int i = 0; i < parts.length; ++i) {
                        String part = parts[i];
                        if ("*".equals(part)) {
                            sb.append("${PAR#" + num++ + " default=\"\"}");
                        } else {
                            sb.append(part);
                        }
                        if (i < parts.length - 1) {
                            sb.append(":\n");
                            ArrayUtilities.appendSpaces((StringBuilder)sb, (int)(indent += this.indentLevelSize));
                            continue;
                        }
                        sb.append(": ${cursor}");
                    }
                    CodeTemplateManager.get((Document)doc).createTemporary(sb.toString()).insert(component);
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static final class TopLevelItem
    extends MicronautConfigCompletionItem {
        private TopLevelItem(String propName, int offset, int baseIndent, int indentLevelSize) {
            super(propName, offset, baseIndent, indentLevelSize);
        }

        public int getSortPriority() {
            return 10;
        }

        @Override
        protected String getLeftHtmlText() {
            return PROPERTY_NAME_COLOR + "<b>" + this.propName + "</b></font>";
        }

        @Override
        protected void process(JTextComponent component, boolean overwrite) {
            try {
                Document doc = component.getDocument();
                LineDocument lineDocument = (LineDocument)LineDocumentUtils.as((Document)doc, LineDocument.class);
                if (lineDocument != null) {
                    int caretOffset = component.getCaretPosition();
                    int end = LineDocumentUtils.getWordEnd((LineDocument)lineDocument, (int)caretOffset);
                    if (overwrite && LineDocumentUtils.getWordStart((LineDocument)lineDocument, (int)end) == this.offset) {
                        if (doc.getText(end, 1).endsWith(":")) {
                            ++end;
                        }
                        doc.remove(this.offset, Math.max(caretOffset, end) - this.offset);
                    } else if (this.offset < caretOffset) {
                        doc.remove(this.offset, caretOffset - this.offset);
                    }
                    int lineStart = LineDocumentUtils.getLineStart((LineDocument)lineDocument, (int)caretOffset);
                    int lineIndent = IndentUtils.lineIndent((Document)doc, (int)lineStart);
                    StringBuilder sb = new StringBuilder();
                    ArrayUtilities.appendSpaces((StringBuilder)sb, (int)(this.baseIndent - lineIndent));
                    sb.append("*".equals(this.propName) ? "${PAR#1 default=\"\"}" : this.propName).append(":\n");
                    ArrayUtilities.appendSpaces((StringBuilder)sb, (int)(this.baseIndent + this.indentLevelSize));
                    sb.append("${cursor completionInvoke}");
                    CodeTemplateManager.get((Document)doc).createTemporary(sb.toString()).insert(component);
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

