/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.RestObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=RestObjectNode.class)
public final class RestObjectNodeGen
extends RestObjectNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @Node.Child
    private JSToObjectNode other_toObjectNode_;

    private RestObjectNodeGen(JSContext context, JavaScriptNode targetNode, JavaScriptNode sourceNode) {
        super(context, targetNode, sourceNode);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Object targetNodeValue_ = this.targetNode.execute(frameValue);
        Object sourceNodeValue_ = this.sourceNode.execute(frameValue);
        if (state != 0 && JSTypes.isDynamicObject(targetNodeValue_)) {
            DynamicObject sourceNodeValue__;
            DynamicObject targetNodeValue__ = (DynamicObject)targetNodeValue_;
            if ((state & 1) != 0 && JSGuards.isNullOrUndefined(sourceNodeValue_)) {
                return RestObjectNode.doNullOrUndefined(targetNodeValue__, sourceNodeValue_);
            }
            if ((state & 2) != 0 && JSTypes.isDynamicObject(sourceNodeValue_) && JSGuards.isJSObject(sourceNodeValue__ = (DynamicObject)sourceNodeValue_)) {
                return this.copyDataProperties(targetNodeValue__, sourceNodeValue__);
            }
            if ((state & 4) != 0 && !JSGuards.isJSType(sourceNodeValue_)) {
                return this.doOther(targetNodeValue__, sourceNodeValue_, this.other_toObjectNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(targetNodeValue_, sourceNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    private Object executeAndSpecialize(Object targetNodeValue, Object sourceNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (JSTypes.isDynamicObject(targetNodeValue)) {
                DynamicObject sourceNodeValue_;
                DynamicObject targetNodeValue_ = (DynamicObject)targetNodeValue;
                if (JSGuards.isNullOrUndefined(sourceNodeValue)) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = RestObjectNode.doNullOrUndefined(targetNodeValue_, sourceNodeValue);
                    return dynamicObject;
                }
                if (JSTypes.isDynamicObject(sourceNodeValue) && JSGuards.isJSObject(sourceNodeValue_ = (DynamicObject)sourceNodeValue)) {
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.copyDataProperties(targetNodeValue_, sourceNodeValue_);
                    return dynamicObject;
                }
                if (!JSGuards.isJSType(sourceNodeValue)) {
                    this.other_toObjectNode_ = (JSToObjectNode)super.insert((Node)JSToObjectNode.createToObjectNoCheck(this.context));
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doOther(targetNodeValue_, sourceNodeValue, this.other_toObjectNode_);
                    return object;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.targetNode, this.sourceNode}, new Object[]{targetNodeValue, sourceNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doNullOrUndefined";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "copyDataProperties";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doOther";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            ArrayList<List<JSToObjectNode>> cached = new ArrayList<List<JSToObjectNode>>();
            cached.add(Arrays.asList(this.other_toObjectNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[3] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static RestObjectNode create(JSContext context, JavaScriptNode targetNode, JavaScriptNode sourceNode) {
        return new RestObjectNodeGen(context, targetNode, sourceNode);
    }
}

