/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.js.runtime.util.OutputStreamWrapper;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public final class PrintWriterWrapper
extends PrintWriter {
    private OutputStreamWrapper outWrapper;

    public PrintWriterWrapper(OutputStream out, boolean autoFlush) {
        this(new OutputStreamWrapper(out), autoFlush);
    }

    private PrintWriterWrapper(OutputStreamWrapper outWrapper, boolean autoFlush) {
        this(new OutputStreamWriter(outWrapper), autoFlush);
        this.outWrapper = outWrapper;
    }

    private PrintWriterWrapper(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelegate(Writer out) {
        Object object = this.lock;
        synchronized (object) {
            this.out = out;
            this.outWrapper = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelegate(OutputStream out) {
        Object object = this.lock;
        synchronized (object) {
            if (this.outWrapper != null) {
                this.outWrapper.setDelegate(out);
            } else {
                this.outWrapper = new OutputStreamWrapper(out);
                this.out = new OutputStreamWriter(this.outWrapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrom(PrintWriterWrapper otherWrapper) {
        Object object = this.lock;
        synchronized (object) {
            boolean newWrapper = false;
            if (otherWrapper.outWrapper != null) {
                if (this.outWrapper != null) {
                    this.outWrapper.setDelegate(otherWrapper.outWrapper.getDelegate());
                } else {
                    this.outWrapper = new OutputStreamWrapper(otherWrapper.outWrapper.getDelegate());
                    newWrapper = true;
                }
            } else {
                this.outWrapper = null;
            }
            if (this.outWrapper != null) {
                if (newWrapper) {
                    this.out = new OutputStreamWriter(this.outWrapper);
                }
            } else {
                this.out = otherWrapper.out;
            }
        }
    }
}

