/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.Action;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Binding;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlChangeListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsNode;
import org.netbeans.modules.websvc.core.jaxws.nodes.OperationNode;
import org.netbeans.modules.websvc.core.jaxws.nodes.WsdlOperationComparator;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperGenerator;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperHandler;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.PropertiesAction;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.xml.sax.SAXException;

public class JaxWsChildren
extends Children.Keys<Object> {
    private Image cachedIcon;
    private static final String OPERATION_ICON = "org/netbeans/modules/websvc/core/webservices/ui/resources/wsoperation.png";
    private FileObject implClass;
    private Service service;
    private FileObject srcRoot;
    private WsdlModel wsdlModel;
    private WsdlModeler wsdlModeler;
    private boolean modelGenerationFinished;
    private WsdlChangeListener wsdlChangeListener;
    private FileChangeListener fcl;
    private RequestProcessor requestProcessor = new RequestProcessor("JaxWs-request-processor");
    private static Comparator<WebOperationInfo> OPERATION_INFO_COMPARATOR = new WebOperationInfoComparator();

    public JaxWsChildren(Service service, FileObject srcRoot, FileObject implClass) {
        this.service = service;
        this.srcRoot = srcRoot;
        this.implClass = implClass;
    }

    private List<ExecutableElement> getPublicMethods(CompilationController controller, TypeElement classElement) throws IOException {
        List<? extends Element> members = classElement.getEnclosedElements();
        List<ExecutableElement> methods = ElementFilter.methodsIn(members);
        ArrayList<ExecutableElement> publicMethods = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methods) {
            Set<Modifier> modifiers = method.getModifiers();
            if (!modifiers.contains((Object)Modifier.PUBLIC)) continue;
            publicMethods.add(method);
        }
        return publicMethods;
    }

    protected void addNotify() {
        if (this.isFromWsdl()) {
            try {
                FileObject localWsdlFolder = this.getJAXWSSupport().getLocalWsdlFolderForService(this.service.getName(), false);
                if (localWsdlFolder == null) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, "missing folder for wsdl file");
                    this.updateKeys();
                    return;
                }
                FileObject wsdlFo = localWsdlFolder.getFileObject(this.service.getLocalWsdlFile());
                if (wsdlFo == null) {
                    return;
                }
                if (this.wsdlModeler == null) {
                    this.wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(wsdlFo.getURL());
                }
                if (this.wsdlModeler == null) {
                    return;
                }
                this.wsdlChangeListener = new WsdlChangeListener(){

                    public void wsdlModelChanged(WsdlModel oldWsdlModel, WsdlModel newWsdlModel) {
                        JaxWsChildren.this.wsdlModel = newWsdlModel;
                        JaxWsChildren.this.updateKeys();
                        ((JaxWsNode)JaxWsChildren.this.getNode()).changeIcon();
                    }
                };
                this.wsdlModeler.addWsdlChangeListener(this.wsdlChangeListener);
                String packageName = this.service.getPackageName();
                if (packageName != null && this.service.isPackageNameForceReplace()) {
                    this.wsdlModeler.setPackageName(packageName);
                } else {
                    this.wsdlModeler.setPackageName(null);
                }
                JAXWSSupport support = this.getJAXWSSupport();
                this.wsdlModeler.setCatalog(support.getCatalog());
                this.setBindings(support, this.wsdlModeler, this.service);
                this.modelGenerationFinished = false;
                ((JaxWsNode)this.getNode()).changeIcon();
                this.wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                    public void modelCreated(WsdlModel model) {
                        JaxWsChildren.this.modelGenerationFinished = true;
                        if (model == null) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new JaxWsUtils.WsImportServiceFailedMessage(JaxWsChildren.this.wsdlModeler.getCreationException()));
                        }
                    }
                });
            }
            catch (FileStateInvalidException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
                this.updateKeys();
            }
        } else {
            assert (this.implClass != null);
            if (this.fcl == null) {
                this.fcl = new FileChangeAdapter(){

                    public void fileChanged(FileEvent fe) {
                        JaxWsChildren.this.updateKeys();
                    }
                };
                this.implClass.addFileChangeListener(this.fcl);
            }
            this.updateKeys();
        }
    }

    protected void removeNotify() {
        if (this.wsdlModeler != null) {
            this.wsdlModeler.removeWsdlChangeListener(this.wsdlChangeListener);
        }
        if (this.fcl != null) {
            this.implClass.removeFileChangeListener(this.fcl);
            this.fcl = null;
        }
        this.setKeys(Collections.emptySet());
    }

    private void updateKeys() {
        if (this.isFromWsdl()) {
            WsdlPort wsdlPort;
            WsdlService wsdlService;
            List keys = null;
            if (this.wsdlModel != null && (wsdlService = this.wsdlModel.getServiceByName(this.service.getServiceName())) != null && (wsdlPort = wsdlService.getPortByName(this.service.getPortName())) != null) {
                keys = wsdlPort.getOperations();
            }
            if (keys != null) {
                Collections.sort(keys, WsdlOperationComparator.getInstance());
                this.setKeys(keys);
            } else {
                this.setKeys(Collections.emptyList());
            }
        } else {
            this.requestProcessor.post(new Runnable(){

                @Override
                public void run() {
                    JavaSource javaSource;
                    final List[] keys = new List[1];
                    if (JaxWsChildren.this.implClass != null && (javaSource = JavaSource.forFileObject((FileObject)JaxWsChildren.this.implClass)) != null) {
                        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

                            public void run(CompilationController controller) throws IOException {
                                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
                                List publicMethods = JaxWsChildren.this.getPublicMethods(controller, typeElement);
                                ArrayList<ExecutableElement> webMethods = new ArrayList<ExecutableElement>();
                                HashMap<ExecutableElement, AnnotationMirror> webMethodAnnMap = new HashMap<ExecutableElement, AnnotationMirror>();
                                for (ExecutableElement method : publicMethods) {
                                    AnnotationMirror webMethodAnn = this.getWebMethodAnnotation(method);
                                    if (webMethodAnn != null) {
                                        boolean exclude = false;
                                        Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = webMethodAnn.getElementValues();
                                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                                            if (!entry.getKey().getSimpleName().contentEquals("exclude")) continue;
                                            Object object = expressions.get(entry.getKey()).getValue();
                                            if (!Boolean.TRUE.equals(object)) break;
                                            exclude = true;
                                            break;
                                        }
                                        if (exclude) continue;
                                        webMethods.add(method);
                                        webMethodAnnMap.put(method, webMethodAnn);
                                        continue;
                                    }
                                    webMethods.add(method);
                                }
                                ArrayList<WebOperationInfo> webOperations = new ArrayList<WebOperationInfo>();
                                for (ExecutableElement webMethod : webMethods) {
                                    TypeMirror returnType;
                                    WebOperationInfo webOperation = new WebOperationInfo();
                                    AnnotationMirror webMethodAnn = (AnnotationMirror)webMethodAnnMap.get(webMethod);
                                    if (webMethodAnn != null) {
                                        Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = webMethodAnn.getElementValues();
                                        for (Map.Entry entry : expressions.entrySet()) {
                                            if (!((ExecutableElement)entry.getKey()).getSimpleName().contentEquals("operationName")) continue;
                                            webOperation.setOperationName((String)expressions.get(entry.getKey()).getValue());
                                        }
                                    }
                                    if (webOperation.getOperationName() == null) {
                                        webOperation.setOperationName(webMethod.getSimpleName().toString());
                                    }
                                    if ((returnType = webMethod.getReturnType()) instanceof DeclaredType) {
                                        TypeElement element = (TypeElement)((DeclaredType)returnType).asElement();
                                        webOperation.setReturnType(element.getQualifiedName().toString());
                                    } else {
                                        webOperation.setReturnType(returnType.toString());
                                    }
                                    List<? extends VariableElement> params = webMethod.getParameters();
                                    ArrayList<String> arrayList = new ArrayList<String>();
                                    for (VariableElement variableElement : params) {
                                        TypeMirror type = variableElement.asType();
                                        if (type instanceof DeclaredType) {
                                            TypeElement element = (TypeElement)((DeclaredType)type).asElement();
                                            arrayList.add(element.getQualifiedName().toString());
                                            continue;
                                        }
                                        arrayList.add(type.toString());
                                    }
                                    webOperation.setParamTypes(arrayList);
                                    webOperations.add(webOperation);
                                }
                                keys[0] = webOperations;
                            }

                            public void cancel() {
                            }

                            private AnnotationMirror getWebMethodAnnotation(ExecutableElement method) {
                                List<? extends AnnotationMirror> annotations = method.getAnnotationMirrors();
                                boolean hasWebMethodAnnotation = false;
                                for (AnnotationMirror annotationMirror : annotations) {
                                    Element anElement = annotationMirror.getAnnotationType().asElement();
                                    if (!(anElement instanceof TypeElement) || !(hasWebMethodAnnotation = "javax.jws.WebMethod".contentEquals(((TypeElement)anElement).getQualifiedName()))) continue;
                                    return annotationMirror;
                                }
                                return null;
                            }
                        };
                        try {
                            javaSource.runUserActionTask((Task)task, true);
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                    }
                    if (keys[0] == null) {
                        keys[0] = Collections.emptyList();
                    } else {
                        Collections.sort(keys[0], OPERATION_INFO_COMPARATOR);
                    }
                    JaxWsChildren.this.setKeys(keys[0]);
                }
            });
        }
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof WsdlOperation) {
            return new Node[]{new OperationNode((WsdlOperation)key)};
        }
        if (key instanceof WebOperationInfo) {
            final WebOperationInfo method = (WebOperationInfo)key;
            AbstractNode n = new AbstractNode(Children.LEAF){

                public Image getIcon(int type) {
                    if (JaxWsChildren.this.cachedIcon == null) {
                        JaxWsChildren.this.cachedIcon = ImageUtilities.loadImage((String)JaxWsChildren.OPERATION_ICON);
                    }
                    return JaxWsChildren.this.cachedIcon;
                }

                public Action[] getActions(boolean context) {
                    return new Action[]{SystemAction.get(PropertiesAction.class)};
                }

                public Action getPreferredAction() {
                    return SystemAction.get(PropertiesAction.class);
                }

                public String getDisplayName() {
                    return JaxWsChildren.getWebOperationInfoName(method);
                }
            };
            StringBuffer buf = new StringBuffer();
            for (String paramType : method.getParamTypes()) {
                buf.append(buf.length() == 0 ? paramType : ", " + paramType);
            }
            n.setShortDescription(NbBundle.getMessage(JaxWsChildren.class, (String)"TXT_operationDesc", (Object)method.getReturnType(), (Object)method.getOperationName(), (Object)buf.toString()));
            return new Node[]{n};
        }
        return new Node[0];
    }

    private boolean isFromWsdl() {
        return this.service.getWsdlUrl() != null;
    }

    private JAXWSSupport getJAXWSSupport() {
        return JAXWSSupport.getJAXWSSupport((FileObject)this.srcRoot);
    }

    private void setBindings(JAXWSSupport support, WsdlModeler wsdlModeler, Service service) {
        Binding[] extbindings = service.getBindings();
        if (extbindings == null || extbindings.length == 0) {
            wsdlModeler.setJAXBBindings(null);
            return;
        }
        String[] bindingFiles = new String[extbindings.length];
        for (int i = 0; i < extbindings.length; ++i) {
            bindingFiles[i] = extbindings[i].getFileName();
        }
        FileObject bindingsFolder = support.getBindingsFolderForService(this.getNode().getName(), true);
        ArrayList<URL> list = new ArrayList<URL>();
        for (int i = 0; i < bindingFiles.length; ++i) {
            FileObject fo = bindingsFolder.getFileObject(bindingFiles[i]);
            list.add(fo.toURL());
        }
        URL[] bindings = new URL[list.size()];
        list.toArray(bindings);
        wsdlModeler.setJAXBBindings(bindings);
    }

    void refreshKeys(boolean downloadWsdl, final boolean refreshImplClass, String newWsdlUrl) {
        if (!this.isFromWsdl()) {
            return;
        }
        super.addNotify();
        try {
            FileObject localWsdlFolder;
            JAXWSSupport support = this.getJAXWSSupport();
            if (downloadWsdl) {
                String serviceName = this.getNode().getName();
                FileObject xmlResorcesFo = support.getLocalWsdlFolderForService(serviceName, true);
                FileObject localWsdl = null;
                try {
                    String oldWsdlUrl = this.service.getWsdlUrl();
                    boolean jaxWsModelChanged = false;
                    if (newWsdlUrl.length() > 0 && !oldWsdlUrl.equals(newWsdlUrl)) {
                        localWsdl = WSUtils.retrieveResource((FileObject)xmlResorcesFo, (URI)new URI(newWsdlUrl));
                        jaxWsModelChanged = true;
                    } else {
                        localWsdl = WSUtils.retrieveResource((FileObject)xmlResorcesFo, (URI)new URI(oldWsdlUrl));
                    }
                    if (jaxWsModelChanged) {
                        Project project;
                        JaxWsModel jaxWsModel;
                        this.service.setWsdlUrl(newWsdlUrl);
                        FileObject xmlResourcesFo = support.getLocalWsdlFolderForService(serviceName, false);
                        if (xmlResourcesFo != null) {
                            String localWsdlUrl = FileUtil.getRelativePath((FileObject)xmlResourcesFo, (FileObject)localWsdl);
                            this.service.setLocalWsdlFile(localWsdlUrl);
                        }
                        if ((jaxWsModel = (JaxWsModel)(project = FileOwnerQuery.getOwner((FileObject)this.srcRoot)).getLookup().lookup(JaxWsModel.class)) != null) {
                            jaxWsModel.write();
                        }
                    }
                    FileObject wsdlFolder = this.getWsdlFolderForService(support, serviceName);
                    WSUtils.copyFiles((FileObject)xmlResorcesFo, (FileObject)wsdlFolder);
                }
                catch (URISyntaxException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                catch (UnknownHostException ex) {
                    ErrorManager.getDefault().annotate((Throwable)ex, NbBundle.getMessage(JaxWsChildren.class, (String)"MSG_ConnectionProblem"));
                    return;
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().annotate((Throwable)ex, NbBundle.getMessage(JaxWsChildren.class, (String)"MSG_ConnectionProblem"));
                    return;
                }
                if (localWsdl != null) {
                    WsdlWrapperHandler handler = null;
                    try {
                        handler = WsdlWrapperGenerator.parse((String)localWsdl.toURL().toExternalForm());
                    }
                    catch (ParserConfigurationException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    catch (SAXException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    if (handler != null && !handler.isServiceElement()) {
                        StreamSource source = new StreamSource(localWsdl.toURL().toExternalForm());
                        try {
                            File wrapperWsdlFile = new File(FileUtil.toFile((FileObject)localWsdl.getParent()), WsdlWrapperGenerator.getWrapperName((URL)localWsdl.toURL()));
                            if (!wrapperWsdlFile.exists()) {
                                try {
                                    wrapperWsdlFile.createNewFile();
                                }
                                catch (IOException ex) {
                                    ErrorManager.getDefault().notify(4096, (Throwable)ex);
                                }
                            }
                            if (wrapperWsdlFile.exists()) {
                                WsdlWrapperGenerator.generateWrapperWSDLContent((File)wrapperWsdlFile, (StreamSource)source, (String)handler.getTargetNsPrefix(), (String)localWsdl.getNameExt());
                            }
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                    }
                }
            }
            if ((localWsdlFolder = this.getJAXWSSupport().getLocalWsdlFolderForService(this.service.getName(), false)) == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsChildren.class, (String)"MSG_RefreshWithReplaceWsdl"), 2));
                return;
            }
            FileObject wsdlFo = localWsdlFolder.getFileObject(this.service.getLocalWsdlFile());
            this.wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(wsdlFo.getURL());
            String packageName = this.service.getPackageName();
            if (packageName != null && this.service.isPackageNameForceReplace()) {
                this.wsdlModeler.setPackageName(packageName);
            } else {
                this.wsdlModeler.setPackageName(null);
            }
            this.wsdlModeler.setCatalog(support.getCatalog());
            this.setBindings(support, this.wsdlModeler, this.service);
            this.regenerateJavaArtifacts();
            this.modelGenerationFinished = false;
            ((JaxWsNode)this.getNode()).changeIcon();
            this.wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                public void modelCreated(WsdlModel model) {
                    JaxWsChildren.this.wsdlModel = model;
                    JaxWsChildren.this.modelGenerationFinished = true;
                    ((JaxWsNode)JaxWsChildren.this.getNode()).changeIcon();
                    if (model == null) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new JaxWsUtils.WsImportServiceFailedMessage(JaxWsChildren.this.wsdlModeler.getCreationException()));
                    }
                    if (model != null) {
                        try {
                            JaxWsModel jaxWsModel;
                            Project project;
                            String newPkgName;
                            String javaName;
                            int dotPosition;
                            WsdlPort wsdlPort;
                            String serviceName = JaxWsChildren.this.service.getServiceName();
                            String portName = JaxWsChildren.this.service.getPortName();
                            WsdlService wsdlService = model.getServiceByName(serviceName);
                            boolean jaxWsModelChanged = false;
                            if (wsdlService == null && !model.getServices().isEmpty()) {
                                wsdlService = (WsdlService)model.getServices().get(0);
                                JaxWsChildren.this.service.setServiceName(wsdlService.getName());
                                jaxWsModelChanged = true;
                            }
                            if (wsdlService != null && (wsdlPort = wsdlService.getPortByName(portName)) == null && !wsdlService.getPorts().isEmpty()) {
                                wsdlPort = (WsdlPort)wsdlService.getPorts().get(0);
                                JaxWsChildren.this.service.setPortName(wsdlPort.getName());
                                jaxWsModelChanged = true;
                            }
                            String oldPkgName = JaxWsChildren.this.service.getPackageName();
                            if (wsdlService != null && oldPkgName != null && !JaxWsChildren.this.service.isPackageNameForceReplace() && (dotPosition = (javaName = wsdlService.getJavaName()).lastIndexOf(".")) >= 0 && !oldPkgName.equals(newPkgName = javaName.substring(0, dotPosition))) {
                                JaxWsChildren.this.service.setPackageName(newPkgName);
                                jaxWsModelChanged = true;
                            }
                            if (jaxWsModelChanged && (project = FileOwnerQuery.getOwner((FileObject)JaxWsChildren.this.srcRoot)) != null && (jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class)) != null) {
                                jaxWsModel.write();
                            }
                            if (refreshImplClass) {
                                FileObject folder;
                                String implClass = JaxWsChildren.this.service.getImplementationClass();
                                FileObject oldImplClass = JaxWsChildren.this.srcRoot.getFileObject(implClass.replace('.', '/') + ".java");
                                FileObject oldCopy = JaxWsChildren.this.srcRoot.getFileObject(implClass.replace('.', '/') + ".java.old");
                                int index = implClass.lastIndexOf(".");
                                FileObject fileObject = folder = index > 0 ? JaxWsChildren.this.srcRoot.getFileObject(implClass.substring(0, index).replace('.', '/')) : JaxWsChildren.this.srcRoot;
                                if (folder != null) {
                                    String name;
                                    String string = name = index >= 0 ? implClass.substring(index + 1) : implClass;
                                    if (oldImplClass != null) {
                                        if (oldCopy != null) {
                                            oldCopy.delete();
                                        }
                                        FileUtil.copyFile((FileObject)oldImplClass, (FileObject)folder, (String)(name + ".java"), (String)"old");
                                        oldImplClass.delete();
                                    }
                                    JaxWsNode parent = (JaxWsNode)JaxWsChildren.this.getNode();
                                    JaxWsUtils.generateJaxWsImplementationClass(FileOwnerQuery.getOwner((FileObject)JaxWsChildren.this.srcRoot), folder, name, model, JaxWsChildren.this.service);
                                    FileObject newImplClass = JaxWsChildren.this.srcRoot.getFileObject(implClass.replace('.', '/') + ".java");
                                    if (newImplClass != null) {
                                        JaxWsChildren.this.implClass = newImplClass;
                                    }
                                    parent.refreshImplClass();
                                }
                            }
                        }
                        catch (Exception ex) {
                            ErrorManager.getDefault().notify(65536, (Throwable)ex);
                        }
                    }
                }
            });
        }
        catch (FileStateInvalidException ex) {
            ErrorManager.getDefault().log(ex.getLocalizedMessage());
        }
    }

    private void regenerateJavaArtifacts() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.srcRoot);
        if (project != null) {
            FileObject buildImplFo = project.getProjectDirectory().getFileObject("build.xml");
            try {
                String name = this.service.getName();
                ExecutorTask wsimportTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{"wsimport-service-clean-" + name, "wsimport-service-generate"}, null);
                wsimportTask.waitFinished();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
            catch (IllegalArgumentException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getWsdlFolderForService(JAXWSSupport support, String name) throws IOException {
        FileObject globalWsdlFolder = support.getWsdlFolder(true);
        FileObject oldWsdlFolder = globalWsdlFolder.getFileObject(name);
        if (oldWsdlFolder != null) {
            FileLock lock = oldWsdlFolder.lock();
            try {
                oldWsdlFolder.delete(lock);
            }
            finally {
                lock.releaseLock();
            }
        }
        return globalWsdlFolder.createFolder(name);
    }

    WsdlModeler getWsdlModeler() {
        return this.wsdlModeler;
    }

    boolean isModelGenerationFinished() {
        return this.modelGenerationFinished;
    }

    private static String getClassName(String fullClassName) {
        StringTokenizer tok = new StringTokenizer(fullClassName, ".");
        String token = "";
        while (tok.hasMoreTokens()) {
            token = tok.nextToken();
        }
        return token;
    }

    private static String getWebOperationInfoName(WebOperationInfo method) {
        return method.getOperationName() + ": " + JaxWsChildren.getClassName(method.getReturnType());
    }

    private static class WebOperationInfo {
        private String operationName;
        private List<String> paramTypes;
        private String returnType;

        private WebOperationInfo() {
        }

        String getOperationName() {
            return this.operationName;
        }

        void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        List<String> getParamTypes() {
            return this.paramTypes;
        }

        void setParamTypes(List<String> paramTypes) {
            this.paramTypes = paramTypes;
        }

        String getReturnType() {
            return this.returnType;
        }

        void setReturnType(String returnType) {
            this.returnType = returnType;
        }
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static class WebOperationInfoComparator
    implements Comparator<WebOperationInfo> {
        private WebOperationInfoComparator() {
        }

        @Override
        public int compare(WebOperationInfo info1, WebOperationInfo info2) {
            String name1 = JaxWsChildren.getWebOperationInfoName(info1);
            String name2 = JaxWsChildren.getWebOperationInfoName(info2);
            return name1.compareTo(name2);
        }
    }
}

