/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.webservices.ui.panels;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.ProjectClientView;
import org.netbeans.modules.websvc.spi.support.DefaultClientSelectionPanel;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ClientExplorerPanel
extends DefaultClientSelectionPanel {
    private Project[] projects = OpenProjects.getDefault().getOpenProjects();
    private Children rootChildren = new Children.Array();
    private Node explorerClientRoot = new AbstractNode(this.rootChildren);
    private List<Node> projectNodeList = new ArrayList<Node>();

    public ClientExplorerPanel(FileObject srcFileObject) {
        super(srcFileObject);
    }

    public void addNotify() {
        super.addNotify();
        this.getTreeView().expandAll();
    }

    protected Node getRootContext() {
        for (int i = 0; i < this.projects.length; ++i) {
            LogicalViewProvider logicalProvider;
            Project srcFileProject = FileOwnerQuery.getOwner((FileObject)this.getTargetFile());
            if (srcFileProject == null || !JaxWsUtils.isProjectReferenceable(this.projects[i], srcFileProject) || (logicalProvider = (LogicalViewProvider)this.projects[i].getLookup().lookup(LogicalViewProvider.class)) == null) continue;
            Node rootNode = logicalProvider.createLogicalView();
            Node[] servicesNodes = ProjectClientView.createClientView(this.projects[i]);
            if (servicesNodes == null || servicesNodes.length <= 0) continue;
            Children.Array children = new Children.Array();
            for (Node servicesNode : servicesNodes) {
                Node[] nodes = servicesNode.getChildren().getNodes();
                if (nodes == null || nodes.length <= 0) continue;
                Node[] filterNodes = new Node[nodes.length];
                for (int j = 0; j < nodes.length; ++j) {
                    filterNodes[j] = new FilterNode(nodes[j]);
                }
                children.add(filterNodes);
            }
            if (children.getNodesCount() <= 0) continue;
            this.projectNodeList.add((Node)new ProjectNode((Children)children, rootNode));
        }
        if (this.projectNodeList.size() > 0) {
            Node[] projectNodes = new Node[this.projectNodeList.size()];
            this.projectNodeList.toArray(projectNodes);
            this.rootChildren.add(projectNodes);
        } else {
            NoServicesNode noClients = new NoServicesNode();
            this.rootChildren.add(new Node[]{noClients});
        }
        return this.explorerClientRoot;
    }

    protected boolean isClientNode(Node node) {
        return node.getLookup().lookup(WsdlOperation.class) != null;
    }

    private static class NoServicesNode
    extends AbstractNode {
        NoServicesNode() {
            super(Children.LEAF);
            this.setIconBaseWithExtension("org/netbeans/modules/websvc/core/webservices/ui/resources/webservice.png");
            this.setName("no_ws_clients");
            this.setDisplayName(NbBundle.getMessage(ClientExplorerPanel.class, (String)"LBL_no_ws_clients"));
        }
    }

    private static class ProjectNode
    extends AbstractNode {
        private Node rootNode;

        ProjectNode(Children children, Node rootNode) {
            super(children);
            this.rootNode = rootNode;
            this.setName(rootNode.getDisplayName());
        }

        public Image getIcon(int type) {
            return this.rootNode.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            return this.rootNode.getOpenedIcon(type);
        }
    }
}

