/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.scripting;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.scripting.BSFManagerFilter;
import org.apache.struts.scripting.StrutsInfo;

public class ScriptAction
extends Action {
    protected static final Log LOG = LogFactory.getLog((Class)ScriptAction.class);
    protected static final String PROPS_PATH = "/struts-scripting.properties";
    protected static final String ENGINE_BASE = "struts-scripting.engine.";
    protected static final String FILTERS_BASE = "struts-scripting.filters.";
    private static BSFManagerFilter[] filters = null;
    private Map scripts = new Hashtable();
    static /* synthetic */ Class class$java$lang$String;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BSFManager bsfManager = new BSFManager();
        String scriptName = null;
        try {
            scriptName = this.parseScriptName(mapping.getParameter(), bsfManager);
        }
        catch (Exception ex) {
            LOG.error((Object)("Unable to parse " + mapping.getParameter()), (Throwable)ex);
            throw new Exception("Unable to parse " + mapping.getParameter());
        }
        if (scriptName == null) {
            LOG.error((Object)"No script specified in the parameter attribute");
            throw new Exception("No script specified");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Executing script: " + scriptName));
        }
        HttpSession session = request.getSession();
        ServletContext application = this.getServlet().getServletContext();
        Script script = this.loadScript(scriptName, application);
        bsfManager.declareBean("request", (Object)request, HttpServletRequest.class);
        bsfManager.declareBean("response", (Object)response, HttpServletResponse.class);
        if (session == null) {
            LOG.debug((Object)"HTTP session is null");
        } else {
            bsfManager.declareBean("session", (Object)session, HttpSession.class);
        }
        bsfManager.declareBean("application", (Object)application, ServletContext.class);
        bsfManager.declareBean("log", (Object)LOG, Log.class);
        StrutsInfo struts = new StrutsInfo(this, mapping, form, this.getResources(request));
        bsfManager.declareBean("struts", (Object)struts, StrutsInfo.class);
        for (int x = 0; x < filters.length; ++x) {
            filters[x].apply(bsfManager);
        }
        bsfManager.exec(script.lang, script.file.getCanonicalPath(), 0, 0, (Object)script.string);
        ActionForward af = struts.getForward();
        return af;
    }

    protected String parseScriptName(String url, BSFManager manager) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parsing " + url));
        }
        String name = null;
        if (url != null) {
            String[] parsed = ScriptAction.split(url, "?");
            name = parsed[0];
            if (parsed.length == 2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Found a query string");
                }
                String[] args = ScriptAction.split(parsed[1], "&");
                for (int x = 0; x < args.length; ++x) {
                    String[] param = ScriptAction.split(args[x], "=");
                    Object o = manager.lookupBean(param[0]);
                    if (o != null) {
                        LOG.warn((Object)("BSF variable " + param[0] + " already exists"));
                        param[0] = "_" + param[0];
                    }
                    manager.declareBean(param[0], (Object)param[1], class$java$lang$String == null ? ScriptAction.class$("java.lang.String") : class$java$lang$String);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Registering param " + param[0] + " with value " + param[1]));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No query string:" + parsed.length));
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Script loadScript(String name, ServletContext context) {
        Script script = (Script)this.scripts.get(name);
        if (script == null) {
            script = new Script();
            script.file = new File(context.getRealPath(name));
            try {
                script.lang = BSFManager.getLangFromFilename((String)script.file.getName());
            }
            catch (BSFException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
        }
        boolean reloadScript = false;
        long scriptLastModified = script.file.lastModified();
        if (scriptLastModified > script.timeLastLoaded) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading updated or new script: " + script.file.getName()));
            }
            reloadScript = true;
        }
        if (reloadScript || script.string == null) {
            ScriptAction scriptAction = this;
            synchronized (scriptAction) {
                script.timeLastLoaded = System.currentTimeMillis();
                FileReader reader = null;
                try {
                    reader = new FileReader(script.file);
                    script.string = IOUtils.getStringFromReader((Reader)reader);
                }
                catch (IOException ex) {
                    LOG.error((Object)("Unable to load script: " + script.file), (Throwable)ex);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ex) {
                            LOG.debug((Object)ex, (Throwable)ex);
                        }
                    }
                }
            }
        }
        return script;
    }

    protected static BSFManagerFilter[] loadFilters(Properties props) {
        ArrayList<BSFManagerFilter> list = new ArrayList<BSFManagerFilter>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            if (!prop.startsWith(FILTERS_BASE) || !prop.endsWith("class")) continue;
            String type = prop.substring(FILTERS_BASE.length(), prop.indexOf(".", FILTERS_BASE.length()));
            String claz = props.getProperty(prop);
            try {
                Class<?> cls = Class.forName(claz);
                BSFManagerFilter f = (BSFManagerFilter)cls.newInstance();
                f.init(type, props);
                list.add(f);
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)("Loaded " + type + " filter: " + claz));
            }
            catch (Exception ex) {
                LOG.error((Object)("Unable to load " + type + " filter: " + claz));
            }
        }
        BSFManagerFilter[] filters = new BSFManagerFilter[list.size()];
        filters = list.toArray(filters);
        return filters;
    }

    protected static String[] split(String line, String delimiter) {
        if (line == null || "".equals(line)) {
            return new String[0];
        }
        ArrayList lst = new ArrayList();
        StringTokenizer e = new StringTokenizer(line, delimiter);
        while (e.hasMoreElements()) {
            lst.add(e.nextElement());
        }
        String[] ret = new String[lst.size()];
        return lst.toArray(ret);
    }

    public void saveToken(HttpServletRequest req) {
        super.saveToken(req);
    }

    public boolean isCancelled(HttpServletRequest req) {
        return super.isCancelled(req);
    }

    public boolean isTokenValid(HttpServletRequest req) {
        return super.isTokenValid(req);
    }

    public void resetToken(HttpServletRequest req) {
        super.resetToken(req);
    }

    public Locale getLocale(HttpServletRequest req) {
        return super.getLocale(req);
    }

    public void saveMessages(HttpServletRequest req, ActionMessages mes) {
        super.saveMessages(req, mes);
    }

    public void saveErrors(HttpServletRequest req, ActionErrors errs) {
        super.saveErrors(req, (ActionMessages)errs);
    }

    static {
        Properties props = new Properties();
        try {
            InputStream in = ScriptAction.class.getClassLoader().getResourceAsStream(PROPS_PATH);
            if (in == null) {
                in = ScriptAction.class.getClassLoader().getResourceAsStream("/struts-bsf.properties");
                if (in != null) {
                    LOG.warn((Object)"The struts-bsf.properties file has been deprecated.  Please use struts-scripting.properties instead.");
                } else {
                    LOG.warn((Object)"struts-scripting.properties not found, using default engine mappings.");
                }
            }
            if (in != null) {
                props.load(in);
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Unable to load struts-scripting.properties, using  default engine mappings.");
        }
        int pos = ENGINE_BASE.length();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(ENGINE_BASE) || !name.endsWith(".class")) continue;
            String type = name.substring(pos, name.indexOf(46, pos));
            String cls = props.getProperty(name);
            String ext = props.getProperty(ENGINE_BASE + type + ".extensions", "");
            String[] exts = ScriptAction.split(ext, ",");
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Loading BSF engine name:" + type + " class:" + cls + " ext:" + ext));
            }
            BSFManager.registerScriptingEngine((String)type, (String)cls, (String[])exts);
        }
        filters = ScriptAction.loadFilters(props);
    }

    class Script {
        public File file;
        public String lang = null;
        public long timeLastLoaded = 0L;
        public String string = null;

        Script() {
        }
    }
}

