/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.notifications.center;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

class MenuToggleButton
extends JToggleButton {
    private boolean mouseInArrowArea = false;

    public MenuToggleButton(final Icon regIcon, Icon rollOverIcon, int arrowWidth) {
        assert (null != regIcon);
        assert (null != rollOverIcon);
        final LineIcon lineIcon = new LineIcon(rollOverIcon, arrowWidth);
        this.setIcon(regIcon);
        this.setRolloverIcon(lineIcon);
        this.setRolloverSelectedIcon(lineIcon);
        this.setFocusable(false);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                MenuToggleButton.this.mouseInArrowArea = MenuToggleButton.this.isInArrowArea(e.getPoint());
                MenuToggleButton.this.setRolloverIcon(MenuToggleButton.this.mouseInArrowArea ? regIcon : lineIcon);
                MenuToggleButton.this.setRolloverSelectedIcon(MenuToggleButton.this.mouseInArrowArea ? regIcon : lineIcon);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu popup;
                if (MenuToggleButton.this.isInArrowArea(e.getPoint()) && null != (popup = MenuToggleButton.this.getPopupMenu())) {
                    popup.show(MenuToggleButton.this, 0, MenuToggleButton.this.getHeight());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MenuToggleButton.this.mouseInArrowArea = MenuToggleButton.this.isInArrowArea(e.getPoint());
                MenuToggleButton.this.setRolloverIcon(MenuToggleButton.this.mouseInArrowArea ? regIcon : lineIcon);
                MenuToggleButton.this.setRolloverSelectedIcon(MenuToggleButton.this.mouseInArrowArea ? regIcon : lineIcon);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MenuToggleButton.this.mouseInArrowArea = false;
                MenuToggleButton.this.setRolloverIcon(regIcon);
                MenuToggleButton.this.setRolloverSelectedIcon(regIcon);
            }
        });
        this.setModel(new Model());
    }

    protected JPopupMenu getPopupMenu() {
        return null;
    }

    private boolean isInArrowArea(Point p) {
        return p.getLocation().x >= this.getWidth() - 3 - 2 - this.getInsets().right;
    }

    private class Model
    extends JToggleButton.ToggleButtonModel {
        private Model() {
        }

        @Override
        public void setPressed(boolean b) {
            if (MenuToggleButton.this.mouseInArrowArea) {
                return;
            }
            super.setPressed(b);
        }
    }

    private static class LineIcon
    implements Icon {
        private final Icon origIcon;
        private final int arrowWidth;

        public LineIcon(Icon origIcon, int arrowWidth) {
            this.origIcon = origIcon;
            this.arrowWidth = arrowWidth;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.origIcon.paintIcon(c, g, x, y);
            g.setColor(UIManager.getColor("controlHighlight"));
            g.drawLine(x + this.origIcon.getIconWidth() - this.arrowWidth - 2, y, x + this.origIcon.getIconWidth() - this.arrowWidth - 2, y + this.getIconHeight());
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawLine(x + this.origIcon.getIconWidth() - this.arrowWidth - 3, y, x + this.origIcon.getIconWidth() - this.arrowWidth - 3, y + this.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return this.origIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.origIcon.getIconHeight();
        }
    }
}

