/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;

class ASTFeatures {
    private static final ASTFeatures DEFAULT = new ASTFeatures();
    private static Map<String, ASTFeatures> mimeTypeToASTFeatures = new HashMap<String, ASTFeatures>();
    boolean removeEmpty = false;
    boolean removeSimple = false;
    boolean removeEmptyN = true;
    boolean removeSimpleN = true;
    Set<String> empty = new HashSet<String>();
    Set<String> simple = new HashSet<String>();

    ASTFeatures() {
    }

    static ASTFeatures get(Language language) {
        if (language == null) {
            return DEFAULT;
        }
        String mimeType = language.getMimeType();
        ASTFeatures astFeatures = mimeTypeToASTFeatures.get(mimeType);
        if (astFeatures == null) {
            astFeatures = new ASTFeatures();
            mimeTypeToASTFeatures.put(mimeType, astFeatures);
            Feature optimiseProperty = language.getFeatureList().getFeature("AST");
            if (optimiseProperty != null) {
                StringTokenizer st;
                String s = (String)optimiseProperty.getValue("removeEmpty");
                if (s != null) {
                    if (s.startsWith("!")) {
                        astFeatures.removeEmptyN = false;
                        s = s.substring(1);
                    }
                    astFeatures.removeEmpty = "true".equals(s);
                    if (!"false".equals(s)) {
                        st = new StringTokenizer(s, ",");
                        while (st.hasMoreTokens()) {
                            astFeatures.empty.add(st.nextToken());
                        }
                    }
                }
                if ((s = (String)optimiseProperty.getValue("removeSimple")) != null) {
                    if (s.startsWith("!")) {
                        astFeatures.removeSimpleN = false;
                        s = s.substring(1);
                    }
                    astFeatures.removeSimple = "true".equals(s);
                    if (!"false".equals(s)) {
                        st = new StringTokenizer(s, ",");
                        while (st.hasMoreTokens()) {
                            astFeatures.simple.add(st.nextToken());
                        }
                    }
                }
            }
        }
        return astFeatures;
    }
}

