/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.InstancesController;
import org.netbeans.modules.profiler.heapwalk.details.api.DetailsSupport;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.ClassNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.model.RootNode;
import org.netbeans.modules.profiler.heapwalk.ui.InstancesListControllerUI;

public class InstancesListController
extends AbstractController {
    public static final AbstractHeapWalkerNode EMPTY_INSTANCE_NODE = new AbstractHeapWalkerNode(null){

        @Override
        protected String computeName() {
            return Bundle.InstancesListController_NoInstanceString();
        }

        @Override
        protected String computeType() {
            return "";
        }

        @Override
        protected String computeValue() {
            return "";
        }

        @Override
        protected String computeSize() {
            return "";
        }

        @Override
        protected String computeRetainedSize() {
            return "";
        }

        @Override
        protected Icon computeIcon() {
            return null;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    };
    public static final Instance INSTANCE_FIRST = new Instance(){

        public JavaClass getJavaClass() {
            return null;
        }

        public long getInstanceId() {
            return -1L;
        }

        public int getInstanceNumber() {
            return -1;
        }

        public long getSize() {
            return -1L;
        }

        public long getRetainedSize() {
            return -1L;
        }

        public long getReachableSize() {
            return -1L;
        }

        public List getFieldValues() {
            return null;
        }

        public Object getValueOfField(String name) {
            return null;
        }

        public List getStaticFieldValues() {
            return null;
        }

        public List getReferences() {
            return null;
        }

        public boolean isGCRoot() {
            return false;
        }

        public Instance getNearestGCRootPointer() {
            return null;
        }
    };
    public Instance instanceToSelect;
    public int containerToSelectIndex;
    private Instance selectedInstance;
    private InstancesController instancesController;
    private JavaClass jClass;
    private TreePath pathToSelect;

    public InstancesListController(InstancesController instancesController) {
        this.instancesController = instancesController;
    }

    public void setClass(JavaClass jClass) {
        this.jClass = jClass;
        ((InstancesListControllerUI)((Object)this.getPanel())).initColumns();
        this.update();
    }

    public HeapWalkerNode getFilteredSortedInstances(String filterValue, int sortingColumn, boolean sortingOrder) {
        if (this.jClass == null) {
            return EMPTY_INSTANCE_NODE;
        }
        return this.getInstances(this.jClass, filterValue, sortingColumn, sortingOrder);
    }

    public HeapWalkerNode getInstanceContainer(Instance instance, InstancesListClassNode rootNode) {
        HeapWalkerNode instanceContainer = null;
        List instances = this.jClass.getInstances();
        List filteredInstances = this.getFilteredInstances(instances, rootNode.filterValue);
        List sortedFilteredInstances = this.getSortedInstances(filteredInstances, rootNode.sortingColumn, rootNode.sortingOrder);
        int instanceIndex = sortedFilteredInstances.indexOf(instance);
        if (instanceIndex != -1) {
            int childrenCount = sortedFilteredInstances.size();
            BrowserUtils.GroupingInfo groupingInfo = BrowserUtils.getGroupingInfo(childrenCount);
            int containersCount = groupingInfo.containersCount;
            int collapseUnitSize = groupingInfo.collapseUnitSize;
            instanceContainer = rootNode.getChild(instanceIndex / collapseUnitSize);
        }
        return instanceContainer;
    }

    public InstancesController getInstancesController() {
        return this.instancesController;
    }

    public Instance getSelectedInstance() {
        return this.selectedInstance;
    }

    public void instanceSelected(Instance instance) {
        if (this.selectedInstance == instance) {
            return;
        }
        this.selectedInstance = instance;
        this.instancesController.instanceSelected();
    }

    public void scheduleContainerSelection(int containerIndex) {
        this.containerToSelectIndex = containerIndex;
        this.instanceToSelect = null;
    }

    public void scheduleFirstInstanceSelection() {
        this.instanceToSelect = INSTANCE_FIRST;
        this.containerToSelectIndex = -1;
    }

    public void scheduleInstanceSelection(Instance instance) {
        this.instanceToSelect = instance;
        this.containerToSelectIndex = -1;
    }

    public void selectInstance(Instance instance) {
        ((InstancesListControllerUI)((Object)this.getPanel())).makeVisible();
        ((InstancesListControllerUI)((Object)this.getPanel())).selectInstance(instance);
    }

    public void showInstance(Instance instance) {
        if (this.jClass != instance.getJavaClass()) {
            this.scheduleInstanceSelection(instance);
            this.setClass(instance.getJavaClass());
        } else {
            this.selectInstance(instance);
        }
    }

    public void update() {
        ((InstancesListControllerUI)((Object)this.getPanel())).update();
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((InstancesListControllerUI)((Object)this.getPanel())).getPresenter();
    }

    @Override
    protected JPanel createControllerUI() {
        return new InstancesListControllerUI(this);
    }

    private List getFilteredInstances(List instances, String filterValue) {
        return instances;
    }

    private HeapWalkerNode getInstances(JavaClass jClass, String filterValue, int sortingColumn, boolean sortingOrder) {
        return new InstancesListClassNode(jClass, filterValue, sortingColumn, sortingOrder);
    }

    private List getSortedInstances(List filteredInstances, int sortingColumn, boolean sortingOrder) {
        Collections.sort(filteredInstances, new InstancesComparator(sortingColumn, sortingOrder));
        return filteredInstances;
    }

    private boolean matchesFilter(Instance instance, String filterValue) {
        return true;
    }

    private static class InstancesComparator
    implements Comparator {
        private boolean sortingOrder;
        private int sortingColumn;

        public InstancesComparator(int sortingColumn, boolean sortingOrder) {
            this.sortingColumn = sortingColumn;
            this.sortingOrder = sortingOrder;
        }

        public int compare(Object o1, Object o2) {
            Instance instance1 = this.sortingOrder ? (Instance)o1 : (Instance)o2;
            Instance instance2 = this.sortingOrder ? (Instance)o2 : (Instance)o1;
            switch (this.sortingColumn) {
                case 0: {
                    return Integer.compare(instance1.getInstanceNumber(), instance2.getInstanceNumber());
                }
                case 1: {
                    return Long.compare(instance1.getInstanceId(), instance2.getInstanceId());
                }
                case 2: {
                    return Long.compare(instance1.getSize(), instance2.getSize());
                }
                case 3: {
                    return Long.compare(instance1.getRetainedSize(), instance2.getRetainedSize());
                }
                case 4: {
                    return Long.compare(instance1.getReachableSize(), instance2.getReachableSize());
                }
            }
            throw new RuntimeException("Unsupported compare operation for " + o1 + ", " + o2);
        }
    }

    public static class InstancesListInstanceNode
    extends HeapWalkerNode
    implements InstancesListNode {
        private static final NumberFormat numberFormat = NumberFormat.getInstance();
        private HeapWalkerNode parent;
        private ImageIcon icon;
        private Instance instance;
        private String name;
        private String reachableSize;
        private String retainedSize;
        private String size;
        private String details;

        public InstancesListInstanceNode(Instance instance, HeapWalkerNode parent) {
            this.parent = parent;
            this.instance = instance;
            this.name = "#" + instance.getInstanceNumber();
        }

        @Override
        public HeapWalkerNode getChild(int index) {
            return null;
        }

        @Override
        public HeapWalkerNode[] getChildren() {
            return new HeapWalkerNode[0];
        }

        @Override
        public Icon getIcon() {
            if (this.icon == null) {
                this.icon = this.computeIcon();
            }
            return this.icon;
        }

        public int getIndexOfChild(Object child) {
            return -1;
        }

        public Instance getInstance() {
            return this.instance;
        }

        @Override
        public String getID() {
            return "0x" + Long.toHexString(this.getInstance().getInstanceId());
        }

        @Override
        public TreePath getInstancePath(Instance inst) {
            TreePath instancePath = null;
            if (this.instance.equals(inst)) {
                ArrayList<InstancesListInstanceNode> paths = new ArrayList<InstancesListInstanceNode>();
                for (HeapWalkerNode node = this; node != null; node = ((HeapWalkerNode)node).getParent()) {
                    paths.add(0, (InstancesListInstanceNode)node);
                }
                instancePath = new TreePath(paths.toArray());
            }
            return instancePath;
        }

        public boolean isLeaf() {
            return true;
        }

        @Override
        public int getMode() {
            return 0;
        }

        @Override
        public boolean isModeFields() {
            return false;
        }

        public int getNChildren() {
            return 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public HeapWalkerNode getParent() {
            return this.parent;
        }

        @Override
        public String getReachableSize() {
            if (this.reachableSize == null) {
                this.reachableSize = "N/A";
            }
            return this.reachableSize;
        }

        @Override
        public String getRetainedSize() {
            if (this.retainedSize == null) {
                this.retainedSize = numberFormat.format(this.instance.getRetainedSize());
            }
            return this.retainedSize;
        }

        @Override
        public boolean isRoot() {
            return false;
        }

        @Override
        public String getSimpleType() {
            return this.parent.getSimpleType();
        }

        @Override
        public String getSize() {
            if (this.size == null) {
                this.size = numberFormat.format(this.instance.getSize());
            }
            return this.size;
        }

        @Override
        public String getType() {
            return this.parent.getType();
        }

        @Override
        public String getValue() {
            return this.parent.getValue();
        }

        @Override
        public String getDetails() {
            if (this.details == null) {
                this.details = "";
                HeapWalkerNode _root = BrowserUtils.getRoot(this.parent);
                if (_root instanceof RootNode) {
                    final RootNode root = (RootNode)((Object)_root);
                    BrowserUtils.performTask(new Runnable(){

                        @Override
                        public void run() {
                            final String d = root.getDetails(instance);
                            if (d != null) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        details = d;
                                        root.repaintView();
                                    }
                                });
                            }
                        }
                    });
                }
            }
            return this.details;
        }

        @Override
        public boolean currentlyHasChildren() {
            return false;
        }

        public String toString() {
            return this.getName();
        }

        protected ImageIcon computeIcon() {
            return this.getInstance().getJavaClass().isArray() ? BrowserUtils.ICON_ARRAY : BrowserUtils.ICON_INSTANCE;
        }

        @Override
        public Object getNodeID() {
            return this.instance;
        }
    }

    public class InstancesListContainerNode
    extends AbstractHeapWalkerNode
    implements InstancesListNode {
        private String filterValue;
        private boolean sortingOrder;
        private int endIndex;
        private int sortingColumn;
        private int startIndex;

        public InstancesListContainerNode(ClassNode classNode, int startIndex, int endIndex, String filterValue, int sortingColumn, boolean sortingOrder) {
            super(classNode);
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.filterValue = filterValue;
            this.sortingColumn = sortingColumn;
            this.sortingOrder = sortingOrder;
        }

        public InstancesListContainerNode(ClassNode classNode, int startIndex, int endIndex, String filterValue, int sortingColumn, boolean sortingOrder, List sortedFilteredInstances, int instanceToSelectIndex) {
            this(classNode, startIndex, endIndex, filterValue, sortingColumn, sortingOrder);
            int itemsCount = endIndex - startIndex + 1;
            HeapWalkerNode[] children = new HeapWalkerNode[itemsCount];
            for (int i = 0; i < itemsCount; ++i) {
                children[i] = new InstancesListInstanceNode((Instance)sortedFilteredInstances.get(startIndex + i), this);
                if (instanceToSelectIndex != startIndex + i) continue;
                this$0.pathToSelect = new TreePath(new Object[]{classNode, this, children[i]});
            }
            this$0.instanceToSelect = null;
            this$0.containerToSelectIndex = -1;
            this.setChildren(children);
        }

        @Override
        public TreePath getInstancePath(Instance instance) {
            TreePath instancePath = null;
            if (this.currentlyHasChildren()) {
                HeapWalkerNode[] children = this.getChildren();
                for (int i = 0; !(i >= children.length || children[i] instanceof InstancesListNode && (instancePath = ((InstancesListNode)((Object)children[i])).getInstancePath(instance)) != null); ++i) {
                }
            }
            return instancePath;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public String getID() {
            return "";
        }

        @Override
        public String getReachableSize() {
            return "";
        }

        @Override
        protected ChildrenComputer getChildrenComputer() {
            return new ChildrenComputer(){

                @Override
                public HeapWalkerNode[] computeChildren() {
                    int itemsCount = InstancesListContainerNode.this.endIndex - InstancesListContainerNode.this.startIndex + 1;
                    HeapWalkerNode[] children = new HeapWalkerNode[itemsCount];
                    List instances = ((ClassNode)InstancesListContainerNode.this.getParent()).getJavaClass().getInstances();
                    List filteredInstances = InstancesListController.this.getFilteredInstances(instances, InstancesListContainerNode.this.filterValue);
                    List sortedFilteredInstances = InstancesListController.this.getSortedInstances(filteredInstances, InstancesListContainerNode.this.sortingColumn, InstancesListContainerNode.this.sortingOrder);
                    for (int i = 0; i < children.length; ++i) {
                        Instance instance = (Instance)sortedFilteredInstances.get(InstancesListContainerNode.this.startIndex + i);
                        children[i] = new InstancesListInstanceNode(instance, InstancesListContainerNode.this);
                        if (InstancesListController.this.instanceToSelect == null || (InstancesListContainerNode.this.startIndex + i != 0 || InstancesListController.this.instanceToSelect != INSTANCE_FIRST) && !instance.equals(InstancesListController.this.instanceToSelect)) continue;
                        InstancesListController.this.pathToSelect = new TreePath(new Object[]{children[i].getParent().getParent(), children[i].getParent(), children[i]});
                        InstancesListController.this.instanceToSelect = null;
                        InstancesListController.this.containerToSelectIndex = -1;
                    }
                    return children;
                }
            };
        }

        @Override
        protected HeapWalkerNode[] computeChildren() {
            return BrowserUtils.lazilyCreateChildren(this, this.getChildrenComputer());
        }

        @Override
        protected Icon computeIcon() {
            return null;
        }

        @Override
        protected String computeName() {
            return Bundle.InstancesListController_InstancesNumberString(this.endIndex - this.startIndex + 1);
        }

        @Override
        protected String computeType() {
            return this.getParent().getType();
        }

        @Override
        protected String computeValue() {
            return this.getParent().getValue();
        }

        @Override
        protected String computeSize() {
            return "";
        }

        @Override
        protected String computeRetainedSize() {
            return "";
        }

        @Override
        public Object getNodeID() {
            return this.startIndex;
        }
    }

    public class InstancesListClassNode
    extends ClassNode.RootNode
    implements InstancesListNode {
        String filterValue;
        boolean sortingOrder;
        int sortingColumn;
        private String size;

        public InstancesListClassNode(JavaClass javaClass, String filterValue, int sortingColumn, boolean sortingOrder) {
            super(javaClass, "class", null);
            this.size = String.valueOf(javaClass.getAllInstancesSize());
            this.filterValue = filterValue;
            this.sortingColumn = sortingColumn;
            this.sortingOrder = sortingOrder;
        }

        @Override
        public GCRoot getGCRoot(Instance instance) {
            return InstancesListController.this.instancesController.getHeapFragmentWalker().getHeapFragment().getGCRoot(instance);
        }

        @Override
        public TreePath getInstancePath(Instance instance) {
            TreePath instancePath = null;
            if (this.currentlyHasChildren()) {
                HeapWalkerNode[] children = this.getChildren();
                for (int i = 0; !(i >= children.length || children[i] instanceof InstancesListNode && (instancePath = ((InstancesListNode)((Object)children[i])).getInstancePath(instance)) != null); ++i) {
                }
            }
            return instancePath;
        }

        @Override
        public String getID() {
            return "0x" + Long.toHexString(this.getJavaClass().getJavaClassId());
        }

        @Override
        public JavaClass getJavaClassByID(long javaclassId) {
            return InstancesListController.this.instancesController.getHeapFragmentWalker().getHeapFragment().getJavaClassByID(javaclassId);
        }

        @Override
        public String getDetails(Instance instance) {
            return DetailsSupport.getDetailsString(instance, InstancesListController.this.instancesController.getHeapFragmentWalker().getHeapFragment());
        }

        @Override
        public void repaintView() {
            InstancesListController.this.getPanel().repaint();
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public String getReachableSize() {
            return "N/A";
        }

        @Override
        public String getRetainedSize() {
            return "N/A";
        }

        @Override
        public String getSize() {
            return this.size;
        }

        @Override
        public void refreshView() {
            ((InstancesListControllerUI)((Object)InstancesListController.this.getPanel())).refreshView();
            if (InstancesListController.this.pathToSelect != null) {
                ((InstancesListControllerUI)((Object)InstancesListController.this.getPanel())).selectPath(InstancesListController.this.pathToSelect);
                InstancesListController.this.pathToSelect = null;
            }
        }

        @Override
        protected ChildrenComputer getChildrenComputer() {
            return new ChildrenComputer(){

                @Override
                public HeapWalkerNode[] computeChildren() {
                    HeapWalkerNode[] children = null;
                    List instances = InstancesListClassNode.this.getJavaClass().getInstances();
                    List filteredInstances = InstancesListController.this.getFilteredInstances(instances, InstancesListClassNode.this.filterValue);
                    List sortedFilteredInstances = null;
                    if (InstancesListController.this.instanceToSelect != null) {
                        sortedFilteredInstances = InstancesListController.this.getSortedInstances(filteredInstances, InstancesListClassNode.this.sortingColumn, InstancesListClassNode.this.sortingOrder);
                    }
                    if (filteredInstances.size() == 0) {
                        children = new HeapWalkerNode[]{HeapWalkerNodeFactory.createNoItemsNode(InstancesListClassNode.this)};
                    } else if (filteredInstances.size() > 2000) {
                        int instanceToSelectIndex = -1;
                        if (InstancesListController.this.instanceToSelect != null) {
                            instanceToSelectIndex = InstancesListController.this.instanceToSelect == INSTANCE_FIRST ? 0 : sortedFilteredInstances.indexOf(InstancesListController.this.instanceToSelect);
                        }
                        int childrenCount = filteredInstances.size();
                        BrowserUtils.GroupingInfo groupingInfo = BrowserUtils.getGroupingInfo(childrenCount);
                        int containersCount = groupingInfo.containersCount;
                        int collapseUnitSize = groupingInfo.collapseUnitSize;
                        children = new HeapWalkerNode[containersCount];
                        for (int i = 0; i < containersCount; ++i) {
                            int unitStartIndex = collapseUnitSize * i;
                            int unitEndIndex = Math.min(unitStartIndex + collapseUnitSize, childrenCount) - 1;
                            if (instanceToSelectIndex != -1 && instanceToSelectIndex >= unitStartIndex && instanceToSelectIndex <= unitEndIndex) {
                                children[i] = new InstancesListContainerNode(InstancesListClassNode.this, unitStartIndex, unitEndIndex, InstancesListClassNode.this.filterValue, InstancesListClassNode.this.sortingColumn, InstancesListClassNode.this.sortingOrder, sortedFilteredInstances, instanceToSelectIndex);
                                instanceToSelectIndex = -1;
                                continue;
                            }
                            children[i] = new InstancesListContainerNode(InstancesListClassNode.this, unitStartIndex, unitEndIndex, InstancesListClassNode.this.filterValue, InstancesListClassNode.this.sortingColumn, InstancesListClassNode.this.sortingOrder);
                            if (InstancesListController.this.containerToSelectIndex != i) continue;
                            InstancesListController.this.pathToSelect = new TreePath(new Object[]{InstancesListClassNode.this, children[i]});
                            InstancesListController.this.containerToSelectIndex = -1;
                            InstancesListController.this.instanceToSelect = null;
                        }
                        InstancesListController.this.containerToSelectIndex = -1;
                        InstancesListController.this.instanceToSelect = null;
                    } else {
                        if (sortedFilteredInstances == null) {
                            sortedFilteredInstances = InstancesListController.this.getSortedInstances(filteredInstances, InstancesListClassNode.this.sortingColumn, InstancesListClassNode.this.sortingOrder);
                        }
                        children = new HeapWalkerNode[sortedFilteredInstances.size()];
                        for (int i = 0; i < children.length; ++i) {
                            Instance instance = (Instance)sortedFilteredInstances.get(i);
                            children[i] = new InstancesListInstanceNode(instance, InstancesListClassNode.this);
                            if (InstancesListController.this.instanceToSelect == null || (i != 0 || InstancesListController.this.instanceToSelect != INSTANCE_FIRST) && !instance.equals(InstancesListController.this.instanceToSelect)) continue;
                            InstancesListController.this.pathToSelect = new TreePath(new Object[]{InstancesListClassNode.this, children[i]});
                            InstancesListController.this.instanceToSelect = null;
                            InstancesListController.this.containerToSelectIndex = -1;
                        }
                        InstancesListController.this.instanceToSelect = null;
                        InstancesListController.this.containerToSelectIndex = -1;
                    }
                    return children;
                }
            };
        }

        @Override
        protected ImageIcon computeIcon() {
            return this.getJavaClass().isArray() ? BrowserUtils.ICON_ARRAY : BrowserUtils.ICON_INSTANCE;
        }

        @Override
        protected String computeName() {
            return InstancesListController.this.jClass.getName();
        }
    }

    public static interface InstancesListNode {
        public TreePath getInstancePath(Instance var1);

        public String getName();

        public String getReachableSize();

        public String getRetainedSize();

        public String getSize();

        public String getID();
    }
}

