/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.netbeans.modules.project.libraries.LibrariesStorage;
import org.netbeans.modules.project.libraries.LibraryDeclarationHandler;
import org.netbeans.modules.project.libraries.LibraryTypeRegistry;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.util.BaseUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LibraryDeclarationHandlerImpl
implements LibraryDeclarationHandler {
    private LibraryImplementation library;
    private String libraryType;
    private String libraryDescription;
    private String libraryName;
    private String localizingBundle;
    private String displayName;
    private final Map<String, List<URL>> contentTypes = new HashMap<String, List<URL>>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private List<URL> cpEntries;
    private String contentType;
    private State state = State.LIB;
    private final AtomicBoolean used = new AtomicBoolean();
    private String propName;
    private String propValue;

    @Override
    public void startDocument() {
        if (this.used.getAndSet(true)) {
            throw new IllegalStateException("The LibraryDeclarationHandlerImpl was already used, create a new instance");
        }
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void start_volume(Attributes meta) throws SAXException {
        this.cpEntries = new ArrayList<URL>();
        this.state = State.VOLUME;
    }

    @Override
    public void end_volume() throws SAXException {
        this.contentTypes.put(this.contentType, this.cpEntries);
        this.state = State.LIB;
        this.contentType = null;
    }

    @Override
    public void handle_type(String data, Attributes meta) throws SAXException {
        if (data == null || data.length() == 0) {
            throw new SAXException("Empty value of type element");
        }
        if (this.state == State.VOLUME) {
            this.contentType = data;
        } else {
            this.libraryType = data;
        }
    }

    @Override
    public String start_library(String nameSpace, Attributes meta) throws SAXException {
        String version = meta.getValue("version");
        if ("1.0".equals(version)) {
            return "";
        }
        if ("2.0".equals(version)) {
            return "http://www.netbeans.org/ns/library-declaration/2";
        }
        if ("3.0".equals(version)) {
            return "http://www.netbeans.org/ns/library-declaration/3";
        }
        throw new SAXException("Invalid librray descriptor version");
    }

    @Override
    public void end_library() throws SAXException {
        boolean update;
        if (this.library != null) {
            if (this.libraryType == null || !this.libraryType.equals(this.library.getType())) {
                throw new SAXParseException("Changing library type of library: " + this.libraryName + " from: " + this.library.getType() + " to: " + this.libraryType, null);
            }
            update = true;
        } else {
            if (this.libraryType == null) {
                throw new SAXParseException("Unspecified library type for: " + this.libraryName, null);
            }
            LibraryTypeProvider provider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(this.libraryType);
            if (provider == null) {
                throw new UnknownLibraryTypeException(this.libraryName, this.libraryType);
            }
            this.library = provider.createLibrary();
            update = false;
            LibrariesStorage.LOG.log(Level.FINE, "LibraryDeclarationHandlerImpl library {0} type {1} found", new Object[]{this.libraryName, this.libraryType});
        }
        if (!update || !BaseUtilities.compareObjects((Object)this.library.getLocalizingBundle(), (Object)this.localizingBundle)) {
            this.library.setLocalizingBundle(this.localizingBundle);
        }
        if (!update || !BaseUtilities.compareObjects((Object)this.library.getName(), (Object)this.libraryName)) {
            this.library.setName(this.libraryName);
        }
        if (!update || !BaseUtilities.compareObjects((Object)this.library.getDescription(), (Object)this.libraryDescription)) {
            this.library.setDescription(this.libraryDescription);
        }
        LibrariesSupport.setDisplayName(this.library, this.displayName);
        LibrariesSupport.setProperties(this.library, this.properties);
        for (Map.Entry<String, List<URL>> entry : this.contentTypes.entrySet()) {
            String contentType = entry.getKey();
            List<URL> cp = entry.getValue();
            try {
                if (update && LibraryDeclarationHandlerImpl.urlsEqual(this.library.getContent(contentType), cp)) continue;
                this.library.setContent(contentType, cp);
            }
            catch (IllegalArgumentException e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void handle_resource(URL data, Attributes meta) throws SAXException {
        if (data != null) {
            this.cpEntries.add(data);
        }
    }

    @Override
    public void handle_name(String data, Attributes meta) throws SAXException {
        if (this.state == State.PROPERTY) {
            this.propName = data;
        } else {
            this.libraryName = data;
        }
    }

    @Override
    public void handle_description(String data, Attributes meta) throws SAXException {
        this.libraryDescription = data;
    }

    @Override
    public void handle_localizingBundle(String data, Attributes meta) throws SAXException {
        this.localizingBundle = data;
    }

    @Override
    public void handle_displayName(String data, Attributes meta) throws SAXException {
        this.displayName = data;
    }

    public void setLibrary(LibraryImplementation library) {
        this.library = library;
    }

    public LibraryImplementation getLibrary() {
        return this.library;
    }

    @Override
    public void start_properties(Attributes meta) throws SAXException {
        this.state = State.PROPERTIES;
        this.properties.clear();
    }

    @Override
    public void end_properties() throws SAXException {
        this.state = State.LIB;
    }

    @Override
    public void start_property(Attributes meta) throws SAXException {
        this.propName = null;
        this.propValue = null;
        this.state = State.PROPERTY;
    }

    @Override
    public void end_property() throws SAXException {
        this.state = State.PROPERTIES;
        assert (this.propName != null);
        this.properties.put(this.propName, this.propValue);
    }

    @Override
    public void handle_value(String data, Attributes meta) throws SAXException {
        this.propValue = data;
    }

    private static boolean urlsEqual(Collection<? extends URL> first, Collection<? extends URL> second) {
        assert (first != null);
        assert (second != null);
        if (first.size() != second.size()) {
            return false;
        }
        Iterator<? extends URL> fit = first.iterator();
        Iterator<? extends URL> sit = second.iterator();
        while (fit.hasNext()) {
            URL furl = fit.next();
            URL surl = sit.next();
            if (furl.toExternalForm().equals(surl.toExternalForm())) continue;
            return false;
        }
        return true;
    }

    private static enum State {
        LIB,
        VOLUME,
        PROPERTIES,
        PROPERTY;

    }

    public static class UnknownLibraryTypeException
    extends SAXException {
        public final String type;

        private UnknownLibraryTypeException(String libraryName, String libraryType) {
            super("Cannot create library: " + libraryName + " of unknown type: " + libraryType, null);
            this.type = libraryType;
        }
    }
}

