/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileOrZipEntry {
    private File file;
    private String dirOrJar;
    private String fileName;
    private boolean isZipEntry;
    private long len;

    public FileOrZipEntry(String dirOrJar, String fileName) {
        this.dirOrJar = dirOrJar;
        this.fileName = fileName;
        String lcd = dirOrJar.toLowerCase();
        this.isZipEntry = lcd.endsWith(".jar") || lcd.endsWith(".zip");
        this.len = -1L;
    }

    public FileOrZipEntry(File file) {
        this.file = file;
        this.isZipEntry = false;
        this.len = -1L;
    }

    public File getFile() {
        if (this.isZipEntry) {
            return null;
        }
        if (this.file == null) {
            this.file = new File(this.dirOrJar, this.fileName);
        }
        return this.file;
    }

    public boolean isFile() {
        return !this.isZipEntry;
    }

    public String getFullName() {
        if (!this.isZipEntry) {
            if (this.file == null) {
                this.file = new File(this.dirOrJar, this.fileName);
            }
            return this.file.getAbsolutePath();
        }
        return this.dirOrJar + "/" + this.fileName;
    }

    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        if (!this.isZipEntry) {
            this.file = new File(this.dirOrJar, this.fileName);
            this.len = this.file.length();
            return new FileInputStream(this.file);
        }
        ZipFile zip = new ZipFile(this.dirOrJar);
        ZipEntry entry = zip.getEntry(this.fileName);
        this.len = entry.getSize();
        return zip.getInputStream(entry);
    }

    public long getLength() throws IOException {
        if (this.len != -1L) {
            return this.len;
        }
        if (this.file != null) {
            return this.file.length();
        }
        if (!this.isZipEntry) {
            return new File(this.dirOrJar, this.fileName).length();
        }
        ZipFile zip = new ZipFile(this.dirOrJar);
        return zip.getEntry(this.fileName).getSize();
    }

    public String getName() {
        if (this.isZipEntry) {
            int lastSlashIdx = this.fileName.lastIndexOf(47);
            if (lastSlashIdx == -1) {
                return this.fileName;
            }
            return this.fileName.substring(lastSlashIdx + 1);
        }
        if (this.fileName == null) {
            this.fileName = this.file.getName();
        }
        return this.fileName;
    }
}

