/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.history;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;

class HistoryEntry {
    private final VCSHistoryProvider.HistoryEntry entry;
    private final boolean local;
    private Map<VCSFileProxy, HistoryEntry> parents;

    HistoryEntry(VCSHistoryProvider.HistoryEntry entry, boolean local) {
        this.entry = entry;
        this.local = local;
    }

    public Object[] getLookupObjects() {
        Object[] delegates = org.netbeans.modules.versioning.core.util.Utils.getDelegateEntry((VCSHistoryProvider.HistoryEntry)this.entry);
        if (delegates == null) {
            return new Object[]{this.entry};
        }
        Object[] ret = new Object[delegates.length + 1];
        System.arraycopy(delegates, 0, ret, 0, delegates.length);
        ret[delegates.length] = this.entry;
        return ret;
    }

    public String getUsernameShort() {
        return this.entry.getUsernameShort();
    }

    public String getUsername() {
        return this.entry.getUsername();
    }

    public String getRevisionShort() {
        return this.entry.getRevisionShort();
    }

    public void getRevisionFile(VCSFileProxy originalFile, VCSFileProxy revisionFile) {
        this.entry.getRevisionFile(originalFile, revisionFile);
        Utils.associateEncoding((FileObject)originalFile.toFileObject(), (FileObject)revisionFile.toFileObject());
    }

    public String getRevision() {
        return this.entry.getRevision();
    }

    public String getMessage() {
        return this.entry.getMessage();
    }

    public VCSFileProxy[] getFiles() {
        return this.entry.getFiles();
    }

    public Date getDateTime() {
        return this.entry.getDateTime();
    }

    public Action[] getActions() {
        return this.entry.getActions();
    }

    public void setMessage(String message) throws IOException {
        this.entry.setMessage(message);
    }

    public boolean canEdit() {
        return this.entry.canEdit();
    }

    public synchronized HistoryEntry getParent(VCSFileProxy file) {
        HistoryEntry parent = null;
        if (this.parents == null) {
            this.parents = new HashMap<VCSFileProxy, HistoryEntry>();
        } else {
            parent = this.parents.get(file);
        }
        if (parent == null) {
            VCSHistoryProvider.HistoryEntry vcsParent = this.entry.getParentEntry(file);
            parent = vcsParent != null ? new HistoryEntry(vcsParent, this.local) : null;
            this.parents.put(file, parent);
        }
        return parent;
    }

    public boolean isLocalHistory() {
        return this.local;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("files=[");
        VCSFileProxy[] files = this.getFiles();
        for (int i = 0; i < files.length; ++i) {
            sb.append(files[i]);
            if (i >= files.length - 1) continue;
            sb.append(",");
        }
        sb.append("],");
        sb.append("timestamp=");
        sb.append(this.getDateTime().getTime());
        sb.append(",");
        sb.append("revision=");
        sb.append(this.getRevision());
        sb.append(",");
        sb.append("username=");
        sb.append(this.getUsername());
        sb.append(",");
        sb.append("message=");
        sb.append(this.getMessage());
        sb.append(",");
        sb.append("canEdit=");
        sb.append(this.canEdit());
        sb.append("]");
        return sb.toString();
    }
}

