/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.launcher.LanguageLauncherBase;
import org.graalvm.launcher.Launcher;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.PolyglotException;

public abstract class AbstractLanguageLauncher
extends LanguageLauncherBase {
    protected static final boolean IS_LIBPOLYGLOT = Boolean.getBoolean("graalvm.libpolyglot");

    protected final void launch(String[] args) {
        try {
            try {
                this.launch(new ArrayList<String>(Arrays.asList(args)), null, true);
            }
            catch (Launcher.AbortException e) {
                throw e;
            }
            catch (PolyglotException e) {
                this.handlePolyglotException(e);
            }
            catch (Throwable t) {
                throw this.abort(t);
            }
        }
        catch (Launcher.AbortException e) {
            this.handleAbortException(e);
        }
    }

    final void launch(List<String> args, Map<String, String> defaultOptions, boolean doNativeSetup) {
        Map<String, String> polyglotOptions = defaultOptions;
        if (polyglotOptions == null) {
            polyglotOptions = new HashMap<String, String>();
        }
        if (AbstractLanguageLauncher.isAOT() && doNativeSetup) {
            System.setProperty("org.graalvm.launcher.languageId", this.getLanguageId());
        }
        List<String> unrecognizedArgs = this.preprocessArguments(args, polyglotOptions);
        if (AbstractLanguageLauncher.isAOT() && doNativeSetup && !IS_LIBPOLYGLOT) {
            assert (this.nativeAccess != null);
            this.maybeNativeExec(args, false, polyglotOptions);
        }
        this.parseUnrecognizedOptions(this.getLanguageId(), polyglotOptions, unrecognizedArgs);
        if (this.runLauncherAction()) {
            return;
        }
        this.validateArguments(polyglotOptions);
        this.argumentsProcessingDone();
        Context.Builder builder = this.isPolyglot() ? Context.newBuilder((String[])new String[0]).options(polyglotOptions) : Context.newBuilder((String[])this.getDefaultLanguages()).options(polyglotOptions);
        builder.allowAllAccess(true);
        this.setupContextBuilder(builder);
        this.launch(builder);
    }

    protected abstract List<String> preprocessArguments(List<String> var1, Map<String, String> var2);

    protected void validateArguments(Map<String, String> polyglotOptions) {
    }

    protected abstract void launch(Context.Builder var1);

    protected abstract String getLanguageId();

    @Override
    protected void printVersion() {
        this.printVersion(AbstractLanguageLauncher.getTempEngine());
    }

    protected void printVersion(Engine engine) {
        String languageId = this.getLanguageId();
        Language language = (Language)engine.getLanguages().get(languageId);
        if (language == null) {
            throw this.abort(String.format("Unknown language: '%s'!", languageId));
        }
        String languageImplementationName = language.getImplementationName();
        if (languageImplementationName == null || languageImplementationName.length() == 0) {
            String languageName = language.getName();
            if (languageName == null || languageName.length() == 0) {
                languageName = languageId;
            }
            languageImplementationName = languageName;
        }
        String engineImplementationName = engine.getImplementationName();
        engineImplementationName = AbstractLanguageLauncher.isAOT() ? engineImplementationName + " Native" : engineImplementationName + " JVM";
        String languageVersion = language.getVersion();
        languageVersion = languageVersion.equals(engine.getVersion()) ? "" : languageVersion + " ";
        System.out.println(String.format("%s %s(%s %s)", languageImplementationName, languageVersion, engineImplementationName, engine.getVersion()));
    }

    protected void runVersionAction(Launcher.VersionAction action, Engine engine) {
        switch (action) {
            case PrintAndContinue: {
                this.printVersion(engine);
                break;
            }
            case PrintAndExit: {
                this.printVersion(engine);
                throw this.exit();
            }
        }
    }

    protected String[] getDefaultLanguages() {
        return new String[]{this.getLanguageId()};
    }
}

