/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.launcher;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import jline.console.ConsoleReader;
import jline.console.UserInterruptException;
import jline.console.history.History;
import jline.console.history.MemoryHistory;
import jline.internal.NonBlockingInputStream;
import org.graalvm.launcher.Launcher;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;

class MultiLanguageShell {
    private final Map<Language, History> histories = new HashMap<Language, History>();
    private final Context context;
    private final InputStream in;
    private final OutputStream out;
    private final String defaultStartLanguage;

    MultiLanguageShell(Context context, InputStream in, OutputStream out, String defaultStartLanguage) {
        this.context = context;
        this.in = in;
        this.out = out;
        this.defaultStartLanguage = defaultStartLanguage;
    }

    /*
     * WARNING - void declaration
     */
    public int readEvalPrint() throws IOException {
        void var7_12;
        Language currentLanguage;
        ConsoleReader console = new ConsoleReader(this.in, this.out);
        console.setHandleUserInterrupt(true);
        console.setExpandEvents(false);
        console.setCopyPasteDetection(true);
        console.println("GraalVM MultiLanguage Shell " + this.context.getEngine().getVersion());
        console.println("Copyright (c) 2013-2019, Oracle and/or its affiliates");
        ArrayList<Language> languages = new ArrayList<Language>();
        HashSet<Language> uniqueValues = new HashSet<Language>();
        for (Language language : this.context.getEngine().getLanguages().values()) {
            if (!language.isInteractive() || !uniqueValues.add(language)) continue;
            languages.add(language);
        }
        languages.sort(Comparator.comparing(Language::getName));
        HashMap<String, Language> prompts = new HashMap<String, Language>();
        StringBuilder promptsString = new StringBuilder();
        for (Language language : languages) {
            String prompt = MultiLanguageShell.createPrompt(language).trim();
            promptsString.append(prompt).append(" ");
            prompts.put(prompt, language);
            console.println("  " + language.getName() + " version " + language.getVersion());
        }
        if (languages.isEmpty()) {
            throw new Launcher.AbortException("Error: No Graal languages installed. Exiting shell.", 1);
        }
        MultiLanguageShell.printUsage(console, promptsString, false);
        int maxNameLength = 0;
        for (Language language : languages) {
            maxNameLength = Math.max(maxNameLength, language.getName().length());
        }
        String string = this.defaultStartLanguage;
        if (string == null) {
            String string2 = ((Language)languages.get(0)).getId();
        }
        if ((currentLanguage = (Language)this.context.getEngine().getLanguages().get(var7_12)) == null) {
            throw new Launcher.AbortException("Error: could not find language '" + (String)var7_12 + "'", 1);
        }
        assert (languages.indexOf(currentLanguage) >= 0);
        Source bufferSource = null;
        String id = currentLanguage.getId();
        String prompt = MultiLanguageShell.createPrompt(currentLanguage);
        console.getKeys().bind(String.valueOf('\f'), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                throw new ChangeLanguageException(null);
            }
        });
        this.context.initialize(currentLanguage.getId());
        boolean verboseErrors = false;
        block8: while (true) {
            String input = null;
            Source source = null;
            try {
                input = console.readLine(bufferSource == null ? prompt : MultiLanguageShell.createBufferPrompt(prompt));
                if (input != null) {
                    if (bufferSource == null && input.trim().equals("")) continue;
                    Language switchedLanguage = null;
                    String trimmedInput = input.trim();
                    if (trimmedInput.equals("-usage")) {
                        MultiLanguageShell.printUsage(console, promptsString, true);
                        input = "";
                    } else if (trimmedInput.equals("-verboseErrors")) {
                        boolean bl = verboseErrors = !verboseErrors;
                        if (verboseErrors) {
                            console.println("Verbose errors is now on.");
                        } else {
                            console.println("Verbose errors is now off.");
                        }
                        input = "";
                    } else if (prompts.containsKey(trimmedInput)) {
                        switchedLanguage = (Language)prompts.get(input);
                        input = "";
                    } else if (bufferSource != null) {
                        input = bufferSource.getCharacters() + "\n" + input;
                    }
                    NonBlockingInputStream nonBlockIn = (NonBlockingInputStream)console.getInput();
                    while (nonBlockIn.isNonBlockingEnabled() && nonBlockIn.peek(10L) >= 0 && switchedLanguage == null) {
                        String line = console.readLine(MultiLanguageShell.createBufferPrompt(prompt));
                        String trimmedLine = line.trim();
                        if (prompts.containsKey(trimmedLine)) {
                            switchedLanguage = (Language)prompts.get(trimmedLine);
                            break;
                        }
                        input = input + "\n" + line;
                    }
                    if (!input.trim().equals("")) {
                        source = Source.newBuilder((String)currentLanguage.getId(), (CharSequence)input, (String)"<shell>").interactive(true).build();
                        this.context.eval(source);
                        bufferSource = null;
                        console.getHistory().replace(source.getCharacters());
                    }
                    if (switchedLanguage == null) continue;
                    throw new ChangeLanguageException(switchedLanguage);
                }
            }
            catch (EOFException | UserInterruptException e) {
            }
            catch (ChangeLanguageException e) {
                bufferSource = null;
                this.histories.put(currentLanguage, console.getHistory());
                currentLanguage = e.getLanguage() == null ? (Language)languages.get((languages.indexOf(currentLanguage) + 1) % languages.size()) : e.getLanguage();
                History history = this.histories.computeIfAbsent(currentLanguage, k -> new MemoryHistory());
                console.setHistory(history);
                id = currentLanguage.getId();
                prompt = MultiLanguageShell.createPrompt(currentLanguage);
                console.resetPromptLine("", "", 0);
                this.context.initialize(id);
                continue;
            }
            catch (PolyglotException e) {
                bufferSource = null;
                if (e.isInternalError()) {
                    console.println("Internal error occurred: " + e.toString());
                    if (verboseErrors) {
                        e.printStackTrace(new PrintWriter(console.getOutput()));
                        continue;
                    }
                    console.println("Run with --verbose to see the full stack trace.");
                    continue;
                }
                if (e.isExit()) {
                    return e.getExitStatus();
                }
                if (e.isCancelled()) {
                    console.println("Execution got cancelled.");
                    continue;
                }
                if (e.isIncompleteSource()) {
                    bufferSource = source;
                    continue;
                }
                if (e.isSyntaxError()) {
                    console.println(e.getMessage());
                    continue;
                }
                ArrayList<PolyglotException.StackFrame> trace = new ArrayList<PolyglotException.StackFrame>();
                for (PolyglotException.StackFrame stackFrame : e.getPolyglotStackTrace()) {
                    trace.add(stackFrame);
                }
                for (int i = trace.size() - 1; i >= 0 && ((PolyglotException.StackFrame)trace.get(i)).isHostFrame(); --i) {
                    trace.remove(i);
                }
                if (e.isHostException()) {
                    console.println(e.asHostException().toString());
                } else {
                    console.println(e.getMessage());
                }
                if (trace.size() <= 1) continue;
                Iterator iterator = trace.iterator();
                while (true) {
                    PolyglotException.StackFrame stackFrame;
                    if (!iterator.hasNext()) continue block8;
                    stackFrame = (PolyglotException.StackFrame)iterator.next();
                    console.print("        at ");
                    console.println(stackFrame.toString());
                }
            }
            catch (Throwable e) {
                console.println("Internal error occurred: " + e.toString());
                if (verboseErrors) {
                    e.printStackTrace(new PrintWriter(console.getOutput()));
                    continue;
                }
                console.println("Run with --verbose to see the full stack trace.");
                continue;
            }
            break;
        }
        return 0;
    }

    private static void printUsage(ConsoleReader console, StringBuilder promptsString, boolean showCommands) throws IOException {
        if (showCommands) {
            console.println("Commands:");
            console.println("  -usage           to show this list.");
            console.println("  -verboseErrors   to toggle verbose error messages (default off).");
            console.println("  " + promptsString + "    to switch to a language.");
        } else {
            console.println("Usage: ");
            console.println("  Use Ctrl+L to switch language and Ctrl+D to exit.");
            console.println("  Enter -usage to get a list of available commands.");
        }
    }

    private static String createBufferPrompt(String prompt) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < prompt.length() - 2; ++i) {
            b.append(" ");
        }
        return b.append("+ ").toString();
    }

    private static String createPrompt(Language currentLanguage) {
        return String.format("%s> ", currentLanguage.getId());
    }

    private static class ChangeLanguageException
    extends RuntimeException {
        private final Language language;

        ChangeLanguageException(Language language) {
            this.language = language;
        }

        public Language getLanguage() {
            return this.language;
        }

        @Override
        public final Throwable fillInStackTrace() {
            return this;
        }
    }
}

