/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    private static Pattern pattern = Pattern.compile("\\$\\{([^}]+)\\}");

    public static String lineSeparator() {
        String lineSeparator = System.getProperty("line.separator");
        if (lineSeparator == null) {
            lineSeparator = "\n";
        }
        return lineSeparator;
    }

    public static String sanitizeName(String name) {
        if (null == name || name.matches("[\\p{L}\\p{N}_][\\p{L}\\p{N}\\-_./;#:]*")) {
            return name;
        }
        return "_" + name.replaceAll("[^\\p{L}\\p{N}\\-_./;#:]", "_");
    }

    public static String quote(String path) {
        return path.indexOf(32) == -1 ? path : "\"" + path + "\"";
    }

    public static List<File> classPathToFileList(String cp, File root) {
        ArrayList<File> result = new ArrayList<File>();
        if (cp != null && cp.length() > 0) {
            String[] jars;
            for (String jar : jars = cp.split(File.pathSeparator)) {
                File jarFile = new File(jar);
                if (!jarFile.isAbsolute() && root != null) {
                    jarFile = new File(root, jar);
                }
                if (!jarFile.exists()) continue;
                result.add(jarFile);
            }
        }
        return result;
    }

    public static String doSub(String value, Map<String, String> varMap) {
        try {
            Matcher matcher = pattern.matcher(value);
            boolean result = matcher.find();
            if (result) {
                StringBuffer sb = new StringBuffer(value.length() * 2);
                do {
                    String key;
                    String replacement;
                    replacement = (replacement = varMap.get(key = matcher.group(1))) == null ? ((replacement = System.getProperty(key)) != null ? Utils.escapePath(replacement) : "\\$\\{" + key + "\\}") : Utils.escapePath(replacement);
                    matcher.appendReplacement(sb, replacement);
                } while (result = matcher.find());
                matcher.appendTail(sb);
                value = sb.toString();
            }
        }
        catch (Exception ex) {
            Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
        }
        return value;
    }

    public static String escapePath(String path) {
        return path.replace("\\", "\\\\").replace("$", "\\$");
    }

    public static String[] splitOptionsString(String optionString) {
        return optionString.trim().split("\\s+(?=-)");
    }

    public static String concatenate(String[] array) {
        if (array != null) {
            boolean first = true;
            StringBuilder sb = new StringBuilder();
            for (String str : array) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(str);
            }
            return sb.toString();
        }
        return null;
    }
}

