/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.spi.dom.UOException;
import org.netbeans.modules.xml.text.api.dom.SyntaxElement;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.bracematch.XMLBraceMatcher;
import org.netbeans.modules.xml.text.completion.AttributeResultItem;
import org.netbeans.modules.xml.text.completion.ElementResultItem;
import org.netbeans.modules.xml.text.completion.EntityRefResultItem;
import org.netbeans.modules.xml.text.completion.GrammarManager;
import org.netbeans.modules.xml.text.completion.SyntaxQueryHelper;
import org.netbeans.modules.xml.text.completion.ValueResultItem;
import org.netbeans.modules.xml.text.completion.XMLResultItem;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.w3c.dom.Text;

public class XMLCompletionQuery {
    public static final String DOCUMENT_GRAMMAR_BINDING_PROP = "doc-bind-query";
    public static final String TAG_FIRST_CHAR = "<";
    public static final String TAG_LAST_CHAR = ">";
    public static final String END_TAG_PREFIX = "</";
    public static final String END_TAG_SUFFIX = "/>";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<CompletionItem> query(JTextComponent component, int offset, XMLSyntaxSupport sup) {
        BaseDocument doc = (BaseDocument)component.getDocument();
        if (doc == null) {
            return null;
        }
        try {
            SyntaxQueryHelper helper = new SyntaxQueryHelper(sup, offset);
            XMLResultItem.substituteOffset = helper.getOffset() - helper.getEraseCount();
            if (helper.getCompletionType() != 6) {
                ElementResultItem item;
                List<CompletionItem> stlist;
                ArrayList<CompletionItem> all = new ArrayList<CompletionItem>();
                List<CompletionItem> list = null;
                switch (helper.getCompletionType()) {
                    case 1: {
                        list = this.queryAttributes(helper, (Document)doc, sup);
                        break;
                    }
                    case 2: {
                        list = this.queryValues(helper, (Document)doc, sup);
                        break;
                    }
                    case 3: {
                        list = this.queryElements(helper, (Document)doc, sup);
                        break;
                    }
                    case 4: {
                        list = this.queryEntities(helper, (Document)doc, sup);
                        break;
                    }
                    case 5: {
                        list = this.queryNotations(helper, (Document)doc, sup);
                    }
                    case 0: {
                        return null;
                    }
                }
                if (list == null) {
                    return null;
                }
                if (list.isEmpty() && helper.getPreText().startsWith(END_TAG_PREFIX) && (stlist = XMLCompletionQuery.findStartTag(helper.getSyntaxElement(), !helper.getPreText().endsWith("/") ? "/" : "")) != null && !stlist.isEmpty() && !XMLBraceMatcher.hasEndTag((Document)doc, offset, (item = (ElementResultItem)stlist.get(0)).getItemText()) && (!item.getItemText().startsWith("/") || item.getItemText().startsWith(helper.getPreText().substring(1)))) {
                    String string = NbBundle.getMessage(XMLCompletionQuery.class, (String)"MSG_result", (Object)helper.getPreText());
                }
                String debugMsg = Boolean.getBoolean("netbeans.debug.xml") ? " " + helper.getOffset() + "-" + helper.getEraseCount() : "";
                String title = NbBundle.getMessage(XMLCompletionQuery.class, (String)"MSG_result", (Object)helper.getPreText()) + debugMsg;
                all.addAll(list);
                if (all.isEmpty()) return null;
                return all;
            }
            if (helper.getToken().id() == XMLTokenId.PI_CONTENT && !helper.getPreText().endsWith("encoding=")) return null;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public static GrammarQuery getPerformer(Document doc, XMLSyntaxSupport sup) {
        Object grammarBindingObj = doc.getProperty(DOCUMENT_GRAMMAR_BINDING_PROP);
        if (grammarBindingObj == null) {
            grammarBindingObj = new GrammarManager(doc, sup);
            doc.putProperty(DOCUMENT_GRAMMAR_BINDING_PROP, grammarBindingObj);
        }
        return ((GrammarManager)grammarBindingObj).getGrammar();
    }

    private List queryEntities(SyntaxQueryHelper helper, Document doc, XMLSyntaxSupport sup) {
        Enumeration res = XMLCompletionQuery.getPerformer(doc, sup).queryEntities(helper.getContext().getCurrentPrefix());
        return this.translateEntityRefs(res);
    }

    private List queryElements(SyntaxQueryHelper helper, Document doc, XMLSyntaxSupport sup) {
        try {
            GrammarQuery performer = XMLCompletionQuery.getPerformer(doc, sup);
            HintContext ctx = helper.getContext();
            if (helper.getPreText().startsWith(END_TAG_PREFIX)) {
                return Collections.EMPTY_LIST;
            }
            String typedPrefix = ctx.getCurrentPrefix();
            Enumeration res = performer.queryElements(ctx);
            return this.translateElements(res, typedPrefix, performer);
        }
        catch (UOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }

    private List<CompletionItem> queryAttributes(SyntaxQueryHelper helper, Document doc, XMLSyntaxSupport sup) {
        Enumeration res = XMLCompletionQuery.getPerformer(doc, sup).queryAttributes(helper.getContext());
        return this.translateAttributes(res, helper.isBoundary());
    }

    private List<CompletionItem> queryValues(SyntaxQueryHelper helper, Document doc, XMLSyntaxSupport sup) {
        try {
            Enumeration res = XMLCompletionQuery.getPerformer(doc, sup).queryValues(helper.getContext());
            int delLen = 0;
            String suffix = null;
            if (helper.getToken() != null) {
                String tagName;
                if (helper.getToken().id() == XMLTokenId.TEXT) {
                    String c = helper.getToken().text().toString();
                    String p = helper.getPreText();
                    int nlIndex = c.indexOf(10);
                    if (nlIndex > 0) {
                        c = c.substring(0, nlIndex);
                    }
                    delLen = c.length() - p.length();
                    String tagName2 = XMLCompletionQuery.shouldCloseTag(helper, doc, sup);
                    if (tagName2 != null) {
                        suffix = END_TAG_PREFIX + tagName2 + TAG_LAST_CHAR;
                    }
                } else if (helper.getToken().id() == XMLTokenId.VALUE) {
                    int l;
                    String c = helper.getToken().text().toString();
                    delLen = c.length();
                    if (c.charAt(0) == '\"' || c.charAt(0) == '\'') {
                        --delLen;
                    }
                    if (c.charAt(l = c.length() - 1) == '\"' || c.charAt(l) == '\'') {
                        --delLen;
                    }
                } else if (helper.getToken().id() == XMLTokenId.TAG && (tagName = XMLCompletionQuery.shouldCloseTag(helper, doc, sup)) != null) {
                    suffix = END_TAG_PREFIX + tagName + TAG_LAST_CHAR;
                }
            }
            return this.translateValues(res, delLen, suffix);
        }
        catch (Exception ex) {
            Logger.getLogger(XMLCompletionQuery.class.getName()).log(Level.INFO, "cf. #118136", ex);
            return null;
        }
    }

    private List<CompletionItem> queryNotations(SyntaxQueryHelper helper, Document doc, XMLSyntaxSupport sup) {
        Enumeration res = XMLCompletionQuery.getPerformer(doc, sup).queryNotations(helper.getContext().getCurrentPrefix());
        return null;
    }

    private List<CompletionItem> translateEntityRefs(Enumeration refs) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>(133);
        int i = 0;
        while (refs.hasMoreElements()) {
            GrammarResult next = (GrammarResult)refs.nextElement();
            if (next == null || next.getNodeName() == null) continue;
            EntityRefResultItem ref = new EntityRefResultItem(i++, next);
            result.add(ref);
        }
        return result;
    }

    private List<CompletionItem> translateElements(Enumeration els, String prefix, GrammarQuery perfomer) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>(13);
        int i = 0;
        while (els.hasMoreElements()) {
            GrammarResult next = (GrammarResult)els.nextElement();
            if (prefix.equals(next.getNodeName()) || next == null || next.getNodeName() == null) continue;
            ElementResultItem ei = new ElementResultItem(i++, next);
            result.add(ei);
        }
        return result;
    }

    private List<CompletionItem> translateAttributes(Enumeration attrs, boolean boundary) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>(13);
        int i = 0;
        while (attrs.hasMoreElements()) {
            GrammarResult next = (GrammarResult)attrs.nextElement();
            if (next == null || next.getNodeName() == null) continue;
            AttributeResultItem attr = new AttributeResultItem(i++, next, false);
            result.add(attr);
        }
        return result;
    }

    private static String shouldCloseTagLocked(TokenSequence ts) {
        int offset = ts.offset();
        if (!ts.movePrevious()) {
            return null;
        }
        Token previous = ts.token();
        if (previous.id() != XMLTokenId.TAG) {
            return null;
        }
        String tagName = previous.text().toString();
        if (tagName.equals(TAG_LAST_CHAR)) {
            boolean ok;
            while ((ok = ts.movePrevious()) && (previous = ts.token()).id() != XMLTokenId.TAG) {
            }
            if (!ok) {
                return null;
            }
            tagName = previous.text().toString();
        }
        if (tagName.startsWith(END_TAG_PREFIX)) {
            return null;
        }
        if (!tagName.startsWith(TAG_FIRST_CHAR)) {
            return null;
        }
        if (XMLCompletionQuery.isClosingEndTagFoundAfter(offset, ts, tagName = tagName.substring(1, tagName.length()).trim())) {
            return null;
        }
        return tagName;
    }

    static String shouldCloseTag(SyntaxQueryHelper helper, Document doc, XMLSyntaxSupport sup) {
        try {
            return sup.runWithSequence(helper.getOffset(), XMLCompletionQuery::shouldCloseTagLocked);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static boolean isEndTagPrefix(Token token) {
        String tokenText;
        if (token == null) {
            return false;
        }
        TokenId tokenID = token.id();
        return (tokenID.equals(XMLTokenId.TAG) || tokenID.equals(XMLTokenId.TEXT)) && (tokenText = token.text().toString()).startsWith(END_TAG_PREFIX);
    }

    public static boolean isTagFirstChar(Token token) {
        if (token == null) {
            return false;
        }
        TokenId tokenID = token.id();
        if (tokenID.equals(XMLTokenId.TAG) || tokenID.equals(XMLTokenId.TEXT)) {
            String tokenText = token.text().toString();
            if (!XMLCompletionQuery.isEndTagPrefix(token) && tokenText.startsWith(TAG_FIRST_CHAR)) {
                return true;
            }
        }
        return false;
    }

    public static String getTokenTagName(Token token) {
        if (token == null) {
            return null;
        }
        int index = -1;
        if (XMLCompletionQuery.isTagFirstChar(token)) {
            index = TAG_FIRST_CHAR.length();
        } else if (XMLCompletionQuery.isEndTagPrefix(token)) {
            index = END_TAG_PREFIX.length();
        } else {
            return null;
        }
        String tokenText = token.text().toString();
        String tagName = tokenText == null ? null : tokenText.substring(index);
        return tagName;
    }

    private static boolean isClosingEndTagFoundAfter(int caretPos, TokenSequence tokenSequence, String startTagName) {
        if (tokenSequence == null || startTagName == null) {
            return false;
        }
        tokenSequence.move(caretPos);
        int unclosedTagCount = 1;
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            String nextTagName = XMLCompletionQuery.getTokenTagName(token);
            if (XMLCompletionQuery.isEndTagPrefix(token)) {
                if (unclosedTagCount-- == 0) {
                    return false;
                }
            } else {
                if (!XMLCompletionQuery.isTagFirstChar(token)) continue;
                ++unclosedTagCount;
            }
            if (unclosedTagCount != 0 || !XMLCompletionQuery.isEndTagPrefix(token)) continue;
            return startTagName.equals(nextTagName);
        }
        return false;
    }

    private List<CompletionItem> translateValues(Enumeration values, int delLen, String suffix) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>(3);
        int i = 0;
        while (values.hasMoreElements()) {
            GrammarResult next = (GrammarResult)values.nextElement();
            int dl = delLen;
            if (next instanceof Text && (dl = ((Text)next).getLength()) < 0) {
                dl = delLen;
            }
            if (next == null || next.getDisplayName() == null) continue;
            ValueResultItem val = new ValueResultItem(i++, next, dl, suffix);
            result.add(val);
        }
        return result;
    }

    private static List<CompletionItem> findStartTag(SyntaxElement text, String prefix) {
        SyntaxElement parentEl = text.getParentElement();
        if (parentEl == null) {
            return Collections.EMPTY_LIST;
        }
        Object parent = parentEl.getNode();
        if (parent == null) {
            return Collections.EMPTY_LIST;
        }
        String name = parent.getNodeName();
        if (name == null) {
            return Collections.EMPTY_LIST;
        }
        ElementResultItem res = new ElementResultItem(0, prefix + name);
        ArrayList<CompletionItem> list = new ArrayList<CompletionItem>(1);
        list.add(res);
        return list;
    }

    private static List<CompletionItem> findStartTag(SyntaxElement text) {
        return XMLCompletionQuery.findStartTag(text, "");
    }
}

