/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative.conditionapi;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.hints.declarative.conditionapi.Context;
import org.netbeans.modules.java.hints.declarative.conditionapi.Matcher;
import org.netbeans.modules.java.hints.declarative.conditionapi.Variable;

public final class DefaultRuleUtilities {
    private final Context context;
    private final Matcher matcher;

    DefaultRuleUtilities(Context context, Matcher matcher) {
        this.context = context;
        this.matcher = matcher;
    }

    public boolean referencedIn(Variable variable, Variable in) {
        return this.matcher.referencedIn(variable, in);
    }

    public boolean sourceVersionGE(SourceVersion source) {
        return this.context.sourceVersion().compareTo(source) >= 0;
    }

    public boolean hasModifier(Variable variable, Modifier modifier) {
        return this.context.modifiers(variable).contains((Object)modifier);
    }

    public boolean parentMatches(String pattern) {
        Variable parent = this.context.parent(this.context.variableForName("$_"));
        if (parent == null) {
            return false;
        }
        return this.matcher.matchesAny(parent, pattern);
    }

    public boolean elementKindMatches(Variable variable, ElementKind ... kind) {
        EnumSet<ElementKind> kinds = EnumSet.noneOf(ElementKind.class);
        kinds.addAll(Arrays.asList(kind));
        return kinds.contains((Object)this.context.elementKind(variable));
    }

    public boolean isNullLiteral(@NonNull Variable var) {
        return this.context.isNullLiteral(var);
    }

    public boolean matches(String pattern) {
        Variable current = this.context.variableForName("$_");
        assert (current != null);
        return this.matchesAny(current, pattern);
    }

    public boolean matchesWithBind(Variable var, String pattern) {
        return this.matcher.matchesWithBind(var, pattern);
    }

    public boolean matchesAny(Variable var, String ... patterns) {
        return this.matcher.matchesAny(var, patterns);
    }

    public boolean containsAny(Variable var, String ... patterns) {
        return this.matcher.containsAny(var, patterns);
    }

    public boolean inClass(String ... className) {
        Pattern p = DefaultRuleUtilities.constructRegexp(className);
        Variable current = this.context.variableForName("$_");
        assert (current != null);
        for (String string : this.context.enclosingClasses(current)) {
            if (!p.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean inPackage(String ... packageName) {
        Pattern p = DefaultRuleUtilities.constructRegexp(packageName);
        return p.matcher(this.context.enclosingPackage()).matches();
    }

    private static Pattern constructRegexp(String[] pattern) {
        StringBuilder regexp = new StringBuilder();
        boolean first = true;
        for (String p : pattern) {
            if (first) {
                regexp.append("|");
            }
            regexp.append("(");
            regexp.append(Pattern.quote(p));
            regexp.append(")");
            first = false;
        }
        Pattern p = Pattern.compile(regexp.toString());
        return p;
    }

    public boolean isAvailable(@NonNull String elementDescription) {
        return this.context.isAvailable(elementDescription);
    }
}

