/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco;

import io.foojay.api.discoclient.pkg.ArchiveType;
import io.foojay.api.discoclient.pkg.Distribution;
import io.foojay.api.discoclient.pkg.PackageType;
import io.foojay.api.discoclient.pkg.Pkg;
import io.foojay.api.discoclient.pkg.ReleaseStatus;
import io.foojay.api.discoclient.pkg.VersionNumber;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BundleTableModel
extends AbstractTableModel {
    private String[] columnNames = new String[]{"Version", "Distribution", "Architecture", "Bundle Type", "Release Status", "Extension"};
    private List<Pkg> bundles;

    public BundleTableModel(List<Pkg> bundles) {
        this.bundles = bundles;
    }

    public List<Pkg> getBundles() {
        return this.bundles;
    }

    public void setBundles(List<Pkg> bundles) {
        this.bundles = bundles;
        this.fireTableDataChanged();
    }

    @Override
    public @NonNull String getColumnName(int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.columnNames[col];
            }
        }
        throw new IllegalArgumentException("Column not found " + col);
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return VersionNumber.class;
            }
            case 1: {
                return Distribution.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return PackageType.class;
            }
            case 4: {
                return ReleaseStatus.class;
            }
            case 5: {
                return ArchiveType.class;
            }
        }
        return super.getColumnClass(col);
    }

    @Override
    public int getRowCount() {
        if (null == this.bundles) {
            return 0;
        }
        return this.bundles.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public @NonNull Object getValueAt(@NonNegative int row, @NonNegative int col) {
        if (row < 0 || row >= this.getRowCount()) {
            throw new IllegalArgumentException("Row not found " + row);
        }
        Pkg bundle = this.bundles.get(row);
        switch (col) {
            case 0: {
                return bundle.getDistributionVersion();
            }
            case 1: {
                return bundle.getDistribution().getUiString();
            }
            case 2: {
                return bundle.getArchitecture().getUiString();
            }
            case 3: {
                return bundle.getPackageType().getUiString();
            }
            case 4: {
                return bundle.getReleaseStatus().name();
            }
            case 5: {
                return bundle.getArchiveType().getUiString();
            }
        }
        throw new IllegalArgumentException("Column not found " + col);
    }
}

