/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.branding;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.spi.BrandingModel;
import org.netbeans.modules.apisupport.project.spi.BrandingSupport;
import org.netbeans.modules.apisupport.project.ui.branding.AbstractBrandingPanel;
import org.netbeans.modules.apisupport.project.ui.branding.BasicBrandingPanel;
import org.netbeans.modules.apisupport.project.ui.branding.DragManager;
import org.netbeans.modules.apisupport.project.ui.branding.SplashComponentPreview;
import org.netbeans.modules.apisupport.project.ui.branding.SplashUISupport;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class SplashBrandingPanel
extends AbstractBrandingPanel {
    @NonNull
    private final SplashComponentPreview splashImage = new SplashComponentPreview();
    @NonNull
    private final JFormattedTextField fontSize = SplashUISupport.getIntegerField();
    @NonNull
    private final JFormattedTextField runningTextBounds = SplashUISupport.getBoundsField();
    @NonNull
    private final JFormattedTextField progressBarBounds = SplashUISupport.getBoundsField();
    @NonNull
    private final SplashUISupport.ColorComboBox textColor = SplashUISupport.getColorComboBox();
    @NonNull
    private final SplashUISupport.ColorComboBox barColor = SplashUISupport.getColorComboBox();
    @NonNull
    private final SplashUISupport.ColorComboBox edgeColor = SplashUISupport.getColorComboBox();
    @NonNull
    private final SplashUISupport.ColorComboBox cornerColor = SplashUISupport.getColorComboBox();
    private URL splashSource;
    private JLabel barBoundsLabel;
    private JLabel barColorLabel;
    private JButton browse;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JCheckBox progressBarEnabled;
    private JLabel splashLabel;
    private JLabel splashPreview;
    private JLabel textBoundsLabel;
    private JLabel textColorLabel;
    private JLabel textFontSizeLabel;

    public SplashBrandingPanel(BrandingModel model) {
        super(NbBundle.getMessage(BasicBrandingPanel.class, (String)"LBL_SplashTab"), model);
        this.splashImage.setDropHandletForProgress(new DragManager.DropHandler(){

            @Override
            public void dragAccepted(Rectangle original, Rectangle afterDrag) {
                SplashBrandingPanel.this.progressBarBounds.setValue(afterDrag);
                SplashBrandingPanel.this.setModified();
            }
        });
        this.splashImage.setDropHandletForText(new DragManager.DropHandler(){

            @Override
            public void dragAccepted(Rectangle original, Rectangle afterDrag) {
                SplashBrandingPanel.this.runningTextBounds.setValue(afterDrag);
                double ratio = (double)afterDrag.height / (double)original.height;
                int size = (int)((double)((Number)SplashBrandingPanel.this.fontSize.getValue()).intValue() * ratio);
                size = size > 0 ? size : 3;
                SplashBrandingPanel.this.fontSize.setValue(size);
                SplashBrandingPanel.this.setModified();
            }
        });
        this.initComponents();
        this.refresh();
        this.enableDisableComponents();
        PropertyChangeListener pL = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() != "color") {
                    return;
                }
                SplashBrandingPanel.this.setModified();
                SplashBrandingPanel.this.resetSplashPreview();
            }
        };
        this.textColor.addPropertyChangeListener(pL);
        this.barColor.addPropertyChangeListener(pL);
        this.edgeColor.addPropertyChangeListener(pL);
        this.cornerColor.addPropertyChangeListener(pL);
        this.fontSize.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (e != null || SplashBrandingPanel.this.fontSize.isFocusOwner()) {
                    try {
                        SplashBrandingPanel.this.fontSize.commitEdit();
                        ((Number)SplashBrandingPanel.this.fontSize.getValue()).intValue();
                        SplashBrandingPanel.this.setErrorMessage(null);
                        SplashBrandingPanel.this.setValid(true);
                        SplashBrandingPanel.this.resetSplashPreview();
                    }
                    catch (ParseException ex) {
                        SplashBrandingPanel.this.setErrorMessage(NbBundle.getMessage(SplashBrandingPanel.class, (String)"ERR_InvalidFontSize"));
                        SplashBrandingPanel.this.setValid(false);
                    }
                    SplashBrandingPanel.this.setModified();
                }
            }
        });
        this.runningTextBounds.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (e != null || SplashBrandingPanel.this.runningTextBounds.isFocusOwner()) {
                    try {
                        SplashBrandingPanel.this.runningTextBounds.commitEdit();
                        SplashBrandingPanel.this.setErrorMessage(null);
                        SplashBrandingPanel.this.setValid(true);
                        SplashBrandingPanel.this.resetSplashPreview();
                    }
                    catch (ParseException ex) {
                        SplashBrandingPanel.this.setErrorMessage(NbBundle.getMessage(SplashBrandingPanel.class, (String)"ERR_InvalidTextBounds"));
                        SplashBrandingPanel.this.setValid(false);
                    }
                    SplashBrandingPanel.this.setModified();
                }
            }
        });
        this.progressBarBounds.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (e != null || SplashBrandingPanel.this.progressBarBounds.isFocusOwner()) {
                    try {
                        SplashBrandingPanel.this.progressBarBounds.commitEdit();
                        SplashBrandingPanel.this.setErrorMessage(null);
                        SplashBrandingPanel.this.setValid(true);
                        SplashBrandingPanel.this.resetSplashPreview();
                    }
                    catch (ParseException ex) {
                        SplashBrandingPanel.this.setErrorMessage(NbBundle.getMessage(SplashBrandingPanel.class, (String)"ERR_InvalidProgressBarBounds"));
                        SplashBrandingPanel.this.setValid(false);
                    }
                    SplashBrandingPanel.this.setModified();
                }
            }
        });
    }

    @Override
    public void store() {
        Image image;
        BrandingModel branding = this.getBranding();
        SplashUISupport.setValue(branding.getSplashRunningTextFontSize(), SplashUISupport.numberToString((Number)this.fontSize.getValue()));
        SplashUISupport.setValue(branding.getSplashRunningTextBounds(), SplashUISupport.boundsToString((Rectangle)this.runningTextBounds.getValue()));
        SplashUISupport.setValue(branding.getSplashProgressBarBounds(), SplashUISupport.boundsToString((Rectangle)this.progressBarBounds.getValue()));
        if (this.textColor.getColor() != null) {
            SplashUISupport.setValue(branding.getSplashRunningTextColor(), SplashUISupport.colorToString(this.textColor.getColor()));
        }
        if (this.barColor.getColor() != null) {
            SplashUISupport.setValue(branding.getSplashProgressBarColor(), SplashUISupport.colorToString(this.barColor.getColor()));
        }
        SplashUISupport.setValue(branding.getSplashShowProgressBar(), Boolean.toString(this.progressBarEnabled.isSelected()));
        BrandingSupport.BrandedFile splash = branding.getSplash();
        if (splash != null) {
            splash.setBrandingSource(this.splashSource);
        }
        if ((image = this.splashImage.image) != null) {
            SplashUISupport.setValue(branding.getSplashWidth(), Integer.toString(image.getWidth(null), 10));
            SplashUISupport.setValue(branding.getSplashHeight(), Integer.toString(image.getHeight(null), 10));
        }
    }

    void refresh() {
        BrandingModel branding = this.getBranding();
        this.fontSize.setValue(SplashUISupport.bundleKeyToInteger(branding.getSplashRunningTextFontSize()));
        this.runningTextBounds.setValue(SplashUISupport.bundleKeyToBounds(branding.getSplashRunningTextBounds()));
        this.progressBarBounds.setValue(SplashUISupport.bundleKeyToBounds(branding.getSplashProgressBarBounds()));
        this.textColor.setColor(SplashUISupport.bundleKeyToColor(branding.getSplashRunningTextColor()));
        this.barColor.setColor(SplashUISupport.bundleKeyToColor(branding.getSplashProgressBarColor()));
        this.edgeColor.setColor(SplashUISupport.bundleKeyToColor(branding.getSplashProgressBarEdgeColor()));
        this.cornerColor.setColor(SplashUISupport.bundleKeyToColor(branding.getSplashProgressBarCornerColor()));
        this.progressBarEnabled.setSelected(SplashUISupport.bundleKeyToBoolean(branding.getSplashShowProgressBar()));
        BrandingSupport.BrandedFile splash = branding.getSplash();
        this.splashSource = splash != null ? splash.getBrandingSource() : null;
        this.resetSplashPreview();
        this.splashImage.setMaxSteps(10);
        this.splashImage.resetSteps();
        this.splashImage.setText(NbBundle.getMessage(this.getClass(), (String)"TEXT_SplashSample"));
        this.enableDisableComponents();
    }

    private void enableDisableComponents() {
        BrandingModel branding = this.getBranding();
        this.jLabel1.setEnabled(branding.isBrandingEnabled());
        this.jLabel2.setEnabled(branding.isBrandingEnabled());
        this.fontSize.setEnabled(branding.isBrandingEnabled());
        this.runningTextBounds.setEnabled(branding.isBrandingEnabled());
        this.progressBarBounds.setEnabled(branding.isBrandingEnabled());
        this.textColor.setEnabled(branding.isBrandingEnabled());
        this.barColor.setEnabled(branding.isBrandingEnabled());
        this.edgeColor.setEnabled(branding.isBrandingEnabled());
        this.cornerColor.setEnabled(branding.isBrandingEnabled());
        this.progressBarEnabled.setEnabled(branding.isBrandingEnabled());
        this.splashImage.setEnabled(branding.isBrandingEnabled());
        this.barBoundsLabel.setEnabled(branding.isBrandingEnabled());
        this.barColorLabel.setEnabled(branding.isBrandingEnabled());
        this.browse.setEnabled(branding.isBrandingEnabled());
        this.splashLabel.setEnabled(branding.isBrandingEnabled());
        this.splashPreview.setEnabled(branding.isBrandingEnabled());
        this.textBoundsLabel.setEnabled(branding.isBrandingEnabled());
        this.textColorLabel.setEnabled(branding.isBrandingEnabled());
        this.textFontSizeLabel.setEnabled(branding.isBrandingEnabled());
        this.splashImage.setEnabled(branding.isBrandingEnabled());
    }

    private void resetSplashPreview() throws NumberFormatException {
        Image oldImage = this.splashImage.image;
        if (null != oldImage) {
            oldImage.flush();
        }
        this.splashImage.setSplashImageIcon(this.splashSource);
        Rectangle tRectangle = (Rectangle)this.runningTextBounds.getValue();
        Rectangle pRectangle = (Rectangle)this.progressBarBounds.getValue();
        this.splashImage.setTextColor(this.textColor.getColor());
        this.splashImage.setColorBar(this.barColor.getColor());
        this.splashImage.setColorEdge(this.edgeColor.getColor());
        this.splashImage.setColorEdge(this.cornerColor.getColor());
        this.splashImage.setFontSize(((Number)this.fontSize.getValue()).intValue());
        this.splashImage.setRunningTextBounds(tRectangle);
        this.splashImage.setProgressBarBounds(pRectangle);
        this.splashImage.setProgressBarEnabled(this.progressBarEnabled.isSelected());
        this.splashImage.resetSteps();
        this.splashImage.setText(NbBundle.getMessage(this.getClass(), (String)"TEXT_SplashSample"));
    }

    private void initComponents() {
        SplashUISupport.ColorComboBox barColor = this.barColor;
        JFormattedTextField jTextField1 = this.progressBarBounds;
        this.barColorLabel = new JLabel();
        this.barBoundsLabel = new JLabel();
        this.textColorLabel = new JLabel();
        SplashUISupport.ColorComboBox textColor = this.textColor;
        JFormattedTextField jTextField4 = this.runningTextBounds;
        JFormattedTextField fontSize = this.fontSize;
        this.progressBarEnabled = new JCheckBox();
        this.textFontSizeLabel = new JLabel();
        this.textBoundsLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.splashLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.splashPreview = this.splashImage;
        this.browse = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)barColor, gridBagConstraints);
        jTextField1.setInputVerifier(jTextField1.getInputVerifier());
        jTextField1.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)jTextField1, gridBagConstraints);
        this.barColorLabel.setLabelFor(barColor);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/branding/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.barColorLabel, (String)bundle.getString("LBL_BarColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.barColorLabel, gridBagConstraints);
        this.barColorLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_BarColor"));
        this.barBoundsLabel.setLabelFor(jTextField1);
        Mnemonics.setLocalizedText((JLabel)this.barBoundsLabel, (String)bundle.getString("LBL_BarBounds"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.barBoundsLabel, gridBagConstraints);
        this.barBoundsLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_BarBounds"));
        this.textColorLabel.setLabelFor(textColor);
        Mnemonics.setLocalizedText((JLabel)this.textColorLabel, (String)bundle.getString("LBL_TextColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.textColorLabel, gridBagConstraints);
        this.textColorLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TextColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)textColor, gridBagConstraints);
        jTextField4.setInputVerifier(jTextField1.getInputVerifier());
        jTextField4.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)jTextField4, gridBagConstraints);
        fontSize.setInputVerifier(jTextField1.getInputVerifier());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)fontSize, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.progressBarEnabled, (String)bundle.getString("LBL_ProgressBarEnabled"));
        this.progressBarEnabled.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.progressBarEnabled.setMargin(new Insets(0, 0, 0, 0));
        this.progressBarEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SplashBrandingPanel.this.progressBarEnabledActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 1, 0, 12);
        this.add((Component)this.progressBarEnabled, gridBagConstraints);
        this.progressBarEnabled.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ProgressEnabled"));
        this.textFontSizeLabel.setLabelFor(fontSize);
        Mnemonics.setLocalizedText((JLabel)this.textFontSizeLabel, (String)bundle.getString("LBL_TextFontSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.textFontSizeLabel, gridBagConstraints);
        this.textFontSizeLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_FontSize"));
        this.textBoundsLabel.setLabelFor(jTextField4);
        Mnemonics.setLocalizedText((JLabel)this.textBoundsLabel, (String)bundle.getString("LBL_TextBounds"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.textBoundsLabel, gridBagConstraints);
        this.textBoundsLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TextBounds"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)bundle.getString("LBL_ProgressBar"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)bundle.getString("LBL_RunningText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.splashLabel, (String)bundle.getString("LBL_Splash"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.jPanel1.add((Component)this.splashLabel, gridBagConstraints);
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setViewportView(this.splashPreview);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browse, (String)bundle.getString("LBL_Browse"));
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SplashBrandingPanel.this.browseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.browse, gridBagConstraints);
        this.browse.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_SplashBrowse"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void browseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = UIUtil.getIconFileChooser();
        int ret = chooser.showDialog(this, NbBundle.getMessage(this.getClass(), (String)"LBL_Select"));
        if (ret == 0) {
            File file = chooser.getSelectedFile();
            try {
                this.splashSource = Utilities.toURI((File)file).toURL();
                Image oldImage = this.splashImage.image;
                this.splashImage.setSplashImageIcon(this.splashSource);
                Image newImage = this.splashImage.image;
                assert (newImage != null);
                int newWidth = newImage.getWidth(null);
                int newHeight = newImage.getHeight(null);
                if (oldImage != null) {
                    oldImage.flush();
                    int oldWidth = oldImage.getWidth(null);
                    int oldHeight = oldImage.getHeight(null);
                    if (newWidth != oldWidth || newHeight != oldHeight) {
                        double xRatio = (double)newWidth / (double)oldWidth;
                        double yRatio = (double)newHeight / (double)oldHeight;
                        Rectangle tRectangle = (Rectangle)this.runningTextBounds.getValue();
                        Rectangle pRectangle = (Rectangle)this.progressBarBounds.getValue();
                        int x = (int)((double)tRectangle.x * xRatio);
                        int y = (int)((double)tRectangle.y * yRatio);
                        int width = (int)((double)tRectangle.width * xRatio);
                        int height = (int)((double)tRectangle.height * xRatio);
                        width = width <= 0 ? 2 : width;
                        height = height <= 0 ? 2 : height;
                        tRectangle.setBounds(x, y, width, height);
                        x = (int)((double)pRectangle.x * xRatio);
                        y = (int)((double)pRectangle.y * yRatio);
                        width = (int)((double)pRectangle.width * xRatio);
                        height = (int)((double)pRectangle.height * xRatio);
                        width = width <= 6 ? 6 : width;
                        height = height <= 6 ? 6 : height;
                        pRectangle.setBounds(x, y, width, height);
                        this.runningTextBounds.setValue(tRectangle);
                        this.progressBarBounds.setValue(pRectangle);
                        int size = (int)((double)((Number)this.fontSize.getValue()).intValue() * yRatio);
                        size = size <= 6 ? 6 : size;
                        this.fontSize.setValue(size);
                    } else {
                        this.resetSplashPreview();
                    }
                } else {
                    this.resetSplashPreview();
                }
                this.setModified();
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    private void progressBarEnabledActionPerformed(ActionEvent evt) {
        this.resetSplashPreview();
    }
}

