/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.ActionProviderImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.execute.navigator.Bundle;
import org.netbeans.modules.maven.execute.navigator.TapPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class GoalsPanel
extends JPanel
implements ExplorerManager.Provider,
Runnable {
    private static final String LIFECYCLE_ICON = "org/netbeans/modules/maven/execute/navigator/thread_running_16.png";
    private static final String HELP_ICON = "org/netbeans/modules/maven/execute/navigator/help.png";
    private static final String PROP_SHOW_LIFECYCLE_GOALS = "showLifecycleGoals";
    private static final String PROP_SHOW_HELP_GOALS = "showHelpGoals";
    private static final Logger LOG = Logger.getLogger(GoalsPanel.class.getName());
    private final transient ExplorerManager explorerManager = new ExplorerManager();
    private final BeanTreeView treeView;
    private final Object PROJECT_LOCK = new Object();
    private NbMavenProject current;
    private Project currentP;
    private final TapPanel filtersPanel;
    private final Preferences preferences;
    private final PropertyChangeListener pchadapter = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                GoalsPanel.this.showWaitNode();
                RequestProcessor.getDefault().post((Runnable)GoalsPanel.this);
            }
        }
    };
    private JScrollPane jScrollPane1;
    private static final String WAIT_GIF = "org/netbeans/modules/maven/resources/wait.gif";

    public GoalsPanel() {
        this.initComponents();
        this.treeView = (BeanTreeView)this.jScrollPane1;
        this.preferences = NbPreferences.forModule(GoalsPanel.class).node("goalNavigator");
        this.filtersPanel = new TapPanel();
        this.filtersPanel.setOrientation(2);
        KeyStroke toggleKey = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        String keyText = Utilities.keyToString((KeyStroke)toggleKey);
        this.filtersPanel.setToolTipText(Bundle.HINT_Panel_hide(keyText));
        JComponent buttons = this.createFilterButtons();
        buttons.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        this.filtersPanel.add(buttons);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.filtersPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.add((Component)this.filtersPanel, "South");
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void navigate(DataObject d) {
        Object object = this.PROJECT_LOCK;
        synchronized (object) {
            if (this.current != null) {
                this.current.removePropertyChangeListener(this.pchadapter);
            }
        }
        NbMavenProject n = null;
        FileObject f = d.getPrimaryFile();
        if (!f.isFolder()) {
            f = f.getParent();
        }
        Project p = null;
        try {
            p = ProjectManager.getDefault().findProject(f);
            if (p != null) {
                n = (NbMavenProject)p.getLookup().lookup(NbMavenProject.class);
            }
        }
        catch (IOException iOException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (n == null) {
            this.release();
            return;
        }
        Object object2 = this.PROJECT_LOCK;
        synchronized (object2) {
            this.current = n;
            this.currentP = p;
            this.current.addPropertyChangeListener(this.pchadapter);
        }
        this.showWaitNode();
        RequestProcessor.getDefault().post((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NbMavenProject mpp;
        Project cp;
        Object object = this.PROJECT_LOCK;
        synchronized (object) {
            cp = this.currentP;
        }
        if (cp != null && (mpp = (NbMavenProject)cp.getLookup().lookup(NbMavenProject.class)) != null) {
            final Children ch = Children.create((ChildFactory)new PluginChildren(cp), (boolean)true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GoalsPanel.this.treeView.setRootVisible(false);
                    GoalsPanel.this.explorerManager.setRootContext((Node)new AbstractNode(ch));
                    GoalsPanel.this.treeView.expandAll();
                }
            });
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GoalsPanel.this.treeView.setRootVisible(false);
                GoalsPanel.this.explorerManager.setRootContext(GoalsPanel.createEmptyNode());
                GoalsPanel.this.treeView.expandAll();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        Object object = this.PROJECT_LOCK;
        synchronized (object) {
            if (this.current != null) {
                this.current.removePropertyChangeListener(this.pchadapter);
            }
            this.current = null;
            this.currentP = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GoalsPanel.this.treeView.setRootVisible(false);
                GoalsPanel.this.explorerManager.setRootContext(GoalsPanel.createEmptyNode());
                GoalsPanel.this.treeView.expandAll();
            }
        });
    }

    public void showWaitNode() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GoalsPanel.this.treeView.setRootVisible(true);
                GoalsPanel.this.explorerManager.setRootContext(GoalsPanel.createWaitNode());
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new BeanTreeView();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jScrollPane1, "Center");
    }

    private static Node createWaitNode() {
        AbstractNode an = new AbstractNode(Children.LEAF);
        an.setIconBaseWithExtension(WAIT_GIF);
        an.setDisplayName(Bundle.LBL_Wait());
        return an;
    }

    private static Node createEmptyNode() {
        AbstractNode an = new AbstractNode(Children.LEAF);
        return an;
    }

    private JComponent createFilterButtons() {
        Box box = new Box(0);
        box.setBorder(new EmptyBorder(1, 2, 3, 5));
        JToolBar toolbar = new JToolBar(0){

            @Override
            protected void paintComponent(Graphics g) {
            }
        };
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.setBorderPainted(false);
        toolbar.setBorder(BorderFactory.createEmptyBorder());
        toolbar.setOpaque(false);
        toolbar.setFocusable(false);
        final JToggleButton tg1 = new JToggleButton();
        tg1.setIcon(ImageUtilities.loadImageIcon((String)HELP_ICON, (boolean)true));
        tg1.setToolTipText(Bundle.LBL_Show_Help());
        tg1.setSelected(this.preferences.getBoolean(PROP_SHOW_HELP_GOALS, false));
        tg1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GoalsPanel.this.preferences.putBoolean(GoalsPanel.PROP_SHOW_HELP_GOALS, tg1.isSelected());
            }
        });
        toolbar.add(tg1);
        final JToggleButton tg2 = new JToggleButton();
        tg2.setIcon(ImageUtilities.loadImageIcon((String)LIFECYCLE_ICON, (boolean)true));
        tg2.setToolTipText(Bundle.LBL_Show_Lifecycle());
        tg2.setSelected(this.preferences.getBoolean(PROP_SHOW_LIFECYCLE_GOALS, false));
        tg2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GoalsPanel.this.preferences.putBoolean(GoalsPanel.PROP_SHOW_LIFECYCLE_GOALS, tg2.isSelected());
            }
        });
        toolbar.add(tg2);
        Dimension space = new Dimension(3, 0);
        toolbar.addSeparator(space);
        box.add(toolbar);
        return box;
    }

    @CheckForNull
    private static Document loadPluginXml(File jar) {
        if (!jar.isFile() || !jar.getName().endsWith(".jar")) {
            return null;
        }
        LOG.log(Level.FINER, "parsing plugin.xml from {0}", jar);
        try {
            return XMLUtil.parse((InputSource)new InputSource("jar:" + Utilities.toURI((File)jar) + "!/META-INF/maven/plugin.xml"), (boolean)false, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
        }
        catch (Exception x) {
            LOG.log(Level.FINE, "could not parse " + jar, x.toString());
            return null;
        }
    }

    private static class RunGoalAction
    extends AbstractAction {
        private final Mojo mojo;
        private final Project project;

        public RunGoalAction(Mojo mojo, Project prj) {
            this.mojo = mojo;
            this.project = prj;
            this.putValue("Name", Bundle.ACT_Execute());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RunConfig config = RunUtils.createRunConfig(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), this.project, this.mojo.prefix + ":" + this.mojo.goal, Collections.singletonList(this.mojo.a.getGroupId() + ":" + this.mojo.a.getArtifactId() + ":" + this.mojo.a.getVersion() + ":" + this.mojo.goal));
            M2ConfigProvider prof = (M2ConfigProvider)this.project.getLookup().lookup(M2ConfigProvider.class);
            M2Configuration m2c = prof.getActiveConfiguration();
            if (m2c != null) {
                config.addProperties(m2c.getProperties());
                config.setActivatedProfiles(m2c.getActivatedProfiles());
            }
            RunUtils.run(config);
        }
    }

    private static class MojoNode
    extends AbstractNode {
        private final Mojo mojo;
        private final Project project;

        private MojoNode(@NonNull Mojo mojo, Project p) {
            super(Children.LEAF);
            this.setDisplayName(mojo.goal);
            this.setShortDescription("<html>Plugin:" + mojo.a.getId() + "<br/>Goal:" + mojo.goal + "<br/>Prefix:" + mojo.prefix + (mojo.lifecycleBound ? "<br/>Bound to lifecycle in current POM." : ""));
            this.mojo = mojo;
            this.project = p;
        }

        public Action[] getActions(boolean context) {
            NetbeansActionMapping mapp = new NetbeansActionMapping();
            for (Param p : this.mojo.getNotSetParams()) {
                if (p.property == null) continue;
                mapp.addProperty(p.property, "");
            }
            mapp.setGoals(Collections.singletonList(this.mojo.a.getGroupId() + ":" + this.mojo.a.getArtifactId() + ":" + this.mojo.a.getVersion() + ":" + this.mojo.goal));
            Action runGoalWithModsAction = ActionProviderImpl.createCustomMavenAction(this.mojo.prefix + ":" + this.mojo.goal, mapp, true, Lookup.EMPTY, this.project);
            runGoalWithModsAction.putValue("Name", Bundle.ACT_Execute_mod());
            NetbeansActionMapping mappForHelpDesc = new NetbeansActionMapping();
            mappForHelpDesc.setGoals(Collections.singletonList("help:describe"));
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("cmd", String.format("%s:%s:%s:%s", this.mojo.a.getGroupId(), this.mojo.a.getArtifactId(), this.mojo.a.getVersion(), this.mojo.goal));
            m.put("detail", "true");
            mappForHelpDesc.setProperties(m);
            Action runHelpDescAction = ActionProviderImpl.createCustomMavenAction(String.format("help:describe for %s:%s", this.mojo.prefix, this.mojo.goal), mappForHelpDesc, false, Lookup.EMPTY, this.project);
            runHelpDescAction.putValue("Name", Bundle.ACT_Execute_help());
            return new Action[]{new RunGoalAction(this.mojo, this.project), runGoalWithModsAction, null, runHelpDescAction};
        }

        public String getHtmlDisplayName() {
            return "<html>" + this.mojo.prefix + " <b>" + this.mojo.goal + "</b></html>";
        }

        public Action getPreferredAction() {
            return new RunGoalAction(this.mojo, this.project);
        }

        public Image getIcon(int type) {
            if ("help".equals(this.mojo.goal)) {
                return ImageUtilities.loadImage((String)GoalsPanel.HELP_ICON);
            }
            if (this.mojo.lifecycleBound) {
                return ImageUtilities.loadImage((String)GoalsPanel.LIFECYCLE_ICON);
            }
            return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/execute/ui/mojo.png");
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }
    }

    private static final class Param {
        final String parameterName;
        final boolean required;
        String property;
        String defValue;
        boolean parameterInModel = false;
        boolean propertyInModel = false;

        public Param(String parameterName, boolean required) {
            this.parameterName = parameterName;
            this.required = required;
        }
    }

    private static class Mojo
    implements Comparable<Mojo> {
        final Artifact a;
        final String goal;
        final String prefix;
        final List<Param> parameters;
        final boolean lifecycleBound;

        public Mojo(String prefix, String goal, Artifact a, List<Param> parameters, boolean lifecycleBound) {
            this.a = a;
            this.goal = goal;
            this.prefix = prefix;
            this.parameters = parameters;
            this.lifecycleBound = lifecycleBound;
        }

        List<Param> getNotSetParams() {
            ArrayList<Param> toRet = new ArrayList<Param>();
            for (Param p : this.parameters) {
                if (!p.required || p.parameterInModel || p.property != null && p.propertyInModel) continue;
                toRet.add(p);
            }
            return toRet;
        }

        @Override
        public int compareTo(Mojo o) {
            int res = this.prefix.compareTo(o.prefix);
            if (res == 0) {
                res = this.goal.compareTo(o.goal);
            }
            return res;
        }

        public int hashCode() {
            int hash = 3;
            hash = 17 * hash + (this.goal != null ? this.goal.hashCode() : 0);
            hash = 17 * hash + (this.prefix != null ? this.prefix.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Mojo other = (Mojo)obj;
            if (this.goal == null ? other.goal != null : !this.goal.equals(other.goal)) {
                return false;
            }
            return !(this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix));
        }
    }

    private class PluginChildren
    extends ChildFactory<Mojo>
    implements PreferenceChangeListener {
        private final Project prj;

        PluginChildren(Project prj) {
            this.prj = prj;
            GoalsPanel.this.preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)GoalsPanel.this.preferences));
        }

        protected boolean createKeys(List<Mojo> toPopulate) {
            NbMavenProject nbmp = (NbMavenProject)this.prj.getLookup().lookup(NbMavenProject.class);
            assert (nbmp != null) : "Project " + this.prj + " has no NbMavenProject in lookup.";
            if (nbmp == null) {
                LOG.log(Level.WARNING, "Project {0} has no NbMavenProject in lookup.", this.prj);
                return true;
            }
            MavenProject mp = nbmp.getMavenProject();
            if (mp == null) {
                LOG.log(Level.WARNING, "Project {0} has no MavenProject.", this.prj);
                return true;
            }
            Set artifacts = mp.getPluginArtifacts();
            if (artifacts == null || artifacts.isEmpty()) {
                LOG.log(Level.FINE, "Project {0} returns {1} artifacts.", new Object[]{this.prj, artifacts == null ? "NULL" : "no"});
                return true;
            }
            toPopulate.addAll(this.getGoals(artifacts, mp));
            return true;
        }

        private Set<Mojo> getGoals(Set<Artifact> artifacts, MavenProject mp) throws IllegalArgumentException {
            TreeSet<Mojo> goals = new TreeSet<Mojo>();
            for (Artifact p : artifacts) {
                try {
                    EmbedderFactory.getOnlineEmbedder().resolve(p, mp.getPluginArtifactRepositories(), EmbedderFactory.getOnlineEmbedder().getLocalRepository());
                    Document d = GoalsPanel.loadPluginXml(p.getFile());
                    if (d == null) continue;
                    Element root = d.getDocumentElement();
                    Element mojos = XMLUtil.findElement((Element)root, (String)"mojos", null);
                    if (mojos == null) {
                        LOG.log(Level.WARNING, "no mojos in {0}", p.getFile());
                        continue;
                    }
                    Element goalPrefix = XMLUtil.findElement((Element)root, (String)"goalPrefix", null);
                    if (goalPrefix == null) {
                        LOG.log(Level.WARNING, "no goalPrefix in {0}", p.getFile());
                        continue;
                    }
                    for (Element mojo : XMLUtil.findSubElements((Element)mojos)) {
                        Element config;
                        if (!mojo.getTagName().equals("mojo")) continue;
                        Element goal = XMLUtil.findElement((Element)mojo, (String)"goal", null);
                        if (goal == null) {
                            LOG.log(Level.WARNING, "mojo missing goal in {0}", p.getFile());
                            continue;
                        }
                        String goalString = XMLUtil.findText((org.w3c.dom.Node)goal).trim();
                        if ("help".equals(goalString) && !GoalsPanel.this.preferences.getBoolean(GoalsPanel.PROP_SHOW_HELP_GOALS, false)) continue;
                        ArrayList<Param> params = new ArrayList<Param>();
                        Element parameters = XMLUtil.findElement((Element)mojo, (String)"parameters", null);
                        if (parameters != null) {
                            for (Object param : XMLUtil.findSubElements((Element)parameters)) {
                                if (!param.getTagName().equals("parameter")) continue;
                                Element nameEl = XMLUtil.findElement((Element)param, (String)"name", null);
                                Element editableEl = XMLUtil.findElement((Element)param, (String)"editable", null);
                                Element requiredEl = XMLUtil.findElement((Element)param, (String)"required", null);
                                if (nameEl == null || requiredEl == null || editableEl == null || !"true".equals(XMLUtil.findText((org.w3c.dom.Node)editableEl))) continue;
                                String r = XMLUtil.findText((org.w3c.dom.Node)requiredEl);
                                Param par = new Param(XMLUtil.findText((org.w3c.dom.Node)nameEl), "true".equals(r));
                                params.add(par);
                            }
                        }
                        if ((config = XMLUtil.findElement((Element)mojo, (String)"configuration", null)) != null) {
                            Object param;
                            param = params.iterator();
                            while (param.hasNext()) {
                                Xpp3Dom c;
                                Plugin pl;
                                Param par = (Param)param.next();
                                Element pconfEl = XMLUtil.findElement((Element)config, (String)par.parameterName, null);
                                if (pconfEl != null) {
                                    String val;
                                    Attr attr = pconfEl.getAttributeNode("default-value");
                                    if (attr != null) {
                                        par.defValue = attr.getValue();
                                    }
                                    if ((val = XMLUtil.findText((org.w3c.dom.Node)pconfEl)) != null && val.startsWith("${") && val.endsWith("}")) {
                                        par.property = val.substring(2, val.length() - 1);
                                    }
                                }
                                if ((pl = mp.getPlugin(Plugin.constructKey((String)p.getGroupId(), (String)p.getArtifactId()))) != null && (c = (Xpp3Dom)pl.getConfiguration()) != null) {
                                    boolean bl = par.parameterInModel = c.getChild(par.parameterName) != null;
                                }
                                if (par.property == null) continue;
                                par.propertyInModel = mp.getProperties().getProperty(par.property) != null;
                            }
                        }
                        Plugin plg = mp.getPlugin(Plugin.constructKey((String)p.getGroupId(), (String)p.getArtifactId()));
                        boolean lifecycleBound = false;
                        List execs = plg.getExecutions();
                        if (execs != null) {
                            for (PluginExecution exec : execs) {
                                if (!exec.getGoals().contains(goalString)) continue;
                                lifecycleBound = true;
                                break;
                            }
                            if (lifecycleBound && !GoalsPanel.this.preferences.getBoolean(GoalsPanel.PROP_SHOW_LIFECYCLE_GOALS, false)) continue;
                        }
                        goals.add(new Mojo(XMLUtil.findText((org.w3c.dom.Node)goalPrefix).trim(), goalString, p, params, lifecycleBound));
                    }
                }
                catch (ArtifactResolutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ArtifactNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return goals;
        }

        protected Node createNodeForKey(Mojo mdl) {
            return new MojoNode(mdl, this.prj);
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            this.refresh(false);
        }
    }
}

