/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.modelcache;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.maven.M2AuxilaryConfigImpl;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.modelcache.ActiveConfigurationProvider;
import org.netbeans.modules.maven.modelcache.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;

public final class MavenProjectCache {
    private static final Logger LOG = Logger.getLogger(MavenProjectCache.class.getName());
    private static final String CONTEXT_EXECUTION_RESULT = "NB_Execution_Result";
    private static final String CONTEXT_PARTICIPANTS = "NB_AbstractParticipant_Present";
    private static final Set<String> PARTICIPANT_WHITELIST = new HashSet<String>(Arrays.asList("org.sonatype.nexus.maven.staging.deploy.DeployLifecycleParticipant"));
    private static final Map<File, WeakReference<MavenProject>> file2Project = new WeakHashMap<File, WeakReference<MavenProject>>();
    private static final Map<File, Mutex> file2Mutex = new WeakHashMap<File, Mutex>();

    public static void clearMavenProject(final File pomFile) {
        Mutex mutex = MavenProjectCache.getMutex(pomFile);
        mutex.writeAccess((Mutex.Action)new Mutex.Action<MavenProject>(){

            public MavenProject run() {
                file2Project.remove(pomFile);
                return null;
            }
        });
    }

    public static MavenProject getMavenProject(final File pomFile, final boolean reload) {
        Mutex mutex = MavenProjectCache.getMutex(pomFile);
        MavenProject mp = (MavenProject)mutex.writeAccess((Mutex.Action)new Mutex.Action<MavenProject>(){

            public MavenProject run() {
                MavenProject mp;
                WeakReference ref;
                if (!reload && (ref = (WeakReference)file2Project.get(pomFile)) != null && (mp = (MavenProject)ref.get()) != null) {
                    return mp;
                }
                MavenProject mp2 = MavenProjectCache.loadOriginalMavenProject(pomFile);
                file2Project.put(pomFile, new WeakReference<MavenProject>(mp2));
                return mp2;
            }
        });
        return mp;
    }

    public static MavenExecutionResult getExecutionResult(MavenProject project) {
        return (MavenExecutionResult)project.getContextValue(CONTEXT_EXECUTION_RESULT);
    }

    public static boolean unknownBuildParticipantObserved(MavenProject project) {
        return project.getContextValue(CONTEXT_PARTICIPANTS) != null;
    }

    public static Collection<String> getUnknownBuildParticipantsClassNames(MavenProject project) {
        return (Collection)project.getContextValue(CONTEXT_PARTICIPANTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static MavenProject loadOriginalMavenProject(File pomFile) {
        DefaultMavenExecutionResult res;
        MavenProject newproject;
        long startLoading;
        block26: {
            startLoading = System.currentTimeMillis();
            MavenEmbedder projectEmbedder = EmbedderFactory.getProjectEmbedder();
            newproject = null;
            FileObject projectDir = FileUtil.toFileObject((File)pomFile.getParentFile());
            if (projectDir == null || !projectDir.isValid()) {
                return MavenProjectCache.getFallbackProject(pomFile);
            }
            M2AuxilaryConfigImpl aux = new M2AuxilaryConfigImpl(projectDir, false);
            ActiveConfigurationProvider config = new ActiveConfigurationProvider(projectDir, aux);
            M2Configuration active = config.getActiveConfiguration();
            res = null;
            try {
                ClassRealm projectRealm;
                List<Object> mavenConfigOpts = Collections.emptyList();
                for (FileObject root = projectDir; root != null; root = root.getParent()) {
                    FileObject mavenConfig = root.getFileObject(".mvn/maven.config");
                    if (mavenConfig == null || !mavenConfig.isData()) continue;
                    mavenConfigOpts = Arrays.asList(mavenConfig.asText().split("\\s+"));
                    break;
                }
                MavenExecutionRequest req = projectEmbedder.createMavenExecutionRequest();
                req.addActiveProfiles(active.getActivatedProfiles());
                BiConsumer<String, String> addActiveProfiles = (opt, prefix) -> req.addActiveProfiles(Arrays.asList(opt.substring(prefix.length()).split(",")));
                Iterator<Object> optIt = mavenConfigOpts.iterator();
                while (optIt.hasNext()) {
                    String opt2 = (String)optIt.next();
                    if (opt2.equals("-P") || opt2.equals("--activate-profiles")) {
                        addActiveProfiles.accept((String)optIt.next(), "");
                        continue;
                    }
                    if (opt2.startsWith("-P")) {
                        addActiveProfiles.accept(opt2, "-P");
                        continue;
                    }
                    if (!opt2.startsWith("--activate-profiles=")) continue;
                    addActiveProfiles.accept(opt2, "--activate-profiles=");
                }
                req.setPom(pomFile);
                req.setNoSnapshotUpdates(true);
                req.setUpdateSnapshots(false);
                req.setInteractiveMode(false);
                req.setRecursive(false);
                req.setOffline(true);
                Properties uprops = req.getUserProperties();
                BiConsumer<String, String> setProperty = (opt, prefix) -> {
                    String value = opt.substring(prefix.length());
                    int equals = value.indexOf(61);
                    if (equals != -1) {
                        uprops.setProperty(value.substring(0, equals), value.substring(equals + 1));
                    } else {
                        uprops.setProperty(value, "true");
                    }
                };
                optIt = mavenConfigOpts.iterator();
                while (optIt.hasNext()) {
                    String opt3 = (String)optIt.next();
                    if (opt3.equals("-D") || opt3.equals("--define")) {
                        setProperty.accept((String)optIt.next(), "");
                        continue;
                    }
                    if (opt3.startsWith("-D")) {
                        setProperty.accept(opt3, "-D");
                        continue;
                    }
                    if (!opt3.startsWith("--define=")) continue;
                    setProperty.accept(opt3, "--define=");
                }
                uprops.putAll((Map<?, ?>)MavenProjectCache.createUserPropsForProjectLoading(active.getProperties()));
                req.setUserProperties(uprops);
                res = projectEmbedder.readProjectWithDependencies(req, true);
                newproject = res.getProject();
                if (newproject != null && (projectRealm = newproject.getClassRealm()) != null) {
                    ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
                    try {
                        List lookup = projectEmbedder.getPlexus().lookupList(AbstractMavenLifecycleParticipant.class);
                        if (lookup.size() > 0) {
                            ArrayList<String> parts = new ArrayList<String>();
                            for (AbstractMavenLifecycleParticipant part : lookup) {
                                String name = part.getClass().getName();
                                if (PARTICIPANT_WHITELIST.contains(name)) continue;
                                parts.add(name);
                            }
                            if (parts.size() > 0) {
                                newproject.setContextValue(CONTEXT_PARTICIPANTS, parts);
                            }
                        }
                    }
                    catch (ComponentLookupException componentLookupException) {
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(originalClassLoader);
                    }
                }
                if (newproject != null) break block26;
            }
            catch (IOException | RuntimeException exc) {
                block27: {
                    try {
                        LOG.log(Level.INFO, "Runtime exception thrown while loading maven project at " + pomFile, exc);
                        res = new DefaultMavenExecutionResult();
                        res.addException((Throwable)exc);
                        if (newproject != null) break block27;
                    }
                    catch (Throwable throwable) {
                        if (newproject == null) {
                            newproject = MavenProjectCache.getFallbackProject(pomFile);
                        }
                        newproject.setProjectBuildingRequest(null);
                        newproject.setContextValue(CONTEXT_EXECUTION_RESULT, res);
                        long endLoading = System.currentTimeMillis();
                        LOG.log(Level.FINE, "Loaded project in {0} msec at {1}", new Object[]{endLoading - startLoading, pomFile.getPath()});
                        if (LOG.isLoggable(Level.FINE) && SwingUtilities.isEventDispatchThread()) {
                            LOG.log(Level.FINE, "Project " + pomFile.getPath() + " loaded in AWT event dispatching thread!", new RuntimeException());
                        }
                        throw throwable;
                    }
                    newproject = MavenProjectCache.getFallbackProject(pomFile);
                }
                newproject.setProjectBuildingRequest(null);
                newproject.setContextValue(CONTEXT_EXECUTION_RESULT, (Object)res);
                long endLoading = System.currentTimeMillis();
                LOG.log(Level.FINE, "Loaded project in {0} msec at {1}", new Object[]{endLoading - startLoading, pomFile.getPath()});
                if (LOG.isLoggable(Level.FINE) && SwingUtilities.isEventDispatchThread()) {
                    LOG.log(Level.FINE, "Project " + pomFile.getPath() + " loaded in AWT event dispatching thread!", new RuntimeException());
                }
            }
            newproject = MavenProjectCache.getFallbackProject(pomFile);
        }
        newproject.setProjectBuildingRequest(null);
        newproject.setContextValue(CONTEXT_EXECUTION_RESULT, (Object)res);
        long endLoading = System.currentTimeMillis();
        LOG.log(Level.FINE, "Loaded project in {0} msec at {1}", new Object[]{endLoading - startLoading, pomFile.getPath()});
        if (LOG.isLoggable(Level.FINE) && SwingUtilities.isEventDispatchThread()) {
            LOG.log(Level.FINE, "Project " + pomFile.getPath() + " loaded in AWT event dispatching thread!", new RuntimeException());
        }
        return newproject;
    }

    public static MavenProject getFallbackProject(File projectFile) throws AssertionError {
        MavenProject newproject = new MavenProject();
        newproject.setGroupId("error");
        newproject.setArtifactId("error");
        newproject.setVersion("0");
        newproject.setPackaging("pom");
        newproject.setName(Bundle.LBL_Incomplete_Project_Name());
        newproject.setDescription(Bundle.LBL_Incomplete_Project_Desc());
        newproject.setFile(projectFile);
        return newproject;
    }

    public static boolean isFallbackproject(MavenProject prj) {
        return "error".equals(prj.getGroupId()) && "error".equals(prj.getArtifactId()) && Bundle.LBL_Incomplete_Project_Name().equals(prj.getName());
    }

    public static Properties createUserPropsForProjectLoading(Map<String, String> activeConfiguration) {
        Properties props = new Properties();
        if (activeConfiguration != null) {
            props.putAll(activeConfiguration);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Mutex getMutex(File pomFile) {
        Map<File, Mutex> map = file2Mutex;
        synchronized (map) {
            Mutex mutex = file2Mutex.get(pomFile);
            if (mutex != null) {
                return mutex;
            }
            mutex = new Mutex();
            file2Mutex.put(pomFile, mutex);
            return mutex;
        }
    }
}

