/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.dbgp.ConversionUtils;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.SessionManager;
import org.netbeans.modules.php.dbgp.models.ViewModelSupport;
import org.netbeans.modules.php.dbgp.packets.StatusCommand;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ThreadsModel
extends ViewModelSupport
implements TreeModel,
NodeModel,
NodeActionsProvider,
TableModel {
    private static final String RUNNING_STATE = "LBL_Running";
    private static final String SUSPENDED_STATE = "LBL_Suspended";
    private static final String INACTIVE_THREAD_STATE = "LBL_InactiveThreadState";
    private static final String ACTIVE_THREAD_STATE = "LBL_ActiveThreadState";
    private static final String THREAD_NAME = "LBL_ThreadName";
    public static final String CURRENT = "org/netbeans/modules/debugger/resources/threadsView/CurrentThread";
    public static final String RUNNING = "org/netbeans/modules/debugger/resources/threadsView/RunningThread";
    public static final String SUSPENDED = "org/netbeans/modules/debugger/resources/threadsView/SuspendedThread";
    private ContextProvider myProvider;

    public ThreadsModel(ContextProvider contextProvider) {
        this.myProvider = contextProvider;
    }

    @Override
    public void clearModel() {
        this.update();
    }

    public Object getRoot() {
        return "Root";
    }

    public void update() {
        this.refresh();
    }

    public void updateSession(DebugSession session) {
        this.updateThreadState(session);
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            int size;
            SessionId id = this.getSessionId();
            if (id == null) {
                return new Object[0];
            }
            DebugSession debugSession = ConversionUtils.toDebugSession(id);
            int n = size = debugSession != null ? 1 : 0;
            if (from >= size) {
                return new Object[0];
            }
            int end = Math.min(to, size);
            if (from == 0 && to == size) {
                Object[] objectArray;
                if (debugSession != null) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = debugSession;
                } else {
                    objectArray = new Object[]{};
                }
                return objectArray;
            }
            ArrayList<DebugSession> list = new ArrayList<DebugSession>();
            if (debugSession != null) {
                list.add(debugSession);
            }
            List result = list.subList(from, end);
            return result.toArray(new Object[result.size()]);
        }
        throw new UnknownTypeException(parent);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof DebugSession) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            SessionId id = this.getSessionId();
            if (id == null) {
                return 0;
            }
            SessionManager sessionManager = SessionManager.getInstance();
            return sessionManager.findSessionsById(id).size();
        }
        throw new UnknownTypeException(node);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof DebugSession) {
            DebugSession session = (DebugSession)node;
            String scriptName = this.getScriptName(session);
            return NbBundle.getMessage(ThreadsModel.class, (String)THREAD_NAME, (Object)scriptName);
        }
        if (node == "Root") {
            return "Root".toString();
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof DebugSession) {
            DebugSession session = (DebugSession)node;
            if (session.getBridge().isSuspended()) {
                return SUSPENDED;
            }
            if (this.isCurrent(session)) {
                return CURRENT;
            }
            return RUNNING;
        }
        if (node == "Root") {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return null;
        }
        if (node instanceof DebugSession) {
            return ((DebugSession)node).getFileName();
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node instanceof DebugSession) {
            DebugSession session = (DebugSession)node;
            SessionId id = this.getSessionId();
            if (id == null) {
                return;
            }
            DebugSession current = SessionManager.getInstance().getSession(id);
            if (!session.equals(current)) {
                StatusCommand command = new StatusCommand(session.getTransactionId());
                session.sendCommandLater(command);
                this.updateThreadState(current);
                this.updateThreadState(session);
            }
        }
        throw new UnknownTypeException(node);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        return new Action[0];
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node == "Root") {
            return null;
        }
        if (node instanceof DebugSession) {
            DebugSession session = (DebugSession)node;
            switch (columnID) {
                case "ThreadSuspended": {
                    return session.getBridge().isSuspended();
                }
                case "ThreadState": {
                    String key = this.isCurrent(session) ? ACTIVE_THREAD_STATE : INACTIVE_THREAD_STATE;
                    String value = session.getBridge().isSuspended() ? SUSPENDED_STATE : RUNNING_STATE;
                    String result = NbBundle.getMessage(ThreadsModel.class, (String)key, (Object)NbBundle.getMessage(ThreadsModel.class, (String)value));
                    return result;
                }
            }
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if (node == "Root" || node instanceof DebugSession) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    private void updateThreadState(DebugSession session) {
        this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)session));
    }

    private String getScriptName(DebugSession session) {
        SessionId id = session.getSessionId();
        if (id == null) {
            return "";
        }
        String fileName = session.getFileName();
        FileObject script = id.toSourceFile(fileName);
        if (script == null) {
            return "";
        }
        Project project = FileOwnerQuery.getOwner((FileObject)script);
        return FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)script);
    }

    private Session getSession() {
        return (Session)this.getContextProvider().lookupFirst(null, Session.class);
    }

    private SessionId getSessionId() {
        ContextProvider provider = this.getContextProvider();
        if (provider == null) {
            return null;
        }
        return (SessionId)provider.lookupFirst(null, SessionId.class);
    }

    private ContextProvider getContextProvider() {
        return this.myProvider;
    }

    private boolean isCurrent(DebugSession session) {
        SessionId id = this.getSessionId();
        DebugSession current = SessionManager.getInstance().getSession(id);
        return session.equals(current);
    }
}

