/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.polyglot.Engine;

public final class HostAccess {
    private final String name;
    private final EconomicSet<Class<? extends Annotation>> accessAnnotations;
    private final EconomicSet<Class<? extends Annotation>> implementableAnnotations;
    private final EconomicMap<Class<?>, Boolean> excludeTypes;
    private final EconomicSet<AnnotatedElement> members;
    private final EconomicSet<Class<?>> implementableTypes;
    private final List<Object> targetMappings;
    private final boolean allowPublic;
    private final boolean allowAllImplementations;
    final boolean allowArrayAccess;
    final boolean allowListAccess;
    volatile Object impl;
    private static final HostAccess EMPTY = new HostAccess(null, null, null, null, null, null, null, false, false, false, false);
    public static final HostAccess EXPLICIT = HostAccess.newBuilder().allowAccessAnnotatedBy(Export.class).allowImplementationsAnnotatedBy(Implementable.class).allowImplementationsAnnotatedBy(FunctionalInterface.class).name("HostAccess.EXPLICIT").build();
    public static final HostAccess ALL = HostAccess.newBuilder().allowPublicAccess(true).allowAllImplementations(true).allowArrayAccess(true).allowListAccess(true).name("HostAccess.ALL").build();
    public static final HostAccess NONE = HostAccess.newBuilder().name("HostAccess.NONE").build();

    HostAccess(EconomicSet<Class<? extends Annotation>> annotations, EconomicMap<Class<?>, Boolean> excludeTypes, EconomicSet<AnnotatedElement> members, EconomicSet<Class<? extends Annotation>> implementableAnnotations, EconomicSet<Class<?>> implementableTypes, List<Object> targetMappings, String name, boolean allowPublic, boolean allowAllImplementations, boolean allowArrayAccess, boolean allowListAccess) {
        this.accessAnnotations = HostAccess.copySet(annotations, Equivalence.IDENTITY);
        this.excludeTypes = HostAccess.copyMap(excludeTypes, Equivalence.IDENTITY);
        this.members = HostAccess.copySet(members, Equivalence.DEFAULT);
        this.implementableAnnotations = HostAccess.copySet(implementableAnnotations, Equivalence.IDENTITY);
        this.implementableTypes = HostAccess.copySet(implementableTypes, Equivalence.IDENTITY);
        this.targetMappings = targetMappings != null ? new ArrayList<Object>(targetMappings) : null;
        this.name = name;
        this.allowPublic = allowPublic;
        this.allowAllImplementations = allowAllImplementations;
        this.allowArrayAccess = allowArrayAccess;
        this.allowListAccess = allowListAccess;
    }

    private static <T> EconomicSet<T> copySet(EconomicSet<T> values, Equivalence equivalence) {
        if (values == null) {
            return null;
        }
        return EconomicSet.create(equivalence, values);
    }

    private static <K, T> EconomicMap<K, T> copyMap(EconomicMap<K, T> values, Equivalence equivalence) {
        if (values == null) {
            return null;
        }
        return EconomicMap.create(equivalence, values);
    }

    public static Builder newBuilder() {
        return EMPTY.new Builder();
    }

    public static Builder newBuilder(HostAccess conf) {
        Objects.requireNonNull(conf);
        HostAccess hostAccess = EMPTY;
        hostAccess.getClass();
        return hostAccess.new Builder(conf);
    }

    List<Object> getTargetMappings() {
        return this.targetMappings;
    }

    boolean allowsImplementation(Class<?> type) {
        if (this.allowAllImplementations) {
            return true;
        }
        if (this.implementableTypes != null && this.implementableTypes.contains(type)) {
            return true;
        }
        if (this.implementableAnnotations != null) {
            for (Class clazz : this.implementableAnnotations) {
                if (type.getAnnotation(clazz) == null) continue;
                return true;
            }
        }
        return false;
    }

    boolean allowsAccess(AnnotatedElement member) {
        if (this.excludeTypes != null) {
            Class<?> owner = HostAccess.getDeclaringClass(member);
            UnmodifiableMapCursor unmodifiableMapCursor = this.excludeTypes.getEntries();
            while (unmodifiableMapCursor.advance()) {
                Class ban = (Class)unmodifiableMapCursor.getKey();
                if (!((Boolean)unmodifiableMapCursor.getValue() != false ? ban.isAssignableFrom(owner) : ban == owner)) continue;
                return false;
            }
        }
        if (this.allowPublic) {
            return true;
        }
        if (this.members != null && this.members.contains(member)) {
            return true;
        }
        if (this.accessAnnotations != null) {
            for (Class clazz : this.accessAnnotations) {
                if (!HostAccess.hasAnnotation(member, clazz)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.name == null ? super.toString() : this.name;
    }

    private static boolean hasAnnotation(AnnotatedElement member, Class<? extends Annotation> annotationType) {
        if (member instanceof Field) {
            Field f = (Field)member;
            return f.getAnnotation(annotationType) != null;
        }
        if (member instanceof Method) {
            Method m = (Method)member;
            return m.getAnnotation(annotationType) != null;
        }
        if (member instanceof Constructor) {
            Constructor c = (Constructor)member;
            return c.getAnnotation(annotationType) != null;
        }
        return false;
    }

    private static Class<?> getDeclaringClass(AnnotatedElement member) {
        if (member instanceof Field) {
            Field f = (Field)member;
            return f.getDeclaringClass();
        }
        if (member instanceof Method) {
            Method m = (Method)member;
            return m.getDeclaringClass();
        }
        if (member instanceof Constructor) {
            Constructor c = (Constructor)member;
            return c.getDeclaringClass();
        }
        return Object.class;
    }

    public final class Builder {
        private EconomicSet<Class<? extends Annotation>> accessAnnotations;
        private EconomicSet<Class<? extends Annotation>> implementationAnnotations;
        private EconomicMap<Class<?>, Boolean> excludeTypes;
        private EconomicSet<Class<?>> implementableTypes;
        private EconomicSet<AnnotatedElement> members;
        private List<Object> targetMappings;
        private boolean allowPublic;
        private boolean allowListAccess;
        private boolean allowArrayAccess;
        private boolean allowAllImplementations;
        private String name;

        Builder() {
        }

        Builder(HostAccess access) {
            this.accessAnnotations = HostAccess.copySet(access.accessAnnotations, Equivalence.IDENTITY);
            this.excludeTypes = HostAccess.copyMap(access.excludeTypes, Equivalence.IDENTITY);
            this.members = HostAccess.copySet(access.members, Equivalence.DEFAULT);
            this.implementationAnnotations = HostAccess.copySet(access.implementableAnnotations, Equivalence.IDENTITY);
            this.implementableTypes = HostAccess.copySet(access.implementableTypes, Equivalence.IDENTITY);
            this.targetMappings = access.targetMappings != null ? new ArrayList(access.targetMappings) : null;
            this.excludeTypes = access.excludeTypes;
            this.members = access.members;
            this.targetMappings = access.targetMappings;
            this.allowPublic = access.allowPublic;
            this.allowListAccess = access.allowListAccess;
            this.allowArrayAccess = access.allowArrayAccess;
            this.allowAllImplementations = access.allowAllImplementations;
        }

        public Builder allowAccessAnnotatedBy(Class<? extends Annotation> annotation) {
            Objects.requireNonNull(annotation);
            if (this.accessAnnotations == null) {
                this.accessAnnotations = EconomicSet.create(Equivalence.IDENTITY);
            }
            this.accessAnnotations.add(annotation);
            return this;
        }

        public Builder allowPublicAccess(boolean allow) {
            this.allowPublic = allow;
            return this;
        }

        public Builder allowAccess(Executable element) {
            Objects.requireNonNull(element);
            if (this.members == null) {
                this.members = EconomicSet.create();
            }
            this.members.add(element);
            return this;
        }

        public Builder allowAccess(Field element) {
            Objects.requireNonNull(element);
            if (this.members == null) {
                this.members = EconomicSet.create();
            }
            this.members.add(element);
            return this;
        }

        public Builder denyAccess(Class<?> clazz) {
            return this.denyAccess(clazz, true);
        }

        public Builder denyAccess(Class<?> clazz, boolean includeSubclasses) {
            Objects.requireNonNull(clazz);
            if (this.excludeTypes == null) {
                this.excludeTypes = EconomicMap.create(Equivalence.IDENTITY);
            }
            this.excludeTypes.put(clazz, includeSubclasses);
            return this;
        }

        public Builder allowAllImplementations(boolean allow) {
            this.allowAllImplementations = allow;
            return this;
        }

        public Builder allowImplementationsAnnotatedBy(Class<? extends Annotation> annotation) {
            Objects.requireNonNull(annotation);
            if (this.implementationAnnotations == null) {
                this.implementationAnnotations = EconomicSet.create(Equivalence.IDENTITY);
            }
            this.implementationAnnotations.add(annotation);
            return this;
        }

        public Builder allowImplementations(Class<?> interfaceClass) {
            Objects.requireNonNull(interfaceClass);
            if (this.implementableTypes == null) {
                this.implementableTypes = EconomicSet.create(Equivalence.IDENTITY);
            }
            this.implementableTypes.add(interfaceClass);
            return this;
        }

        public Builder allowArrayAccess(boolean arrayAccess) {
            this.allowArrayAccess = arrayAccess;
            return this;
        }

        public Builder allowListAccess(boolean listAccess) {
            this.allowListAccess = listAccess;
            return this;
        }

        public <S, T> Builder targetTypeMapping(Class<S> sourceType, Class<T> targetType, Predicate<S> accepts, Function<S, T> converter) {
            Objects.requireNonNull(sourceType);
            Objects.requireNonNull(targetType);
            Objects.requireNonNull(converter);
            if (targetType.isPrimitive()) {
                throw new IllegalArgumentException("Primitive target type is not supported as target mapping.");
            }
            if (this.targetMappings == null) {
                this.targetMappings = new ArrayList<Object>();
            }
            this.targetMappings.add(Engine.getImpl().newTargetTypeMapping(sourceType, targetType, accepts, converter));
            return this;
        }

        Builder name(String givenName) {
            this.name = givenName;
            return this;
        }

        public HostAccess build() {
            return new HostAccess(this.accessAnnotations, this.excludeTypes, this.members, this.implementationAnnotations, this.implementableTypes, this.targetMappings, this.name, this.allowPublic, this.allowAllImplementations, this.allowArrayAccess, this.allowListAccess);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Implementable {
    }

    @Target(value={ElementType.CONSTRUCTOR, ElementType.FIELD, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Export {
    }
}

