/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.matchers;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.regex.charset.Range;
import com.oracle.truffle.regex.tregex.matchers.InvertibleCharMatcher;
import com.oracle.truffle.regex.tregex.matchers.SingleRangeMatcherNodeGen;

public abstract class SingleRangeMatcher
extends InvertibleCharMatcher {
    private final int lo;
    private final int hi;

    SingleRangeMatcher(boolean invert, int lo, int hi) {
        super(invert);
        this.lo = lo;
        this.hi = hi;
    }

    public static SingleRangeMatcher create(boolean invert, int lo, int hi) {
        return SingleRangeMatcherNodeGen.create(invert, lo, hi);
    }

    public int getLo() {
        return this.lo;
    }

    public int getHi() {
        return this.hi;
    }

    @Specialization
    boolean match(int c) {
        return this.result(this.lo <= c && this.hi >= c);
    }

    @Override
    public int estimatedCost() {
        return 2;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.modifiersToString() + Range.toString(this.lo, this.hi);
    }
}

