/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.hudson.api.HudsonFolder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.api.HudsonVersion;
import org.netbeans.modules.hudson.api.ui.ConsoleDataDisplayer;
import org.netbeans.modules.hudson.api.ui.FailureDataDisplayer;
import org.netbeans.modules.hudson.spi.HudsonJobChangeItem;
import org.netbeans.modules.hudson.spi.RemoteFileSystem;

public abstract class BuilderConnector {
    @NonNull
    public abstract InstanceData getInstanceData(boolean var1);

    @NonNull
    public InstanceData getInstanceData(@NonNull HudsonFolder parentFolder, boolean authentication) {
        return new InstanceData(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @NonNull
    public abstract Collection<BuildData> getJobBuildsData(@NonNull HudsonJob var1);

    public abstract void getJobBuildResult(@NonNull HudsonJobBuild var1, @NonNull AtomicBoolean var2, @NonNull AtomicReference<HudsonJobBuild.Result> var3);

    @CheckForNull
    public abstract RemoteFileSystem getArtifacts(@NonNull HudsonJobBuild var1);

    @CheckForNull
    public abstract RemoteFileSystem getArtifacts(@NonNull HudsonMavenModuleBuild var1);

    @CheckForNull
    public abstract RemoteFileSystem getWorkspace(@NonNull HudsonJob var1);

    public abstract boolean isConnected();

    public abstract boolean isForbidden();

    @NonNull
    public abstract HudsonVersion getHudsonVersion(boolean var1);

    public abstract void startJob(@NonNull HudsonJob var1);

    @CheckForNull
    public abstract ConsoleDataProvider getConsoleDataProvider();

    @CheckForNull
    public abstract FailureDataProvider getFailureDataProvider();

    public abstract Collection<? extends HudsonJobChangeItem> getJobBuildChanges(HudsonJobBuild var1);

    public static final class InstanceData {
        private Collection<JobData> jobsData;
        private Collection<ViewData> viewsData;
        private final Collection<FolderData> foldersData;

        @Deprecated
        public InstanceData(Collection<JobData> jobsData, Collection<ViewData> viewsData) {
            this(jobsData, viewsData, Collections.emptySet());
        }

        public InstanceData(Collection<JobData> jobsData, Collection<ViewData> viewsData, Collection<FolderData> foldersData) {
            this.jobsData = jobsData;
            this.viewsData = viewsData;
            this.foldersData = foldersData;
        }

        public Collection<JobData> getJobsData() {
            return this.jobsData;
        }

        public Collection<ViewData> getViewsData() {
            return this.viewsData;
        }

        public Collection<FolderData> getFoldersData() {
            return this.foldersData;
        }
    }

    public static final class ViewData {
        private String name;
        private String url;
        private boolean primary;

        public ViewData(String name, String url, boolean primary) {
            this.name = name;
            this.url = url;
            this.primary = primary;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isPrimary() {
            return this.primary;
        }
    }

    public static final class BuildData {
        private int number;
        private HudsonJobBuild.Result result;
        private boolean building;

        public BuildData(int number, HudsonJobBuild.Result result, boolean building) {
            this.number = number;
            this.result = result;
            this.building = building;
        }

        public int getNumber() {
            return this.number;
        }

        public HudsonJobBuild.Result getResult() {
            return this.result;
        }

        public boolean isBuilding() {
            return this.building;
        }
    }

    public static final class ModuleData {
        private String name;
        private String displayName;
        private HudsonJob.Color color;
        private String url;

        public ModuleData(String name, String displayName, HudsonJob.Color color, String url) {
            this.name = name;
            this.displayName = displayName;
            this.color = color;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public HudsonJob.Color getColor() {
            return this.color;
        }

        public String getUrl() {
            return this.url;
        }
    }

    public static final class FolderData {
        private String name;
        private String url;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static final class JobData {
        private String jobName;
        private String jobUrl;
        private boolean secured;
        private HudsonJob.Color color;
        private String displayName;
        private boolean buildable;
        private boolean inQueue;
        private int lastBuild;
        private int lastFailedBuild;
        private int lastStableBuild;
        private int lastSuccessfulBuild;
        private int lastCompletedBuild;
        private List<ModuleData> modules = new LinkedList<ModuleData>();
        private List<String> views = new LinkedList<String>();

        public String getJobName() {
            return this.jobName;
        }

        public void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public String getJobUrl() {
            return this.jobUrl;
        }

        public void setJobUrl(String jobUrl) {
            this.jobUrl = jobUrl;
        }

        public boolean isSecured() {
            return this.secured;
        }

        public void setSecured(boolean secured) {
            this.secured = secured;
        }

        public HudsonJob.Color getColor() {
            return this.color;
        }

        public void setColor(HudsonJob.Color color) {
            this.color = color;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public boolean isBuildable() {
            return this.buildable;
        }

        public void setBuildable(boolean buildable) {
            this.buildable = buildable;
        }

        public boolean isInQueue() {
            return this.inQueue;
        }

        public void setInQueue(boolean inQueue) {
            this.inQueue = inQueue;
        }

        public int getLastBuild() {
            return this.lastBuild;
        }

        public void setLastBuild(int lastBuild) {
            this.lastBuild = lastBuild;
        }

        public int getLastFailedBuild() {
            return this.lastFailedBuild;
        }

        public void setLastFailedBuild(int lastFailedBuild) {
            this.lastFailedBuild = lastFailedBuild;
        }

        public int getLastStableBuild() {
            return this.lastStableBuild;
        }

        public void setLastStableBuild(int lastStableBuild) {
            this.lastStableBuild = lastStableBuild;
        }

        public int getLastSuccessfulBuild() {
            return this.lastSuccessfulBuild;
        }

        public void setLastSuccessfulBuild(int lastSuccessfulBuild) {
            this.lastSuccessfulBuild = lastSuccessfulBuild;
        }

        public int getLastCompletedBuild() {
            return this.lastCompletedBuild;
        }

        public void setLastCompletedBuild(int lastCompletedBuild) {
            this.lastCompletedBuild = lastCompletedBuild;
        }

        public Collection<ModuleData> getModules() {
            return this.modules;
        }

        public void addModule(String name, String displayName, HudsonJob.Color color, String url) {
            this.modules.add(new ModuleData(name, displayName, color, url));
        }

        public Collection<String> getViews() {
            return this.views;
        }

        public void addView(String viewName) {
            if (viewName != null && !viewName.trim().isEmpty()) {
                this.views.add(viewName);
            }
        }
    }

    public static abstract class FailureDataProvider {
        public abstract void showFailures(@NonNull HudsonJobBuild var1, @NonNull FailureDataDisplayer var2);

        public abstract void showFailures(@NonNull HudsonMavenModuleBuild var1, @NonNull FailureDataDisplayer var2);
    }

    public static abstract class ConsoleDataProvider {
        public abstract void showConsole(@NonNull HudsonJobBuild var1, ConsoleDataDisplayer var2);

        public abstract void showConsole(@NonNull HudsonMavenModuleBuild var1, ConsoleDataDisplayer var2);
    }
}

