/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.openide.util.Pair;

public class IgnorePattern {
    private final List<Rule> rules;
    private final boolean negative;

    private IgnorePattern(List<Rule> rules, boolean negative) {
        this.rules = rules;
        this.negative = negative;
    }

    @CheckForNull
    public static IgnorePattern compile(String pattern, Character separator, boolean exclusionSupported) {
        char sep;
        String preprocessed;
        String trimmed = pattern.trim();
        boolean negative = false;
        if (exclusionSupported && trimmed.startsWith("!")) {
            negative = true;
            trimmed = trimmed.substring(1).trim();
        }
        if ((preprocessed = IgnorePattern.preprocess(trimmed, sep = separator != null ? separator.charValue() : File.separatorChar)).startsWith(Character.toString(sep))) {
            preprocessed = preprocessed.substring(1);
        }
        return IgnorePattern.compilePattern(preprocessed, sep, negative);
    }

    static String preprocess(String pattern, char separator) {
        String[] parts;
        String volume;
        String sep = Character.toString(separator);
        String trimmed = pattern.trim();
        String path = trimmed.substring((volume = IgnorePattern.getVolume(trimmed, separator)).length());
        String ret = path.replaceAll("(" + Pattern.quote(sep) + "){2,}", Matcher.quoteReplacement(sep)).replaceAll("(" + Pattern.quote(sep) + "\\.)+(" + Pattern.quote(sep) + "|$)", Matcher.quoteReplacement(sep));
        if (ret.endsWith(sep) && ret.length() > 1) {
            ret = ret.substring(0, ret.length() - sep.length());
        }
        if ((parts = ret.split(Pattern.quote(sep))).length > 1) {
            int i;
            boolean root = false;
            StringBuilder removed = new StringBuilder();
            int count = 0;
            for (i = parts.length - 1; i >= 0; --i) {
                if (parts[i].isEmpty()) {
                    root = true;
                    break;
                }
                if (parts[i].equals("..")) {
                    ++count;
                    continue;
                }
                if (count == 0) {
                    if (removed.length() > 0) {
                        removed.insert(0, sep);
                    }
                    removed.insert(0, parts[i]);
                    continue;
                }
                --count;
            }
            for (i = 0; i < count; ++i) {
                if (removed.length() > 0) {
                    removed.insert(0, sep);
                }
                removed.insert(0, "..");
            }
            if (root) {
                removed.insert(0, sep);
            }
            ret = removed.toString();
        }
        if ((ret = ret.replaceAll("^(" + Pattern.quote(sep) + "\\.\\.)+(" + Pattern.quote(sep) + ")?", Matcher.quoteReplacement(sep)).replaceAll("/", Matcher.quoteReplacement(sep))).isEmpty()) {
            ret = ".";
        }
        return volume + ret;
    }

    static IgnorePattern compilePattern(String pattern, char separator, boolean negative) {
        String trimmed = pattern.trim();
        ArrayList<Rule> ret = new ArrayList<Rule>();
        char[] patternChars = trimmed.toCharArray();
        ArrayList<Character> buffer = new ArrayList<Character>();
        block6: for (int i = 0; i < patternChars.length; ++i) {
            char c = patternChars[i];
            switch (c) {
                case '*': {
                    IgnorePattern.addCharacterListRule(ret, buffer);
                    if (!ret.isEmpty() && ret.get(ret.size() - 1) instanceof StarRule) continue block6;
                    ret.add(new StarRule(separator));
                    continue block6;
                }
                case '?': {
                    IgnorePattern.addCharacterListRule(ret, buffer);
                    ret.add(new QuestionRule(separator));
                    continue block6;
                }
                case '[': {
                    IgnorePattern.addCharacterListRule(ret, buffer);
                    Pair<? extends Rule, Integer> p = IgnorePattern.createRange(patternChars, i, separator);
                    ret.add((Rule)p.first());
                    if ((Integer)p.second() < 0) {
                        return new IgnorePattern(ret, negative);
                    }
                    i = (Integer)p.second();
                    continue block6;
                }
                case '\\': {
                    if (separator == '\\') {
                        buffer.add(Character.valueOf(patternChars[i]));
                        continue block6;
                    }
                    if (i < patternChars.length - 1) {
                        buffer.add(Character.valueOf(patternChars[++i]));
                        continue block6;
                    }
                    IgnorePattern.addCharacterListRule(ret, buffer);
                    ret.add(new ErrorRule(trimmed, i));
                    return new IgnorePattern(ret, negative);
                }
                default: {
                    buffer.add(Character.valueOf(patternChars[i]));
                }
            }
        }
        IgnorePattern.addCharacterListRule(ret, buffer);
        return new IgnorePattern(ret, negative);
    }

    private static void addCharacterListRule(List<Rule> rules, List<Character> buffer) {
        if (!buffer.isEmpty()) {
            rules.add(new CharacterListRule(buffer));
            buffer.clear();
        }
    }

    public boolean matches(String input) throws PatternSyntaxException {
        return IgnorePattern.matches(this.rules, input);
    }

    public boolean isNegative() {
        return this.negative;
    }

    boolean isError() {
        for (Rule r : this.rules) {
            if (!(r instanceof ErrorRule)) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(List<Rule> rules, String input) throws PatternSyntaxException {
        char[] inputChars = input.toCharArray();
        int i = 0;
        int listIndex = 0;
        Iterator<Rule> it = rules.iterator();
        while (it.hasNext()) {
            Rule r = it.next();
            if (inputChars.length == 0) {
                return rules.size() == 1 && r.matchesEmpty();
            }
            int[] test = r.consume(inputChars, i);
            if (test == null) {
                return false;
            }
            if (test.length == 1) {
                i = test[0];
            } else if (listIndex == rules.size() - 1 && test[test.length - 1] >= input.length()) {
                i = test[test.length - 1];
            } else {
                for (int j = test.length - 1; j >= 0; --j) {
                    if (!IgnorePattern.matches(rules.subList(listIndex + 1, rules.size()), input.substring(test[j]))) continue;
                    return true;
                }
                return false;
            }
            ++listIndex;
            if (i < inputChars.length) continue;
            if (!it.hasNext()) {
                return true;
            }
            return it.next().matchesEmpty();
        }
        return i >= inputChars.length;
    }

    private static Pair<? extends Rule, Integer> createRange(char[] chars, int offset, char separator) {
        if (chars[offset] != '[' || offset >= chars.length - 1) {
            return Pair.of((Object)new ErrorRule(new String(chars), offset), (Object)-1);
        }
        boolean negated = false;
        int start = offset + 1;
        char first = chars[offset + 1];
        if (first == '^') {
            negated = true;
            ++start;
        }
        if (start >= chars.length - 1) {
            return Pair.of((Object)new ErrorRule(new String(chars), start), (Object)-1);
        }
        Character last = null;
        LinkedList<Character> singles = new LinkedList<Character>();
        LinkedList<Pair<Character, Character>> ranges = new LinkedList<Pair<Character, Character>>();
        boolean inRange = false;
        block5: for (int i = start; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\\': {
                    char l;
                    if (separator == '\\') {
                        l = chars[i];
                        if (inRange) {
                            ranges.add((Pair<Character, Character>)Pair.of((Object)last, (Object)Character.valueOf(l)));
                            inRange = false;
                            last = null;
                            continue block5;
                        }
                        last = Character.valueOf(l);
                        singles.add(Character.valueOf(l));
                        continue block5;
                    }
                    if (i < chars.length - 1) {
                        l = chars[++i];
                        if (inRange) {
                            ranges.add((Pair<Character, Character>)Pair.of((Object)last, (Object)Character.valueOf(l)));
                            inRange = false;
                            last = null;
                            continue block5;
                        }
                        last = Character.valueOf(l);
                        singles.add(Character.valueOf(l));
                        continue block5;
                    }
                    return Pair.of((Object)new ErrorRule(new String(chars), i), (Object)-1);
                }
                case ']': {
                    if (inRange || i == start) {
                        return Pair.of((Object)new ErrorRule(new String(chars), i), (Object)-1);
                    }
                    return Pair.of((Object)new RangeRule(negated, ranges, singles), (Object)i);
                }
                case '-': {
                    if (last == null) {
                        return Pair.of((Object)new ErrorRule(new String(chars), i), (Object)-1);
                    }
                    singles.removeLast();
                    inRange = true;
                    continue block5;
                }
                default: {
                    char l = chars[i];
                    if (inRange) {
                        ranges.add((Pair<Character, Character>)Pair.of((Object)last, (Object)Character.valueOf(l)));
                        inRange = false;
                        last = null;
                        continue block5;
                    }
                    last = Character.valueOf(l);
                    singles.add(Character.valueOf(l));
                }
            }
        }
        return Pair.of((Object)new ErrorRule(new String(chars), chars.length - 1), (Object)-1);
    }

    private static String getVolume(String path, char separator) {
        if (separator != '\\') {
            return "";
        }
        if (path.length() < 2) {
            return "";
        }
        char drive = path.charAt(0);
        if (path.charAt(1) == ':' && ('a' <= drive && drive <= 'z' || 'A' <= drive && drive <= 'Z')) {
            return path.substring(0, 2);
        }
        return "";
    }

    private static class ErrorRule
    implements Rule {
        private final String regex;
        private final int index;

        public ErrorRule(String regex, int index) {
            this.regex = regex;
            this.index = index;
        }

        @Override
        public int[] consume(char[] chars, int offset) {
            throw new PatternSyntaxException("Malformed pattern", this.regex, this.index);
        }

        @Override
        public boolean matchesEmpty() {
            return false;
        }
    }

    private static class CharacterListRule
    implements Rule {
        private final List<Character> array;

        public CharacterListRule(List<Character> array) {
            this.array = new ArrayList<Character>(array);
        }

        @Override
        public int[] consume(char[] chars, int offset) throws IllegalStateException {
            if (offset >= chars.length) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < this.array.size(); ++i) {
                if (this.array.get(i).charValue() == chars[offset + i]) continue;
                return null;
            }
            return new int[]{offset + this.array.size()};
        }

        @Override
        public boolean matchesEmpty() {
            return false;
        }
    }

    private static class RangeRule
    implements Rule {
        private final boolean negated;
        private final List<Pair<Character, Character>> ranges;
        private final List<Character> singles;

        public RangeRule(boolean negated, List<Pair<Character, Character>> ranges, List<Character> singles) {
            this.negated = negated;
            this.ranges = ranges;
            this.singles = singles;
        }

        @Override
        public int[] consume(char[] chars, int offset) {
            if (offset >= chars.length) {
                throw new IllegalArgumentException();
            }
            boolean ok = this.check(chars[offset]);
            if (this.negated) {
                boolean bl = ok = !ok;
            }
            if (!ok) {
                return null;
            }
            return new int[]{offset + 1};
        }

        @Override
        public boolean matchesEmpty() {
            return false;
        }

        private boolean check(char c) {
            for (Character c2 : this.singles) {
                if (c2.charValue() != c) continue;
                return true;
            }
            for (Pair pair : this.ranges) {
                if (((Character)pair.first()).charValue() > c || c > ((Character)pair.second()).charValue()) continue;
                return true;
            }
            return false;
        }
    }

    private static class QuestionRule
    implements Rule {
        private final char separator;

        public QuestionRule(char separator) {
            this.separator = separator;
        }

        @Override
        public int[] consume(char[] chars, int offset) {
            if (offset >= chars.length) {
                throw new IllegalArgumentException();
            }
            if (chars[offset] == this.separator) {
                return null;
            }
            return new int[]{offset + 1};
        }

        @Override
        public boolean matchesEmpty() {
            return false;
        }
    }

    private static class StarRule
    implements Rule {
        private final char separator;

        public StarRule(char separator) {
            this.separator = separator;
        }

        @Override
        public int[] consume(char[] chars, int offset) {
            if (offset >= chars.length) {
                throw new IllegalArgumentException();
            }
            int limit = -1;
            for (int i = offset; i < chars.length; ++i) {
                if (chars[i] != this.separator) continue;
                limit = i;
                break;
            }
            if (limit < 0) {
                limit = chars.length;
            }
            int[] ret = new int[limit - offset + 1];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = offset + i;
            }
            return ret;
        }

        @Override
        public boolean matchesEmpty() {
            return true;
        }
    }

    private static interface Rule {
        public int[] consume(char[] var1, int var2);

        public boolean matchesEmpty();
    }
}

