/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.spi.db;

import com.sun.xml.bind.v2.model.nav.Navigator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public final class TypeInfo {
    public final QName tagName;
    public Type type;
    public final Annotation[] annotations;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private boolean isGlobalElement = true;
    private TypeInfo parentCollectionType;
    private Type genericType;

    public TypeInfo(QName tagName, Type type, Annotation ... annotations) {
        if (tagName == null || type == null || annotations == null) {
            String nullArgs = "";
            if (tagName == null) {
                nullArgs = "tagName";
            }
            if (type == null) {
                nullArgs = nullArgs + (nullArgs.length() > 0 ? ", type" : "type");
            }
            if (annotations == null) {
                nullArgs = nullArgs + (nullArgs.length() > 0 ? ", annotations" : "annotations");
            }
            throw new IllegalArgumentException("Argument(s) \"" + nullArgs + "\" can''t be null.)");
        }
        this.tagName = new QName(tagName.getNamespaceURI().intern(), tagName.getLocalPart().intern(), tagName.getPrefix());
        this.type = type;
        this.annotations = annotations;
    }

    public <A extends Annotation> A get(Class<A> annotationType) {
        for (Annotation a : this.annotations) {
            if (a.annotationType() != annotationType) continue;
            return (A)((Annotation)annotationType.cast(a));
        }
        return null;
    }

    public TypeInfo toItemType() {
        Type base = Navigator.REFLECTION.getBaseClass(this.type, Collection.class);
        if (base == null) {
            return this;
        }
        return new TypeInfo(this.tagName, Navigator.REFLECTION.getTypeArgument(base, 0), new Annotation[0]);
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public boolean isGlobalElement() {
        return this.isGlobalElement;
    }

    public void setGlobalElement(boolean isGlobalElement) {
        this.isGlobalElement = isGlobalElement;
    }

    public TypeInfo getParentCollectionType() {
        return this.parentCollectionType;
    }

    public void setParentCollectionType(TypeInfo parentCollectionType) {
        this.parentCollectionType = parentCollectionType;
    }

    public boolean isRepeatedElement() {
        return this.parentCollectionType != null;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    public String toString() {
        return "TypeInfo: Type = " + this.type + ", tag = " + this.tagName;
    }
}

