/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.connections.common.RemoteUtils;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.runconfigs.RunConfigRemote;
import org.netbeans.modules.php.project.runconfigs.validation.RunConfigRemoteValidator;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.Bundle;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsPanel;
import org.netbeans.modules.php.project.ui.customizer.RunAsWebAdvanced;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public final class RunAsRemoteWeb
extends RunAsPanel.InsidePanel {
    private static final long serialVersionUID = 1654646512354658L;
    private static final PhpProjectProperties.UploadFiles DEFAULT_UPLOAD_FILES = PhpProjectProperties.UploadFiles.ON_RUN;
    final PhpProjectProperties properties;
    final PhpProject project;
    final ProjectCustomizer.Category category;
    private final JLabel[] labels;
    private final JTextField[] textFields;
    private final String[] propertyNames;
    private JButton advancedButton;
    private JLabel argsLabel;
    private JTextField argsTextField;
    private JButton indexFileBrowseButton;
    private JLabel indexFileLabel;
    private JTextField indexFileTextField;
    private JButton manageRemoteConnectionButton;
    private JCheckBox preservePermissionsCheckBox;
    private JLabel preservePermissionsLabel;
    private JComboBox<RemoteConfiguration> remoteConnectionComboBox;
    private JLabel remoteConnectionHintLabel;
    private JLabel remoteConnectionLabel;
    private JComboBox<String> runAsComboBox;
    private JLabel runAsLabel;
    private JCheckBox uploadDirectlyCheckBox;
    private JLabel uploadDirectlyLabel;
    private JLabel uploadDirectoryLabel;
    private JTextField uploadDirectoryTextField;
    private JComboBox<PhpProjectProperties.UploadFiles> uploadFilesComboBox;
    private JLabel uploadFilesHintLabel;
    private JLabel uploadFilesLabel;
    private JTextPane urlHintLabel;
    private JLabel urlLabel;
    private JTextField urlTextField;

    public RunAsRemoteWeb(PhpProjectProperties properties, ConfigManager manager, ProjectCustomizer.Category category) {
        super(manager);
        this.properties = properties;
        this.category = category;
        this.project = properties.getProject();
        this.initComponents();
        this.labels = new JLabel[]{this.urlLabel, this.indexFileLabel, this.argsLabel, this.uploadDirectoryLabel};
        this.textFields = new JTextField[]{this.urlTextField, this.indexFileTextField, this.argsTextField, this.uploadDirectoryTextField};
        this.propertyNames = new String[]{"url", "index.file", "script.arguments", "remote.directory"};
        assert (this.labels.length == this.textFields.length && this.labels.length == this.propertyNames.length);
        this.populateRemoteConnectionComboBox();
        this.remoteConnectionComboBox.setRenderer(new RemoteConnectionRenderer());
        this.remoteConnectionComboBox.setKeySelectionManager(RemoteUtils.createRemoteConfigurationKeySelectionManager());
        for (PhpProjectProperties.UploadFiles uploadFiles : PhpProjectProperties.UploadFiles.values()) {
            this.uploadFilesComboBox.addItem(uploadFiles);
        }
        this.uploadFilesComboBox.setRenderer(new RemoteUploadRenderer());
        this.registerListeners();
    }

    private void registerListeners() {
        for (int i = 0; i < this.textFields.length; ++i) {
            FieldUpdater dl = new FieldUpdater(this.propertyNames[i], this.labels[i], this.textFields[i]);
            this.textFields[i].getDocument().addDocumentListener(dl);
        }
        ComboBoxSelectedItemConvertor remoteConfigurationConvertor = new ComboBoxSelectedItemConvertor(){

            @Override
            public String convert(JComboBox comboBox) {
                RemoteConfiguration remoteConfiguration = (RemoteConfiguration)comboBox.getSelectedItem();
                assert (remoteConfiguration != null);
                return remoteConfiguration.getName();
            }
        };
        this.remoteConnectionComboBox.addActionListener(new ComboBoxUpdater("remote.connection", this.remoteConnectionLabel, this.remoteConnectionComboBox, remoteConfigurationConvertor));
        ComboBoxSelectedItemConvertor remoteUploadConvertor = new ComboBoxSelectedItemConvertor(){

            @Override
            public String convert(JComboBox comboBox) {
                PhpProjectProperties.UploadFiles uploadFiles = (PhpProjectProperties.UploadFiles)((Object)comboBox.getSelectedItem());
                assert (uploadFiles != null);
                RunAsRemoteWeb.this.uploadFilesHintLabel.setText(uploadFiles.getDescription());
                return uploadFiles.name();
            }
        };
        this.uploadFilesComboBox.addActionListener(new ComboBoxUpdater("remote.upload", this.uploadFilesLabel, this.uploadFilesComboBox, remoteUploadConvertor));
        this.remoteConnectionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RunAsRemoteWeb.this.updateRemoteConnectionHint();
                }
            }
        });
        this.uploadDirectoryTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                RunAsRemoteWeb.this.updateRemoteConnectionHint();
            }
        });
        this.updateRemoteConnectionHint();
        this.preservePermissionsCheckBox.addActionListener(new CheckBoxUpdater("remote.permissions", this.preservePermissionsCheckBox));
        this.uploadDirectlyCheckBox.addActionListener(new CheckBoxUpdater("remote.upload.directly", this.uploadDirectlyCheckBox));
    }

    @Override
    protected PhpProjectProperties.RunAsType getRunAsType() {
        return RunConfigRemote.getRunAsType();
    }

    @Override
    protected String getDisplayName() {
        return RunConfigRemote.getDisplayName();
    }

    @Override
    protected JComboBox<String> getRunAsCombo() {
        return this.runAsComboBox;
    }

    @Override
    protected JLabel getRunAsLabel() {
        return this.runAsLabel;
    }

    @Override
    protected void loadFields() {
        for (int i = 0; i < this.textFields.length; ++i) {
            this.textFields[i].setText(this.getValue(this.propertyNames[i]));
        }
        this.selectRemoteConnection();
        PhpProjectProperties.UploadFiles uploadFiles = null;
        String remoteUpload = this.getValue("remote.upload");
        if (remoteUpload == null) {
            uploadFiles = DEFAULT_UPLOAD_FILES;
        } else {
            try {
                uploadFiles = PhpProjectProperties.UploadFiles.valueOf(remoteUpload);
            }
            catch (IllegalArgumentException iae) {
                uploadFiles = DEFAULT_UPLOAD_FILES;
            }
        }
        this.uploadFilesComboBox.setSelectedItem((Object)uploadFiles);
        boolean preservePermissions = Boolean.parseBoolean(this.getValue("remote.permissions"));
        this.preservePermissionsCheckBox.setSelected(preservePermissions);
        boolean uploadDirectly = Boolean.parseBoolean(this.getValue("remote.upload.directly"));
        this.uploadDirectlyCheckBox.setSelected(uploadDirectly);
    }

    @Override
    protected void validateFields() {
        this.category.setErrorMessage(RunConfigRemoteValidator.validateCustomizer(this.createRunConfig()));
        this.category.setValid(true);
    }

    RunConfigRemote createRunConfig() {
        return ((RunConfigRemote)((RunConfigRemote)((RunConfigRemote)((RunConfigRemote)RunConfigRemote.create().setUrl(this.urlTextField.getText())).setIndexParentDir(this.getWebRoot())).setIndexRelativePath(this.indexFileTextField.getText())).setArguments(this.argsTextField.getText())).setRemoteConfiguration((RemoteConfiguration)this.remoteConnectionComboBox.getSelectedItem()).setUploadDirectory(this.uploadDirectoryTextField.getText()).setUploadFilesType((PhpProjectProperties.UploadFiles)((Object)this.uploadFilesComboBox.getSelectedItem())).setPermissionsPreserved(this.preservePermissionsCheckBox.isSelected()).setUploadDirectly(this.uploadDirectlyCheckBox.isSelected());
    }

    private File getWebRoot() {
        return ProjectPropertiesSupport.getSourceSubdirectory(this.project, this.properties.getWebRoot());
    }

    private void populateRemoteConnectionComboBox() {
        List<RemoteConfiguration> connections = RemoteConnections.get().getRemoteConfigurations();
        if (connections.isEmpty()) {
            connections = Arrays.asList(RunConfigRemote.NO_REMOTE_CONFIGURATION);
        }
        DefaultComboBoxModel<RemoteConfiguration> model = new DefaultComboBoxModel<RemoteConfiguration>(new Vector<RemoteConfiguration>(connections));
        this.remoteConnectionComboBox.setModel(model);
    }

    private void selectRemoteConnection() {
        this.selectRemoteConnection(null);
    }

    private void selectRemoteConnection(String remoteConnection) {
        if (remoteConnection == null) {
            remoteConnection = this.getValue("remote.connection");
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.remoteConnectionComboBox.getModel();
        if (remoteConnection == null || "no-config".equals(remoteConnection)) {
            if (model.getIndexOf(RunConfigRemote.NO_REMOTE_CONFIGURATION) < 0) {
                model.insertElementAt(RunConfigRemote.NO_REMOTE_CONFIGURATION, 0);
            }
            this.remoteConnectionComboBox.setSelectedItem(RunConfigRemote.NO_REMOTE_CONFIGURATION);
            return;
        }
        int size = this.remoteConnectionComboBox.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            RemoteConfiguration rc = this.remoteConnectionComboBox.getItemAt(i);
            if (!remoteConnection.equals(rc.getName())) continue;
            this.remoteConnectionComboBox.setSelectedItem(rc);
            return;
        }
        this.remoteConnectionComboBox.addItem(RunConfigRemote.MISSING_REMOTE_CONFIGURATION);
        this.remoteConnectionComboBox.setSelectedItem(RunConfigRemote.MISSING_REMOTE_CONFIGURATION);
        model.removeElement(RunConfigRemote.NO_REMOTE_CONFIGURATION);
    }

    void updateRemoteConnectionHint() {
        String hint = this.createRunConfig().getRemoteConnectionHint();
        this.remoteConnectionHintLabel.setText(hint != null ? "<html><body>" + hint : " ");
    }

    private void initComponents() {
        this.runAsLabel = new JLabel();
        this.runAsComboBox = new JComboBox();
        this.urlLabel = new JLabel();
        this.urlTextField = new JTextField();
        this.indexFileLabel = new JLabel();
        this.indexFileTextField = new JTextField();
        this.indexFileBrowseButton = new JButton();
        this.argsLabel = new JLabel();
        this.argsTextField = new JTextField();
        this.urlHintLabel = new JTextPane();
        this.remoteConnectionLabel = new JLabel();
        this.remoteConnectionComboBox = new JComboBox();
        this.manageRemoteConnectionButton = new JButton();
        this.uploadDirectoryLabel = new JLabel();
        this.uploadDirectoryTextField = new JTextField();
        this.remoteConnectionHintLabel = new JLabel();
        this.uploadFilesLabel = new JLabel();
        this.uploadFilesComboBox = new JComboBox();
        this.uploadFilesHintLabel = new JLabel();
        this.preservePermissionsCheckBox = new JCheckBox();
        this.preservePermissionsLabel = new JLabel();
        this.uploadDirectlyCheckBox = new JCheckBox();
        this.uploadDirectlyLabel = new JLabel();
        this.advancedButton = new JButton();
        this.runAsLabel.setLabelFor(this.runAsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.runAsLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_RunAs"));
        this.urlLabel.setLabelFor(this.urlTextField);
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_ProjectUrl"));
        this.urlTextField.setColumns(20);
        this.indexFileLabel.setLabelFor(this.indexFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.indexFileLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_IndexFile"));
        Mnemonics.setLocalizedText((AbstractButton)this.indexFileBrowseButton, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_Browse"));
        this.indexFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAsRemoteWeb.this.indexFileBrowseButtonActionPerformed(evt);
            }
        });
        this.argsLabel.setLabelFor(this.argsTextField);
        Mnemonics.setLocalizedText((JLabel)this.argsLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_Arguments"));
        this.argsTextField.setColumns(20);
        this.urlHintLabel.setEditable(false);
        this.urlHintLabel.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.urlHintLabel.setBorder(null);
        this.urlHintLabel.setFocusable(false);
        this.remoteConnectionLabel.setLabelFor(this.remoteConnectionComboBox);
        Mnemonics.setLocalizedText((JLabel)this.remoteConnectionLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_RemoteConnection"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageRemoteConnectionButton, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_Manage"));
        this.manageRemoteConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAsRemoteWeb.this.manageRemoteConnectionButtonActionPerformed(evt);
            }
        });
        this.uploadDirectoryLabel.setLabelFor(this.uploadDirectoryTextField);
        Mnemonics.setLocalizedText((JLabel)this.uploadDirectoryLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_UploadDirectory"));
        this.uploadDirectoryTextField.setColumns(20);
        this.remoteConnectionHintLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.remoteConnectionHintLabel, (String)"dummy");
        this.uploadFilesLabel.setLabelFor(this.uploadFilesComboBox);
        Mnemonics.setLocalizedText((JLabel)this.uploadFilesLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_UploadFiles"));
        this.uploadFilesHintLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.uploadFilesHintLabel, (String)"dummy");
        Mnemonics.setLocalizedText((AbstractButton)this.preservePermissionsCheckBox, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.preservePermissionsCheckBox.text"));
        this.preservePermissionsLabel.setLabelFor(this.preservePermissionsCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.preservePermissionsLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.preservePermissionsLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.uploadDirectlyCheckBox, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectlyCheckBox.text"));
        this.uploadDirectlyLabel.setLabelFor(this.uploadDirectlyCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.uploadDirectlyLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectlyLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.advancedButton, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.advancedButton.text"));
        this.advancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAsRemoteWeb.this.advancedButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.remoteConnectionLabel).addComponent(this.uploadDirectoryLabel).addComponent(this.uploadFilesLabel).addComponent(this.urlLabel).addComponent(this.runAsLabel).addComponent(this.indexFileLabel).addComponent(this.argsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.urlHintLabel).addComponent(this.urlTextField, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.indexFileTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.indexFileBrowseButton)).addComponent(this.argsTextField, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.remoteConnectionComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.manageRemoteConnectionButton)).addComponent(this.uploadDirectoryTextField).addComponent(this.uploadFilesComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.runAsComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.advancedButton, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.remoteConnectionHintLabel).addComponent(this.uploadFilesHintLabel)).addContainerGap()))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.preservePermissionsCheckBox).addComponent(this.uploadDirectlyCheckBox).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.preservePermissionsLabel).addComponent(this.uploadDirectlyLabel)))).addContainerGap()));
        layout.linkSize(0, this.indexFileBrowseButton, this.manageRemoteConnectionButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.runAsLabel).addComponent(this.runAsComboBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.urlLabel).addComponent(this.urlTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.indexFileLabel).addComponent(this.indexFileTextField, -2, -1, -2).addComponent(this.indexFileBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.argsLabel).addComponent(this.argsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.urlHintLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.remoteConnectionLabel).addComponent(this.manageRemoteConnectionButton).addComponent(this.remoteConnectionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.uploadDirectoryLabel).addComponent(this.uploadDirectoryTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.remoteConnectionHintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.uploadFilesLabel).addComponent(this.uploadFilesComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.uploadFilesHintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.preservePermissionsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.preservePermissionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.uploadDirectlyCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.uploadDirectlyLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.advancedButton)));
        this.runAsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.runAsLabel.AccessibleContext.accessibleName"));
        this.runAsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.runAsLabel.AccessibleContext.accessibleDescription"));
        this.runAsComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.runAsComboBox.AccessibleContext.accessibleName"));
        this.runAsComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.runAsComboBox.AccessibleContext.accessibleDescription"));
        this.urlLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlLabel.AccessibleContext.accessibleName"));
        this.urlLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlLabel.AccessibleContext.accessibleDescription"));
        this.urlTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlTextField.AccessibleContext.accessibleName"));
        this.urlTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlTextField.AccessibleContext.accessibleDescription"));
        this.indexFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileLabel.AccessibleContext.accessibleName"));
        this.indexFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileLabel.AccessibleContext.accessibleDescription"));
        this.indexFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileTextField.AccessibleContext.accessibleName"));
        this.indexFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileTextField.AccessibleContext.accessibleDescription"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileBrowseButton.AccessibleContext.accessibleName"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileBrowseButton.AccessibleContext.accessibleDescription"));
        this.argsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.argsLabel.AccessibleContext.accessibleName"));
        this.argsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.argsLabel.AccessibleContext.accessibleDescription"));
        this.argsTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.argsTextField.AccessibleContext.accessibleName"));
        this.argsTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.argsTextField.AccessibleContext.accessibleDescription"));
        this.urlHintLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.jTextPane1.AccessibleContext.accessibleName"));
        this.urlHintLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.jTextPane1.AccessibleContext.accessibleDescription"));
        this.remoteConnectionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionLabel.AccessibleContext.accessibleName"));
        this.remoteConnectionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionLabel.AccessibleContext.accessibleDescription"));
        this.remoteConnectionComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionComboBox.AccessibleContext.accessibleName"));
        this.remoteConnectionComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionComboBox.AccessibleContext.accessibleDescription"));
        this.manageRemoteConnectionButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.manageRemoteConnectionButton.AccessibleContext.accessibleName"));
        this.manageRemoteConnectionButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.manageRemoteConnectionButton.AccessibleContext.accessibleDescription"));
        this.uploadDirectoryLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectoryLabel.AccessibleContext.accessibleName"));
        this.uploadDirectoryLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectoryLabel.AccessibleContext.accessibleDescription"));
        this.uploadDirectoryTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectoryTextField.AccessibleContext.accessibleName"));
        this.uploadDirectoryTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectoryTextField.AccessibleContext.accessibleDescription"));
        this.remoteConnectionHintLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionHintLabel.AccessibleContext.accessibleName"));
        this.remoteConnectionHintLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionHintLabel.AccessibleContext.accessibleDescription"));
        this.uploadFilesLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesLabel.AccessibleContext.accessibleName"));
        this.uploadFilesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesLabel.AccessibleContext.accessibleDescription"));
        this.uploadFilesComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesComboBox.AccessibleContext.accessibleName"));
        this.uploadFilesComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesComboBox.AccessibleContext.accessibleDescription"));
        this.uploadFilesHintLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesHintLabel.AccessibleContext.accessibleName"));
        this.uploadFilesHintLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesHintLabel.AccessibleContext.accessibleDescription"));
        this.preservePermissionsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.preservePermissionsCheckBox.AccessibleContext.accessibleName"));
        this.preservePermissionsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.preservePermissionsCheckBox.AccessibleContext.accessibleDescription"));
        this.preservePermissionsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.preservePermissionsLabel.AccessibleContext.accessibleName"));
        this.preservePermissionsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.preservePermissionsLabel.AccessibleContext.accessibleDescription"));
        this.uploadDirectlyCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectlyCheckBox.AccessibleContext.accessibleName"));
        this.uploadDirectlyCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectlyCheckBox.AccessibleContext.accessibleDescription"));
        this.uploadDirectlyLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectlyLabel.AccessibleContext.accessibleName"));
        this.uploadDirectlyLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectlyLabel.AccessibleContext.accessibleDescription"));
        this.advancedButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.advancedButton.AccessibleContext.accessibleName"));
        this.advancedButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.advancedButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.AccessibleContext.accessibleDescription"));
    }

    private void manageRemoteConnectionButtonActionPerformed(ActionEvent evt) {
        if (RemoteConnections.get().openManager((RemoteConfiguration)this.remoteConnectionComboBox.getSelectedItem())) {
            this.populateRemoteConnectionComboBox();
            String selected = null;
            ComboBoxModel<RemoteConfiguration> model = this.remoteConnectionComboBox.getModel();
            if (model.getSize() == 1) {
                selected = ((RemoteConfiguration)model.getElementAt(0)).getName();
            }
            this.selectRemoteConnection(selected);
            this.updateRemoteConnectionHint();
        }
    }

    private void indexFileBrowseButtonActionPerformed(ActionEvent evt) {
        try {
            Utils.browseFolderFile(PhpVisibilityQuery.forProject(this.project), this.getWebRoot(), this.indexFileTextField);
        }
        catch (FileNotFoundException ex) {
            this.category.setErrorMessage(Bundle.RunAsRemoteWeb_webRoot_notFound());
            this.category.setValid(true);
        }
    }

    private void advancedButtonActionPerformed(ActionEvent evt) {
        RunAsWebAdvanced.Properties props = new RunAsWebAdvanced.Properties(this.getValue("debug.url"), this.urlHintLabel.getText(), this.getValue("debug.path.mapping.remote"), this.getValue("debug.path.mapping.local"), this.getValue("debug.proxy.host"), this.getValue("debug.proxy.port"));
        RunAsWebAdvanced advanced = new RunAsWebAdvanced(this.project, props);
        if (advanced.open()) {
            Pair<String, String> pathMapping = advanced.getPathMapping();
            Pair<String, String> debugProxy = advanced.getDebugProxy();
            this.putValue("debug.url", advanced.getDebugUrl().name());
            this.putValue("debug.path.mapping.remote", (String)pathMapping.first());
            this.putValue("debug.path.mapping.local", (String)pathMapping.second());
            this.putValue("debug.proxy.host", (String)debugProxy.first());
            this.putValue("debug.proxy.port", (String)debugProxy.second());
        }
    }

    public static class RemoteUploadRenderer
    extends JLabel
    implements ListCellRenderer<PhpProjectProperties.UploadFiles>,
    UIResource {
        private static final long serialVersionUID = 5867432135478679120L;

        public RemoteUploadRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends PhpProjectProperties.UploadFiles> list, PhpProjectProperties.UploadFiles value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value != null) {
                this.setText(value.getLabel());
            }
            this.setIcon(null);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    public static class RemoteConnectionRenderer
    extends JLabel
    implements ListCellRenderer<RemoteConfiguration>,
    UIResource {
        private static final long serialVersionUID = 14547687982567897L;

        public RemoteConnectionRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends RemoteConfiguration> list, RemoteConfiguration value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            String text = null;
            Color foreground = null;
            if (value != null) {
                RemoteConfiguration remoteConfig = value;
                text = remoteConfig.getDisplayName();
                foreground = this.getForeground(remoteConfig, list, isSelected);
            }
            this.setText(text);
            this.setIcon(null);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setBackground(list.getBackground());
            }
            if (foreground != null) {
                this.setForeground(foreground);
            }
            return this;
        }

        private Color getForeground(RemoteConfiguration remoteConfig, JList list, boolean isSelected) {
            if (remoteConfig == RunConfigRemote.MISSING_REMOTE_CONFIGURATION || remoteConfig == RunConfigRemote.NO_REMOTE_CONFIGURATION) {
                return UIManager.getColor("nb.errorForeground");
            }
            return isSelected ? list.getSelectionForeground() : list.getForeground();
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private class CheckBoxUpdater
    implements ActionListener {
        private final JCheckBox field;
        private final String propName;

        public CheckBoxUpdater(String propName, JCheckBox field) {
            this.field = field;
            this.propName = propName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String value = Boolean.toString(this.field.isSelected());
            RunAsRemoteWeb.this.putValue(this.propName, value);
            RunAsRemoteWeb.this.markAsModified(this.field, this.propName, value);
            RunAsRemoteWeb.this.validateFields();
        }
    }

    private class ComboBoxUpdater
    implements ActionListener {
        private final JLabel label;
        private final JComboBox field;
        private final String propName;
        private final ComboBoxSelectedItemConvertor comboBoxConvertor;

        public ComboBoxUpdater(String propName, JLabel label, JComboBox field, ComboBoxSelectedItemConvertor comboBoxConvertor) {
            this.propName = propName;
            this.label = label;
            this.field = field;
            this.comboBoxConvertor = comboBoxConvertor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String value = this.comboBoxConvertor.convert(this.field);
            RunAsRemoteWeb.this.putValue(this.propName, value);
            RunAsRemoteWeb.this.markAsModified(this.label, this.propName, value);
            RunAsRemoteWeb.this.validateFields();
        }
    }

    static interface ComboBoxSelectedItemConvertor {
        public String convert(JComboBox var1);
    }

    private class FieldUpdater
    extends RunAsPanel.InsidePanel.TextFieldUpdater {
        public FieldUpdater(String propName, JLabel label, JTextField field) {
            super(propName, label, field);
        }

        @Override
        protected String getPropValue() {
            String value = super.getPropValue();
            if (this.getPropName().equals("remote.directory")) {
                value = RemoteUtils.sanitizeUploadDirectory(value, true);
            }
            return value;
        }

        @Override
        protected final String getDefaultValue() {
            return RunAsRemoteWeb.this.getDefaultValue(this.getPropName());
        }

        @Override
        protected void processUpdate() {
            super.processUpdate();
            RunAsRemoteWeb.this.urlHintLabel.setText(RunAsRemoteWeb.this.createRunConfig().getUrlHint());
        }
    }
}

