/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony.ui.actions;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.php.symfony.ui.actions.SymfonyGoToViewActionPopup;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SymfonyGoToViewActionPanel
extends JPanel
implements FocusListener {
    private static final long serialVersionUID = 874543213245676L;
    private final List<FileObject> views;
    private final SymfonyGoToViewActionPopup popup;
    private JScrollPane jScrollPane1;
    private JLabel titleLabel;
    private JList<SymfonyViewItem> viewsList;

    public SymfonyGoToViewActionPanel(List<FileObject> views, SymfonyGoToViewActionPopup popup) {
        this.views = views;
        this.popup = popup;
        this.initComponents();
        this.viewsList.setCursor(Cursor.getPredefinedCursor(12));
        this.addFocusListener(this);
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.viewsList = new JList();
        this.setFocusCycleRoot(true);
        this.setLayout(new GridBagLayout());
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText(NbBundle.getMessage(SymfonyGoToViewActionPanel.class, (String)"SymfonyGoToViewActionPanel.titleLabel.text"));
        this.titleLabel.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.titleLabel, gridBagConstraints);
        this.viewsList.setModel(this.createListModel());
        this.viewsList.setSelectedIndex(0);
        this.viewsList.setVisibleRowCount(this.views.size());
        this.viewsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SymfonyGoToViewActionPanel.this.viewsListMouseClicked(evt);
            }
        });
        this.viewsList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SymfonyGoToViewActionPanel.this.viewsListKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.viewsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void viewsListKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && evt.getModifiers() == 0) {
            this.openSelected();
        }
    }

    private void viewsListMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 1) {
            this.openSelected();
        }
    }

    private void openSelected() {
        FileObject fo;
        SymfonyViewItem view = this.viewsList.getSelectedValue();
        if (view != null && (fo = view.getFileObject()) != null) {
            UiUtils.open((FileObject)fo, (int)0);
        }
        this.popup.hide();
    }

    private ListModel<SymfonyViewItem> createListModel() {
        DefaultListModel<SymfonyViewItem> dlm = new DefaultListModel<SymfonyViewItem>();
        for (FileObject view : this.views) {
            dlm.addElement(new SymfonyViewItem(view));
        }
        return dlm;
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.viewsList.requestFocus();
        this.viewsList.requestFocusInWindow();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }

    private static class SymfonyViewItem {
        private FileObject view;

        public SymfonyViewItem(FileObject view) {
            this.view = view;
        }

        public FileObject getFileObject() {
            return this.view;
        }

        public String toString() {
            return this.view.getNameExt();
        }
    }
}

