/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.Collections;
import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class ClassDeclaration
extends TypeDeclaration {
    private Modifier modifier;
    private Expression superClass;

    private ClassDeclaration(int start, int end, Modifier modifier, Identifier className, Expression superClass, Expression[] interfaces, Block body, List<Attribute> attributes) {
        super(start, end, className, interfaces, body, attributes);
        this.modifier = modifier;
        this.superClass = superClass;
    }

    private ClassDeclaration(int start, int end, Modifier modifier, Identifier className, Expression superClass, List<Expression> interfaces, Block body, List<Attribute> attributes) {
        this(start, end, modifier, className, superClass, interfaces == null ? null : interfaces.toArray(new Expression[interfaces.size()]), body, attributes);
    }

    public ClassDeclaration(int start, int end, Modifier modifier, Identifier className, Expression superClass, List<Expression> interfaces, Block body) {
        this(start, end, modifier, className, superClass, interfaces, body, Collections.emptyList());
    }

    public static ClassDeclaration create(ClassDeclaration declaration, List<Attribute> attributes) {
        assert (attributes != null);
        int start = attributes.isEmpty() ? declaration.getStartOffset() : attributes.get(0).getStartOffset();
        return new ClassDeclaration(start, declaration.getEndOffset(), declaration.getModifier(), declaration.getName(), declaration.getSuperClass(), declaration.getInterfaes(), declaration.getBody(), attributes);
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public Expression getSuperClass() {
        return this.superClass;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        StringBuilder sbAttributes = new StringBuilder();
        this.getAttributes().forEach(attribute -> sbAttributes.append(attribute).append(" "));
        StringBuilder sb = new StringBuilder();
        for (Expression expression : this.getInterfaes()) {
            sb.append(expression).append(",");
        }
        return sbAttributes.toString() + (Object)((Object)this.getModifier()) + "class " + this.getName() + " extends " + this.getSuperClass() + " implements " + sb + this.getBody();
    }

    public static enum Modifier {
        NONE,
        ABSTRACT,
        FINAL;

    }
}

