/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.sharability;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation2;
import org.netbeans.spi.project.libraries.LibraryStorageArea;
import org.openide.util.NbCollections;

class ServerVolumeContentModel
extends AbstractListModel {
    private LibraryImplementation impl;
    private LibraryImplementation2 impl2;
    private LibraryStorageArea area;
    private String volumeType;
    private List<Object> content;

    public ServerVolumeContentModel(LibraryImplementation impl, LibraryStorageArea area, String volumeType) {
        this.impl = impl;
        this.area = area;
        this.volumeType = volumeType;
        if (impl instanceof LibraryImplementation2) {
            this.impl2 = (LibraryImplementation2)impl;
        }
        if (this.impl2 != null) {
            List l = this.impl2.getURIContent(volumeType);
            if (l != null) {
                this.content = new ArrayList<Object>(l);
            }
        } else {
            List l = this.impl.getContent(volumeType);
            if (l != null) {
                this.content = new ArrayList<Object>(l);
            }
        }
        if (this.content == null) {
            this.content = new ArrayList<Object>();
        }
    }

    public LibraryStorageArea getArea() {
        return this.area;
    }

    @Override
    public int getSize() {
        return this.content.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (index < 0 || index >= this.content.size()) {
            throw new IllegalArgumentException();
        }
        return this.content.get(index);
    }

    public void addResource(URL resource) {
        assert (this.impl2 == null);
        this.content.add(resource);
        int index = this.content.size() - 1;
        this.propagateContent();
        this.fireIntervalAdded(this, index, index);
    }

    public void addResource(URI resource) {
        assert (this.impl2 != null);
        this.content.add(resource);
        int index = this.content.size() - 1;
        this.propagateContent();
        this.fireIntervalAdded(this, index, index);
    }

    private void propagateContent() {
        if (this.impl2 != null) {
            this.impl2.setURIContent(this.volumeType, NbCollections.checkedListByCopy(this.content, URI.class, (boolean)true));
        } else {
            this.impl.setContent(this.volumeType, NbCollections.checkedListByCopy(this.content, URL.class, (boolean)true));
        }
    }

    public void removeResources(int[] indices) {
        for (int i = indices.length - 1; i >= 0; --i) {
            this.content.remove(indices[i]);
        }
        this.propagateContent();
        this.fireIntervalRemoved(this, indices[0], indices[indices.length - 1]);
    }

    public void moveUp(int[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            Object value = this.content.remove(indices[i]);
            this.content.add(indices[i] - 1, value);
        }
        this.propagateContent();
        this.fireContentsChanged(this, indices[0] - 1, indices[indices.length - 1]);
    }

    public void moveDown(int[] indices) {
        for (int i = indices.length - 1; i >= 0; --i) {
            Object value = this.content.remove(indices[i]);
            this.content.add(indices[i] + 1, value);
        }
        this.propagateContent();
        this.fireContentsChanged(this, indices[0], indices[indices.length - 1] + 1);
    }
}

