/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.locks;

import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.results.locks.LockCCTNode;
import org.netbeans.lib.profiler.results.locks.MonitorInfo;

class MonitorCCTNode
extends LockCCTNode {
    private static final String WAIT_THREADS_LBL;
    private static final String WAIT_THREADS_OWNER_LBL;
    private static final String OWNER_THREADS_LBL;
    private static final String OWNER_THREADS_WAIT_LBL;
    private final MonitorInfo monitor;
    private final List<MonitorInfo.ThreadDetail> waitThreads;
    private final List<MonitorInfo.ThreadDetail> ownerThreads;
    private ThreadsCCTNode waitNode;
    private long allTime;
    private long allCount;

    MonitorCCTNode(LockCCTNode top, MonitorInfo key, List<List<MonitorInfo.ThreadDetail>> value) {
        super(top);
        assert (value.size() == 2);
        this.monitor = key;
        this.waitThreads = value.get(0);
        this.ownerThreads = value.get(1);
    }

    @Override
    public String getNodeName() {
        return this.monitor.getName();
    }

    @Override
    public long getTime() {
        if (this.allTime == 0L) {
            this.summarize();
        }
        return this.allTime;
    }

    @Override
    public long getWaits() {
        if (this.allCount == 0L) {
            this.summarize();
        }
        return this.allCount;
    }

    @Override
    public boolean isMonitorNode() {
        return true;
    }

    public int hashCode() {
        return this.monitor.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MonitorCCTNode) {
            return this.monitor.equals(((MonitorCCTNode)obj).monitor);
        }
        return false;
    }

    private void summarize() {
        this.getChildren();
        if (this.waitNode != null) {
            this.allTime = this.waitNode.getTime();
            this.allCount = this.waitNode.getWaits();
        }
    }

    @Override
    void computeChildren() {
        super.computeChildren();
        if (!this.waitThreads.isEmpty()) {
            this.waitNode = new ThreadsCCTNode(this, WAIT_THREADS_LBL, WAIT_THREADS_OWNER_LBL, this.waitThreads);
            this.addChild(this.waitNode);
        }
        if (!this.ownerThreads.isEmpty()) {
            this.addChild(new ThreadsCCTNode(this, OWNER_THREADS_LBL, OWNER_THREADS_WAIT_LBL, this.ownerThreads));
        }
    }

    static {
        ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.locks.Bundle");
        WAIT_THREADS_LBL = messages.getString("MonitorCCTNode_WaitThreads");
        WAIT_THREADS_OWNER_LBL = messages.getString("MonitorCCTNode_WaitThreadsOwner");
        OWNER_THREADS_LBL = messages.getString("MonitorCCTNode_OwnerThreads");
        OWNER_THREADS_WAIT_LBL = messages.getString("MonitorCCTNode_OwnerThreadsWait");
    }

    static class ThreadDetailLockCCTNode
    extends LockCCTNode {
        private final MonitorInfo.ThreadDetail threadDetail;
        private final String threadNameFormat;
        private final boolean useFormat;

        ThreadDetailLockCCTNode(LockCCTNode p, String nf, boolean uf, MonitorInfo.ThreadDetail td) {
            super(p);
            this.threadDetail = td;
            this.threadNameFormat = nf;
            this.useFormat = uf;
        }

        ThreadDetailLockCCTNode(LockCCTNode p, String nf, MonitorInfo.ThreadDetail td) {
            this(p, nf, true, td);
        }

        @Override
        public boolean isThreadLockNode() {
            return true;
        }

        @Override
        public String getNodeName() {
            String name = this.threadDetail.threadInfo.getName();
            if (this.threadNameFormat != null && this.useFormat) {
                name = MessageFormat.format(this.threadNameFormat, name);
            }
            return name;
        }

        @Override
        public long getTime() {
            return this.threadDetail.waitTime;
        }

        @Override
        public long getWaits() {
            return this.threadDetail.count;
        }

        public int hashCode() {
            return this.threadDetail.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ThreadDetailLockCCTNode) {
                ThreadDetailLockCCTNode tn = (ThreadDetailLockCCTNode)obj;
                return this.threadDetail.threadInfo.equals(tn.threadDetail.threadInfo) && this.getParent().equals(tn.getParent());
            }
            return false;
        }

        @Override
        void computeChildren() {
            super.computeChildren();
            for (MonitorInfo.ThreadDetail td : this.threadDetail.cloneThreadDetails()) {
                this.addChild(new ThreadDetailLockCCTNode(this, this.threadNameFormat, td));
            }
        }
    }

    static class ThreadsCCTNode
    extends LockCCTNode {
        private final List<MonitorInfo.ThreadDetail> threads;
        private final String name;
        private final String threadNameFormat;
        private long allTime;
        private long allCount;

        ThreadsCCTNode(MonitorCCTNode p, String n, String tnf, List<MonitorInfo.ThreadDetail> ths) {
            super(p);
            this.name = n;
            this.threadNameFormat = tnf;
            this.threads = ths;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        public long getTime() {
            if (this.allTime == 0L) {
                this.summarize();
            }
            return this.allTime;
        }

        @Override
        public long getWaits() {
            if (this.allCount == 0L) {
                this.summarize();
            }
            return this.allCount;
        }

        @Override
        void computeChildren() {
            super.computeChildren();
            for (MonitorInfo.ThreadDetail td : this.threads) {
                this.addChild(new ThreadDetailLockCCTNode(this, this.threadNameFormat, false, td));
            }
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ThreadsCCTNode) {
                ThreadsCCTNode tn = (ThreadsCCTNode)obj;
                return this.name.equals(tn.name) && this.getParent().equals(tn.getParent());
            }
            return false;
        }

        private void summarize() {
            for (MonitorInfo.ThreadDetail td : this.threads) {
                this.allTime += td.waitTime;
                this.allCount += td.count;
            }
        }
    }
}

