/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.joni.Option;
import org.joni.Regex;
import org.joni.Region;
import org.joni.SearchAlgorithm;

public abstract class Matcher
extends IntHolder {
    public static final int FAILED = -1;
    public static final int INTERRUPTED = -2;
    protected final Regex regex;
    protected final Encoding enc;
    protected final byte[] bytes;
    protected final int str;
    protected final int end;
    protected int msaStart;
    protected int msaOptions;
    protected final Region msaRegion;
    protected int msaBestLen;
    protected int msaBestS;
    protected int msaBegin;
    protected int msaEnd;
    int low;
    int high;
    private byte[] icbuf;

    public Matcher(Regex regex, byte[] bytes) {
        this(regex, bytes, 0, bytes.length);
    }

    public Matcher(Regex regex, byte[] bytes, int p, int end) {
        this.regex = regex;
        this.enc = regex.enc;
        this.bytes = bytes;
        this.str = p;
        this.end = end;
        this.msaRegion = regex.numMem == 0 ? null : new Region(regex.numMem + 1);
    }

    protected abstract int matchAt(int var1, int var2, int var3) throws InterruptedException;

    protected abstract void stateCheckBuffInit(int var1, int var2, int var3);

    protected abstract void stateCheckBuffClear();

    public final Region getRegion() {
        return this.msaRegion;
    }

    public final Region getEagerRegion() {
        return this.msaRegion != null ? this.msaRegion : new Region(this.msaBegin, this.msaEnd);
    }

    public final int getBegin() {
        return this.msaBegin;
    }

    public final int getEnd() {
        return this.msaEnd;
    }

    protected final void msaInit(int option, int start) {
        this.msaOptions = option;
        this.msaStart = start;
        this.msaBestLen = -1;
    }

    public final int match(int at, int range, int option) {
        try {
            return this.matchInterruptible(at, range, option);
        }
        catch (InterruptedException ex) {
            return -2;
        }
    }

    public final int matchInterruptible(int at, int range, int option) throws InterruptedException {
        this.msaInit(option, at);
        int prev = this.enc.prevCharHead(this.bytes, this.str, at, this.end);
        return this.matchAt(range, at, prev);
    }

    private boolean forwardSearchRange(byte[] bytes, int str, int end, int s, int range, IntHolder lowPrev) {
        int p;
        int pprev = -1;
        if (this.regex.dMin > 0) {
            if (this.enc.isSingleByte()) {
                p += this.regex.dMin;
            } else {
                int q = p + this.regex.dMin;
                for (p = s; p < q && p < end; p += this.enc.length(bytes, p, end)) {
                }
            }
        }
        block5: while ((p = this.regex.searchAlgorithm.search(this, bytes, p, end, range)) != -1 && p < range) {
            if (p - this.regex.dMin < s) {
                pprev = p;
                p += this.enc.length(bytes, p, end);
                continue;
            }
            if (this.regex.subAnchor != 0) {
                switch (this.regex.subAnchor) {
                    case 2: {
                        int prev;
                        if (p == str || this.enc.isNewLine(bytes, prev = this.enc.prevCharHead(bytes, pprev != -1 ? pprev : str, p, end), end)) break;
                        pprev = p;
                        p += this.enc.length(bytes, p, end);
                        continue block5;
                    }
                    case 32: {
                        if (p == end || this.enc.isNewLine(bytes, p, end)) break;
                        pprev = p;
                        p += this.enc.length(bytes, p, end);
                        continue block5;
                    }
                }
            }
            if (this.regex.dMax == 0) {
                this.low = p;
                if (lowPrev != null) {
                    lowPrev.value = this.low > s ? this.enc.prevCharHead(bytes, s, p, end) : this.enc.prevCharHead(bytes, pprev != -1 ? pprev : str, p, end);
                }
            } else if (this.regex.dMax != Integer.MAX_VALUE) {
                this.low = p - this.regex.dMax;
                if (this.low > s) {
                    this.low = this.enc.rightAdjustCharHeadWithPrev(bytes, s, this.low, end, lowPrev);
                    if (lowPrev != null && lowPrev.value == -1) {
                        lowPrev.value = this.enc.prevCharHead(bytes, pprev != -1 ? pprev : s, this.low, end);
                    }
                } else if (lowPrev != null) {
                    lowPrev.value = this.enc.prevCharHead(bytes, pprev != -1 ? pprev : str, this.low, end);
                }
            }
            this.high = p - this.regex.dMin;
            return true;
        }
        return false;
    }

    private boolean backwardSearchRange(byte[] bytes, int str, int end, int s, int range, int adjrange) {
        range += this.regex.dMin;
        int p = s;
        block4: while ((p = this.regex.searchAlgorithm.searchBackward(this, bytes, range, adjrange, end, p, s, range)) != -1) {
            if (this.regex.subAnchor != 0) {
                switch (this.regex.subAnchor) {
                    case 2: {
                        int prev;
                        if (p == str || this.enc.isNewLine(bytes, prev = this.enc.prevCharHead(bytes, str, p, end), end)) break;
                        p = prev;
                        continue block4;
                    }
                    case 32: {
                        if (p == end || this.enc.isNewLine(bytes, p, end)) break;
                        if ((p = this.enc.prevCharHead(bytes, adjrange, p, end)) != -1) continue block4;
                        return false;
                    }
                }
            }
            if (this.regex.dMax != Integer.MAX_VALUE) {
                this.low = p - this.regex.dMax;
                this.high = p - this.regex.dMin;
                this.high = this.enc.rightAdjustCharHead(bytes, adjrange, this.high, end);
            }
            return true;
        }
        return false;
    }

    private boolean matchCheck(int upperRange, int s, int prev) throws InterruptedException {
        return this.matchAt(this.end, s, prev) != -1 && !Option.isFindLongest(this.regex.options);
    }

    public final int search(int start, int range, int option) {
        try {
            return this.searchInterruptible(start, range, option);
        }
        catch (InterruptedException ex) {
            return -2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int searchInterruptible(int start, int range, int option) throws InterruptedException {
        int prev;
        int origStart = start;
        int origRange = range;
        if (start > this.end || start < this.str) {
            return -1;
        }
        if (this.regex.anchor != 0 && this.str < this.end) {
            int minSemiEnd;
            int maxSemiEnd;
            if ((this.regex.anchor & 4) != 0) {
                range = range > start ? start + 1 : start;
            } else if ((this.regex.anchor & 1) != 0) {
                if (range > start) {
                    if (start != this.str) {
                        return -1;
                    }
                    range = this.str + 1;
                } else {
                    if (range > this.str) return -1;
                    start = this.str;
                    range = this.str;
                }
            } else if ((this.regex.anchor & 8) != 0) {
                maxSemiEnd = this.end;
                minSemiEnd = maxSemiEnd;
                if (this.endBuf(start, range, minSemiEnd, maxSemiEnd)) {
                    return -1;
                }
            } else if ((this.regex.anchor & 0x10) != 0) {
                int preEnd = this.enc.stepBack(this.bytes, this.str, this.end, this.end, 1);
                maxSemiEnd = this.end;
                if (this.enc.isNewLine(this.bytes, preEnd, this.end) ? (minSemiEnd = preEnd) > this.str && start <= minSemiEnd && this.endBuf(start, range, minSemiEnd, maxSemiEnd) : this.endBuf(start, range, minSemiEnd = this.end, maxSemiEnd)) {
                    return -1;
                }
            } else if ((this.regex.anchor & 0x8000) != 0) {
                range = range > start ? start + 1 : start;
            }
        } else if (this.str == this.end) {
            if (this.regex.thresholdLength != 0) return -1;
            int s = start = this.str;
            int prev2 = -1;
            this.msaInit(option, start);
            if (!this.matchCheck(this.end, s, prev2)) return this.mismatch();
            return this.match(s);
        }
        this.msaInit(option, origStart);
        int s = start;
        if (range > start) {
            int prev3 = s > this.str ? this.enc.prevCharHead(this.bytes, this.str, s, this.end) : 0;
            if (this.regex.searchAlgorithm != SearchAlgorithm.NONE) {
                int schRange = range;
                if (this.regex.dMax != 0) {
                    if (this.regex.dMax == Integer.MAX_VALUE) {
                        schRange = this.end;
                    } else if ((schRange += this.regex.dMax) > this.end) {
                        schRange = this.end;
                    }
                }
                if (this.end - start < this.regex.thresholdLength) {
                    return this.mismatch();
                }
                if (this.regex.dMax != Integer.MAX_VALUE) {
                    do {
                        if (!this.forwardSearchRange(this.bytes, this.str, this.end, s, schRange, this)) {
                            return this.mismatch();
                        }
                        if (s < this.low) {
                            s = this.low;
                            prev3 = this.value;
                        }
                        while (s <= this.high) {
                            if (this.matchCheck(origRange, s, prev3)) {
                                return this.match(s);
                            }
                            prev3 = s;
                            s += this.enc.length(this.bytes, s, this.end);
                        }
                    } while (s < range);
                    return this.mismatch();
                }
                if (!this.forwardSearchRange(this.bytes, this.str, this.end, s, schRange, null)) {
                    return this.mismatch();
                }
                if ((this.regex.anchor & 0x4000) != 0) {
                    do {
                        if (this.matchCheck(origRange, s, prev3)) {
                            return this.match(s);
                        }
                        prev3 = s;
                    } while ((s += this.enc.length(this.bytes, s, this.end)) < range);
                    return this.mismatch();
                }
            }
            do {
                if (this.matchCheck(origRange, s, prev3)) {
                    return this.match(s);
                }
                prev3 = s;
            } while ((s += this.enc.length(this.bytes, s, this.end)) < range);
            if (s != range || !this.matchCheck(origRange, s, prev3)) return this.mismatch();
            return this.match(s);
        }
        if (this.regex.searchAlgorithm != SearchAlgorithm.NONE) {
            int schStart;
            int adjrange = range < this.end ? this.enc.leftAdjustCharHead(this.bytes, this.str, range, this.end) : this.end;
            if (this.regex.dMax != Integer.MAX_VALUE && this.end - range >= this.regex.thresholdLength) {
                do {
                    if ((schStart = s + this.regex.dMax) > this.end) {
                        schStart = this.end;
                    }
                    if (!this.backwardSearchRange(this.bytes, this.str, this.end, schStart, range, adjrange)) {
                        return this.mismatch();
                    }
                    if (s > this.high) {
                        s = this.high;
                    }
                    while (s != -1 && s >= this.low) {
                        int prev4 = this.enc.prevCharHead(this.bytes, this.str, s, this.end);
                        if (this.matchCheck(origStart, s, prev4)) {
                            return this.match(s);
                        }
                        s = prev4;
                    }
                } while (s >= range);
                return this.mismatch();
            }
            if (this.end - range < this.regex.thresholdLength) {
                return this.mismatch();
            }
            schStart = s;
            if (this.regex.dMax != 0) {
                schStart = this.regex.dMax == Integer.MAX_VALUE ? this.end : ((schStart += this.regex.dMax) > this.end ? this.end : this.enc.leftAdjustCharHead(this.bytes, start, schStart, this.end));
            }
            if (!this.backwardSearchRange(this.bytes, this.str, this.end, schStart, range, adjrange)) {
                return this.mismatch();
            }
        }
        do {
            if (!this.matchCheck(origStart, s, prev = this.enc.prevCharHead(this.bytes, this.str, s, this.end))) continue;
            return this.match(s);
        } while ((s = prev) >= range);
        return this.mismatch();
    }

    private boolean endBuf(int start, int range, int minSemiEnd, int maxSemiEnd) {
        if (maxSemiEnd - this.str < this.regex.anchorDmin) {
            return true;
        }
        if (range > start) {
            if (minSemiEnd - start > this.regex.anchorDmax) {
                start = minSemiEnd - this.regex.anchorDmax;
                start = start < this.end ? this.enc.rightAdjustCharHead(this.bytes, this.str, start, this.end) : this.enc.prevCharHead(this.bytes, this.str, this.end, this.end);
            }
            if (maxSemiEnd - (range - 1) < this.regex.anchorDmin) {
                range = maxSemiEnd - this.regex.anchorDmin + 1;
            }
            if (start >= range) {
                return true;
            }
        } else {
            if (minSemiEnd - range > this.regex.anchorDmax) {
                range = minSemiEnd - this.regex.anchorDmax;
            }
            if (maxSemiEnd - start < this.regex.anchorDmin) {
                start = maxSemiEnd - this.regex.anchorDmin;
                start = this.enc.leftAdjustCharHead(this.bytes, this.str, start, this.end);
            }
            if (range > start) {
                return true;
            }
        }
        return false;
    }

    private int match(int s) {
        return s - this.str;
    }

    private int mismatch() {
        if (this.msaBestLen >= 0) {
            int s = this.msaBestS;
            return this.match(s);
        }
        return -1;
    }

    final byte[] icbuf() {
        return this.icbuf == null ? (this.icbuf = new byte[18]) : this.icbuf;
    }
}

