/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.JSType;
import com.oracle.js.parser.Lexer;
import com.oracle.js.parser.Token;
import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LexicalContextNode;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.PropertyKey;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public abstract class LiteralNode<T>
extends Expression
implements PropertyKey {
    protected final T value;

    protected LiteralNode(long l, int n, T t) {
        super(l, n);
        this.value = t;
    }

    protected LiteralNode(LiteralNode<T> literalNode) {
        this(literalNode, literalNode.value);
    }

    protected LiteralNode(LiteralNode<T> literalNode, T t) {
        super(literalNode);
        this.value = t;
    }

    public LiteralNode<?> initialize(LexicalContext lexicalContext) {
        return this;
    }

    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public String getPropertyName() {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean() {
        return JSType.toBoolean(this.value);
    }

    public int getInt32() {
        return JSType.toInt32(this.value);
    }

    public long getUint32() {
        return JSType.toUint32(this.value);
    }

    public long getLong() {
        return JSType.toLong(this.value);
    }

    public double getNumber() {
        return JSType.toNumber(this.value);
    }

    public String getString() {
        return String.valueOf(this.value);
    }

    public Object getObject() {
        return this.value;
    }

    public boolean isArray() {
        return false;
    }

    public List<Expression> getElementExpressions() {
        return null;
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public boolean isNumeric() {
        return this.value instanceof Number;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterLiteralNode(this)) {
            return nodeVisitor.leaveLiteralNode(this);
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterLiteralNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        if (this.value == null) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append(this.value.toString());
        }
    }

    public final T getValue() {
        return this.value;
    }

    private static Expression[] valueToArray(List<Expression> list) {
        return list.toArray(new Expression[list.size()]);
    }

    public static LiteralNode<Object> newInstance(long l, int n) {
        return new NullLiteralNode(l, n);
    }

    public static LiteralNode<Boolean> newInstance(long l, int n, boolean bl) {
        return new BooleanLiteralNode(l, n, bl);
    }

    public static LiteralNode<Number> newInstance(long l, int n, Number number) {
        return new NumberLiteralNode(l, n, number, null);
    }

    public static LiteralNode<Number> newInstance(long l, int n, Number number, Function<Number, String> function) {
        return new NumberLiteralNode(l, n, number, function);
    }

    public static LiteralNode<String> newInstance(long l, int n, String string) {
        return new StringLiteralNode(l, n, string);
    }

    public static LiteralNode<Lexer.LexerToken> newInstance(long l, int n, Lexer.LexerToken lexerToken) {
        return new LexerTokenLiteralNode(l, n, lexerToken);
    }

    public static LiteralNode<Expression[]> newInstance(long l, int n, List<Expression> list) {
        return LiteralNode.newInstance(l, n, LiteralNode.valueToArray(list));
    }

    public static LiteralNode<Expression[]> newInstance(long l, int n, List<Expression> list, boolean bl, boolean bl2) {
        return new ArrayLiteralNode(l, n, LiteralNode.valueToArray(list), bl, bl2);
    }

    public static LiteralNode<Expression[]> newInstance(long l, int n, Expression[] expressionArray) {
        return new ArrayLiteralNode(l, n, expressionArray);
    }

    public static final class ArrayLiteralNode
    extends LiteralNode<Expression[]>
    implements LexicalContextNode {
        private final List<ArrayUnit> units;
        private final boolean hasSpread;
        private final boolean hasTrailingComma;

        protected ArrayLiteralNode(long l, int n, Expression[] expressionArray) {
            this(l, n, expressionArray, false, false);
        }

        protected ArrayLiteralNode(long l, int n, Expression[] expressionArray, boolean bl, boolean bl2) {
            super(Token.recast(l, TokenType.ARRAY), n, expressionArray);
            this.units = null;
            this.hasSpread = bl;
            this.hasTrailingComma = bl2;
        }

        private ArrayLiteralNode(ArrayLiteralNode arrayLiteralNode, Expression[] expressionArray, List<ArrayUnit> list) {
            super(arrayLiteralNode, expressionArray);
            this.units = list;
            this.hasSpread = arrayLiteralNode.hasSpread;
            this.hasTrailingComma = arrayLiteralNode.hasTrailingComma;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        public boolean hasSpread() {
            return this.hasSpread;
        }

        public boolean hasTrailingComma() {
            return this.hasTrailingComma;
        }

        @Override
        public List<Expression> getElementExpressions() {
            return Collections.unmodifiableList(Arrays.asList((Object[])this.value));
        }

        public ArrayLiteralNode initialize(LexicalContext lexicalContext) {
            return Node.replaceInLexicalContext(lexicalContext, this, ArrayLiteralInitializer.initialize(this));
        }

        public List<ArrayUnit> getUnits() {
            return this.units == null ? null : Collections.unmodifiableList(this.units);
        }

        @Override
        public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
            return LexicalContextNode.Acceptor.accept((LexicalContextNode)this, nodeVisitor);
        }

        @Override
        public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
            return LexicalContextNode.Acceptor.accept((LexicalContextNode)this, translatorNodeVisitor);
        }

        @Override
        public Node accept(LexicalContext lexicalContext, NodeVisitor<? extends LexicalContext> nodeVisitor) {
            if (nodeVisitor.enterLiteralNode(this)) {
                List<Object> list;
                List<Object> list2 = Arrays.asList((Object[])this.value);
                return nodeVisitor.leaveLiteralNode(list2 != (list = Node.accept(nodeVisitor, list2)) ? this.setValue(lexicalContext, list) : this);
            }
            return this;
        }

        @Override
        public <R> R accept(LexicalContext lexicalContext, TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
            return translatorNodeVisitor.enterLiteralNode(this);
        }

        private ArrayLiteralNode setValue(LexicalContext lexicalContext, Expression[] expressionArray) {
            if (this.value == expressionArray) {
                return this;
            }
            return Node.replaceInLexicalContext(lexicalContext, this, new ArrayLiteralNode(this, expressionArray, this.units));
        }

        private ArrayLiteralNode setValue(LexicalContext lexicalContext, List<Expression> list) {
            return this.setValue(lexicalContext, list.toArray(new Expression[list.size()]));
        }

        @Override
        public void toString(StringBuilder stringBuilder, boolean bl) {
            stringBuilder.append('[');
            boolean bl2 = true;
            for (Expression expression : (Expression[])this.value) {
                if (!bl2) {
                    stringBuilder.append(',');
                    stringBuilder.append(' ');
                }
                if (expression == null) {
                    stringBuilder.append("undefined");
                } else {
                    expression.toString(stringBuilder, bl);
                }
                bl2 = false;
            }
            stringBuilder.append(']');
        }

        private static final class ArrayLiteralInitializer {
            private ArrayLiteralInitializer() {
            }

            static ArrayLiteralNode initialize(ArrayLiteralNode arrayLiteralNode) {
                return new ArrayLiteralNode(arrayLiteralNode, (Expression[])arrayLiteralNode.value, arrayLiteralNode.units);
            }
        }

        public static final class ArrayUnit {
            private final int lo;
            private final int hi;

            public ArrayUnit(int n, int n2) {
                this.lo = n;
                this.hi = n2;
            }

            public int getHi() {
                return this.hi;
            }

            public int getLo() {
                return this.lo;
            }
        }
    }

    private static final class NullLiteralNode
    extends PrimitiveLiteralNode<Object> {
        private NullLiteralNode(long l, int n) {
            super(Token.recast(l, TokenType.OBJECT), n, null);
        }
    }

    private static final class LexerTokenLiteralNode
    extends LiteralNode<Lexer.LexerToken> {
        private LexerTokenLiteralNode(long l, int n, Lexer.LexerToken lexerToken) {
            super(Token.recast(l, TokenType.STRING), n, lexerToken);
        }

        private LexerTokenLiteralNode(LexerTokenLiteralNode lexerTokenLiteralNode) {
            super(lexerTokenLiteralNode);
        }

        @Override
        public void toString(StringBuilder stringBuilder, boolean bl) {
            stringBuilder.append(((Lexer.LexerToken)this.value).toString());
        }
    }

    private static final class StringLiteralNode
    extends PrimitiveLiteralNode<String> {
        private StringLiteralNode(long l, int n, String string) {
            super(Token.recast(l, TokenType.STRING), n, string);
        }

        private StringLiteralNode(StringLiteralNode stringLiteralNode) {
            super(stringLiteralNode);
        }

        @Override
        public void toString(StringBuilder stringBuilder, boolean bl) {
            stringBuilder.append('\"');
            stringBuilder.append((String)this.value);
            stringBuilder.append('\"');
        }
    }

    private static final class NumberLiteralNode
    extends PrimitiveLiteralNode<Number> {
        private final Function<Number, String> toStringConverter;

        private NumberLiteralNode(long l, int n, Number number, Function<Number, String> function) {
            super(Token.recast(l, TokenType.DECIMAL), n, number);
            this.toStringConverter = function;
        }

        private NumberLiteralNode(NumberLiteralNode numberLiteralNode) {
            super(numberLiteralNode);
            this.toStringConverter = numberLiteralNode.toStringConverter;
        }

        @Override
        public String getPropertyName() {
            return this.toStringConverter == null ? super.getPropertyName() : this.toStringConverter.apply((Number)this.getValue());
        }
    }

    private static final class BooleanLiteralNode
    extends PrimitiveLiteralNode<Boolean> {
        private BooleanLiteralNode(long l, int n, boolean bl) {
            super(Token.recast(l, bl ? TokenType.TRUE : TokenType.FALSE), n, bl);
        }

        private BooleanLiteralNode(BooleanLiteralNode booleanLiteralNode) {
            super(booleanLiteralNode);
        }

        @Override
        public boolean isTrue() {
            return (Boolean)this.value;
        }
    }

    public static class PrimitiveLiteralNode<T>
    extends LiteralNode<T> {
        private PrimitiveLiteralNode(long l, int n, T t) {
            super(l, n, t);
        }

        private PrimitiveLiteralNode(PrimitiveLiteralNode<T> primitiveLiteralNode) {
            super(primitiveLiteralNode);
        }

        public boolean isTrue() {
            return JSType.toBoolean(this.value);
        }

        @Override
        public boolean isAlwaysFalse() {
            return !this.isTrue();
        }

        @Override
        public boolean isAlwaysTrue() {
            return this.isTrue();
        }

        @Override
        public String getPropertyName() {
            return String.valueOf(this.getObject());
        }
    }
}

