/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.nodes.control.ReturnException;
import com.oracle.truffle.js.nodes.control.ReturnNode;
import com.oracle.truffle.js.nodes.control.SuspendNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.nodes.control.YieldStarNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.UserScriptException;
import com.oracle.truffle.js.runtime.objects.Completion;
import java.util.Set;

public class YieldNode
extends JavaScriptNode
implements ResumableNode,
SuspendNode {
    @Node.Child
    protected JavaScriptNode expression;
    @Node.Child
    private CreateIterResultObjectNode createIterResultObjectNode;
    @Node.Child
    protected JavaScriptNode yieldValue;
    @Node.Child
    private ReturnNode returnNode;
    @Node.Child
    private YieldResultNode generatorYieldNode;
    private final JSContext context;
    private final ConditionProfile returnOrExceptionProfile = ConditionProfile.createBinaryProfile();

    protected YieldNode(JSContext context, JavaScriptNode expression, JavaScriptNode yieldValue, ReturnNode returnNode, JSWriteFrameSlotNode writeYieldResultNode) {
        this.context = context;
        this.expression = expression;
        this.returnNode = returnNode;
        this.createIterResultObjectNode = CreateIterResultObjectNode.create(context);
        this.yieldValue = yieldValue;
        this.generatorYieldNode = writeYieldResultNode == null ? new ExceptionYieldResultNode() : new FrameYieldResultNode(writeYieldResultNode);
    }

    public static YieldNode createYield(JSContext context, JavaScriptNode expression, JavaScriptNode yieldValue, ReturnNode returnNode, JSWriteFrameSlotNode writeYieldResultNode) {
        return new YieldNode(context, expression, yieldValue, returnNode, writeYieldResultNode);
    }

    public static YieldNode createYieldStar(JSContext context, JavaScriptNode expression, JavaScriptNode yieldValue, ReturnNode returnNode, JSWriteFrameSlotNode writeYieldResultNode) {
        return new YieldStarNode(context, expression, yieldValue, returnNode, writeYieldResultNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object value = this.expression.execute(frame);
        DynamicObject iterNextObj = this.createIterResultObjectNode.execute(frame, value, false);
        return this.generatorYield(frame, iterNextObj);
    }

    protected final Object generatorYield(VirtualFrame frame, DynamicObject iterNextObj) {
        throw this.generatorYieldNode.generatorYield(frame, iterNextObj);
    }

    @Override
    public Object resume(VirtualFrame frame) {
        int index = this.getStateAsInt(frame);
        if (index == 0) {
            Object value = this.expression.execute(frame);
            DynamicObject iterNextObj = this.createIterResultObjectNode.execute(frame, value, false);
            this.setState(frame, 1);
            return this.generatorYield(frame, iterNextObj);
        }
        assert (index == 1);
        this.setState(frame, 0);
        Object value = this.yieldValue.execute(frame);
        if (value instanceof Completion) {
            Completion completion = (Completion)value;
            value = completion.getValue();
            if (this.returnOrExceptionProfile.profile(completion.isThrow())) {
                return this.throwValue(value);
            }
            assert (completion.isReturn());
            return this.returnValue(frame, value);
        }
        return value;
    }

    protected final Object throwValue(Object value) {
        throw UserScriptException.create(value, this, this.context.getContextOptions().getStackTraceLimit());
    }

    protected final Object returnValue(VirtualFrame frame, Object value) {
        if (this.returnNode instanceof ReturnNode.FrameReturnNode) {
            ((WriteNode)((Object)this.returnNode.expression)).executeWrite(frame, value);
        }
        throw new ReturnException(value);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        JavaScriptNode expressionCopy = YieldNode.cloneUninitialized(this.expression, materializedTags);
        JavaScriptNode yieldValueCopy = YieldNode.cloneUninitialized(this.yieldValue, materializedTags);
        ReturnNode returnCopy = YieldNode.cloneUninitialized(this.returnNode, materializedTags);
        JSWriteFrameSlotNode writeYieldValueCopy = YieldNode.cloneUninitialized(this.generatorYieldNode instanceof FrameYieldResultNode ? ((FrameYieldResultNode)this.generatorYieldNode).writeYieldValueNode : null, materializedTags);
        if (this instanceof YieldStarNode) {
            return YieldNode.createYieldStar(this.context, expressionCopy, yieldValueCopy, returnCopy, writeYieldValueCopy);
        }
        return YieldNode.createYield(this.context, expressionCopy, yieldValueCopy, returnCopy, writeYieldValueCopy);
    }

    public static final class FrameYieldResultNode
    extends YieldResultNode {
        @Node.Child
        private JSWriteFrameSlotNode writeYieldValueNode;

        public FrameYieldResultNode(JSWriteFrameSlotNode writeYieldValueNode) {
            this.writeYieldValueNode = writeYieldValueNode;
        }

        @Override
        public YieldException generatorYield(VirtualFrame frame, Object value) {
            this.writeYieldValueNode.executeWrite(frame, value);
            throw YieldException.YIELD_NULL;
        }
    }

    public static final class ExceptionYieldResultNode
    extends YieldResultNode {
        @Override
        public YieldException generatorYield(VirtualFrame frame, Object value) {
            throw new YieldException(value);
        }
    }

    public static abstract class YieldResultNode
    extends JavaScriptBaseNode {
        public abstract YieldException generatorYield(VirtualFrame var1, Object var2);
    }
}

