/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.runtime.interop.InteropList;
import com.oracle.truffle.js.runtime.objects.Dead;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import java.util.ArrayList;

@ExportLibrary(value=InteropLibrary.class)
public final class DynamicScopeWrapper
implements TruffleObject {
    final DynamicObject scope;

    public DynamicScopeWrapper(DynamicObject scope) {
        this.scope = scope;
    }

    boolean isConst(String name, DynamicObjectLibrary access) {
        return JSProperty.isConst(access.getProperty(this.scope, (Object)name));
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal, @CachedLibrary(value="this.scope") DynamicObjectLibrary access) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Object key : access.getKeyArray(this.scope)) {
            Object value;
            if (!(key instanceof String) || (value = access.getOrDefault(this.scope, key, null)) == null || value == Dead.instance()) continue;
            keys.add((String)key);
        }
        return InteropList.create(keys);
    }

    @ExportMessage
    boolean isMemberReadable(String name, @CachedLibrary(value="this.scope") DynamicObjectLibrary access) {
        Object value = access.getOrDefault(this.scope, (Object)name, null);
        return value != null && value != Dead.instance();
    }

    @ExportMessage
    boolean isMemberModifiable(String name, @CachedLibrary(value="this.scope") DynamicObjectLibrary access) {
        return this.isMemberReadable(name, access) && !this.isConst(name, access);
    }

    @ExportMessage
    boolean isMemberInsertable(String name) {
        return false;
    }

    @ExportMessage
    Object readMember(String name, @CachedLibrary(value="this.scope") DynamicObjectLibrary access, @Cached ExportValueNode exportValueNode) throws UnknownIdentifierException {
        Object value = access.getOrDefault(this.scope, (Object)name, null);
        if (value == null || value == Dead.instance()) {
            throw UnknownIdentifierException.create((String)name);
        }
        return exportValueNode.execute(value);
    }

    @ExportMessage
    void writeMember(String name, Object value, @CachedLibrary(value="this.scope") DynamicObjectLibrary access) throws UnsupportedMessageException, UnknownIdentifierException {
        Object curValue = access.getOrDefault(this.scope, (Object)name, null);
        if (curValue == null || curValue == Dead.instance()) {
            throw UnknownIdentifierException.create((String)name);
        }
        if (this.isConst(name, access)) {
            throw UnsupportedMessageException.create();
        }
        access.putIfPresent(this.scope, (Object)name, value);
    }
}

