/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.newproject;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.lang.model.SourceVersion;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.micronaut.newproject.BasePropertiesWizardPanel;
import org.netbeans.modules.micronaut.newproject.MicronautLaunchService;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.util.AsyncGUIJob;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class BasePropertiesVisual
extends JPanel
implements DocumentListener,
ActionListener,
AsyncGUIJob {
    private final BasePropertiesWizardPanel panel;
    private boolean initialized = false;
    private boolean failed = false;
    private JComboBox<MicronautLaunchService.ApplicationType> applicationTypeComboBox;
    private JLabel applicationTypeLabel;
    private JLabel artifactLabel;
    private JTextField artifactTextField;
    private JRadioButton customRadioButton;
    private JTextField customTextField;
    private JRadioButton defaultRadioButton;
    private JLabel defaultURLLabel;
    private JRadioButton groovyRadioButton;
    private JLabel groupLabel;
    private JTextField groupTextField;
    private JRadioButton javaRadioButton;
    private JComboBox<String> javaVersionComboBox;
    private JLabel javaVersionLabel;
    private JRadioButton junitRadioButton;
    private JRadioButton kotestRadioButton;
    private JRadioButton kotlinRadioButton;
    private ButtonGroup languageButtonGroup;
    private JLabel languageLabel;
    private ButtonGroup serviceButtonGroup;
    private JLabel serviceURLLabel;
    private JRadioButton snapshotRadioButton;
    private JLabel snapshotURLLabel;
    private JRadioButton spockRadioButton;
    private ButtonGroup testFrameworkButtonGroup;
    private JLabel testFrameworkLabel;
    private JLabel versionLabel;
    private JTextField versionTextField;

    public BasePropertiesVisual(final BasePropertiesWizardPanel panel) {
        this.initComponents();
        this.panel = panel;
        this.defaultRadioButton.addActionListener(this);
        this.snapshotRadioButton.addActionListener(this);
        this.customRadioButton.addActionListener(this);
        this.customTextField.getDocument().addDocumentListener(this);
        this.groupTextField.getDocument().addDocumentListener(this);
        this.versionTextField.getDocument().addDocumentListener(this);
        this.customTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                BasePropertiesVisual.this.customRadioButton.setSelected(true);
                BasePropertiesVisual.this.versionTextField.setText("");
                BasePropertiesVisual.this.applicationTypeComboBox.removeAllItems();
                BasePropertiesVisual.this.javaVersionComboBox.removeAllItems();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (BasePropertiesVisual.this.customRadioButton.isSelected()) {
                    if (BasePropertiesVisual.this.customURLValid()) {
                        BasePropertiesVisual.this.refresh();
                    } else {
                        panel.fireChangeEvent();
                    }
                }
            }
        });
    }

    private void initComponents() {
        this.serviceButtonGroup = new ButtonGroup();
        this.languageButtonGroup = new ButtonGroup();
        this.testFrameworkButtonGroup = new ButtonGroup();
        this.serviceURLLabel = new JLabel();
        this.defaultRadioButton = new JRadioButton();
        this.defaultURLLabel = new JLabel();
        this.snapshotRadioButton = new JRadioButton();
        this.snapshotURLLabel = new JLabel();
        this.customRadioButton = new JRadioButton();
        this.customTextField = new JTextField();
        this.versionLabel = new JLabel();
        this.versionTextField = new JTextField();
        this.groupLabel = new JLabel();
        this.groupTextField = new JTextField();
        this.artifactLabel = new JLabel();
        this.artifactTextField = new JTextField();
        this.applicationTypeLabel = new JLabel();
        this.applicationTypeComboBox = new JComboBox();
        this.javaVersionLabel = new JLabel();
        this.javaVersionComboBox = new JComboBox();
        this.languageLabel = new JLabel();
        this.javaRadioButton = new JRadioButton();
        this.kotlinRadioButton = new JRadioButton();
        this.groovyRadioButton = new JRadioButton();
        this.testFrameworkLabel = new JLabel();
        this.junitRadioButton = new JRadioButton();
        this.spockRadioButton = new JRadioButton();
        this.kotestRadioButton = new JRadioButton();
        Mnemonics.setLocalizedText((JLabel)this.serviceURLLabel, (String)NbBundle.getMessage(BasePropertiesVisual.class, (String)"LBL_ChooseServiceURL"));
        this.serviceButtonGroup.add(this.defaultRadioButton);
        this.defaultRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.defaultRadioButton, (String)NbBundle.getMessage(BasePropertiesVisual.class, (String)"LBL_Default"));
        this.defaultRadioButton.setActionCommand("DEFAULT");
        this.defaultURLLabel.setFont(new Font("Dialog", 2, 12));
        Mnemonics.setLocalizedText((JLabel)this.defaultURLLabel, (String)"https://launch.micronaut.io");
        this.serviceButtonGroup.add(this.snapshotRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.snapshotRadioButton, (String)NbBundle.getMessage(BasePropertiesVisual.class, (String)"LBL_Snapshot"));
        this.snapshotRadioButton.setActionCommand("SNAPSHOT");
        this.snapshotURLLabel.setFont(new Font("Dialog", 2, 12));
        Mnemonics.setLocalizedText((JLabel)this.snapshotURLLabel, (String)"https://snapshot.micronaut.io");
        this.serviceButtonGroup.add(this.customRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.customRadioButton, (String)NbBundle.getMessage(BasePropertiesVisual.class, (String)"LBL_Custom"));
        this.customRadioButton.setActionCommand("CUSTOM");
        Mnemonics.setLocalizedText((JLabel)this.versionLabel, (String)NbBundle.getMessage(BasePropertiesVisual.class, (String)"LBL_Version"));
        this.versionTextField.setEditable(false);
        this.versionTextField.setColumns(20);
        this.groupLabel.setLabelFor(this.groupTextField);
        Mnemonics.setLocalizedText((JLabel)this.groupLabel, (String)NbBundle.getMessage(BasePropertiesVisual.class, (String)"LBL_Group"));
        this.groupTextField.setColumns(20);
        this.artifactLabel.setLabelFor(this.artifactTextField);
        Mnemonics.setLocalizedText((JLabel)this.artifactLabel, (String)NbBundle.getMessage(BasePropertiesVisual.class, (String)"LBL_Artifact"));
        this.artifactTextField.setEditable(false);
        this.artifactTextField.setColumns(20);
        this.applicationTypeLabel.setLabelFor(this.applicationTypeComboBox);
        Mnemonics.setLocalizedText((JLabel)this.applicationTypeLabel, (String)NbBundle.getMessage(BasePropertiesVisual.class, (String)"LBL_ApplicationType"));
        this.javaVersionLabel.setLabelFor(this.javaVersionComboBox);
        Mnemonics.setLocalizedText((JLabel)this.javaVersionLabel, (String)NbBundle.getMessage(BasePropertiesVisual.class, (String)"LBL_JavaVersion"));
        Mnemonics.setLocalizedText((JLabel)this.languageLabel, (String)NbBundle.getMessage(BasePropertiesVisual.class, (String)"LBL_Language"));
        this.languageButtonGroup.add(this.javaRadioButton);
        this.javaRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.javaRadioButton, (String)NbBundle.getMessage(BasePropertiesVisual.class, (String)"LBL_Java"));
        this.javaRadioButton.setActionCommand("JAVA");
        this.languageButtonGroup.add(this.kotlinRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.kotlinRadioButton, (String)NbBundle.getMessage(BasePropertiesVisual.class, (String)"LBL_Kotlin"));
        this.kotlinRadioButton.setActionCommand("KOTLIN");
        this.languageButtonGroup.add(this.groovyRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.groovyRadioButton, (String)NbBundle.getMessage(BasePropertiesVisual.class, (String)"LBL_Groovy"));
        this.groovyRadioButton.setActionCommand("GROOVY");
        Mnemonics.setLocalizedText((JLabel)this.testFrameworkLabel, (String)NbBundle.getMessage(BasePropertiesVisual.class, (String)"LBL_TestFramework"));
        this.testFrameworkButtonGroup.add(this.junitRadioButton);
        this.junitRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.junitRadioButton, (String)NbBundle.getMessage(BasePropertiesVisual.class, (String)"LBL_JUnit"));
        this.junitRadioButton.setActionCommand("JUNIT");
        this.testFrameworkButtonGroup.add(this.spockRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.spockRadioButton, (String)NbBundle.getMessage(BasePropertiesVisual.class, (String)"LBL_Spock"));
        this.spockRadioButton.setActionCommand("SPOCK");
        this.testFrameworkButtonGroup.add(this.kotestRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.kotestRadioButton, (String)NbBundle.getMessage(BasePropertiesVisual.class, (String)"LBL_Kotest"));
        this.kotestRadioButton.setActionCommand("KOTEST");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.javaVersionLabel).addComponent(this.groupLabel).addComponent(this.languageLabel).addComponent(this.customRadioButton).addComponent(this.artifactLabel).addComponent(this.applicationTypeLabel, -2, 90, -2).addComponent(this.versionLabel).addComponent(this.snapshotRadioButton).addComponent(this.defaultRadioButton).addComponent(this.serviceURLLabel).addComponent(this.testFrameworkLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.javaVersionComboBox, -2, 63, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.javaRadioButton, -2, 50, -2).addComponent(this.junitRadioButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spockRadioButton).addComponent(this.kotlinRadioButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.groovyRadioButton).addComponent(this.kotestRadioButton)))).addGap(357, 357, 357)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defaultURLLabel, -1, -1, Short.MAX_VALUE).addComponent(this.versionTextField).addComponent(this.snapshotURLLabel, -1, -1, Short.MAX_VALUE).addComponent(this.customTextField).addComponent(this.applicationTypeComboBox, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.artifactTextField, GroupLayout.Alignment.TRAILING).addComponent(this.groupTextField)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.serviceURLLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.defaultRadioButton).addComponent(this.defaultURLLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.snapshotRadioButton).addComponent(this.snapshotURLLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.customRadioButton).addComponent(this.customTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionTextField, -2, -1, -2).addComponent(this.versionLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.groupTextField, -2, 19, -2).addComponent(this.groupLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.artifactTextField, -2, -1, -2).addComponent(this.artifactLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.applicationTypeComboBox, -2, -1, -2).addComponent(this.applicationTypeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javaVersionComboBox, -2, -1, -2).addComponent(this.javaVersionLabel)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.languageLabel).addComponent(this.javaRadioButton).addComponent(this.kotlinRadioButton).addComponent(this.groovyRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testFrameworkLabel).addComponent(this.junitRadioButton).addComponent(this.spockRadioButton).addComponent(this.kotestRadioButton)).addContainerGap(28, Short.MAX_VALUE)));
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (this.failed) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"Problems in contacting service!");
            return false;
        }
        if (this.groupTextField.getText().isEmpty()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"Group can't be empty.");
            return false;
        }
        if (!SourceVersion.isName(this.groupTextField.getText())) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"Not a valid Group name.");
            return false;
        }
        if (this.customRadioButton.isSelected()) {
            if (this.customTextField.getText().isEmpty()) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"Service URL can't be empty.");
                return false;
            }
            if (!this.customURLValid()) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"Not a valid Service URL.");
                return false;
            }
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return !this.versionTextField.getText().isEmpty();
    }

    void store(WizardDescriptor wd) {
        wd.putProperty("service.url", (Object)this.getServiceUrl());
        wd.putProperty("maven.group", (Object)this.groupTextField.getText().trim());
        wd.putProperty("application.type", this.applicationTypeComboBox.getSelectedItem());
        wd.putProperty("java.version", this.javaVersionComboBox.getSelectedItem());
        wd.putProperty("language", (Object)this.languageButtonGroup.getSelection().getActionCommand());
        wd.putProperty("test.framework", (Object)this.testFrameworkButtonGroup.getSelection().getActionCommand());
    }

    void read(WizardDescriptor wd) {
        String group;
        String serviceUrl = (String)wd.getProperty("service.url");
        if (serviceUrl != null) {
            switch (serviceUrl) {
                case "https://launch.micronaut.io": {
                    this.defaultRadioButton.setSelected(true);
                    break;
                }
                case "https://snapshot.micronaut.io": {
                    this.snapshotRadioButton.setSelected(true);
                    break;
                }
                default: {
                    this.customTextField.setText(serviceUrl);
                }
            }
        }
        this.groupTextField.setText((group = (String)wd.getProperty("maven.group")) == null || group.isEmpty() ? "com.example" : group);
        this.artifactTextField.setText((String)wd.getProperty("maven.artifact"));
        this.javaVersionComboBox.setSelectedItem("java.version");
        this.applicationTypeComboBox.setSelectedItem(wd.getProperty("application.type"));
    }

    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.panel.fireChangeEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.panel.fireChangeEvent();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.panel.fireChangeEvent();
    }

    public void construct() {
        try {
            this.panel.wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)"Contacting service...");
            MicronautLaunchService service = MicronautLaunchService.getInstance();
            String serviceUrl = this.getServiceUrl();
            String micronautVersion = service.getMicronautVersion(serviceUrl);
            for (MicronautLaunchService.ApplicationType type : service.getApplicationTypes(serviceUrl)) {
                this.applicationTypeComboBox.addItem(type);
            }
            for (String version : service.getJdkVersions(serviceUrl)) {
                this.javaVersionComboBox.addItem(version);
            }
            this.versionTextField.setText(micronautVersion);
            this.initialized = true;
        }
        catch (Exception ex) {
            this.panel.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"Could not query Micronaut Launch service");
            this.failed = true;
            this.panel.fireChangeEvent();
        }
    }

    public void finished() {
        if (this.initialized) {
            this.panel.fireChangeEvent();
            this.groupTextField.requestFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.versionTextField.setText("");
        this.applicationTypeComboBox.removeAllItems();
        this.javaVersionComboBox.removeAllItems();
        if ("CUSTOM".equals(e.getActionCommand())) {
            this.customTextField.requestFocus();
        } else {
            this.refresh();
        }
    }

    private void refresh() {
        this.initialized = false;
        this.failed = false;
        RequestProcessor.getDefault().post(() -> {
            this.construct();
            SwingUtilities.invokeLater(() -> this.finished());
        });
    }

    private String getServiceUrl() {
        switch (this.serviceButtonGroup.getSelection().getActionCommand()) {
            case "DEFAULT": {
                return "https://launch.micronaut.io";
            }
            case "SNAPSHOT": {
                return "https://snapshot.micronaut.io";
            }
        }
        return this.customTextField.getText();
    }

    private boolean customURLValid() {
        try {
            new URL(this.customTextField.getText());
        }
        catch (MalformedURLException ex) {
            return false;
        }
        return true;
    }
}

